package noria.ui.examples

import androidx.compose.foundation.Image
import androidx.compose.foundation.layout.*
import androidx.compose.runtime.CompositionLocalProvider
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.scale
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.painter.ColorPainter
import androidx.compose.ui.platform.LocalDensity
import androidx.compose.ui.unit.Density
import androidx.compose.ui.unit.DpSize
import androidx.compose.ui.unit.dp
import fleet.compose.theme.components.Icon
import noria.model.IconKey
import noria.scope
import fleet.compose.theme.components.gallery.Gallery
import fleet.compose.theme.components.gallery.gallery
import noria.ui.components.list.ListItem
import noria.ui.components.list.listModel
import noria.ui.components.list.listView
import fleet.compose.theme.theme
import fleet.compose.theme.components.UiText
import fleet.compose.theme.keys.ThemeKeys

fun composeImageExamples(): Gallery = gallery("Compose Images", NoriaExamples.sourceCodeForFile("ComposeImage.kt")) {
  example("Compose Color Image") {
    Row(horizontalArrangement = Arrangement.spacedBy(10.dp)) {
      Image(painter = ColorPainter(Color.Red), contentDescription = null, modifier = Modifier.size(20.dp))
      Image(painter = ColorPainter(Color.Red), contentDescription = null, modifier = Modifier.size(50.dp))
    }
  }
  example("Compose Icons") {
    Row(horizontalArrangement = Arrangement.spacedBy(10.dp)) {
      Icon(IconKey("icons.checkmark"))
      Icon(IconKey("icons.checkmark"), size = DpSize(50.dp, 50.dp))
      Icon(IconKey("icons.checkmark"), palette = mapOf("icon" to theme[ThemeKeys.TextSuccess]))
    }
  }
  example("Low and Normal Dpi Icons") {
    Row(horizontalArrangement = Arrangement.spacedBy(10.dp)) {
      val normalDensity = LocalDensity.current
      CompositionLocalProvider(LocalDensity provides Density(0.5f, 1f)) {
        Icon(IconKey("icons.debugger-nodes.variable"), modifier = Modifier.scale(normalDensity.density / LocalDensity.current.density))
      }
      Icon(IconKey("icons.debugger-nodes.variable"))
    }
  }
  example("ListView with Compose Icons") {
    listView(
      listModel = listModel(
        size = 10000
      ) { idx ->
        ListItem(idx, idx) { opts ->
          Row(horizontalArrangement = Arrangement.spacedBy(10.dp)) {
            Icon(IconKey("icons.github"), modifier = Modifier.scale(3f))
            repeat(50) {
              scope(it) {
                Icon(IconKey("icons.github"))
              }
            }
            Icon(IconKey("icons.github"), size = DpSize(40.dp, 40.dp))
            UiText("Row #$idx")
          }
        }
      },
      modifier = Modifier.height(600.dp),
      stretchHorizontally = true
    )
  }
}