import expand, {extract} from 'emmet';

const args = process.argv.slice(2);
const line = args[0]
const opts = args[1]
let data = extract(line);

if (data === undefined) {
  process.stderr.write("Can't parse input: `" + line + "`")
  process.exit(1);
}

const field = function (index, placeholder, offset, line, column) {
    if (placeholder !== '')
        return '${' + index + ':' + placeholder + '}'
    return '${' + index + '}'
}

let options = {};
if (opts != null) {
    options = JSON.parse(opts)
}

const preview = expand(data.abbreviation, options);
const snippet = expand(data.abbreviation, {...options, 'options': {'output.field': field}})
const result = {
    'line': line,
    'preview': preview,
    'snippet': snippet,
    'abbreviation': {
        'abbreviation': data.abbreviation,
        'location': data.location,
        'start': data.start,
        'end': data.end,
    },
}

const json = JSON.stringify(result);

function chunkSubstr(str, size) {
  const numChunks = Math.ceil(str.length / size)
  const chunks = new Array(numChunks)

  for (let i = 0, o = 0; i < numChunks; ++i, o += size) {
    chunks[i] = str.substr(o, size)
  }

  return chunks
}

const chunks = chunkSubstr(json, 1000);

for (let i in chunks) {
  process.stdout.write(chunks[i]);
}