(function() {
  const hasHrefAttribute = (target) => {
    return target.hasAttribute('href') || target.hasAttribute('xlink:href');
  };
  const getHrefAttribute = (target) => {
    return target.getAttribute('href') || target.getAttribute('xlink:href');
  };

  const isLinkElement = (element) => {
    return element.tagName?.toLowerCase() === "a";
  };

  const processLinkClick = (element) => {
    if (!hasHrefAttribute(element)) {
      return false;
    }
    const href = getHrefAttribute(element);
    if (!href.startsWith("#")) {
      return false;
    }
    const elementId = href.toLowerCase().substring(1);
    const decodedElementId = decodeURI(elementId);
    const elementById = window.document.getElementById(decodedElementId);
    if (elementById) {
      // Chromium only
      // noinspection JSUnresolvedReference
      elementById.scrollIntoViewIfNeeded();
      return true;
    }
    return false;
  };

  const findLinkElement = (element) => {
    let target = element;
    while (target && !isLinkElement(target)) {
      target = target.parentNode;
    }
    return target;
  };

  window.document.addEventListener("click", (event) => {
    const target = findLinkElement(event.target);
    if (!target) {
      return;
    }
    if (isLinkElement(target) && hasHrefAttribute(target)) {
      const wasHandled = processLinkClick(target);
      if (wasHandled) {
        event.stopPropagation();
        event.preventDefault();
      }
    }
  });
})();
