/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.lang.javascript.parsing;

import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.lang.javascript.parsing.FunctionParser;
import fleet.com.intellij.lang.javascript.parsing.JavaScriptParser;
import fleet.com.intellij.lang.javascript.parsing.modifiers.JSModifiersStructure;
import fleet.com.intellij.openapi.util.Key;
import fleet.com.intellij.psi.PsiElement;
import java.util.EnumSet;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class JSParsingContextUtil {
    public static final Key<Function<PsiBuilder, JavaScriptParser<?, ?, ?, ?>>> PARSER_FACTORY_KEY = Key.create((String)"js.parser.factory");
    public static final Key<Boolean> ASYNC_METHOD_KEY = Key.create((String)"js.asyncMethod");
    private static final Key<Boolean> IS_GENERATOR_FUNCTION_KEY = Key.create((String)"js.generator.Function");
    static final boolean IS_TOP_LEVEL_ASYNC = true;

    static void fillBuilderData(@NotNull PsiElement context, PsiBuilder builder, FunctionParser functionParser) {
        throw new Error(context.getClass().getName() + ": " + context.getText());
    }

    public static boolean isAsyncContext(PsiBuilder builder) {
        Boolean asyncValue = (Boolean)builder.getUserData(ASYNC_METHOD_KEY);
        if (asyncValue == null) {
            return true;
        }
        return asyncValue;
    }

    static boolean isGeneratorContext(PsiBuilder builder) {
        return Boolean.TRUE.equals(builder.getUserData(IS_GENERATOR_FUNCTION_KEY));
    }

    public static void setIsGenerator(boolean isGenerator, PsiBuilder builder) {
        builder.putUserData(IS_GENERATOR_FUNCTION_KEY, (Object)isGenerator);
    }

    @NotNull
    public static EnumSet<JSModifiersStructure.JSModifiersParseResult> saveAndUpdateParsingContext(@NotNull EnumSet<JSModifiersStructure.JSModifiersParseResult> newContext, @NotNull PsiBuilder builder) {
        boolean wasGeneratorContext = JSParsingContextUtil.isGeneratorContext(builder);
        boolean wasAsyncContext = JSParsingContextUtil.isAsyncContext(builder);
        JSParsingContextUtil.restoreParsingContext(newContext, builder);
        return wasGeneratorContext ? (wasAsyncContext ? EnumSet.of(JSModifiersStructure.JSModifiersParseResult.MULT_FOUND, JSModifiersStructure.JSModifiersParseResult.ASYNC_FOUND) : EnumSet.of(JSModifiersStructure.JSModifiersParseResult.MULT_FOUND)) : (wasAsyncContext ? EnumSet.of(JSModifiersStructure.JSModifiersParseResult.ASYNC_FOUND) : EnumSet.noneOf(JSModifiersStructure.JSModifiersParseResult.class));
    }

    public static void restoreParsingContext(@NotNull EnumSet<JSModifiersStructure.JSModifiersParseResult> savedContext, @NotNull PsiBuilder builder) {
        JSParsingContextUtil.setIsGenerator(savedContext.contains((Object)JSModifiersStructure.JSModifiersParseResult.MULT_FOUND), builder);
        builder.putUserData(ASYNC_METHOD_KEY, (Object)savedContext.contains((Object)JSModifiersStructure.JSModifiersParseResult.ASYNC_FOUND));
    }
}

