/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.lang.javascript.flow.psi;

import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.lang.ecmascript6.parsing.ES6FunctionParser;
import fleet.com.intellij.lang.javascript.JSKeywordSets;
import fleet.com.intellij.lang.javascript.JSStubElementTypes;
import fleet.com.intellij.lang.javascript.JSTokenTypes;
import fleet.com.intellij.lang.javascript.ecmascript6.parsing.jsx.JSXExpressionParser;
import fleet.com.intellij.lang.javascript.flow.psi.FlowInJSPsiTypeParser;
import fleet.com.intellij.lang.javascript.flow.psi.FlowJSParser;
import fleet.com.intellij.openapi.util.Ref;
import fleet.com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public final class FlowJSExpressionParser
extends JSXExpressionParser<FlowJSParser> {
    private int myParenthesizedLevel = 0;

    public FlowJSExpressionParser(FlowJSParser parser) {
        super(parser);
    }

    @Override
    protected boolean parseUnaryExpression() {
        if (this.builder.getTokenType() == JSTokenTypes.LT && ((ES6FunctionParser)((FlowJSParser)this.myJavaScriptParser).getFunctionParser()).parseArrowFunction()) {
            return true;
        }
        return super.parseUnaryExpression();
    }

    @Override
    protected int getCurrentBinarySignPriority(boolean allowIn, boolean advance) {
        int x = FlowJSExpressionParser.collapseGtAndGetPriority(advance, this.builder);
        if (x > 0) {
            return x;
        }
        return super.getCurrentBinarySignPriority(allowIn, advance);
    }

    @Override
    protected boolean isFunctionPropertyStart(@NotNull PsiBuilder builder) {
        return JSKeywordSets.PROPERTY_NAMES.contains(builder.getTokenType()) && builder.lookAhead(1) == JSTokenTypes.LT || super.isFunctionPropertyStart(builder);
    }

    @Override
    protected void parseDestructuringArrayElement() {
        PsiBuilder.Marker arrayElement = this.builder.mark();
        if (this.builder.getTokenType() == JSTokenTypes.DOT_DOT_DOT) {
            this.parseDestructuringRestElementNoMarker(true);
            arrayElement.done((IElementType)JSStubElementTypes.DESTRUCTURING_ARRAY_REST);
            return;
        }
        arrayElement.done(this.parseDestructuringElementNoMarker(true, false));
    }

    @Override
    protected boolean parseDialectSpecificMemberExpressionPart(Ref<PsiBuilder.Marker> markerRef, boolean isInExtendsOrImplementsList) {
        if (((FlowInJSPsiTypeParser)((FlowJSParser)this.myJavaScriptParser).getTypeParser()).parseOptionalTypeArgumentListInExpression()) {
            return true;
        }
        return super.parseDialectSpecificMemberExpressionPart(markerRef, isInExtendsOrImplementsList);
    }

    @Override
    public void parseParenthesizedExpression() {
        try {
            ++this.myParenthesizedLevel;
            super.parseParenthesizedExpression();
        }
        finally {
            --this.myParenthesizedLevel;
        }
    }

    public int getParenthesizedLevel() {
        return this.myParenthesizedLevel;
    }

    @Override
    protected IElementType getFunctionPropertyElementType() {
        return JSStubElementTypes.TYPESCRIPT_FUNCTION_PROPERTY;
    }
}

