/*
 * Decompiled with CFR 0.152.
 */
package fleet.frontend.run.api.macro;

import com.jetbrains.rhizomedb.ChangeScope;
import com.jetbrains.rhizomedb.EntitiesKt;
import fleet.api.FileAddress;
import fleet.frontend.run.api.macro.MacroBuilderEntry;
import fleet.frontend.run.api.macro.MacroContext;
import fleet.frontend.run.api.macro.MacroEntity;
import fleet.frontend.run.api.macro.MacroEvaluationScope;
import fleet.frontend.run.api.macro.MacroProviderBuilder;
import fleet.frontend.run.api.macro.MacroRequirement;
import fleet.frontend.run.api.macro.MacroSupportCheckerEntity;
import fleet.kernel.plugins.ContributionScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a#\u0010\u0007\u001a\u00020\b*\u00020\t2\u0017\u0010\n\u001a\u0013\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\b0\u000b\u00a2\u0006\u0002\b\r\u001a\u001e\u0010\u000e\u001a\u00020\b*\u00020\t2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00030\u000b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0002\u001a\u00020\u0003*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"MACRO_REGEX", "Lkotlin/text/Regex;", "supportsMacros", "", "Lfleet/api/FileAddress;", "getSupportsMacros", "(Lfleet/api/FileAddress;)Z", "macroProvider", "", "Lfleet/kernel/plugins/ContributionScope;", "builder", "Lkotlin/Function1;", "Lfleet/frontend/run/api/macro/MacroProviderBuilder;", "Lkotlin/ExtensionFunctionType;", "macroSupport", "checker", "fleet.run.frontend"})
@SourceDebugExtension(value={"SMAP\nMacroBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MacroBuilder.kt\nfleet/frontend/run/api/macro/MacroBuilderKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,160:1\n1855#2,2:161\n1747#2,3:163\n*S KotlinDebug\n*F\n+ 1 MacroBuilder.kt\nfleet/frontend/run/api/macro/MacroBuilderKt\n*L\n57#1:161,2\n130#1:163,3\n*E\n"})
public final class MacroBuilderKt {
    @NotNull
    private static final Regex MACRO_REGEX = new Regex("[a-zA-Z0-9_]+");

    public static final void macroProvider(@NotNull ContributionScope $this$macroProvider, @NotNull Function1<? super MacroProviderBuilder, Unit> builder2) {
        Intrinsics.checkNotNullParameter((Object)$this$macroProvider, (String)"<this>");
        Intrinsics.checkNotNullParameter(builder2, (String)"builder");
        Set contexts = new LinkedHashSet();
        List macros = new ArrayList();
        builder2.invoke((Object)new MacroProviderBuilder(contexts, macros){
            final /* synthetic */ Set<MacroContext<?>> $contexts;
            final /* synthetic */ List<MacroBuilderEntry> $macros;
            {
                this.$contexts = $contexts;
                this.$macros = $macros;
            }

            @NotNull
            public <T> MacroRequirement.Required<T> required(@NotNull MacroContext<T> context) {
                Intrinsics.checkNotNullParameter(context, (String)"context");
                this.$contexts.add(context);
                return new MacroRequirement.Required<T>(context);
            }

            @NotNull
            public <T> MacroRequirement.Optional<T> optional(@NotNull MacroContext<T> context) {
                Intrinsics.checkNotNullParameter(context, (String)"context");
                return new MacroRequirement.Optional<T>(context);
            }

            public void macro(@NotNull String name, int priority, @NotNull Function1<? super MacroEvaluationScope, String> evaluator) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter(evaluator, (String)"evaluator");
                CharSequence charSequence = name;
                if (!MacroBuilderKt.access$getMACRO_REGEX$p().matches(charSequence)) {
                    boolean bl = false;
                    String string = "Macro names may only consist of alphanumeric letters and underscores";
                    throw new IllegalArgumentException(string.toString());
                }
                String string = name.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
                this.$macros.add(new MacroBuilderEntry(string, priority, evaluator));
            }
        });
        Iterable $this$forEach$iv = macros;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MacroBuilderEntry macroBuilderEntry = (MacroBuilderEntry)element$iv;
            boolean bl = false;
            String name = macroBuilderEntry.component1();
            int priority = macroBuilderEntry.component2();
            Function1<MacroEvaluationScope, String> evaluator = macroBuilderEntry.component3();
            ChangeScope.DefaultImpls.new$default((ChangeScope)((ChangeScope)$this$macroProvider), (KClass)Reflection.getOrCreateKotlinClass(MacroEntity.class), (int)0, (Function1)((Function1)new Function1<MacroEntity, Unit>(name, priority, evaluator, contexts){
                final /* synthetic */ String $name;
                final /* synthetic */ int $priority;
                final /* synthetic */ Function1<MacroEvaluationScope, String> $evaluator;
                final /* synthetic */ Set<MacroContext<?>> $contexts;
                {
                    this.$name = $name;
                    this.$priority = $priority;
                    this.$evaluator = $evaluator;
                    this.$contexts = $contexts;
                    super(1);
                }

                public final void invoke(@NotNull MacroEntity $this$new) {
                    Intrinsics.checkNotNullParameter((Object)$this$new, (String)"$this$new");
                    $this$new.setName(this.$name);
                    $this$new.setPriority(this.$priority);
                    $this$new.setEvaluator(this.$evaluator);
                    $this$new.setContexts(CollectionsKt.toSet((Iterable)this.$contexts));
                }
            }), (int)2, null);
        }
    }

    public static final void macroSupport(@NotNull ContributionScope $this$macroSupport, @NotNull Function1<? super FileAddress, Boolean> checker) {
        Intrinsics.checkNotNullParameter((Object)$this$macroSupport, (String)"<this>");
        Intrinsics.checkNotNullParameter(checker, (String)"checker");
        ChangeScope.DefaultImpls.new$default((ChangeScope)((ChangeScope)$this$macroSupport), (KClass)Reflection.getOrCreateKotlinClass(MacroSupportCheckerEntity.class), (int)0, (Function1)((Function1)new Function1<MacroSupportCheckerEntity, Unit>(checker){
            final /* synthetic */ Function1<FileAddress, Boolean> $checker;
            {
                this.$checker = $checker;
                super(1);
            }

            public final void invoke(@NotNull MacroSupportCheckerEntity $this$new) {
                Intrinsics.checkNotNullParameter((Object)$this$new, (String)"$this$new");
                $this$new.setChecker(this.$checker);
            }
        }), (int)2, null);
    }

    public static final boolean getSupportsMacros(@NotNull FileAddress $this$supportsMacros) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$supportsMacros, (String)"<this>");
            Iterable $this$any$iv = EntitiesKt.byEntityType((KClass)Reflection.getOrCreateKotlinClass(MacroSupportCheckerEntity.class));
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    MacroSupportCheckerEntity it = (MacroSupportCheckerEntity)element$iv;
                    boolean bl2 = false;
                    if (!((Boolean)it.getChecker().invoke((Object)$this$supportsMacros)).booleanValue()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final /* synthetic */ Regex access$getMACRO_REGEX$p() {
        return MACRO_REGEX;
    }
}

