/*
 * Decompiled with CFR 0.152.
 */
package fleet.plugins.dotnet.frontend.features.formatter;

import boringFormatter.indenter.IndentParserSpecific;
import fleet.com.intellij.psi.TokenType;
import fleet.com.jetbrains.lang.syntax.SyntaxNode;
import fleet.com.jetbrains.lang.syntax.SyntaxNodeExtKt;
import fleet.plugins.dotnet.frontend.features.psi.CSharpTokenType;
import fleet.plugins.dotnet.frontend.features.psi.CsTreeUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0016J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0016J\r\u0010\u000f\u001a\u00020\u0004*\u00020\u0004H\u0082\u0010J\u000e\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u0004H\u0002J\r\u0010\u0010\u001a\u00020\u0004*\u00020\u0004H\u0082\u0010\u00a8\u0006\u0011"}, d2={"Lfleet/plugins/dotnet/frontend/features/formatter/CsIndentingLanguageSpecific;", "LboringFormatter/indenter/IndentParserSpecific;", "()V", "getBaseIndentNode", "Lfleet/com/jetbrains/lang/syntax/SyntaxNode;", "nodeFrom", "nodeTo", "getBaseNode", "root", "range", "Lkotlin/ranges/LongRange;", "isNewLine", "", "token", "isSpace", "getAncestorThatStartsFromNewLine", "highestAncestor", "fleet.plugins.dotnet.frontend"})
public final class CsIndentingLanguageSpecific
implements IndentParserSpecific {
    @NotNull
    public static final CsIndentingLanguageSpecific INSTANCE = new CsIndentingLanguageSpecific();

    private CsIndentingLanguageSpecific() {
    }

    @NotNull
    public SyntaxNode getBaseNode(@NotNull SyntaxNode root2, @NotNull LongRange range) {
        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        long fromOffset = range.getStart();
        long toOffset = range.getEndInclusive();
        if (toOffset == 0L) {
            return root2;
        }
        SyntaxNode syntaxNode = SyntaxNodeExtKt.leafByOffset((SyntaxNode)root2, (long)toOffset);
        if (syntaxNode == null) {
            SyntaxNode syntaxNode2 = SyntaxNodeExtKt.leafByOffset((SyntaxNode)root2, (long)(toOffset - 1L));
            syntaxNode = syntaxNode2;
            Intrinsics.checkNotNull((Object)syntaxNode2);
        }
        SyntaxNode nodeTo = syntaxNode;
        if (fromOffset == toOffset) {
            return this.getBaseIndentNode(nodeTo, nodeTo);
        }
        SyntaxNode syntaxNode3 = SyntaxNodeExtKt.leafByOffset((SyntaxNode)root2, (long)fromOffset);
        if (syntaxNode3 == null) {
            return this.highestAncestor(root2);
        }
        SyntaxNode nodeFrom = syntaxNode3;
        return this.getBaseIndentNode(nodeFrom, nodeTo);
    }

    public boolean isNewLine(@NotNull SyntaxNode token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        return Intrinsics.areEqual((Object)token.getType(), (Object)((Object)CSharpTokenType.NEW_LINE));
    }

    public boolean isSpace(@NotNull SyntaxNode token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        return Intrinsics.areEqual((Object)token.getType(), (Object)TokenType.WHITE_SPACE);
    }

    private final SyntaxNode getBaseIndentNode(SyntaxNode nodeFrom, SyntaxNode nodeTo) {
        if (Intrinsics.areEqual((Object)nodeTo, (Object)nodeFrom)) {
            SyntaxNode syntaxNode = this.getBaseIndentNode(nodeTo);
            if (syntaxNode == null) {
                syntaxNode = this.highestAncestor(nodeFrom);
            }
            return syntaxNode;
        }
        SyntaxNode lca = CsTreeUtilsKt.lowestCommonAncestor(nodeFrom, nodeTo);
        SyntaxNode ancestorThatStartsFromNewLine = this.getAncestorThatStartsFromNewLine(lca);
        if (ancestorThatStartsFromNewLine.getStartOffset() < nodeFrom.getStartOffset()) {
            return ancestorThatStartsFromNewLine;
        }
        SyntaxNode syntaxNode = this.getBaseIndentNode(ancestorThatStartsFromNewLine);
        if (syntaxNode == null) {
            syntaxNode = this.highestAncestor(ancestorThatStartsFromNewLine);
        }
        return syntaxNode;
    }

    private final SyntaxNode getBaseIndentNode(SyntaxNode $this$getBaseIndentNode) {
        SyntaxNode syntaxNode;
        if (Intrinsics.areEqual((Object)$this$getBaseIndentNode.getType(), (Object)TokenType.WHITE_SPACE)) {
            syntaxNode = CsTreeUtilsKt.nextNonWhiteSpace($this$getBaseIndentNode);
            if (syntaxNode == null) {
                return null;
            }
        } else {
            syntaxNode = $this$getBaseIndentNode;
        }
        SyntaxNode current = syntaxNode;
        long begin = current.getStartOffset();
        if (Intrinsics.areEqual((Object)current.getType(), (Object)((Object)CSharpTokenType.RBRACE)) || Intrinsics.areEqual((Object)current.getType(), (Object)((Object)CSharpTokenType.RPARENTH)) || Intrinsics.areEqual((Object)current.getType(), (Object)((Object)CSharpTokenType.RBRACKET))) {
            SyntaxNode syntaxNode2 = current.parent();
            if (syntaxNode2 == null) {
                return null;
            }
            current = syntaxNode2;
        }
        while (current.getStartOffset() >= begin || !CsTreeUtilsKt.startsFromNewLine(current)) {
            SyntaxNode syntaxNode3 = current.parent();
            SyntaxNode sibling = (syntaxNode3 != null ? CsTreeUtilsKt.isCsList(syntaxNode3) : false) ? CsTreeUtilsKt.prevNonTokenNonPPSibling(current) : null;
            SyntaxNode syntaxNode4 = sibling;
            if (syntaxNode4 == null && (syntaxNode4 = current.parent()) == null) {
                return current;
            }
            current = syntaxNode4;
        }
        return current;
    }

    private final SyntaxNode highestAncestor(SyntaxNode $this$highestAncestor) {
        while ($this$highestAncestor.parent() != null) {
            SyntaxNode parent;
            $this$highestAncestor = parent;
        }
        return $this$highestAncestor;
    }

    private final SyntaxNode getAncestorThatStartsFromNewLine(SyntaxNode $this$getAncestorThatStartsFromNewLine) {
        while (!CsTreeUtilsKt.startsFromNewLine($this$getAncestorThatStartsFromNewLine)) {
            SyntaxNode syntaxNode;
            CsIndentingLanguageSpecific csIndentingLanguageSpecific = this_;
            if ($this$getAncestorThatStartsFromNewLine.parent() == null) {
                throw new Exception("");
            }
            CsIndentingLanguageSpecific this_ = csIndentingLanguageSpecific;
            $this$getAncestorThatStartsFromNewLine = syntaxNode;
        }
        return $this$getAncestorThatStartsFromNewLine;
    }
}

