/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal.model;

import com.jediterm.terminal.TerminalColor;
import com.jediterm.terminal.TextStyle;
import org.jetbrains.annotations.NotNull;

public class StyleState {
    private volatile TextStyle myCurrentStyle = TextStyle.EMPTY;
    private volatile TextStyle myDefaultStyle = TextStyle.EMPTY;

    @NotNull
    public TextStyle getCurrent() {
        return this.myCurrentStyle;
    }

    public void reset() {
        this.myCurrentStyle = this.myDefaultStyle;
    }

    public void set(StyleState styleState) {
        this.setCurrent(styleState.getCurrent());
    }

    public void setDefaultStyle(TextStyle defaultStyle) {
        this.myDefaultStyle = defaultStyle;
    }

    public TerminalColor getBackground() {
        return this.getBackground(null);
    }

    public TerminalColor getBackground(TerminalColor color) {
        return color != null ? color : this.myDefaultStyle.getBackground();
    }

    public TerminalColor getForeground() {
        return this.getForeground(null);
    }

    public TerminalColor getForeground(TerminalColor color) {
        return color != null ? color : this.myDefaultStyle.getForeground();
    }

    public void setCurrent(TextStyle current) {
        this.myCurrentStyle = current;
    }
}

