/*
 * Decompiled with CFR 0.152.
 */
package fleet.frontend.clipboard;

import fleet.api.FileAddress;
import fleet.api.ProtocolPath;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0004\u0007\b\t\nB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0004\u000b\f\r\u000e\u00a8\u0006\u000f"}, d2={"Lfleet/frontend/clipboard/PasteOperation;", "", "()V", "pathRepresentation", "Lfleet/api/ProtocolPath;", "getPathRepresentation", "()Lfleet/api/ProtocolPath;", "CopyFile", "CreateDir", "DeleteDir", "RevealFile", "Lfleet/frontend/clipboard/PasteOperation$CopyFile;", "Lfleet/frontend/clipboard/PasteOperation$CreateDir;", "Lfleet/frontend/clipboard/PasteOperation$DeleteDir;", "Lfleet/frontend/clipboard/PasteOperation$RevealFile;", "fleet.frontend"})
abstract class PasteOperation {
    private PasteOperation() {
    }

    @NotNull
    public abstract ProtocolPath getPathRepresentation();

    public /* synthetic */ PasteOperation(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lfleet/frontend/clipboard/PasteOperation$CopyFile;", "Lfleet/frontend/clipboard/PasteOperation;", "sourceFile", "Lfleet/api/FileAddress;", "targetFile", "(Lfleet/api/FileAddress;Lfleet/api/FileAddress;)V", "pathRepresentation", "Lfleet/api/ProtocolPath;", "getPathRepresentation", "()Lfleet/api/ProtocolPath;", "getSourceFile", "()Lfleet/api/FileAddress;", "getTargetFile", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "fleet.frontend"})
    public static final class CopyFile
    extends PasteOperation {
        @NotNull
        private final FileAddress sourceFile;
        @NotNull
        private final FileAddress targetFile;
        @NotNull
        private final ProtocolPath pathRepresentation;

        public CopyFile(@NotNull FileAddress sourceFile, @NotNull FileAddress targetFile) {
            Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
            Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
            super(null);
            this.sourceFile = sourceFile;
            this.targetFile = targetFile;
            this.pathRepresentation = this.targetFile.getPath();
        }

        @NotNull
        public final FileAddress getSourceFile() {
            return this.sourceFile;
        }

        @NotNull
        public final FileAddress getTargetFile() {
            return this.targetFile;
        }

        @Override
        @NotNull
        public ProtocolPath getPathRepresentation() {
            return this.pathRepresentation;
        }

        @NotNull
        public final FileAddress component1() {
            return this.sourceFile;
        }

        @NotNull
        public final FileAddress component2() {
            return this.targetFile;
        }

        @NotNull
        public final CopyFile copy(@NotNull FileAddress sourceFile, @NotNull FileAddress targetFile) {
            Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
            Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
            return new CopyFile(sourceFile, targetFile);
        }

        public static /* synthetic */ CopyFile copy$default(CopyFile copyFile, FileAddress fileAddress, FileAddress fileAddress2, int n, Object object) {
            if ((n & 1) != 0) {
                fileAddress = copyFile.sourceFile;
            }
            if ((n & 2) != 0) {
                fileAddress2 = copyFile.targetFile;
            }
            return copyFile.copy(fileAddress, fileAddress2);
        }

        @NotNull
        public String toString() {
            return "CopyFile(sourceFile=" + this.sourceFile + ", targetFile=" + this.targetFile + ")";
        }

        public int hashCode() {
            int result2 = this.sourceFile.hashCode();
            result2 = result2 * 31 + this.targetFile.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CopyFile)) {
                return false;
            }
            CopyFile copyFile = (CopyFile)other;
            if (!Intrinsics.areEqual((Object)this.sourceFile, (Object)copyFile.sourceFile)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.targetFile, (Object)copyFile.targetFile);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lfleet/frontend/clipboard/PasteOperation$CreateDir;", "Lfleet/frontend/clipboard/PasteOperation;", "fileAddress", "Lfleet/api/FileAddress;", "(Lfleet/api/FileAddress;)V", "getFileAddress", "()Lfleet/api/FileAddress;", "pathRepresentation", "Lfleet/api/ProtocolPath;", "getPathRepresentation", "()Lfleet/api/ProtocolPath;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "fleet.frontend"})
    public static final class CreateDir
    extends PasteOperation {
        @NotNull
        private final FileAddress fileAddress;
        @NotNull
        private final ProtocolPath pathRepresentation;

        public CreateDir(@NotNull FileAddress fileAddress) {
            Intrinsics.checkNotNullParameter((Object)fileAddress, (String)"fileAddress");
            super(null);
            this.fileAddress = fileAddress;
            this.pathRepresentation = this.fileAddress.getPath();
        }

        @NotNull
        public final FileAddress getFileAddress() {
            return this.fileAddress;
        }

        @Override
        @NotNull
        public ProtocolPath getPathRepresentation() {
            return this.pathRepresentation;
        }

        @NotNull
        public final FileAddress component1() {
            return this.fileAddress;
        }

        @NotNull
        public final CreateDir copy(@NotNull FileAddress fileAddress) {
            Intrinsics.checkNotNullParameter((Object)fileAddress, (String)"fileAddress");
            return new CreateDir(fileAddress);
        }

        public static /* synthetic */ CreateDir copy$default(CreateDir createDir, FileAddress fileAddress, int n, Object object) {
            if ((n & 1) != 0) {
                fileAddress = createDir.fileAddress;
            }
            return createDir.copy(fileAddress);
        }

        @NotNull
        public String toString() {
            return "CreateDir(fileAddress=" + this.fileAddress + ")";
        }

        public int hashCode() {
            return this.fileAddress.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CreateDir)) {
                return false;
            }
            CreateDir createDir = (CreateDir)other;
            return Intrinsics.areEqual((Object)this.fileAddress, (Object)createDir.fileAddress);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lfleet/frontend/clipboard/PasteOperation$DeleteDir;", "Lfleet/frontend/clipboard/PasteOperation;", "sourceToDelete", "Lfleet/api/FileAddress;", "(Lfleet/api/FileAddress;)V", "pathRepresentation", "Lfleet/api/ProtocolPath;", "getPathRepresentation", "()Lfleet/api/ProtocolPath;", "getSourceToDelete", "()Lfleet/api/FileAddress;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "fleet.frontend"})
    public static final class DeleteDir
    extends PasteOperation {
        @NotNull
        private final FileAddress sourceToDelete;
        @NotNull
        private final ProtocolPath pathRepresentation;

        public DeleteDir(@NotNull FileAddress sourceToDelete) {
            Intrinsics.checkNotNullParameter((Object)sourceToDelete, (String)"sourceToDelete");
            super(null);
            this.sourceToDelete = sourceToDelete;
            this.pathRepresentation = this.sourceToDelete.getPath();
        }

        @NotNull
        public final FileAddress getSourceToDelete() {
            return this.sourceToDelete;
        }

        @Override
        @NotNull
        public ProtocolPath getPathRepresentation() {
            return this.pathRepresentation;
        }

        @NotNull
        public final FileAddress component1() {
            return this.sourceToDelete;
        }

        @NotNull
        public final DeleteDir copy(@NotNull FileAddress sourceToDelete) {
            Intrinsics.checkNotNullParameter((Object)sourceToDelete, (String)"sourceToDelete");
            return new DeleteDir(sourceToDelete);
        }

        public static /* synthetic */ DeleteDir copy$default(DeleteDir deleteDir, FileAddress fileAddress, int n, Object object) {
            if ((n & 1) != 0) {
                fileAddress = deleteDir.sourceToDelete;
            }
            return deleteDir.copy(fileAddress);
        }

        @NotNull
        public String toString() {
            return "DeleteDir(sourceToDelete=" + this.sourceToDelete + ")";
        }

        public int hashCode() {
            return this.sourceToDelete.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DeleteDir)) {
                return false;
            }
            DeleteDir deleteDir = (DeleteDir)other;
            return Intrinsics.areEqual((Object)this.sourceToDelete, (Object)deleteDir.sourceToDelete);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lfleet/frontend/clipboard/PasteOperation$RevealFile;", "Lfleet/frontend/clipboard/PasteOperation;", "fileAddress", "Lfleet/api/FileAddress;", "(Lfleet/api/FileAddress;)V", "getFileAddress", "()Lfleet/api/FileAddress;", "pathRepresentation", "Lfleet/api/ProtocolPath;", "getPathRepresentation", "()Lfleet/api/ProtocolPath;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "fleet.frontend"})
    public static final class RevealFile
    extends PasteOperation {
        @NotNull
        private final FileAddress fileAddress;
        @NotNull
        private final ProtocolPath pathRepresentation;

        public RevealFile(@NotNull FileAddress fileAddress) {
            Intrinsics.checkNotNullParameter((Object)fileAddress, (String)"fileAddress");
            super(null);
            this.fileAddress = fileAddress;
            this.pathRepresentation = this.fileAddress.getPath();
        }

        @NotNull
        public final FileAddress getFileAddress() {
            return this.fileAddress;
        }

        @Override
        @NotNull
        public ProtocolPath getPathRepresentation() {
            return this.pathRepresentation;
        }

        @NotNull
        public final FileAddress component1() {
            return this.fileAddress;
        }

        @NotNull
        public final RevealFile copy(@NotNull FileAddress fileAddress) {
            Intrinsics.checkNotNullParameter((Object)fileAddress, (String)"fileAddress");
            return new RevealFile(fileAddress);
        }

        public static /* synthetic */ RevealFile copy$default(RevealFile revealFile, FileAddress fileAddress, int n, Object object) {
            if ((n & 1) != 0) {
                fileAddress = revealFile.fileAddress;
            }
            return revealFile.copy(fileAddress);
        }

        @NotNull
        public String toString() {
            return "RevealFile(fileAddress=" + this.fileAddress + ")";
        }

        public int hashCode() {
            return this.fileAddress.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RevealFile)) {
                return false;
            }
            RevealFile revealFile = (RevealFile)other;
            return Intrinsics.areEqual((Object)this.fileAddress, (Object)revealFile.fileAddress);
        }
    }
}

