/*
 * Decompiled with CFR 0.152.
 */
package fleet.frontend.actions;

import com.jetbrains.rhizomedb.EntitiesKt;
import fleet.compose.foundation.input.InputEvent;
import fleet.compose.foundation.input.InputHandlerModifierKt;
import fleet.frontend.FrontendPlugin;
import fleet.frontend.actions.ActionListenerEntity;
import fleet.frontend.actions.ActionsReportsKt;
import fleet.frontend.actions.FleetActionManagerKt;
import fleet.frontend.actions.FleetActionsKt;
import fleet.frontend.actions.FleetDataKeys;
import fleet.frontend.actions.InvocationQueueItem;
import fleet.frontend.actions.RememberedState;
import fleet.kernel.plugins.Plugin;
import fleet.kernel.plugins.PluginKt;
import fleet.kernel.plugins.PluginScope;
import fleet.reporting.fus.api.FusApi;
import fleet.util.logging.KLogger;
import fleet.util.logging.KLoggers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import noria.model.Action;
import noria.model.ActionContext;
import noria.model.ActionKt;
import noria.model.ActionManager;
import noria.model.ActionPresentation;
import noria.model.ActionTag;
import noria.model.ActionsKt;
import noria.model.CommonDataKeys;
import noria.model.FocusDataKey;
import noria.model.LastAppearedDataKey;
import noria.model.Propagate;
import noria.model.Trigger;
import noria.ui.core.Initiator;
import noria.ui.events.HandlerScope;
import noria.windowManagement.api.Window;
import noria.windowManagement.extensions.WindowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J.\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b0\n2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J2\u0010\u0013\u001a\u0016\u0012\u0004\u0012\u00020\u0014\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00150\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J,\u0010\u0013\u001a\u0016\u0012\u0004\u0012\u00020\u0014\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00150\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\fH\u0016J:\u0010\u0013\u001a\u0016\u0012\u0004\u0012\u00020\u0014\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00150\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\nH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001b"}, d2={"Lfleet/frontend/actions/FleetActionManager;", "Lnoria/model/ActionManager;", "window", "Lnoria/windowManagement/api/Window;", "(Lnoria/windowManagement/api/Window;)V", "logger", "Lfleet/util/logging/KLogger;", "getWindow", "()Lnoria/windowManagement/api/Window;", "availableActions", "", "Lkotlin/Pair;", "Lnoria/model/Action;", "Lnoria/model/ActionPresentation;", "actionContext", "Lnoria/model/ActionContext;", "triggers", "", "Lnoria/model/Trigger;", "performActionImpl", "Lnoria/model/Propagate;", "Lkotlinx/coroutines/Deferred;", "", "triggers2", "action", "tags", "Lnoria/model/ActionTag;", "fleet.frontend"})
@SourceDebugExtension(value={"SMAP\nFleetActionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FleetActionManager.kt\nfleet/frontend/actions/FleetActionManager\n+ 2 KLoggers.kt\nfleet/util/logging/KLoggersKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 KLogger.kt\nfleet/util/logging/KLogger\n*L\n1#1,270:1\n22#2:271\n1603#3,9:272\n1855#3:281\n1856#3:283\n1612#3:284\n1549#3:285\n1620#3,3:286\n1549#3:289\n1620#3,3:290\n766#3:296\n857#3,2:297\n1855#3,2:299\n1747#3,3:303\n1#4:282\n1#4:295\n9#5,2:293\n9#5,2:301\n5#5,2:306\n*S KotlinDebug\n*F\n+ 1 FleetActionManager.kt\nfleet/frontend/actions/FleetActionManager\n*L\n57#1:271\n63#1:272,9\n63#1:281\n63#1:283\n63#1:284\n72#1:285\n72#1:286,3\n77#1:289\n77#1:290,3\n117#1:296\n117#1:297,2\n153#1:299,2\n161#1:303,3\n63#1:282\n79#1:293,2\n159#1:301,2\n168#1:306,2\n*E\n"})
public final class FleetActionManager
implements ActionManager {
    @NotNull
    private final Window window;
    @NotNull
    private final KLogger logger;

    public FleetActionManager(@NotNull Window window2) {
        Intrinsics.checkNotNullParameter((Object)window2, (String)"window");
        this.window = window2;
        boolean $i$f$logger = false;
        this.logger = KLoggers.INSTANCE.logger(Reflection.getOrCreateKotlinClass(FleetActionManager.class));
    }

    @NotNull
    public final Window getWindow() {
        return this.window;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Pair<Propagate, Deferred<Unit>> performActionImpl(@NotNull ActionContext actionContext2, @NotNull Set<? extends Trigger> triggers2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)actionContext2, (String)"actionContext");
        Intrinsics.checkNotNullParameter(triggers2, (String)"triggers2");
        Set<? extends Trigger> triggers = triggers2;
        ActionContext preparedActionContext = ActionContext.put$default((ActionContext)actionContext2, (LastAppearedDataKey)CommonDataKeys.INSTANCE.getActionManager(), (Object)this, (int)0, (int)0, (int)8, null);
        Iterable iterable = FleetActionsKt.getWeightedActions(preparedActionContext, triggers);
        boolean $i$f$mapNotNull = false;
        void var8_8 = $this$mapNotNull$iv;
        Iterable<ActionContext.Data> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ActionContext.Data it$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ActionContext.Data it = (ActionContext.Data)element$iv$iv;
            boolean bl2 = false;
            Pair pair = (Pair)it.getValue();
            Action action = (Action)pair.component1();
            ActionPresentation actionPresentation = (ActionPresentation)pair.component2();
            if ((actionPresentation.getEnabled() ? new ActionContext.Data((Object)new InvocationQueueItem.ActionWithPresentation(action, actionPresentation), it.getFocusLayerIndex(), it.getWeight()) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List filteredActionsAndPresentations = (List)destination$iv$iv;
        Iterable $this$map$iv2 = preparedActionContext.getAllWeighted((FocusDataKey)InputHandlerModifierKt.getInputHandlerKey());
        boolean $i$f$map22 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            element$iv$iv$iv = (ActionContext.Data)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(new ActionContext.Data((Object)new InvocationQueueItem.InputHandler((Function2<? super HandlerScope, ? super InputEvent, ? extends Propagate>)((Function2)it.getValue())), it.getFocusLayerIndex(), it.getWeight()));
        }
        List inputHandlers = (List)destination$iv$iv2;
        Iterable $i$f$map22 = CollectionsKt.sortedDescending((Iterable)CollectionsKt.plus((Collection)filteredActionsAndPresentations, (Iterable)inputHandlers));
        boolean $i$f$map = false;
        destination$iv$iv2 = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ActionContext.Data bl = (ActionContext.Data)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl4 = false;
            collection.add((InvocationQueueItem)it.getValue());
        }
        List invocationQueue = (List)destination$iv$iv3;
        KLogger this_$iv = this.logger;
        boolean $i$f$debug = false;
        if (this_$iv.isDebugEnabled()) {
            collection = this_$iv;
            boolean bl = false;
            collection.debug("Mapped " + triggers + " to " + invocationQueue);
        }
        Pair<Propagate, Deferred<Unit>> invocationEvent = (Pair<Propagate, Deferred<Unit>>)actionContext2.get((FocusDataKey)CommonDataKeys.INSTANCE.getInvocationEvent());
        List completionDeferreds = new ArrayList();
        for (InvocationQueueItem item : invocationQueue) {
            Pair<Propagate, Deferred<Unit>> it;
            InvocationQueueItem invocationQueueItem = item;
            if (invocationQueueItem instanceof InvocationQueueItem.ActionWithPresentation) {
                Action action = ((InvocationQueueItem.ActionWithPresentation)item).component1();
                ActionPresentation presentation = ((InvocationQueueItem.ActionWithPresentation)item).component2();
                it = this.performActionImpl(preparedActionContext, action, presentation.getTags());
                Propagate result2 = (Propagate)it.component1();
                Deferred completionDeferred = (Deferred)it.component2();
                if (completionDeferred != null) {
                    Deferred it2;
                    boolean bl = false;
                    completionDeferreds.add(it2);
                }
                if (result2 != Propagate.STOP) continue;
                return TuplesKt.to((Object)Propagate.STOP, (Object)FleetActionManagerKt.access$waitForAllDeferred(completionDeferreds));
            }
            if (!(invocationQueueItem instanceof InvocationQueueItem.InputHandler)) continue;
            Function2<HandlerScope, InputEvent, Propagate> inputHandler = ((InvocationQueueItem.InputHandler)item).getValue();
            if (invocationEvent == null) continue;
            boolean bl = false;
            if (inputHandler.invoke((Object)new HandlerScope(actionContext2), it) != Propagate.STOP) continue;
            return TuplesKt.to((Object)Propagate.STOP, (Object)FleetActionManagerKt.access$waitForAllDeferred(completionDeferreds));
        }
        return TuplesKt.to((Object)Propagate.CONTINUE, null);
    }

    @NotNull
    public Pair<Propagate, Deferred<Unit>> performActionImpl(@NotNull ActionContext actionContext2, @NotNull Action action) {
        Object object;
        block3: {
            block2: {
                Pair<Propagate, Deferred<Unit>> pair;
                Intrinsics.checkNotNullParameter((Object)actionContext2, (String)"actionContext");
                Intrinsics.checkNotNullParameter((Object)action, (String)"action");
                ActionsKt.assertRequirementsAreMet((ActionContext)actionContext2, (Action)action);
                object = ActionsKt.presentation((Action)action, (ActionContext)actionContext2);
                if (object == null) break block2;
                Pair<Propagate, Deferred<Unit>> it = pair = object;
                boolean bl = false;
                object = it.getEnabled() ? pair : null;
                if (object == null) break block2;
                Pair<Propagate, Deferred<Unit>> presentation = object;
                boolean bl2 = false;
                Pair<Propagate, Deferred<Unit>> pair2 = this.performActionImpl(actionContext2, action, presentation.getTags());
                object = pair2;
                if (pair2 != null) break block3;
            }
            object = TuplesKt.to((Object)Propagate.CONTINUE, null);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<Action, ActionPresentation>> availableActions(@NotNull ActionContext actionContext2, @NotNull Set<? extends Trigger> triggers) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)actionContext2, (String)"actionContext");
        Intrinsics.checkNotNullParameter(triggers, (String)"triggers");
        ActionContext context = ActionContext.put$default((ActionContext)actionContext2, (LastAppearedDataKey)CommonDataKeys.INSTANCE.getActionManager(), (Object)this, (int)0, (int)0, (int)8, null);
        Iterable $this$filter$iv = FleetActionsKt.collectActions(context, triggers);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!((ActionPresentation)it.getSecond()).getEnabled()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Pair<Propagate, Deferred<Unit>> performActionImpl(ActionContext actionContext2, Action action, List<ActionTag> tags) {
        boolean bl;
        KLogger kLogger;
        KLogger this_$iv;
        Pair result2;
        block15: {
            Pair pair2;
            Lazy<RememberedState> lazy;
            FusApi fus;
            Trigger trigger = (Trigger)CollectionsKt.firstOrNull((Iterable)ActionKt.allTriggers((Action)action));
            FusApi fusApi = fus = (FusApi)actionContext2.get((FocusDataKey)FleetDataKeys.INSTANCE.getFusApi());
            if (fusApi != null) {
                FusApi it = fusApi;
                boolean pair2 = false;
                lazy = ActionsReportsKt.rememberState(action.getIdentifier(), trigger, actionContext2, tags);
            } else {
                lazy = null;
            }
            Lazy<RememberedState> rememberedState = lazy;
            ActionContext preparedActionContext = ActionContext.put$default((ActionContext)actionContext2, (LastAppearedDataKey)CommonDataKeys.INSTANCE.getActionManager(), (Object)this, (int)0, (int)0, (int)8, null).remove((FocusDataKey)CommonDataKeys.INSTANCE.getLayerIndexFilterForActions());
            try {
                pair2 = ActionsKt.performImplDoNotUse((Action)action, (ActionContext)preparedActionContext, (CoroutineScope)((CoroutineScope)PluginKt.findPluginScope((Plugin.Key)FrontendPlugin.Companion)));
            }
            catch (Throwable e) {
                this.logger.error(e, (Object)"Can't perform action");
                pair2 = TuplesKt.to((Object)Propagate.STOP, (Object)CompletableDeferredKt.CompletableDeferred((Object)Unit.INSTANCE));
            }
            result2 = pair2;
            FusApi fusApi2 = fus;
            if (fusApi2 != null) {
                FusApi it = fusApi2;
                boolean bl2 = false;
                Lazy<RememberedState> lazy2 = rememberedState;
                if (lazy2 != null) {
                    Lazy<RememberedState> it2 = lazy2;
                    boolean bl3 = false;
                    PluginScope pluginScope = PluginKt.findPluginScope((Plugin.Key)FrontendPlugin.Companion);
                    ((Deferred)result2.getSecond()).invokeOnCompletion((Function1)new Function1<Throwable, Unit>(pluginScope, fus, rememberedState){
                        final /* synthetic */ PluginScope $pluginScope;
                        final /* synthetic */ FusApi $fus;
                        final /* synthetic */ Lazy<RememberedState> $rememberedState;
                        {
                            this.$pluginScope = $pluginScope;
                            this.$fus = $fus;
                            this.$rememberedState = $rememberedState;
                            super(1);
                        }

                        public final void invoke(@Nullable Throwable it) {
                            BuildersKt.launch$default((CoroutineScope)((CoroutineScope)this.$pluginScope), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$fus, this.$rememberedState, null){
                                int label;
                                final /* synthetic */ FusApi $fus;
                                final /* synthetic */ Lazy<RememberedState> $rememberedState;
                                {
                                    this.$fus = $fus;
                                    this.$rememberedState = $rememberedState;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            ActionsReportsKt.reportInvocationToFus(this.$fus, (RememberedState)this.$rememberedState.getValue());
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)3, null);
                        }
                    });
                }
            }
            Iterable $this$forEach$iv = EntitiesKt.byEntityType((KClass)Reflection.getOrCreateKotlinClass(ActionListenerEntity.class));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Throwable throwable;
                Object object;
                ActionListenerEntity listener = (ActionListenerEntity)element$iv;
                boolean bl4 = false;
                try {
                    boolean bl5 = false;
                    listener.getListener().invoke((Object)action, (Object)preparedActionContext);
                    object = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable throwable2) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                }
                if (Result.exceptionOrNull-impl((Object)object) == null) continue;
                Throwable it = throwable;
                boolean bl6 = false;
                this.logger.error(it, (Object)("Exception on action listener execution. Listener: " + listener));
            }
            this_$iv = this.logger;
            boolean $i$f$debug = false;
            if (this_$iv.isDebugEnabled()) {
                kLogger = this_$iv;
                boolean bl7 = false;
                kLogger.debug((Object)("Received result " + result2.getFirst() + " from performing action " + action.getIdentifier()));
            }
            Iterable $this$any$iv = tags;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ActionTag it = (ActionTag)element$iv;
                    boolean bl8 = false;
                    boolean bl9 = Intrinsics.areEqual((Object)it, (Object)FleetActionsKt.getDOC_CHANGE_ACTION_TAG()) || Intrinsics.areEqual((Object)it, (Object)ActionsKt.getCARET_OR_SELECTION_CHANGE_ACTION_TAG()) || Intrinsics.areEqual((Object)it, (Object)FleetActionsKt.getSHOW_GOTO_PROVIDER_ACTION_TAG());
                    if (!bl9) continue;
                    bl = true;
                    break block15;
                }
                bl = false;
            }
        }
        if (bl && actionContext2.get((FocusDataKey)CommonDataKeys.INSTANCE.getInitiator()) == Initiator.KeyboardEvent && result2.getFirst() == Propagate.STOP) {
            this_$iv = this.logger;
            boolean $i$f$trace = false;
            if (this_$iv.isTraceEnabled()) {
                kLogger = this_$iv;
                boolean bl10 = false;
                kLogger.trace((Object)("Hide cursor while performing action " + action.getIdentifier()));
            }
            WindowKt.setCursorVisible((Window)this.window, (boolean)false);
        }
        return result2;
    }
}

