/*
 * Decompiled with CFR 0.152.
 */
package fleet.frontend.actions;

import com.jetbrains.rhizomedb.DbContext;
import com.jetbrains.rhizomedb.Entity;
import com.jetbrains.rhizomedb.Q;
import com.jetbrains.rhizomedb.impl.EntitiesImplKt;
import fleet.common.FleetCommonSettingsKeysKt;
import fleet.common.fus.validation.CustomValidationKt;
import fleet.dock.connectors.fus.EventContext;
import fleet.dock.connectors.fus.ValidationResult;
import fleet.dock.connectors.fus.ValidationRule;
import fleet.frontend.actions.ActionEntity;
import fleet.frontend.actions.ActionTriggerValidator;
import fleet.frontend.actions.ActionsReportsKt;
import fleet.util.logging.BaseLogger;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KMutableProperty1;
import kotlin.reflect.KProperty1;
import noria.model.ActionId;
import noria.model.CommonTrigger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lfleet/frontend/actions/ActionTriggerValidator;", "Lfleet/dock/connectors/fus/ValidationRule;", "()V", "isSafeToReport", "", "triggerIdent", "", "validate", "Lfleet/dock/connectors/fus/ValidationResult;", "data", "context", "Lfleet/dock/connectors/fus/EventContext;", "Companion", "fleet.frontend"})
@SourceDebugExtension(value={"SMAP\nActionsReports.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActionsReports.kt\nfleet/frontend/actions/ActionTriggerValidator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Entities.kt\ncom/jetbrains/rhizomedb/EntitiesKt\n*L\n1#1,387:1\n1747#2,3:388\n1747#2,3:392\n235#3:391\n*S KotlinDebug\n*F\n+ 1 ActionsReports.kt\nfleet/frontend/actions/ActionTriggerValidator\n*L\n338#1:388,3\n339#1:392,3\n339#1:391\n*E\n"})
public final class ActionTriggerValidator
implements ValidationRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String RULE_ID = "fleet.actions.trigger";

    @NotNull
    public ValidationResult validate(@NotNull String data, @NotNull EventContext context) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean isSafeToReport2 = this.isSafeToReport(data);
        if (!isSafeToReport2 && FleetCommonSettingsKeysKt.isInternalMode() && ((Number)ActionsReportsKt.access$getReported$p().getAndUpdate((Function1)validate.1.INSTANCE)).intValue() > 0) {
            BaseLogger.error$default((BaseLogger)((BaseLogger)ActionsReportsKt.access$getLogger()), (Throwable)new Throwable("Action trigger " + data + " was reported, but not registered. This is internal-mode-only error, please report it"), null, (int)2, null);
        }
        return isSafeToReport2 ? ValidationResult.ACCEPTED : ValidationResult.REJECTED;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isSafeToReport(@NotNull String triggerIdent) {
        ActionEntity actionEntity;
        void property$iv;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)triggerIdent, (String)"triggerIdent");
        Iterable $this$any$iv = (Iterable)EntriesMappings.entries$0;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                CommonTrigger it = (CommonTrigger)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)triggerIdent)) continue;
                return true;
            }
            bl = false;
        }
        if (bl) return true;
        $this$any$iv = (KMutableProperty1)isSafeToReport.2.INSTANCE;
        ActionId value$iv = new ActionId(triggerIdent);
        boolean $i$f$lookup = false;
        $this$any$iv = EntitiesImplKt.lookupImpl((Q)DbContext.Companion.getThreadBound().getImpl(), (KProperty1)((KProperty1)property$iv), (Object)value$iv, (KClass)Reflection.getOrCreateKotlinClass(ActionEntity.class));
        $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            Object element$iv;
            if (!iterator.hasNext()) return false;
            element$iv = iterator.next();
            actionEntity = (ActionEntity)element$iv;
            boolean bl3 = false;
        } while (!CustomValidationKt.isFromAllowedPlugin((ValidationRule.Companion)ValidationRule.Companion, (Entity)((Entity)actionEntity)));
        return true;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lfleet/frontend/actions/ActionTriggerValidator$Companion;", "", "()V", "RULE_ID", "", "getRULE_ID", "()Ljava/lang/String;", "fleet.frontend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getRULE_ID() {
            return RULE_ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<CommonTrigger> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])CommonTrigger.values()));
        }
    }
}

