/*
 * Decompiled with CFR 0.152.
 */
package org.clang.lex.llvm;

import org.clang.basic.DirectoryEntry;
import org.clang.basic.FileEntry;
import org.clank.java.std_pair;
import org.clank.support.NativePointer;
import org.clank.support.NativeType;
import org.llvm.adt.aliases.SmallVector;

public final class SmallVectorPtrPairFileEntryDirectoryEntry
implements NativeType.SizeofCapable {
    public static final SmallVectorPtrPairFileEntryDirectoryEntry DEFAULT = new SmallVectorPtrPairFileEntryDirectoryEntry(0, null);
    private FileEntry[] arrayFileEntry;
    private DirectoryEntry[] arrayDirectoryEntry;
    private int end;

    public SmallVectorPtrPairFileEntryDirectoryEntry(SmallVector<std_pair.pair<FileEntry, DirectoryEntry>> other) {
        int capacity = other.capacity();
        this.end = other.size();
        this.arrayFileEntry = new FileEntry[capacity];
        this.arrayDirectoryEntry = new DirectoryEntry[capacity];
        for (int i = 0; i < this.end; ++i) {
            std_pair.pair p = (std_pair.pair)other.$at(i);
            this.arrayFileEntry[i] = (FileEntry)p.first;
            this.arrayDirectoryEntry[i] = (DirectoryEntry)p.second;
        }
    }

    public SmallVectorPtrPairFileEntryDirectoryEntry(int capacity, std_pair.pair<FileEntry, DirectoryEntry> defaultValue) {
        this.arrayFileEntry = new FileEntry[capacity];
        this.arrayDirectoryEntry = new DirectoryEntry[capacity];
        this.end = 0;
        assert (defaultValue == null);
    }

    public final void clear() {
        this.setEnd(0);
    }

    public final FileEntry first$at(int idx) {
        return this.arrayFileEntry[idx];
    }

    public final DirectoryEntry second$at(int idx) {
        return this.arrayDirectoryEntry[idx];
    }

    public final boolean empty() {
        return this.size() == 0;
    }

    public final void $destroy() {
        this.destroy_range(0, this.end);
        this.end = 0;
    }

    public final void push_back(FileEntry first, DirectoryEntry second) {
        if (this.size() >= this.capacity()) {
            this.grow();
        }
        this.arrayFileEntry[this.end] = first;
        this.arrayDirectoryEntry[this.end] = second;
        ++this.end;
    }

    public final FileEntry first$front() {
        return this.arrayFileEntry[0];
    }

    public final DirectoryEntry second$front() {
        return this.arrayDirectoryEntry[0];
    }

    public final int size() {
        return this.end;
    }

    public final int max_size() {
        return Integer.MAX_VALUE;
    }

    public final int capacity() {
        return this.arrayFileEntry.length;
    }

    public final int $sizeof() {
        return this.capacity_in_bytes();
    }

    public final int capacity_in_bytes() {
        return 2 * this.arrayFileEntry.length * 4;
    }

    public final void set_size(int N) {
        assert (N <= this.capacity());
        this.setEnd(N);
    }

    private void destroy_range(int from, int to) {
        for (int i = from; i < to; ++i) {
            this.arrayFileEntry[i] = null;
            this.arrayDirectoryEntry[i] = null;
        }
    }

    private void grow(int newSize) {
        Object[] oldFileEntryArray = this.arrayFileEntry;
        this.arrayFileEntry = new FileEntry[newSize];
        NativePointer.copy$Object((Object[])oldFileEntryArray, (int)0, (Object[])this.arrayFileEntry, (int)0, (int)oldFileEntryArray.length);
        Object[] oldDirectoryEntryArray = this.arrayDirectoryEntry;
        this.arrayDirectoryEntry = new DirectoryEntry[newSize];
        NativePointer.copy$Object((Object[])oldDirectoryEntryArray, (int)0, (Object[])this.arrayDirectoryEntry, (int)0, (int)oldDirectoryEntryArray.length);
    }

    private void grow() {
        int capacity = this.capacity();
        if (capacity == 0) {
            this.arrayFileEntry = new FileEntry[8];
            this.arrayDirectoryEntry = new DirectoryEntry[8];
        } else {
            this.grow(capacity * 2);
        }
    }

    private void setEnd(int to) {
        this.end = to;
    }

    public String toString() {
        if (this.end == 0) {
            return "<EMPTY>";
        }
        StringBuilder out = new StringBuilder("\nSmallVectorPtrPairFileEntryDirectoryEntry{\nend = " + this.end + '\n');
        String fmt = "%" + (int)Math.ceil(Math.log10(this.end + 1)) + "d";
        for (int i = 0; i < this.end; ++i) {
            FileEntry file = this.arrayFileEntry[i];
            DirectoryEntry dir = this.arrayDirectoryEntry[i];
            out.append("[").append(String.format(fmt, i)).append("]{");
            out.append(file).append(";").append(dir).append("}\n");
        }
        out.append("}SmallVectorPtrPairFileEntryDirectoryEntry}\n");
        return out.toString();
    }
}

