/*
 * Decompiled with CFR 0.152.
 */
package org.clang.lex.impl;

import org.clang.basic.BasicClangGlobals;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.DiagnosticsEngine;
import org.clang.basic.DirectoryEntry;
import org.clang.basic.FileEntry;
import org.clang.basic.FileManager;
import org.clang.basic.SourceLocation;
import org.clang.lex.HeaderFileInfo;
import org.clank.java.std;
import org.clank.support.Native;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.support.BumpPtrAllocatorImpl;
import org.llvm.support.llvm;
import org.llvm.support.sys.path;

public final class HeaderSearchStatics {
    public static DirectoryEntry getTopFrameworkDir(FileManager FileMgr, StringRef DirName, SmallVectorImpl<std.string> SubmodulePath) {
        assert (llvm.$eq_StringRef((StringRef)path.extension((StringRef)DirName), (String)".framework")) : "Not a framework directory";
        DirectoryEntry TopFrameworkDir = FileMgr.getDirectory(DirName);
        DirName.$assignMove(FileMgr.getCanonicalName(TopFrameworkDir));
        while (true) {
            DirectoryEntry Dir;
            DirName.$assignMove(path.parent_path((StringRef)DirName));
            if (DirName.empty() || (Dir = FileMgr.getDirectory(DirName)) == null) break;
            if (!llvm.$eq_StringRef((StringRef)path.extension((StringRef)DirName), (String)".framework")) continue;
            SubmodulePath.push_back((Object)path.stem((StringRef)DirName).$string());
            TopFrameworkDir = Dir;
        }
        return TopFrameworkDir;
    }

    public static boolean checkMSVCHeaderSearch(DiagnosticsEngine Diags, FileEntry MSFE, FileEntry FE, SourceLocation IncludeLoc) {
        if (MSFE != null && FE != MSFE) {
            BasicClangGlobals.$out_DiagnosticBuilder$C_char$ptr$C((DiagnosticBuilder)Diags.Report(IncludeLoc, 890), (char.ptr)MSFE.getName()).$destroy();
            return true;
        }
        return false;
    }

    public static char.ptr copyString(StringRef Str, BumpPtrAllocatorImpl Alloc) {
        assert (!Str.empty());
        char.ptr CopyStr = Native.$tryClone((char.ptr)Alloc.Allocate(Str.size() + 1));
        std.copy((char.iterator)Str.begin(), (char.iterator)Str.end(), (char.iterator)CopyStr);
        CopyStr.$set(Str.size(), (byte)0);
        return CopyStr;
    }

    public static void mergeHeaderFileInfo(HeaderFileInfo HFI, HeaderFileInfo OtherHFI) {
        assert (OtherHFI.External) : "expected to merge external HFI";
        HFI.isImport |= OtherHFI.isImport;
        HFI.isPragmaOnce |= OtherHFI.isPragmaOnce;
        HFI.isModuleHeader |= OtherHFI.isModuleHeader;
        HFI.NumIncludes = (char)(HFI.NumIncludes + Unsigned.$ushort2int((char)OtherHFI.NumIncludes));
        if (HFI.ControllingMacro == null && HFI.ControllingMacroID == 0) {
            HFI.ControllingMacro = OtherHFI.ControllingMacro;
            HFI.ControllingMacroID = OtherHFI.ControllingMacroID;
        }
        HFI.DirInfo = OtherHFI.DirInfo;
        HFI.External = !HFI.IsValid || HFI.External;
        HFI.IsValid = true;
        HFI.IndexHeaderMapHeader = OtherHFI.IndexHeaderMapHeader;
        if (HFI.Framework.empty() && !OtherHFI.Framework.empty()) {
            HFI.Framework = new StringRef(OtherHFI.Framework);
        }
    }

    public static FileEntry getPrivateModuleMap(FileEntry File2, FileManager FileMgr) {
        StringRef Filename = path.filename((StringRef)new StringRef(File2.getName()));
        SmallString PrivateFilename = new SmallString(new StringRef(File2.getDir().getName()), 128);
        if (llvm.$eq_StringRef((StringRef)Filename, (String)"module.map")) {
            path.append((SmallString)PrivateFilename, (Twine)new Twine("module_private.map"));
        } else if (llvm.$eq_StringRef((StringRef)Filename, (String)"module.modulemap")) {
            path.append((SmallString)PrivateFilename, (Twine)new Twine("module.private.modulemap"));
        } else {
            return null;
        }
        return FileMgr.getFile(PrivateFilename.$StringRef());
    }
}

