/*
 * Decompiled with CFR 0.152.
 */
package org.clang.lex;

import org.clang.basic.BasicClangGlobals;
import org.clang.basic.CharSourceRange;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.DiagnosticsEngine;
import org.clang.basic.FullSourceLoc;
import org.clang.basic.LangOptions;
import org.clang.basic.SourceLocation;
import org.clang.basic.SourceManager;
import org.clang.basic.SourceRange;
import org.clang.basic.target.TargetInfo;
import org.clang.lex.LexClangGlobals;
import org.clang.lex.Lexer;
import org.clang.lex.Preprocessor;
import org.clang.lex.Token;
import org.clang.lex.impl.LiteralSupportStatics;
import org.clang.lex.llvm.ArrayRefToken;
import org.clank.java.std;
import org.clank.support.Casts;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uint;
import org.clank.support.aliases.ushort;
import org.clank.support.void;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.support.llvm;

public class StringLiteralParser
implements Destructors.ClassWithDestructor {
    private SourceManager SM;
    private LangOptions Features;
    private TargetInfo Target;
    private DiagnosticsEngine Diags;
    private int MaxTokenLength;
    private int SizeBound;
    private int CharByteWidth;
    private char Kind;
    private SmallString ResultBuf;
    private char.ptr ResultPtr;
    private SmallString UDSuffixBuf;
    private int UDSuffixToken;
    private int UDSuffixOffset;
    private bool.ref hadError;
    public boolean Pascal;

    public StringLiteralParser(ArrayRefToken StringToks, Preprocessor PP) {
        this(StringToks, PP, true);
    }

    public StringLiteralParser(ArrayRefToken StringToks, Preprocessor PP, boolean Complain) {
        this.SM = PP.getSourceManager();
        this.Features = PP.getLangOpts();
        this.Target = PP.getTargetInfo();
        this.Diags = Complain ? (DiagnosticsEngine)Native.$AddrOf((Object)PP.getDiagnostics()) : null;
        this.MaxTokenLength = 0;
        this.SizeBound = 0;
        this.CharByteWidth = 0;
        this.Kind = '\u0000';
        this.ResultBuf = new SmallString(512);
        this.ResultPtr = this.ResultBuf.data();
        this.UDSuffixBuf = new SmallString(32);
        this.hadError = NativePointer.create_bool$ref((boolean)false);
        this.Pascal = false;
        this.init(StringToks);
    }

    public StringLiteralParser(ArrayRefToken StringToks, SourceManager sm, LangOptions features, TargetInfo target) {
        this(StringToks, sm, features, target, null);
    }

    public StringLiteralParser(ArrayRefToken StringToks, SourceManager sm, LangOptions features, TargetInfo target, DiagnosticsEngine diags) {
        this.SM = sm;
        this.Features = features;
        this.Target = target;
        this.Diags = diags;
        this.MaxTokenLength = 0;
        this.SizeBound = 0;
        this.CharByteWidth = 0;
        this.Kind = '\u0000';
        this.ResultBuf = new SmallString(512);
        this.ResultPtr = this.ResultBuf.data();
        this.UDSuffixBuf = new SmallString(32);
        this.hadError = NativePointer.create_bool$ref((boolean)false);
        this.Pascal = false;
        this.init(StringToks);
    }

    public boolean hadError() {
        return this.hadError.$deref();
    }

    public StringRef GetString() {
        return new StringRef(this.ResultBuf.data(), this.GetStringLength());
    }

    public int GetStringLength() {
        return this.ResultPtr.$sub((abstract_iterator)this.ResultBuf.data());
    }

    public int GetNumStringChars() {
        return this.GetStringLength() / this.CharByteWidth;
    }

    public int getOffsetOfStringByte(Token Tok, int ByteNo) {
        SmallString SpellingBuffer = new SmallString(32);
        SpellingBuffer.resize(Tok.getLength());
        bool.ptr StringInvalid = null;
        char.ptr SpellingPtr = Native.$noClone((char.ptr)((char.ptr)Native.$AddrOf((Object)SpellingBuffer.data())));
        int TokLen = Lexer.getSpelling(Tok, SpellingPtr, this.SM, this.Features, StringInvalid);
        if (TokLen == -1) {
            return 0;
        }
        char.ptr SpellingStart = Native.$tryClone((char.ptr)SpellingPtr);
        char.ptr SpellingEnd = Native.$noClone((char.ptr)((char.ptr)SpellingPtr.$add(TokLen)));
        if (SpellingPtr.$at(0) == 117 && SpellingPtr.$at(1) == 56) {
            SpellingPtr.$inc(2);
        }
        assert (SpellingPtr.$at(0) != 76 && SpellingPtr.$at(0) != 117 && SpellingPtr.$at(0) != 85) : "Doesn't handle wide or utf strings yet";
        if (SpellingPtr.$at(0) == 82) {
            assert (SpellingPtr.$at(1) == 34) : "Should be a raw string literal!";
            SpellingPtr.$inc(2);
            while (SpellingPtr.$star() != 40) {
                SpellingPtr.$preInc();
                assert (SpellingPtr.$less((Object)SpellingEnd)) : "Missing ( for raw string literal";
            }
            SpellingPtr.$preInc();
            return SpellingPtr.$sub((abstract_iterator)SpellingStart) + ByteNo;
        }
        assert (SpellingPtr.$at(0) == 34) : "Should be a string literal!";
        SpellingPtr.$preInc();
        while (ByteNo != 0) {
            assert (SpellingPtr.$less((Object)SpellingEnd)) : "Didn't find byte offset!";
            if (SpellingPtr.$star() != 92) {
                SpellingPtr.$preInc();
                --ByteNo;
                continue;
            }
            bool.ref HadError = NativePointer.create_bool$ref((boolean)false);
            if (SpellingPtr.$at(1) == 117 || SpellingPtr.$at(1) == 85) {
                int EscapePtr = SpellingPtr.$index();
                int Len = LiteralSupportStatics.MeasureUCNEscape(SpellingStart, SpellingPtr, SpellingEnd, 1, this.Features, HadError);
                if (Unsigned.$greater_uint((int)Len, (int)ByteNo)) {
                    Native.$setIndex((char.ptr)SpellingPtr, (int)EscapePtr);
                    break;
                }
                ByteNo -= Len;
            } else {
                LiteralSupportStatics.ProcessCharEscape(SpellingStart, SpellingPtr, SpellingEnd, HadError, new FullSourceLoc(Tok.$getLocation(), this.SM), this.CharByteWidth * 8, this.Diags, this.Features);
                --ByteNo;
            }
            assert (!HadError.$deref()) : "This method isn't valid on erroneous strings";
        }
        return SpellingPtr.$sub((abstract_iterator)SpellingStart);
    }

    public boolean isAscii() {
        return this.Kind == '\r';
    }

    public boolean isWide() {
        return this.Kind == '\u000e';
    }

    public boolean isUTF8() {
        return this.Kind == '\u0010';
    }

    public boolean isUTF16() {
        return this.Kind == '\u0011';
    }

    public boolean isUTF32() {
        return this.Kind == '\u0012';
    }

    public boolean isPascal() {
        return this.Pascal;
    }

    public StringRef getUDSuffix() {
        return this.UDSuffixBuf.$StringRef();
    }

    public SmallString $getUDSuffix() {
        return this.UDSuffixBuf;
    }

    public int getUDSuffixToken() {
        assert (!this.UDSuffixBuf.empty()) : "no ud-suffix";
        return this.UDSuffixToken;
    }

    public int getUDSuffixOffset() {
        assert (!this.UDSuffixBuf.empty()) : "no ud-suffix";
        return this.UDSuffixOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(ArrayRefToken StringToks) {
        if (StringToks.empty() || Unsigned.$less_uint((int)((Token)StringToks.$at(0)).getLength(), (int)2)) {
            this.DiagnoseLexingError(StringToks.empty() ? SourceLocation.getInvalid() : ((Token)StringToks.$at(0)).$getLocation());
            return;
        }
        assert (!StringToks.empty()) : "expected at least one token";
        this.MaxTokenLength = ((Token)StringToks.$at(0)).getLength();
        assert (Unsigned.$greatereq_uint((int)((Token)StringToks.$at(0)).getLength(), (int)2)) : "literal token is invalid!";
        this.SizeBound = ((Token)StringToks.$at(0)).getLength() - 2;
        this.Kind = ((Token)StringToks.$at(0)).getKind();
        this.hadError.$set(false);
        for (int i = 1; i != StringToks.size(); ++i) {
            if (Unsigned.$less_uint((int)((Token)StringToks.$at(i)).getLength(), (int)2)) {
                this.DiagnoseLexingError(((Token)StringToks.$at(i)).$getLocation());
                return;
            }
            assert (Unsigned.$greatereq_uint((int)((Token)StringToks.$at(i)).getLength(), (int)2)) : "literal token is invalid!";
            this.SizeBound += ((Token)StringToks.$at(i)).getLength() - 2;
            if (Unsigned.$greater_uint((int)((Token)StringToks.$at(i)).getLength(), (int)this.MaxTokenLength)) {
                this.MaxTokenLength = ((Token)StringToks.$at(i)).getLength();
            }
            if (!((Token)StringToks.$at(i)).isNot(this.Kind) || !((Token)StringToks.$at(i)).isNot('\r')) continue;
            if (this.isAscii()) {
                this.Kind = ((Token)StringToks.$at(i)).getKind();
                continue;
            }
            if (this.Diags != null) {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean((Object)((DiagnosticBuilder)$c$.track((Object)this.Diags.Report(((Token)StringToks.$at(i)).$getLocation(), 852))));
                }
                finally {
                    $c$.$destroy();
                }
            }
            this.hadError.$set(true);
        }
        ++this.SizeBound;
        this.CharByteWidth = LiteralSupportStatics.getCharWidth(this.Kind, this.Target);
        assert ((this.CharByteWidth & 7) == 0) : "Assumes character size is byte multiple";
        this.CharByteWidth /= 8;
        this.SizeBound *= this.CharByteWidth;
        this.ResultBuf.resize(this.SizeBound);
        SmallString TokenBuf = new SmallString(512);
        TokenBuf.resize(this.MaxTokenLength);
        this.ResultPtr = Native.$noClone((char.ptr)((char.ptr)Native.$AddrOf((Object)this.ResultBuf.data())));
        this.Pascal = false;
        int UDSuffixTokLoc = SourceLocation.getInvalid();
        int e = StringToks.size();
        for (int i = 0; i != e; ++i) {
            char.ptr ThisTokBuf = Native.$noClone((char.ptr)((char.ptr)Native.$AddrOf((Object)TokenBuf.data())));
            bool.ptr StringInvalid = null;
            int ThisTokLen = Lexer.getSpelling((Token)StringToks.$at(i), ThisTokBuf, this.SM, this.Features, StringInvalid);
            if (ThisTokLen == -1) {
                this.DiagnoseLexingError(((Token)StringToks.$at(i)).$getLocation());
                return;
            }
            char.ptr ThisTokBegin = Native.$tryClone((char.ptr)ThisTokBuf);
            char.ptr ThisTokEnd = Native.$noClone((char.ptr)((char.ptr)ThisTokBuf.$add(ThisTokLen)));
            if (ThisTokEnd.$at(-1) != 34) {
                int UDSuffixEnd = ThisTokEnd.$index();
                do {
                    ThisTokEnd.$preDec();
                } while (ThisTokEnd.$at(-1) != 34);
                StringRef UDSuffix = new StringRef(Native.$noClone((char.ptr)ThisTokEnd), UDSuffixEnd - ThisTokEnd.$index());
                Native.$cleanConst((char.ptr)ThisTokEnd);
                if (this.UDSuffixBuf.empty()) {
                    if (((Token)StringToks.$at(i)).hasUCN()) {
                        LexClangGlobals.expandUCNs(this.UDSuffixBuf, UDSuffix);
                    } else {
                        this.UDSuffixBuf.assign(UDSuffix);
                    }
                    this.UDSuffixToken = i;
                    this.UDSuffixOffset = ThisTokEnd.$sub((abstract_iterator)ThisTokBuf);
                    UDSuffixTokLoc = ((Token)StringToks.$at(i)).$getLocation();
                } else {
                    SmallString ExpandedUDSuffix = new SmallString(32);
                    if (((Token)StringToks.$at(i)).hasUCN()) {
                        LexClangGlobals.expandUCNs(ExpandedUDSuffix, UDSuffix);
                        UDSuffix.$assignMove(ExpandedUDSuffix.$StringRef());
                    }
                    if (llvm.$noteq_StringRef((StringRef)this.UDSuffixBuf.$StringRef(), (StringRef)UDSuffix)) {
                        if (this.Diags != null) {
                            JavaCleaner $c$ = Native.$createJavaCleaner();
                            try {
                                int TokLoc = ((Token)StringToks.$at(i)).$getLocation();
                                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder$C_SourceRange((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder$C_SourceRange((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder$C_StringRef((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder$C_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.Diags.Report(TokLoc, 844))), (StringRef)this.UDSuffixBuf.$StringRef()), (StringRef)UDSuffix), (SourceRange)new SourceRange(UDSuffixTokLoc, UDSuffixTokLoc)), (SourceRange)new SourceRange(TokLoc, TokLoc)));
                            }
                            finally {
                                $c$.$destroy();
                            }
                        }
                        this.hadError.$set(true);
                    }
                }
            }
            ThisTokEnd.$preDec();
            if (ThisTokBuf.$at(0) == 76 || ThisTokBuf.$at(0) == 117 || ThisTokBuf.$at(0) == 85) {
                ThisTokBuf.$preInc();
                if (ThisTokBuf.$at(0) == 56) {
                    ThisTokBuf.$preInc();
                }
            }
            if (ThisTokBuf.$greatereq((Object)ThisTokEnd)) {
                this.hadError.$set(true);
                return;
            }
            if (ThisTokBuf.$at(0) == 82) {
                ThisTokBuf.$inc(2);
                int Prefix = ThisTokBuf.$index();
                while (ThisTokBuf.$at(0) != 40) {
                    ThisTokBuf.$preInc();
                }
                ThisTokBuf.$preInc();
                ThisTokEnd.$dec(ThisTokBuf.$index() - Prefix);
                assert (ThisTokEnd.$greatereq((Object)ThisTokBuf)) : "malformed raw string literal";
                StringRef RemainingTokenSpan = new StringRef(ThisTokBuf, ThisTokEnd.$sub((abstract_iterator)ThisTokBuf));
                while (!RemainingTokenSpan.empty()) {
                    int CRLFPos = RemainingTokenSpan.find("\r\n");
                    StringRef BeforeCRLF = RemainingTokenSpan.substr(0, CRLFPos);
                    StringRef AfterCRLF = RemainingTokenSpan.substr(CRLFPos);
                    if (this.CopyStringFragment((Token)StringToks.$at(i), ThisTokBegin, new StringRef(BeforeCRLF))) {
                        this.hadError.$set(true);
                    }
                    RemainingTokenSpan.$assignMove(AfterCRLF.substr(1));
                }
                continue;
            }
            if (ThisTokBuf.$at(0) != 34) {
                this.DiagnoseLexingError(((Token)StringToks.$at(i)).$getLocation());
                return;
            }
            ThisTokBuf.$preInc();
            if (this.Features.PascalStrings && Native.$noteq_ptr((void.ptr)((void.ptr)ThisTokBuf.$add(1)), (void.ptr)ThisTokEnd) && ThisTokBuf.$at(0) == 92 && ThisTokBuf.$at(1) == 112) {
                if (i == 0) {
                    ThisTokBuf.$preInc();
                    this.Pascal = true;
                } else if (this.Pascal) {
                    ThisTokBuf.$inc(2);
                }
            }
            while (ThisTokBuf.$less((Object)ThisTokEnd)) {
                uint.ptr ResultWidePtr;
                if (ThisTokBuf.$at(0) != 92) {
                    char.ptr InStart = Native.$tryClone((char.ptr)ThisTokBuf);
                    do {
                        ThisTokBuf.$preInc();
                    } while (ThisTokBuf.$less((Object)ThisTokEnd) && ThisTokBuf.$at(0) != 92);
                    if (!this.CopyStringFragment((Token)StringToks.$at(i), ThisTokBegin, new StringRef(InStart, ThisTokBuf.$sub((abstract_iterator)InStart)))) continue;
                    this.hadError.$set(true);
                    continue;
                }
                if (ThisTokBuf.$at(1) == 117 || ThisTokBuf.$at(1) == 85) {
                    LiteralSupportStatics.EncodeUCNEscape(ThisTokBegin, ThisTokBuf, ThisTokEnd, (type.ref<char.ptr>)this.ResultPtr.$addr().star$ref(), this.hadError, new FullSourceLoc(((Token)StringToks.$at(i)).$getLocation(), this.SM), this.CharByteWidth, this.Diags, this.Features);
                    continue;
                }
                int ResultChar = LiteralSupportStatics.ProcessCharEscape(ThisTokBegin, ThisTokBuf, ThisTokEnd, this.hadError, new FullSourceLoc(((Token)StringToks.$at(i)).$getLocation(), this.SM), this.CharByteWidth * 8, this.Diags, this.Features);
                if (this.CharByteWidth == 4) {
                    ResultWidePtr = (uint.ptr)Native.$tryClone((NativeCloneable)((uint.ptr)Casts.reinterpret_cast(uint.ptr.class, (void.ptr)this.ResultPtr)));
                    ResultWidePtr.$set(ResultChar);
                    this.ResultPtr.$inc(4);
                    continue;
                }
                if (this.CharByteWidth == 2) {
                    ResultWidePtr = (ushort.ptr)Native.$tryClone((NativeCloneable)((ushort.ptr)Casts.reinterpret_cast(ushort.ptr.class, (void.ptr)this.ResultPtr)));
                    ResultWidePtr.$set(Unsigned.$uint2UTF16((int)(ResultChar & 0xFFFF)));
                    this.ResultPtr.$inc(2);
                    continue;
                }
                assert (this.CharByteWidth == 1) : "Unexpected char width";
                this.ResultPtr.$set(Unsigned.$uint2char((int)(ResultChar & 0xFF)));
                this.ResultPtr.$preInc();
            }
        }
        if (this.Pascal) {
            if (this.CharByteWidth == 4) {
                uint.ptr ResultWidePtr = (uint.ptr)Native.$tryClone((NativeCloneable)((uint.ptr)Casts.reinterpret_cast(uint.ptr.class, (void.ptr)this.ResultBuf.data())));
                ResultWidePtr.$set(0, this.GetNumStringChars() - 1);
            } else if (this.CharByteWidth == 2) {
                ushort.ptr ResultWidePtr = (ushort.ptr)Native.$tryClone((NativeCloneable)((ushort.ptr)Casts.reinterpret_cast(ushort.ptr.class, (void.ptr)this.ResultBuf.data())));
                ResultWidePtr.$set(0, Unsigned.$uint2UTF16((int)(this.GetNumStringChars() - 1)));
            } else {
                assert (this.CharByteWidth == 1) : "Unexpected char width";
                this.ResultBuf.$set(0, Unsigned.$uint2char((int)(this.GetNumStringChars() - 1)));
            }
            if (Unsigned.$greater_uint((int)this.GetStringLength(), (int)256)) {
                if (this.Diags != null) {
                    JavaCleaner $c$ = Native.$createJavaCleaner();
                    try {
                        $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder$C_SourceRange((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.Diags.Report(((Token)StringToks.front()).getLocation(), 779))), (SourceRange)new SourceRange(((Token)StringToks.front()).getLocation(), ((Token)StringToks.back()).getLocation())));
                    }
                    finally {
                        $c$.$destroy();
                    }
                }
                this.hadError.$set(true);
                return;
            }
        } else if (this.Diags != null) {
            int MaxChars;
            int n = this.Features.CPlusPlus ? 65536 : (MaxChars = this.Features.C99 ? 4095 : 509);
            if (Unsigned.$greater_uint((int)this.GetNumStringChars(), (int)MaxChars)) {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder$C_SourceRange((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder$C_int((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder$C_uint((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder$C_uint((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.Diags.Report(((Token)StringToks.front()).getLocation(), 901))), (int)this.GetNumStringChars()), (int)MaxChars), (int)(this.Features.CPlusPlus ? 2 : (this.Features.C99 ? 1 : 0))), (SourceRange)new SourceRange(((Token)StringToks.front()).getLocation(), ((Token)StringToks.back()).getLocation())));
                }
                finally {
                    $c$.$destroy();
                }
            }
        }
    }

    private boolean CopyStringFragment(Token Tok, char.ptr TokBegin, StringRef Fragment) {
        type.ref ErrorPtrTmp = NativePointer.create_type$ref(null);
        if (llvm.ConvertUTF8toWide((int)this.CharByteWidth, (StringRef)Fragment, (type.ref)this.ResultPtr.$addr().star$ref(), (type.ref)ErrorPtrTmp)) {
            return false;
        }
        boolean NoErrorOnBadEncoding = this.isAscii();
        if (NoErrorOnBadEncoding) {
            std.memcpy((char.ptr)this.ResultPtr, (char.ptr)Fragment.data(), (int)Fragment.size());
            this.ResultPtr.$inc(Fragment.size());
        }
        if (this.Diags != null) {
            char.ptr ErrorPtr = Native.$tryClone((char.ptr)((char.ptr)Casts.reinterpret_cast(char.ptr.class, (void.ptr)((void.ptr)ErrorPtrTmp.$deref()))));
            FullSourceLoc SourceLoc = new FullSourceLoc(Tok.$getLocation(), this.SM);
            DiagnosticBuilder Builder = LiteralSupportStatics.Diag(this.Diags, this.Features, SourceLoc, TokBegin, ErrorPtr, LiteralSupportStatics.resyncUTF8(ErrorPtr, Fragment.end()), NoErrorOnBadEncoding ? 943 : 724);
            char.ptr NextStart = Native.$tryClone((char.ptr)LiteralSupportStatics.resyncUTF8(ErrorPtr, Fragment.end()));
            StringRef NextFragment = new StringRef(NextStart, Fragment.end().$sub((abstract_iterator)NextStart));
            SmallString Dummy = new SmallString(512);
            Dummy.reserve(Fragment.size() * this.CharByteWidth);
            char.ptr Ptr = Native.$tryClone((char.ptr)Dummy.data());
            while (!llvm.ConvertUTF8toWide((int)this.CharByteWidth, (StringRef)NextFragment, (type.ref)Ptr.$addr().star$ref(), (type.ref)ErrorPtrTmp)) {
                char.ptr _ErrorPtr = Native.$tryClone((char.ptr)((char.ptr)Casts.reinterpret_cast(char.ptr.class, (void.ptr)((void.ptr)ErrorPtrTmp.$deref()))));
                NextStart = Native.$tryClone((char.ptr)LiteralSupportStatics.resyncUTF8(_ErrorPtr, Fragment.end()));
                BasicClangGlobals.$out_DiagnosticBuilder$C_CharSourceRange$C((DiagnosticBuilder)Builder, (CharSourceRange)LiteralSupportStatics.MakeCharSourceRange(this.Features, SourceLoc, TokBegin, _ErrorPtr, NextStart));
                NextFragment.$assignMove(new StringRef(NextStart, Fragment.end().$sub((abstract_iterator)NextStart)));
            }
            Builder.$destroy();
        }
        return !NoErrorOnBadEncoding;
    }

    private void DiagnoseLexingError(int Loc) {
        this.hadError.$set(true);
        if (this.Diags != null) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)((DiagnosticBuilder)$c$.track((Object)this.Diags.Report(Loc, 742))));
            }
            finally {
                $c$.$destroy();
            }
        }
    }

    public void $destroy() {
        this.UDSuffixBuf.$destroy();
        this.ResultBuf.$destroy();
    }

    public String toString() {
        return ", Features=" + this.Features + ", Target=" + this.Target + ", MaxTokenLength=" + this.MaxTokenLength + ", SizeBound=" + this.SizeBound + ", CharByteWidth=" + this.CharByteWidth + ", Kind=" + this.Kind + ", ResultBuf=" + this.ResultBuf + ", ResultPtr=" + this.ResultPtr + ", UDSuffixBuf=" + this.UDSuffixBuf + ", UDSuffixToken=" + this.UDSuffixToken + ", UDSuffixOffset=" + this.UDSuffixOffset + ", hadError=" + this.hadError + ", Pascal=" + this.Pascal;
    }
}

