/*
 * Decompiled with CFR 0.152.
 */
package org.clang.lex;

import org.clang.basic.BasicClangGlobals;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.FileEntry;
import org.clang.basic.IdentifierInfo;
import org.clang.basic.PresumedLoc;
import org.clang.basic.SourceLocation;
import org.clang.basic.SrcMgr;
import org.clang.basic.TranslationUnitKind;
import org.clang.basic.tok;
import org.clang.lex.DirectoryLookup;
import org.clang.lex.EmptyPragmaHandler;
import org.clang.lex.Lexer;
import org.clang.lex.MacroInfo;
import org.clang.lex.PPCallbacks;
import org.clang.lex.PTHLexer;
import org.clang.lex.PragmaHandler;
import org.clang.lex.PragmaIntroducerKind;
import org.clang.lex.PragmaNamespace;
import org.clang.lex.Preprocessor;
import org.clang.lex.PreprocessorLexer;
import org.clang.lex.Preprocessor_PPMacroExpansion;
import org.clang.lex.Token;
import org.clang.lex.TokenLexer;
import org.clang.lex.impl.LexingFor_PragmaRAII;
import org.clang.lex.impl.PragmaARCCFCodeAuditedHandler;
import org.clang.lex.impl.PragmaAssumeNonNullHandler;
import org.clang.lex.impl.PragmaDebugHandler;
import org.clang.lex.impl.PragmaDependencyHandler;
import org.clang.lex.impl.PragmaDiagnosticHandler;
import org.clang.lex.impl.PragmaIncludeAliasHandler;
import org.clang.lex.impl.PragmaMarkHandler;
import org.clang.lex.impl.PragmaMessageHandler;
import org.clang.lex.impl.PragmaOnceHandler;
import org.clang.lex.impl.PragmaPoisonHandler;
import org.clang.lex.impl.PragmaPopMacroHandler;
import org.clang.lex.impl.PragmaPushMacroHandler;
import org.clang.lex.impl.PragmaRegionHandler;
import org.clang.lex.impl.PragmaSTDC_CX_LIMITED_RANGEHandler;
import org.clang.lex.impl.PragmaSTDC_FENV_ACCESSHandler;
import org.clang.lex.impl.PragmaSTDC_UnknownHandler;
import org.clang.lex.impl.PragmaSystemHeaderHandler;
import org.clang.lex.impl.PragmaWarningHandler;
import org.clang.lex.llvm.PragmaHandlerRegistry;
import org.clang.lex.llvm.SmallVectorToken;
import org.clank.java.std;
import org.clank.support.JavaCleaner;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.DenseMapIterator;
import org.llvm.support.Registry;

public class Preprocessor_Pragma
extends Preprocessor_PPMacroExpansion {
    private final Preprocessor $this() {
        return (Preprocessor)this;
    }

    public void AddPragmaHandler(StringRef Namespace, PragmaHandler Handler) {
        PragmaNamespace InsertNS = (PragmaNamespace)this.$this().PragmaHandlers.get();
        if (!Namespace.empty()) {
            PragmaHandler Existing = ((PragmaNamespace)this.$this().PragmaHandlers.$arrow()).FindHandler(Namespace);
            if (Existing != null) {
                InsertNS = Existing.getIfNamespace();
                assert (InsertNS != null) : "Cannot have a pragma namespace and pragma handler with the same name!";
            } else {
                InsertNS = new PragmaNamespace(Namespace);
                ((PragmaNamespace)this.$this().PragmaHandlers.$arrow()).AddPragma(InsertNS);
            }
        }
        assert (InsertNS.FindHandler(Handler.getName()) == null) : "Pragma handler already exists for this identifier!";
        InsertNS.AddPragma(Handler);
    }

    public void RemovePragmaHandler(StringRef Namespace, PragmaHandler Handler) {
        PragmaNamespace NS = (PragmaNamespace)this.$this().PragmaHandlers.get();
        if (!Namespace.empty()) {
            PragmaHandler Existing = ((PragmaNamespace)this.$this().PragmaHandlers.$arrow()).FindHandler(Namespace);
            assert (Existing != null) : "Namespace containing handler does not exist!";
            NS = Existing.getIfNamespace();
            assert (NS != null) : "Invalid namespace, registered as a regular pragma handler!";
        }
        NS.RemovePragmaHandler(Handler);
        if (NS != this.$this().PragmaHandlers.get() && NS.IsEmpty()) {
            ((PragmaNamespace)this.$this().PragmaHandlers.$arrow()).RemovePragmaHandler(NS);
            if (NS != null) {
                NS.$destroy();
            }
        }
    }

    public void IgnorePragmas() {
        this.$this().AddPragmaHandler(new EmptyPragmaHandler());
        this.$this().AddPragmaHandler(new StringRef("GCC"), new EmptyPragmaHandler());
        this.$this().AddPragmaHandler(new StringRef("clang"), new EmptyPragmaHandler());
        PragmaHandler NS = ((PragmaNamespace)this.$this().PragmaHandlers.$arrow()).FindHandler(new StringRef("STDC"));
        if (NS != null) {
            PragmaNamespace STDCNamespace = NS.getIfNamespace();
            assert (STDCNamespace != null) : "Invalid namespace, registered as a regular pragma handler!";
            PragmaHandler Existing = STDCNamespace.FindHandler(StringRef.R$EMPTY, false);
            if (Existing != null) {
                this.$this().RemovePragmaHandler(new StringRef("STDC"), Existing);
                if (Existing != null) {
                    Existing.$destroy();
                }
            }
        }
        this.$this().AddPragmaHandler(new StringRef("STDC"), new EmptyPragmaHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean LexOnOffSwitch(type.ref<tok.OnOffSwitch> Result) {
        Token Tok = new Token();
        this.$this().LexUnexpandedToken(Tok);
        if (Tok.isNot('\u0005')) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)((DiagnosticBuilder)$c$.track((Object)this.$this().Diag(Tok, 881))));
                boolean bl = true;
                return bl;
            }
            finally {
                $c$.$destroy();
            }
        }
        IdentifierInfo II = Tok.getIdentifierInfo();
        if (II.isStr("ON")) {
            Result.$set((Object)tok.OnOffSwitch.OOS_ON);
        } else if (II.isStr("OFF")) {
            Result.$set((Object)tok.OnOffSwitch.OOS_OFF);
        } else if (II.isStr("DEFAULT")) {
            Result.$set((Object)tok.OnOffSwitch.OOS_DEFAULT);
        } else {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)((DiagnosticBuilder)$c$.track((Object)this.$this().Diag(Tok, 881))));
                boolean bl = true;
                return bl;
            }
            finally {
                $c$.$destroy();
            }
        }
        this.$this().LexUnexpandedToken(Tok);
        if (Tok.isNot('\u0002')) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)((DiagnosticBuilder)$c$.track((Object)this.$this().Diag(Tok, 898))));
            }
            finally {
                $c$.$destroy();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void RegisterBuiltinPragmas() {
        this.$this().AddPragmaHandler(new PragmaOnceHandler());
        this.$this().AddPragmaHandler(new PragmaMarkHandler());
        this.$this().AddPragmaHandler(new PragmaPushMacroHandler());
        this.$this().AddPragmaHandler(new PragmaPopMacroHandler());
        this.$this().AddPragmaHandler(new PragmaMessageHandler(PPCallbacks.PragmaMessageKind.PMK_Message));
        this.$this().AddPragmaHandler(new StringRef("GCC"), new PragmaPoisonHandler());
        this.$this().AddPragmaHandler(new StringRef("GCC"), new PragmaSystemHeaderHandler());
        this.$this().AddPragmaHandler(new StringRef("GCC"), new PragmaDependencyHandler());
        this.$this().AddPragmaHandler(new StringRef("GCC"), new PragmaDiagnosticHandler("GCC"));
        this.$this().AddPragmaHandler(new StringRef("GCC"), new PragmaMessageHandler(PPCallbacks.PragmaMessageKind.PMK_Warning, new StringRef("GCC")));
        this.$this().AddPragmaHandler(new StringRef("GCC"), new PragmaMessageHandler(PPCallbacks.PragmaMessageKind.PMK_Error, new StringRef("GCC")));
        this.$this().AddPragmaHandler(new StringRef("clang"), new PragmaPoisonHandler());
        this.$this().AddPragmaHandler(new StringRef("clang"), new PragmaSystemHeaderHandler());
        this.$this().AddPragmaHandler(new StringRef("clang"), new PragmaDebugHandler());
        this.$this().AddPragmaHandler(new StringRef("clang"), new PragmaDependencyHandler());
        this.$this().AddPragmaHandler(new StringRef("clang"), new PragmaDiagnosticHandler("clang"));
        this.$this().AddPragmaHandler(new StringRef("clang"), new PragmaARCCFCodeAuditedHandler());
        this.$this().AddPragmaHandler(new StringRef("clang"), new PragmaAssumeNonNullHandler());
        this.$this().AddPragmaHandler(new StringRef("STDC"), new PragmaSTDC_FENV_ACCESSHandler());
        this.$this().AddPragmaHandler(new StringRef("STDC"), new PragmaSTDC_CX_LIMITED_RANGEHandler());
        this.$this().AddPragmaHandler(new StringRef("STDC"), new PragmaSTDC_UnknownHandler());
        if (this.$this().LangOpts.MicrosoftExt) {
            this.$this().AddPragmaHandler(new PragmaWarningHandler());
            this.$this().AddPragmaHandler(new PragmaIncludeAliasHandler());
            this.$this().AddPragmaHandler(new PragmaRegionHandler("region"));
            this.$this().AddPragmaHandler(new PragmaRegionHandler("endregion"));
        }
        Registry.iterator<PragmaHandler> it = PragmaHandlerRegistry.begin();
        Registry.iterator<PragmaHandler> ie = PragmaHandlerRegistry.end();
        while (it.$noteq(ie)) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                this.$this().AddPragmaHandler((PragmaHandler)$c$.track(it.$arrow().instantiate()).release());
                $c$.clean();
            }
            finally {
                $c$.$destroy();
            }
            it.$preInc();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void Handle_Pragma(Token Tok) {
        LexingFor_PragmaRAII _PragmaLexing = null;
        _PragmaLexing = new LexingFor_PragmaRAII((Preprocessor)((Object)Native.$Deref((Object)((Object)this.$this()))), this.$this().InMacroArgPreExpansion, Tok);
        int PragmaLoc = Tok.$getLocation();
        this.$this().Lex(Tok);
        if (Tok.isNot('\u0015')) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)((DiagnosticBuilder)$c$.track((Object)this.$this().Diag(PragmaLoc, 722))));
                _PragmaLexing.failed();
                return;
            }
            finally {
                $c$.$destroy();
            }
        }
        this.$this().Lex(Tok);
        if (!tok.isStringLiteral((char)Tok.getKind())) {
            this.$this().Diag(PragmaLoc, 722).$destroy();
            if (Tok.isNot('\u0016') && Tok.isNot('\u0001')) {
                this.$this().Lex(Tok);
            }
            while (Tok.isNot('\u0016') && !Tok.isAtStartOfLine() && Tok.isNot('\u0001')) {
                this.$this().Lex(Tok);
            }
            if (Tok.is('\u0016')) {
                this.$this().Lex(Tok);
            }
            _PragmaLexing.failed();
            return;
        }
        if (Tok.hasUDSuffix()) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)((DiagnosticBuilder)$c$.track((Object)this.$this().Diag(Tok, 18))));
                this.$this().Lex(Tok);
                if (Tok.is('\u0016')) {
                    this.$this().Lex(Tok);
                }
                _PragmaLexing.failed();
                return;
            }
            finally {
                $c$.$destroy();
            }
        }
        Token StrTok = new Token(Tok);
        this.$this().Lex(Tok);
        if (!Tok.isNot('\u0016')) {
        }
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            $c$.clean((Object)((DiagnosticBuilder)$c$.track((Object)this.$this().Diag(PragmaLoc, 722))));
            _PragmaLexing.failed();
        }
        catch (Throwable throwable) {
            $c$.$destroy();
            throw throwable;
        }
        $c$.$destroy();
        return;
        finally {
            if (_PragmaLexing != null) {
                _PragmaLexing.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void HandleMicrosoft__pragma(Token Tok) {
        int PragmaLoc = Tok.$getLocation();
        this.$this().Lex(Tok);
        if (Tok.isNot('\u0015')) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)((DiagnosticBuilder)$c$.track((Object)this.$this().Diag(PragmaLoc, 722))));
                return;
            }
            finally {
                $c$.$destroy();
            }
        }
        SmallVectorToken PragmaToks = new SmallVectorToken(32, null);
        int NumParens = 0;
        this.$this().Lex(Tok);
        while (Tok.isNot('\u0001')) {
            PragmaToks.push_back(Tok);
            if (Tok.is('\u0015')) {
                ++NumParens;
            } else if (Tok.is('\u0016') && NumParens-- == 0) break;
            this.$this().Lex(Tok);
        }
        if (Tok.is('\u0001')) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)((DiagnosticBuilder)$c$.track((Object)this.$this().Diag(PragmaLoc, 854))));
                return;
            }
            finally {
                $c$.$destroy();
            }
        }
        PragmaToks.front().setFlag('\u0002');
        PragmaToks.back().setKind('\u0002');
        Object[] TokArray = new Token[PragmaToks.size()];
        std.copy((Object[])PragmaToks.$array(), (int)0, (int)PragmaToks.size(), (Object[])TokArray, (int)0);
        this.$this().EnterTokenStream((Token[])TokArray, 0, PragmaToks.size(), true, true);
        this.$this().HandlePragmaDirective(PragmaLoc, PragmaIntroducerKind.PIK___pragma);
        this.$this().Lex(Tok);
    }

    protected void HandlePragmaDirective(int IntroducerLoc, PragmaIntroducerKind Introducer) {
        if (this.$this().Callbacks$boolean) {
            this.$this().Callbacks$arrow.PragmaDirective(this.$this().$CallbackLoc(IntroducerLoc), Introducer);
        }
        if (!this.$this().PragmasEnabled) {
            return;
        }
        ++this.$this().NumPragma;
        Token Tok = this.$this().$getPragmaDirectiveToken();
        ((PragmaNamespace)this.$this().PragmaHandlers.$arrow()).HandlePragma((Preprocessor)((Object)Native.$Deref((Object)((Object)this.$this()))), Introducer, Tok);
        if (this.$this().CurTokenLexer.$bool() && ((TokenLexer)this.$this().CurTokenLexer.$arrow()).isParsingPreprocessorDirective() || this.$this().CurPPLexer != null && this.$this().CurPPLexer.ParsingPreprocessorDirective) {
            this.$this().DiscardUntilEndOfDirective();
        }
        this.$this().$releasePragmaDirectiveToken(Tok);
    }

    public void HandlePragmaOnce(Token OnceTok) {
        if (this.$this().isInPrimaryFile() && this.$this().TUKind != TranslationUnitKind.TU_Prefix) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)((DiagnosticBuilder)$c$.track((Object)this.$this().Diag(OnceTok, 935))));
                return;
            }
            finally {
                $c$.$destroy();
            }
        }
        this.$this().HeaderInfo.MarkFileIncludeOnce(this.$this().getCurrentFileLexer().getFileEntry());
        if (this.$this().Callbacks$boolean) {
            this.$this().Callbacks$arrow.PragmaOnceDirective(OnceTok);
        }
    }

    public void HandlePragmaMark() {
        assert (this.$this().CurPPLexer != null) : "No current lexer?";
        if (this.$this().CurLexer.$bool()) {
            ((Lexer)this.$this().CurLexer.$arrow()).ReadToEndOfLine();
        } else {
            ((PTHLexer)this.$this().CurPTHLexer.$arrow()).DiscardToEndOfLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void HandlePragmaPoison(Token PoisonTok) {
        Token Tok = new Token();
        while (true) {
            IdentifierInfo II;
            if (this.$this().CurPPLexer != null) {
                this.$this().CurPPLexer.LexingRawMode = true;
            }
            this.$this().LexUnexpandedToken(Tok);
            if (this.$this().CurPPLexer != null) {
                this.$this().CurPPLexer.LexingRawMode = false;
            }
            if (Tok.is('\u0002')) {
                return;
            }
            if (!Tok.isAnyIdentifier()) {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean((Object)((DiagnosticBuilder)$c$.track((Object)this.$this().Diag(Tok, 816))));
                    return;
                }
                finally {
                    $c$.$destroy();
                }
            }
            if (Tok.is('\u0006')) {
                II = this.$this().LookUpIdentifierInfo(Tok);
            } else {
                II = Tok.getIdentifierInfo();
                assert (this.$this().CurPPLexer == this.$this().CurPTHLexer.$arrow()) : "can be only in case of PTHLexer: " + this.$this().CurPPLexer;
                assert (II != null) : "must be valid token " + II;
            }
            if (II.isPoisoned()) continue;
            if (this.$this().isMacroDefined(II)) {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean((Object)((DiagnosticBuilder)$c$.track((Object)this.$this().Diag(Tok, 934))));
                }
                finally {
                    $c$.$destroy();
                }
            }
            II.setIsPoisoned();
            if (!II.isFromAST()) continue;
            II.setChangedSinceDeserialization();
        }
    }

    public void HandlePragmaSystemHeader(Token SysHeaderTok) {
        if (this.$this().isInPrimaryFile()) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)((DiagnosticBuilder)$c$.track((Object)this.$this().Diag(SysHeaderTok, 936))));
                return;
            }
            finally {
                $c$.$destroy();
            }
        }
        PreprocessorLexer TheLexer = this.$this().getCurrentFileLexer();
        this.$this().HeaderInfo.MarkFileSystemHeader(TheLexer.getFileEntry());
        PresumedLoc PLoc = this.$this().SourceMgr.getPresumedLoc(SysHeaderTok.$getLocation());
        if (PLoc.isInvalid()) {
            return;
        }
        int FilenameID = this.$this().SourceMgr.getLineTableFilenameID(new StringRef(PLoc.getFilename()));
        if (this.$this().Callbacks$boolean) {
            this.$this().Callbacks$arrow.FileChanged(this.$this().$CallbackLoc(SysHeaderTok.$getLocation()), PPCallbacks.FileChangeReason.SystemHeaderPragma, SrcMgr.CharacteristicKind.C_System);
        }
        this.$this().SourceMgr.AddLineNote(SysHeaderTok.$getLocation(), PLoc.getLine() + 1, FilenameID, false, false, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void HandlePragmaDependency(Token DependencyTok) {
        Token FilenameTok = new Token();
        this.$this().CurPPLexer.LexIncludeFilename(FilenameTok);
        if (FilenameTok.is('\u0002')) {
            return;
        }
        SmallString FilenameBuffer = new SmallString(128);
        bool.ptr Invalid = NativePointer.create_bool$ptr((boolean)false);
        StringRef Filename = this.$this().getSpelling(FilenameTok, FilenameBuffer, (bool.ptr)Native.$AddrOf((Object)Invalid));
        if (Invalid.$star()) {
            return;
        }
        boolean isAngled = this.$this().GetIncludeFilenameSpelling(FilenameTok.$getLocation(), Filename);
        if (Filename.empty()) {
            return;
        }
        type.ref CurDir = NativePointer.create_type$ref(null);
        FileEntry File2 = this.$this().LookupFile(FilenameTok.getLocation(), Filename, isAngled, (type.ptr<DirectoryLookup>)((type.ptr)null), null, (type.ref<type.ptr<DirectoryLookup>>)CurDir, null, null, null);
        if (File2 == null) {
            if (!this.$this().SuppressIncludeNotFoundError) {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder$C_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.$this().Diag(FilenameTok, 806))), (StringRef)Filename));
                }
                finally {
                    $c$.$destroy();
                }
            }
            return;
        }
        FileEntry CurFile = this.$this().getCurrentFileLexer().getFileEntry();
        if (CurFile != null && CurFile.getModificationTime() < File2.getModificationTime()) {
            std.string Message = new std.string();
            this.$this().Lex(DependencyTok);
            while (DependencyTok.isNot('\u0002')) {
                Message.$addassign(std.$add_str_T((std.string)this.$this().getSpelling(DependencyTok), (String)" "));
                this.$this().Lex(DependencyTok);
            }
            if (!Message.empty()) {
                Message.erase((char.ptr)Message.end().$sub(1));
            }
            BasicClangGlobals.$out_DiagnosticBuilder$C_StringRef((DiagnosticBuilder)this.$this().Diag(FilenameTok, 933), (StringRef)new StringRef(Message)).$destroy();
        }
    }

    public void HandlePragmaPushMacro(Token PushMacroTok) {
        IdentifierInfo IdentInfo = this.$this().ParsePragmaPushOrPopMacro(PushMacroTok);
        if (IdentInfo == null) {
            return;
        }
        MacroInfo MI = this.$this().getMacroInfo(IdentInfo);
        if (MI != null) {
            MI.setIsAllowRedefinitionsWithoutWarning(true);
        }
        ((std.vector)this.$this().PragmaPushMacroInfo.$at((Object)IdentInfo)).push_back((Object)MI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void HandlePragmaPopMacro(Token PopMacroTok) {
        int MessageLoc = PopMacroTok.$getLocation();
        IdentifierInfo IdentInfo = this.$this().ParsePragmaPushOrPopMacro(PopMacroTok);
        if (IdentInfo == null) {
            return;
        }
        DenseMapIterator iter = this.$this().PragmaPushMacroInfo.find((Object)IdentInfo);
        if (iter.$noteq(this.$this().PragmaPushMacroInfo.end())) {
            MacroInfo MacroToReInstall;
            MacroInfo MI = this.$this().getMacroInfo(IdentInfo);
            if (MI != null) {
                if (MI.isWarnIfUnused()) {
                    this.$this().WarnUnusedMacroLocs.erase((Object)MI.getDefinitionLoc());
                }
                this.$this().appendMacroDirective(IdentInfo, this.$this().AllocateUndefMacroDirective(MessageLoc));
            }
            if ((MacroToReInstall = (MacroInfo)((std.vector)iter.$arrow().second).back()) != null) {
                this.$this().appendDefMacroDirective(IdentInfo, MacroToReInstall, MessageLoc);
            }
            ((std.vector)iter.$arrow().second).pop_back();
            if (((std.vector)iter.$arrow().second).size() == 0) {
                this.$this().PragmaPushMacroInfo.erase(iter);
            }
        } else {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder$C_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.$this().Diag(MessageLoc, 998))), (StringRef)IdentInfo.getName()));
            }
            finally {
                $c$.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void HandlePragmaIncludeAlias(Token Tok) {
        this.$this().Lex(Tok);
        if (Tok.isNot('\u0015')) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder$C_char$ptr$C((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.$this().Diag(Tok, 993))), (char.ptr)NativePointer.$LPAREN));
                return;
            }
            finally {
                $c$.$destroy();
            }
        }
        Token SourceFilenameTok = new Token();
        this.$this().CurPPLexer.LexIncludeFilename(SourceFilenameTok);
        if (SourceFilenameTok.is('\u0002')) {
            return;
        }
        StringRef SourceFileName = new StringRef();
        SmallString FileNameBuffer = new SmallString(128);
        if (SourceFilenameTok.is('\r') || SourceFilenameTok.is('\u000f')) {
            SourceFileName.$assignMove(this.$this().getSpelling(SourceFilenameTok, FileNameBuffer));
        } else if (SourceFilenameTok.is('.')) {
            FileNameBuffer.push_back((byte)60);
            SourceLocation End = new SourceLocation();
            if (this.$this().ConcatenateIncludeName(FileNameBuffer, End)) {
                return;
            }
            SourceFileName.$assignMove(FileNameBuffer.$StringRef());
        } else {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)((DiagnosticBuilder)$c$.track((Object)this.$this().Diag(Tok, 994))));
                return;
            }
            finally {
                $c$.$destroy();
            }
        }
        FileNameBuffer.clear();
        this.$this().Lex(Tok);
        if (Tok.isNot('@')) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder$C_char$ptr$C((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.$this().Diag(Tok, 993))), (char.ptr)NativePointer.$COMMA));
                return;
            }
            finally {
                $c$.$destroy();
            }
        }
        Token ReplaceFilenameTok = new Token();
        this.$this().CurPPLexer.LexIncludeFilename(ReplaceFilenameTok);
        if (ReplaceFilenameTok.is('\u0002')) {
            return;
        }
        StringRef ReplaceFileName = new StringRef();
        if (ReplaceFilenameTok.is('\r') || ReplaceFilenameTok.is('\u000f')) {
            ReplaceFileName.$assignMove(this.$this().getSpelling(ReplaceFilenameTok, FileNameBuffer));
        } else if (ReplaceFilenameTok.is('.')) {
            FileNameBuffer.push_back((byte)60);
            SourceLocation End = new SourceLocation();
            if (this.$this().ConcatenateIncludeName(FileNameBuffer, End)) {
                return;
            }
            ReplaceFileName.$assignMove(FileNameBuffer.$StringRef());
        } else {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)((DiagnosticBuilder)$c$.track((Object)this.$this().Diag(Tok, 994))));
                return;
            }
            finally {
                $c$.$destroy();
            }
        }
        this.$this().Lex(Tok);
        if (Tok.isNot('\u0016')) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder$C_char$ptr$C((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.$this().Diag(Tok, 993))), (char.ptr)NativePointer.$RPAREN));
                return;
            }
            finally {
                $c$.$destroy();
            }
        }
        StringRef OriginalSource = new StringRef(SourceFileName);
        boolean SourceIsAngled = this.$this().GetIncludeFilenameSpelling(SourceFilenameTok.getLocation(), SourceFileName);
        boolean ReplaceIsAngled = this.$this().GetIncludeFilenameSpelling(ReplaceFilenameTok.getLocation(), ReplaceFileName);
        if (!SourceFileName.empty() && !ReplaceFileName.empty() && SourceIsAngled != ReplaceIsAngled) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                int DiagID = SourceIsAngled ? 995 : 996;
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder$C_StringRef((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder$C_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.$this().Diag(SourceFilenameTok.getLocation(), DiagID))), (StringRef)SourceFileName), (StringRef)ReplaceFileName));
                return;
            }
            finally {
                $c$.$destroy();
            }
        }
        this.$this().getHeaderSearchInfo().AddIncludeAlias(OriginalSource, ReplaceFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IdentifierInfo ParsePragmaPushOrPopMacro(Token Tok) {
        Token PragmaTok = new Token(Tok);
        this.$this().Lex(Tok);
        if (Tok.isNot('\u0015')) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder$C_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.$this().Diag(PragmaTok.getLocation(), 842))), (StringRef)new StringRef(this.$this().getSpelling(PragmaTok))));
                IdentifierInfo identifierInfo = null;
                return identifierInfo;
            }
            finally {
                $c$.$destroy();
            }
        }
        this.$this().Lex(Tok);
        if (Tok.isNot('\r')) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder$C_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.$this().Diag(PragmaTok.getLocation(), 842))), (StringRef)new StringRef(this.$this().getSpelling(PragmaTok))));
                IdentifierInfo identifierInfo = null;
                return identifierInfo;
            }
            finally {
                $c$.$destroy();
            }
        }
        if (Tok.hasUDSuffix()) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)((DiagnosticBuilder)$c$.track((Object)this.$this().Diag(Tok, 18))));
                IdentifierInfo identifierInfo = null;
                return identifierInfo;
            }
            finally {
                $c$.$destroy();
            }
        }
        std.string StrVal = this.$this().getSpelling(Tok);
        this.$this().Lex(Tok);
        if (Tok.isNot('\u0016')) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder$C_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.$this().Diag(PragmaTok.getLocation(), 842))), (StringRef)new StringRef(this.$this().getSpelling(PragmaTok))));
                IdentifierInfo identifierInfo = null;
                return identifierInfo;
            }
            finally {
                $c$.$destroy();
            }
        }
        assert (StrVal.$at(0) == 34 && StrVal.$at(StrVal.size() - 1) == 34) : "Invalid string token!";
        Token MacroTok = new Token();
        MacroTok.startToken();
        MacroTok.setKind('\u0006');
        this.$this().CreateString(new StringRef((char.ptr)Native.$AddrOf((Object)((char.ptr)StrVal.data().$add(1))), StrVal.size() - 2), MacroTok);
        return this.$this().LookUpIdentifierInfo(MacroTok);
    }
}

