/*
 * Decompiled with CFR 0.152.
 */
package org.clang.lex;

import org.clang.basic.BasicClangGlobals;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.DiagnosticsEngine;
import org.clang.basic.DirectoryEntry;
import org.clang.basic.FileEntry;
import org.clang.basic.FileID;
import org.clang.basic.FileManager;
import org.clang.basic.FullSourceLoc;
import org.clang.basic.LangOptions;
import org.clang.basic.Module;
import org.clang.basic.SourceLocation;
import org.clang.basic.SourceManager;
import org.clang.basic.SourceRange;
import org.clang.basic.SrcMgr;
import org.clang.basic.java.ClankAliases;
import org.clang.basic.target.TargetInfo;
import org.clang.basic.vfs.FileSystem;
import org.clang.basic.vfs.directory_iterator;
import org.clang.lex.HeaderSearch;
import org.clang.lex.Lexer;
import org.clang.lex.ModuleMap;
import org.clang.lex.ModuleMapCallbacks;
import org.clang.lex.impl.ModuleMapParser;
import org.clang.lex.impl.ModuleMapStatics;
import org.clank.java.std;
import org.clank.java.std_errors;
import org.clank.java.std_pair;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeMoveable;
import org.clank.support.NativePointer;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.type;
import org.clank.support.void;
import org.llvm.adt.ADTAliases;
import org.llvm.adt.DenseMapInfo;
import org.llvm.adt.SmallPtrSet;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.DenseMap;
import org.llvm.adt.aliases.DenseMapInfo;
import org.llvm.adt.aliases.DenseMapIterator;
import org.llvm.adt.aliases.DenseMapIteratorTypeBool;
import org.llvm.adt.aliases.DenseMapTypeBool;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.adt.aliases.StringMap;
import org.llvm.adt.aliases.StringMapConstIterator;
import org.llvm.adt.aliases.StringMapEntry;
import org.llvm.adt.aliases.StringMapIterator;
import org.llvm.adt.java.SmallVectorImplCommon;
import org.llvm.support.MemoryBuffer;
import org.llvm.support.llvm;
import org.llvm.support.sys.path;

public class ModuleMap
implements Destructors.ClassWithDestructor {
    private SourceManager SourceMgr;
    private DiagnosticsEngine Diags;
    public LangOptions LangOpts;
    public TargetInfo Target;
    public HeaderSearch HeaderInfo;
    private SmallVector<std_ptr.unique_ptr<ModuleMapCallbacks>> Callbacks;
    private DirectoryEntry BuiltinIncludeDir;
    private LangOptions MMapLangOpts;
    public Module.B SourceModule;
    private StringMap<Module.B> Modules;
    private int NumCreatedModules;
    private DenseMap<FileEntry, SmallVector<KnownHeader>> Headers;
    public DenseMap<DirectoryEntry, Module.B> UmbrellaDirs;
    public DenseMap<DirectoryEntry, InferredDirectory> InferredDirectories;
    private DenseMap<Module.B, FileEntry> InferredModuleAllowedBy;
    private DenseMap<Module.B, SmallPtrSet<FileEntry>> AdditionalModMaps;
    private DenseMapTypeBool<FileEntry> ParsedModuleMap;

    private ADTAliases.PointerInt2Pair<Module.B> resolveExport(Module.B Mod, Module.B.UnresolvedExportDecl Unresolved, boolean Complain) {
        if (Unresolved.Id.empty()) {
            assert (Unresolved.Wildcard) : "Invalid unresolved export";
            return new ADTAliases.PointerInt2Pair((Object)null, true);
        }
        Module.B Context2 = this.resolveModuleId(Unresolved.Id, Mod, Complain);
        if (Context2 == null) {
            return new ADTAliases.PointerInt2Pair();
        }
        return new ADTAliases.PointerInt2Pair((Object)Context2, Unresolved.Wildcard);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Module.B resolveModuleId(ClankAliases.ModuleId Id, Module.B Mod, boolean Complain) {
        Module.B Context2 = this.lookupModuleUnqualified(new StringRef((std.string)((std_pair.pair)Id.$at((int)0)).first), Mod);
        if (Context2 == null) {
            if (Complain) {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder$C_StringRef((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder$C_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.Diags.Report((SourceLocation)((std_pair.pair)Id.$at((int)0)).second, 768))), (StringRef)new StringRef((std.string)((std_pair.pair)Id.$at((int)0)).first)), (StringRef)new StringRef(Mod.getFullModuleName())));
                }
                finally {
                    $c$.$destroy();
                }
            }
            return null;
        }
        int N = Id.size();
        for (int I = 1; I != N; ++I) {
            Module.B Sub = this.lookupModuleQualified(new StringRef((std.string)((std_pair.pair)Id.$at((int)I)).first), Context2);
            if (Sub == null) {
                if (Complain) {
                    JavaCleaner $c$ = Native.$createJavaCleaner();
                    try {
                        $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder$C_SourceRange((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder$C_StringRef((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder$C_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.Diags.Report((SourceLocation)((std_pair.pair)Id.$at((int)I)).second, 767))), (StringRef)new StringRef((std.string)((std_pair.pair)Id.$at((int)I)).first)), (StringRef)new StringRef(Context2.getFullModuleName())), (SourceRange)new SourceRange((SourceLocation)((std_pair.pair)Id.$at((int)0)).second, (SourceLocation)((std_pair.pair)Id.$at((int)(I - 1))).second)));
                    }
                    finally {
                        $c$.$destroy();
                    }
                }
                return null;
            }
            Context2 = Sub;
        }
        return Context2;
    }

    private DenseMapIterator<FileEntry, SmallVector<KnownHeader>> findKnownHeader(FileEntry File) {
        DenseMapIterator Known = this.Headers.find((Object)File);
        if (this.HeaderInfo.getHeaderSearchOpts().ImplicitModuleMaps && Known.$eq(this.Headers.end()) && File.getDir() == this.BuiltinIncludeDir && ModuleMapStatics.isBuiltinHeader(path.filename((StringRef)new StringRef(File.getName())))) {
            this.HeaderInfo.loadTopLevelSystemModules();
            return this.Headers.find((Object)File);
        }
        return Known;
    }

    private KnownHeader findHeaderInUmbrellaDirs(FileEntry File, SmallVectorImpl<DirectoryEntry> IntermediateDirs) {
        if (this.UmbrellaDirs.empty()) {
            return new KnownHeader();
        }
        DirectoryEntry Dir = File.getDir();
        assert (Dir != null) : "file in no directory";
        StringRef DirName = this.SourceMgr.getFileManager().getCanonicalName(Dir);
        do {
            DenseMapIterator KnownDir;
            if ((KnownDir = this.UmbrellaDirs.find((Object)Dir)).$noteq(this.UmbrellaDirs.end())) {
                return new KnownHeader((Module.B)KnownDir.$arrow().second, 0);
            }
            IntermediateDirs.push_back((Object)Dir);
            DirName.$assignMove(path.parent_path((StringRef)DirName));
        } while (!DirName.empty() && (Dir = this.SourceMgr.getFileManager().getDirectory(DirName)) != null);
        return new KnownHeader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KnownHeader findOrCreateModuleForHeaderInUmbrellaDir(FileEntry File) {
        assert (this.Headers.count((Object)File) == 0) : "already have a module for this header";
        SmallVector SkippedDirs = new SmallVector(2, (Object)null);
        KnownHeader H = this.findHeaderInUmbrellaDirs(File, (SmallVectorImpl<DirectoryEntry>)SkippedDirs);
        if (H.$bool()) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                Module.B Result;
                Module.B UmbrellaModule = Result = H.getModule();
                while ($c$.clean(!((Module.B.DirectoryName)$c$.track((Object)UmbrellaModule.getUmbrellaDir())).$bool() && UmbrellaModule.Parent != null)) {
                    UmbrellaModule = UmbrellaModule.Parent;
                }
                if (UmbrellaModule.InferSubmodules) {
                    FileEntry UmbrellaModuleMap = this.getModuleMapFileForUniquing(UmbrellaModule);
                    boolean Explicit = UmbrellaModule.InferExplicitSubmodules;
                    for (int I = SkippedDirs.size(); I != 0; --I) {
                        SmallString NameBuf = new SmallString(32);
                        StringRef Name = ModuleMapStatics.sanitizeFilenameAsIdentifier(path.stem((StringRef)new StringRef(((DirectoryEntry)SkippedDirs.$at(I - 1)).getName())), NameBuf);
                        Result = (Module.B)this.findOrCreateModule((StringRef)Name, (Module.B)Result, (boolean)false, (boolean)Explicit).first;
                        this.InferredModuleAllowedBy.$set((Object)Result, (Object)UmbrellaModuleMap);
                        Result.IsInferred = true;
                        this.UmbrellaDirs.$set((Object)((DirectoryEntry)SkippedDirs.$at(I - 1)), (Object)Result);
                        if (!UmbrellaModule.InferExportWildcard || !Result.Exports.empty()) continue;
                        Result.Exports.push_back((Object)new ADTAliases.PointerInt2Pair((Object)null, true));
                    }
                    SmallString NameBuf = new SmallString(32);
                    StringRef Name = ModuleMapStatics.sanitizeFilenameAsIdentifier(path.stem((StringRef)new StringRef(File.getName())), NameBuf);
                    Result = (Module.B)this.findOrCreateModule((StringRef)Name, (Module.B)Result, (boolean)false, (boolean)Explicit).first;
                    this.InferredModuleAllowedBy.$set((Object)Result, (Object)UmbrellaModuleMap);
                    Result.IsInferred = true;
                    Result.addTopHeader(File);
                    if (UmbrellaModule.InferExportWildcard && Result.Exports.empty()) {
                        Result.Exports.push_back((Object)new ADTAliases.PointerInt2Pair((Object)null, true));
                    }
                } else {
                    int N = SkippedDirs.size();
                    for (int I = 0; I != N; ++I) {
                        this.UmbrellaDirs.$set((Object)((DirectoryEntry)SkippedDirs.$at(I)), (Object)Result);
                    }
                }
                KnownHeader Header2 = new KnownHeader(Result, 0);
                ((SmallVector)this.Headers.$at((Object)File)).push_back((Object)Header2);
                KnownHeader knownHeader = Header2;
                return knownHeader;
            }
            finally {
                $c$.$destroy();
            }
        }
        return new KnownHeader();
    }

    private boolean isHeaderInUmbrellaDirs(FileEntry File) {
        SmallVector IntermediateDirs = new SmallVector(2, (Object)null);
        return this.findHeaderInUmbrellaDirs(File, (SmallVectorImpl<DirectoryEntry>)IntermediateDirs).$bool();
    }

    private Module.B inferFrameworkModule(DirectoryEntry FrameworkDir, Attributes Attrs, Module.B Parent) {
        StringRef FrameworkDirName = this.SourceMgr.getFileManager().getCanonicalName(FrameworkDir);
        SmallString ModuleNameStorage = new SmallString(32);
        StringRef ModuleName = ModuleMapStatics.sanitizeFilenameAsIdentifier(path.stem((StringRef)FrameworkDirName), ModuleNameStorage);
        Module.B Mod = this.lookupModuleQualified(ModuleName, Parent);
        if (Mod != null) {
            return Mod;
        }
        FileManager FileMgr = this.SourceMgr.getFileManager();
        FileEntry ModuleMapFile = null;
        if (Parent == null) {
            StringRef _Parent;
            DirectoryEntry ParentDir;
            boolean canInfer = false;
            if (path.has_parent_path((Twine)new Twine(FrameworkDirName)) && (ParentDir = FileMgr.getDirectory(_Parent = path.parent_path((StringRef)FrameworkDirName))) != null) {
                DenseMapIterator inferred = new DenseMapIterator(this.InferredDirectories.find((Object)ParentDir));
                if (inferred.$eq(this.InferredDirectories.end())) {
                    boolean IsFrameworkDir = _Parent.endswith(".framework");
                    FileEntry ModMapFile = this.HeaderInfo.lookupModuleMapFile(ParentDir, IsFrameworkDir);
                    if (ModMapFile != null) {
                        this.parseModuleMapFile(ModMapFile, Attrs.IsSystem, ParentDir);
                        inferred.$assignMove(this.InferredDirectories.find((Object)ParentDir));
                    }
                    if (inferred.$eq(this.InferredDirectories.end())) {
                        inferred.$assignMove((DenseMapIterator)this.InferredDirectories.insert((std_pair.pair)std.make_pair_Ptr_T((Object)ParentDir, (Object)new InferredDirectory())).first);
                    }
                }
                if (((InferredDirectory)inferred.$arrow().second).InferModules) {
                    StringRef Name = path.stem((StringRef)FrameworkDirName);
                    canInfer = Native.$eq_ptr((void.ptr)((type.ptr)std.find((type.iterator)((InferredDirectory)inferred.$arrow().second).ExcludedModules.begin(), (type.iterator)((InferredDirectory)inferred.$arrow().second).ExcludedModules.end(), (Object)Name)), (void.ptr)((InferredDirectory)inferred.$arrow().second).ExcludedModules.end());
                    Attrs.IsSystem |= ((InferredDirectory)inferred.$arrow().second).Attrs.IsSystem;
                    Attrs.IsExternC |= ((InferredDirectory)inferred.$arrow().second).Attrs.IsExternC;
                    Attrs.IsExhaustive |= ((InferredDirectory)inferred.$arrow().second).Attrs.IsExhaustive;
                    ModuleMapFile = ((InferredDirectory)inferred.$arrow().second).ModuleMapFile;
                }
            }
            if (!canInfer) {
                return null;
            }
        } else {
            ModuleMapFile = this.getModuleMapFileForUniquing(Parent);
        }
        SmallString UmbrellaName = new SmallString(new StringRef(FrameworkDir.getName()), 128);
        path.append((SmallString)UmbrellaName, (Twine)new Twine("Headers"), (Twine)llvm.$add_StringRef_char$ptr$C((StringRef)ModuleName, (String)".h"));
        FileEntry UmbrellaHeader = FileMgr.getFile(UmbrellaName.$StringRef());
        if (UmbrellaHeader == null) {
            return null;
        }
        Module.B Result = new Module.B(ModuleName, new SourceLocation(), Parent, true, false, this.NumCreatedModules++);
        this.InferredModuleAllowedBy.$set((Object)Result, (Object)ModuleMapFile);
        Result.IsInferred = true;
        if (Parent == null) {
            if (llvm.$eq_StringRef((StringRef)new StringRef(this.LangOpts.CurrentModule), (StringRef)ModuleName)) {
                this.SourceModule = Result;
            }
            this.Modules.$set(ModuleName, (Object)Result);
        }
        Result.IsSystem |= Attrs.IsSystem;
        Result.IsExternC |= Attrs.IsExternC;
        Result.ConfigMacrosExhaustive |= Attrs.IsExhaustive;
        Result.Directory = FrameworkDir;
        this.setUmbrellaHeader(Result, UmbrellaHeader, llvm.$add_StringRef_char$ptr$C((StringRef)ModuleName, (String)".h"));
        Result.Exports.push_back((Object)new ADTAliases.PointerInt2Pair((Object)null, true));
        Result.InferSubmodules = true;
        Result.InferExportWildcard = true;
        std_errors.error_code EC = new std_errors.error_code();
        SmallString SubframeworksDirName = new SmallString(new StringRef(FrameworkDir.getName()), 128);
        path.append((SmallString)SubframeworksDirName, (Twine)new Twine("Frameworks"));
        path.__native((SmallString)SubframeworksDirName);
        FileSystem FS = (FileSystem)FileMgr.getVirtualFileSystem().$star();
        directory_iterator Dir = FS.dir_begin(new Twine(SubframeworksDirName), EC);
        directory_iterator DirEnd = new directory_iterator();
        while (Dir.$noteq(DirEnd) && !EC.$bool()) {
            DirectoryEntry SubframeworkDir;
            if (Dir.$arrow().getName().endswith(".framework") && (SubframeworkDir = FileMgr.getDirectory(Dir.$arrow().getName())) != null) {
                boolean FoundParent;
                block17: {
                    StringRef SubframeworkDirName = FileMgr.getCanonicalName(SubframeworkDir);
                    FoundParent = false;
                    do {
                        SubframeworkDirName.$assignMove(path.parent_path((StringRef)SubframeworkDirName));
                        if (SubframeworkDirName.empty()) break block17;
                    } while (FileMgr.getDirectory(SubframeworkDirName) != FrameworkDir);
                    FoundParent = true;
                }
                if (FoundParent) {
                    this.inferFrameworkModule(SubframeworkDir, Attrs, Result);
                }
            }
            Dir.increment(EC);
        }
        if (!Result.isSubFramework()) {
            ModuleMapStatics.inferFrameworkLink(Result, FrameworkDir, FileMgr);
        }
        return Result;
    }

    public ModuleMap(SourceManager SourceMgr, DiagnosticsEngine Diags, LangOptions LangOpts, TargetInfo Target, HeaderSearch HeaderInfo) {
        this.SourceMgr = SourceMgr;
        this.Diags = Diags;
        this.LangOpts = LangOpts;
        this.Target = Target;
        this.HeaderInfo = HeaderInfo;
        this.Callbacks = new SmallVector(1, (Object)new std_ptr.unique_ptr());
        this.BuiltinIncludeDir = null;
        this.MMapLangOpts = new LangOptions();
        this.SourceModule = null;
        this.Modules = new StringMap(null);
        this.NumCreatedModules = 0;
        this.Headers = new DenseMap(FileEntry.DMI$FileEntryPtr, (Object)new SmallVector(1, (Object)new KnownHeader()));
        this.UmbrellaDirs = new DenseMap((DenseMapInfo)DenseMapInfo.LikePtr.$Info(), null);
        this.InferredDirectories = new DenseMap((DenseMapInfo)DenseMapInfo.LikePtr.$Info(), (Object)new InferredDirectory());
        this.InferredModuleAllowedBy = new DenseMap((DenseMapInfo)DenseMapInfo.LikePtr.$Info(), null);
        this.AdditionalModMaps = new DenseMap((DenseMapInfo)DenseMapInfo.LikePtr.$Info(), (Object)new SmallPtrSet(FileEntry.DMI$FileEntryPtr, 1));
        this.ParsedModuleMap = new DenseMapTypeBool(FileEntry.DMI$FileEntryPtr, false);
        this.MMapLangOpts.LineComment = true;
    }

    public void $destroy() {
        for (StringMapEntry M : this.Modules) {
            if (M.getValue() == null) continue;
            ((Module.B)M.getValue()).$destroy();
        }
        this.ParsedModuleMap.$destroy();
        this.AdditionalModMaps.$destroy();
        this.InferredModuleAllowedBy.$destroy();
        this.InferredDirectories.$destroy();
        this.UmbrellaDirs.$destroy();
        this.Headers.$destroy();
        this.Modules.$destroy();
        this.MMapLangOpts.$destroy();
        this.Callbacks.$destroy();
    }

    public void setTarget(TargetInfo Target) {
        assert (this.Target == null || this.Target == Native.$AddrOf((Object)Target)) : "Improper target override";
        this.Target = (TargetInfo)Native.$AddrOf((Object)Target);
    }

    public void setBuiltinIncludeDir(DirectoryEntry Dir) {
        this.BuiltinIncludeDir = Dir;
    }

    public void addModuleMapCallbacks(std_ptr.unique_ptr<ModuleMapCallbacks> Callback) {
        this.Callbacks.push_back_T$RR((Object)((std_ptr.unique_ptr)std.move(Callback)));
    }

    public KnownHeader findModuleForHeader(FileEntry File) {
        findModuleForHeader.MakeResultLambda MakeResult = R -> {
            if ((R.getRole() & 2) != 0) {
                return new KnownHeader();
            }
            return new KnownHeader(JavaDifferentiators.JD$Move.INSTANCE, R);
        };
        DenseMapIterator<FileEntry, SmallVector<KnownHeader>> Known = this.findKnownHeader(File);
        if (Known.$noteq(this.Headers.end())) {
            KnownHeader Result = new KnownHeader();
            for (KnownHeader H : (SmallVector)Known.$arrow().second) {
                if (H.getModule().getTopLevelModule() == this.SourceModule) {
                    return MakeResult.$call(new KnownHeader(H));
                }
                if (Result.$bool() && !ModuleMapStatics.isBetterKnownHeader(H, Result)) continue;
                Result.$assign(H);
            }
            return MakeResult.$call(new KnownHeader(Result));
        }
        return MakeResult.$call(this.findOrCreateModuleForHeaderInUmbrellaDir(File));
    }

    public ArrayRef<KnownHeader> findAllModulesForHeader(FileEntry File) {
        DenseMapIterator It = this.Headers.find((Object)File);
        if (It.$eq(this.Headers.end())) {
            return ArrayRef.None();
        }
        return new ArrayRef((SmallVectorImplCommon)It.$arrow().second);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void diagnoseHeaderInclusion(Module.B RequestingModule, boolean RequestingModuleIsModuleInterface, SourceLocation FilenameLoc, StringRef Filename, FileEntry File) {
        JavaCleaner $c$;
        if (ModuleMapStatics.getTopLevelOrNull(RequestingModule) != ModuleMapStatics.getTopLevelOrNull(this.SourceModule)) {
            return;
        }
        if (RequestingModule != null) {
            this.resolveUses(RequestingModule, false);
        }
        boolean Excluded = false;
        Module.B Private = null;
        Module.B NotUsed = null;
        DenseMapIterator<FileEntry, SmallVector<KnownHeader>> Known = this.findKnownHeader(File);
        if (Known.$noteq(this.Headers.end())) {
            for (KnownHeader Header2 : (SmallVector)Known.$arrow().second) {
                if (ModuleMapStatics.violatesPrivateInclude(RequestingModule, File, Header2)) {
                    Private = Header2.getModule();
                    continue;
                }
                if (RequestingModule != null && this.LangOpts.ModulesDeclUse && !RequestingModule.directlyUses(Header2.getModule())) {
                    NotUsed = Header2.getModule();
                    continue;
                }
                return;
            }
            Excluded = true;
        }
        if (Private != null) {
            $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder$C_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.Diags.Report(FilenameLoc, 1010))), (StringRef)Filename));
                return;
            }
            finally {
                $c$.$destroy();
            }
        }
        if (NotUsed != null) {
            $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder$C_StringRef((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder$C_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.Diags.Report(FilenameLoc, 851))), (StringRef)new StringRef(RequestingModule.getFullModuleName())), (StringRef)Filename));
                return;
            }
            finally {
                $c$.$destroy();
            }
        }
        if (Excluded || this.isHeaderInUmbrellaDirs(File)) {
            return;
        }
        if (this.LangOpts.ModulesStrictDeclUse) {
            $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder$C_StringRef((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder$C_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.Diags.Report(FilenameLoc, 851))), (StringRef)new StringRef(RequestingModule.getFullModuleName())), (StringRef)Filename));
            }
            finally {
                $c$.$destroy();
            }
        }
        if (RequestingModule != null && RequestingModuleIsModuleInterface) {
            $c$ = Native.$createJavaCleaner();
            try {
                int DiagID = RequestingModule.getTopLevelModule().IsFramework ? 974 : 975;
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder$C_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.Diags.Report(FilenameLoc, DiagID))), (StringRef)new StringRef(RequestingModule.getFullModuleName())));
            }
            finally {
                $c$.$destroy();
            }
        }
    }

    public boolean isHeaderInUnavailableModule(FileEntry Header2) {
        return this.isHeaderUnavailableInModule(Header2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHeaderUnavailableInModule(FileEntry Header2, Module.B RequestingModule) {
        DenseMapIterator Known = this.Headers.find((Object)Header2);
        if (Known.$noteq(this.Headers.end())) {
            type.ptr I = ((SmallVector)Known.$arrow().second).begin();
            type.ptr E = ((SmallVector)Known.$arrow().second).end();
            while (Native.$noteq_iter((abstract_iterator)I, (abstract_iterator)E)) {
                if (((KnownHeader)I.$star()).isAvailable() && (RequestingModule == null || ((KnownHeader)I.$star()).getModule().isSubModuleOf(RequestingModule))) {
                    return false;
                }
                I.$preInc();
            }
            return true;
        }
        DirectoryEntry Dir = Header2.getDir();
        SmallVector SkippedDirs = new SmallVector(2, (Object)null);
        StringRef DirName = new StringRef(Dir.getName());
        isHeaderUnavailableInModule.IsUnavailableLambda IsUnavailable = M -> !M.isAvailable() && (RequestingModule == null || M.isSubModuleOf(RequestingModule));
        do {
            DenseMapIterator KnownDir;
            if ((KnownDir = this.UmbrellaDirs.find((Object)Dir)).$noteq(this.UmbrellaDirs.end())) {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    Module.B Found = (Module.B)KnownDir.$arrow().second;
                    if (IsUnavailable.$call(Found)) {
                        boolean bl = true;
                        return bl;
                    }
                    Module.B UmbrellaModule = Found;
                    while ($c$.clean(!((Module.B.DirectoryName)$c$.track((Object)UmbrellaModule.getUmbrellaDir())).$bool() && UmbrellaModule.Parent != null)) {
                        UmbrellaModule = UmbrellaModule.Parent;
                    }
                    if (UmbrellaModule.InferSubmodules) {
                        for (int I = SkippedDirs.size(); I != 0; --I) {
                            SmallString NameBuf = new SmallString(32);
                            StringRef Name = ModuleMapStatics.sanitizeFilenameAsIdentifier(path.stem((StringRef)new StringRef(((DirectoryEntry)SkippedDirs.$at(I - 1)).getName())), NameBuf);
                            Found = this.lookupModuleQualified(Name, Found);
                            if (Found == null) {
                                boolean bl = false;
                                return bl;
                            }
                            if (!IsUnavailable.$call(Found)) continue;
                            boolean bl = true;
                            return bl;
                        }
                        SmallString NameBuf = new SmallString(32);
                        StringRef Name = ModuleMapStatics.sanitizeFilenameAsIdentifier(path.stem((StringRef)new StringRef(Header2.getName())), NameBuf);
                        Found = this.lookupModuleQualified(Name, Found);
                        if (Found == null) {
                            boolean bl = false;
                            return bl;
                        }
                    }
                    boolean bl = IsUnavailable.$call(Found);
                    return bl;
                }
                finally {
                    $c$.$destroy();
                }
            }
            SkippedDirs.push_back((Object)Dir);
            DirName.$assignMove(path.parent_path((StringRef)DirName));
        } while (!DirName.empty() && (Dir = this.SourceMgr.getFileManager().getDirectory(DirName)) != null);
        return false;
    }

    public Module.B findModule(StringRef Name) {
        StringMapIterator Known = this.Modules.find(Name);
        if (Known.$noteq((StringMapConstIterator)this.Modules.end())) {
            return (Module.B)Known.$arrow().getValue();
        }
        return null;
    }

    public Module.B lookupModuleUnqualified(StringRef Name, Module.B Context2) {
        while (Context2 != null) {
            Module.B Sub = this.lookupModuleQualified(Name, Context2);
            if (Sub != null) {
                return Sub;
            }
            Context2 = Context2.Parent;
        }
        return this.findModule(Name);
    }

    public Module.B lookupModuleQualified(StringRef Name, Module.B Context2) {
        if (Context2 == null) {
            return this.findModule(Name);
        }
        return Context2.findSubmodule(new StringRef(Name));
    }

    public std_pair.pairTypeBool<Module.B> findOrCreateModule(StringRef Name, Module.B Parent, boolean IsFramework, boolean IsExplicit) {
        Module.B Sub = this.lookupModuleQualified(Name, Parent);
        if (Sub != null) {
            return std.make_pair_Ptr_bool((Object)Sub, (boolean)false);
        }
        Module.B Result = new Module.B(Name, new SourceLocation(), Parent, IsFramework, IsExplicit, this.NumCreatedModules++);
        if (Parent == null) {
            if (llvm.$eq_StringRef((StringRef)new StringRef(this.LangOpts.CurrentModule), (StringRef)Name)) {
                this.SourceModule = Result;
            }
            this.Modules.$set(Name, (Object)Result);
        }
        return std.make_pair_Ptr_bool((Object)Result, (boolean)true);
    }

    public Module.B inferFrameworkModule(DirectoryEntry FrameworkDir, boolean IsSystem, Module.B Parent) {
        Attributes Attrs = new Attributes();
        Attrs.IsSystem = IsSystem;
        return this.inferFrameworkModule(FrameworkDir, Attrs, Parent);
    }

    public FileEntry getContainingModuleMapFile(Module.B Module2) {
        if (Module2.DefinitionLoc.isInvalid()) {
            return null;
        }
        return this.SourceMgr.getFileEntryForID(this.SourceMgr.getFileID(Module2.DefinitionLoc));
    }

    public FileEntry getModuleMapFileForUniquing(Module.B M) {
        if (M.IsInferred) {
            assert (this.InferredModuleAllowedBy.count((Object)M) != 0) : "missing inferred module map";
            return (FileEntry)this.InferredModuleAllowedBy.find((Object)M).$arrow().second;
        }
        return this.getContainingModuleMapFile(M);
    }

    public void setInferredModuleAllowedBy(Module.B M, FileEntry ModMap) {
        assert (M.IsInferred) : "module not inferred";
        this.InferredModuleAllowedBy.$set((Object)M, (Object)ModMap);
    }

    public SmallPtrSet<FileEntry> getAdditionalModuleMapFiles(Module.B M) {
        DenseMapIterator I = this.AdditionalModMaps.find((Object)M);
        if (I.$eq(this.AdditionalModMaps.end())) {
            return null;
        }
        return (SmallPtrSet)Native.$AddrOf((Object)((SmallPtrSet)I.$arrow().second));
    }

    public void addAdditionalModuleMapFile(Module.B M, FileEntry ModuleMap2) {
        ((SmallPtrSet)this.AdditionalModMaps.$at((Object)M)).insert((Object)ModuleMap2);
    }

    public boolean resolveExports(Module.B Mod, boolean Complain) {
        SmallVector Unresolved = new SmallVector(JavaDifferentiators.JD$Move.INSTANCE, (SmallVector)std.move((Object)Mod.UnresolvedExports));
        Mod.UnresolvedExports.clear();
        for (Module.B.UnresolvedExportDecl UE : Unresolved) {
            ADTAliases.PointerInt2Pair<Module.B> Export = this.resolveExport(Mod, UE, Complain);
            if (Export.getPointer() != null || Export.getInt() != 0) {
                Mod.Exports.push_back(Export);
                continue;
            }
            Mod.UnresolvedExports.push_back((Object)UE);
        }
        return !Mod.UnresolvedExports.empty();
    }

    public boolean resolveUses(Module.B Mod, boolean Complain) {
        SmallVector Unresolved = new SmallVector(Mod.UnresolvedDirectUses);
        Mod.UnresolvedDirectUses.clear();
        for (ClankAliases.ModuleId UDU : Unresolved) {
            Module.B DirectUse = this.resolveModuleId(UDU, Mod, Complain);
            if (DirectUse != null) {
                Mod.DirectUses.push_back((Object)DirectUse);
                continue;
            }
            Mod.UnresolvedDirectUses.push_back((Object)UDU);
        }
        return !Mod.UnresolvedDirectUses.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resolveConflicts(Module.B Mod, boolean Complain) {
        std.vector Unresolved = new std.vector(JavaDifferentiators.JD$Move.INSTANCE, (std.vector)std.move((Object)Mod.UnresolvedConflicts));
        Mod.UnresolvedConflicts.clear();
        for (Module.B.UnresolvedConflict UC : Unresolved) {
            Module.B OtherMod = this.resolveModuleId(UC.Id, Mod, Complain);
            if (OtherMod != null) {
                Module.B.Conflict Conflict2 = null;
                try {
                    Conflict2 = new Module.B.Conflict();
                    Conflict2.Other = OtherMod;
                    Conflict2.Message.$assign(UC.Message);
                    Mod.Conflicts.push_back((Object)Conflict2);
                    continue;
                }
                finally {
                    if (Conflict2 != null) {
                        Conflict2.$destroy();
                    }
                    continue;
                }
            }
            Mod.UnresolvedConflicts.push_back((Object)UC);
        }
        return !Mod.UnresolvedConflicts.empty();
    }

    public Module.B inferModuleFromLocation(FullSourceLoc Loc) {
        FileEntry ExpansionFile;
        if (Loc.isInvalid()) {
            return null;
        }
        if (this.UmbrellaDirs.empty() && this.Headers.empty()) {
            return null;
        }
        FullSourceLoc ExpansionLoc = Loc.getExpansionLoc();
        if (!ExpansionLoc.isFileID()) {
            return null;
        }
        SourceManager SrcMgr2 = Loc.getManager();
        FileID ExpansionFileID = ExpansionLoc.getFileID();
        while ((ExpansionFile = SrcMgr2.getFileEntryForID(ExpansionFileID)) != null) {
            Module.B Mod = this.findModuleForHeader(ExpansionFile).getModule();
            if (Mod != null) {
                return Mod;
            }
            SourceLocation IncludeLoc = SrcMgr2.getIncludeLoc(ExpansionFileID);
            if (IncludeLoc.isInvalid()) {
                return null;
            }
            ExpansionFileID.$assignMove(SrcMgr2.getFileID(IncludeLoc));
        }
        return null;
    }

    public void setUmbrellaHeader(Module.B Mod, FileEntry UmbrellaHeader, Twine NameAsWritten) {
        ((SmallVector)this.Headers.$at_T1$C$R((Object)UmbrellaHeader)).push_back((Object)new KnownHeader(Mod, 0));
        Mod.Umbrella.$assign_T1$C$R(FileEntry.class, (Object)UmbrellaHeader);
        Mod.UmbrellaAsWritten.$assignMove(NameAsWritten.str());
        this.UmbrellaDirs.$set((Object)UmbrellaHeader.getDir(), (Object)Mod);
        for (std_ptr.unique_ptr Cb : this.Callbacks) {
            ((ModuleMapCallbacks)Cb.$arrow()).moduleMapAddUmbrellaHeader((FileManager)Native.$AddrOf((Object)this.SourceMgr.getFileManager()), UmbrellaHeader);
        }
    }

    public void setUmbrellaDir(Module.B Mod, DirectoryEntry UmbrellaDir, Twine NameAsWritten) {
        Mod.Umbrella.$assign_T$C$R(DirectoryEntry.class, (Object)UmbrellaDir);
        Mod.UmbrellaAsWritten.$assignMove(NameAsWritten.str());
        this.UmbrellaDirs.$set((Object)UmbrellaDir, (Object)Mod);
    }

    public void addHeader(Module.B Mod, Module.B.Header Header2, int Role) {
        this.addHeader(Mod, Header2, Role, false);
    }

    public void addHeader(Module.B Mod, Module.B.Header Header2, int Role, boolean Imported) {
        boolean isCompilingModuleHeader;
        KnownHeader KH = new KnownHeader(Mod, Role);
        SmallVector HeaderList = (SmallVector)this.Headers.$at((Object)Header2.Entry);
        for (KnownHeader H : HeaderList) {
            if (!KnownHeader.$eq_KnownHeader(H, KH)) continue;
            return;
        }
        HeaderList.push_back((Object)KH);
        Mod.Headers[ModuleMapStatics.headerRoleToKind(Role).getValue()].push_back_T$RR((Object)((Module.B.Header)std.move((Object)Header2)));
        boolean bl = isCompilingModuleHeader = this.LangOpts.CompilingModule && Mod.getTopLevelModule() == this.SourceModule;
        if (!Imported || isCompilingModuleHeader) {
            this.HeaderInfo.MarkFileModuleHeader(Header2.Entry, Role, isCompilingModuleHeader);
        }
        for (std_ptr.unique_ptr Cb : this.Callbacks) {
            ((ModuleMapCallbacks)Cb.$arrow()).moduleMapAddHeader(new StringRef(Header2.Entry.getName()));
        }
    }

    public void excludeHeader(Module.B Mod, Module.B.Header Header2) {
        this.Headers.$at((Object)Header2.Entry);
        Mod.Headers[Module.B.HeaderKind.HK_Excluded.getValue()].push_back_T$RR((Object)((Module.B.Header)std.move((Object)Header2)));
    }

    public boolean parseModuleMapFile(FileEntry File, boolean IsSystem, DirectoryEntry Dir) {
        return this.parseModuleMapFile(File, IsSystem, Dir, new SourceLocation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parseModuleMapFile(FileEntry File, boolean IsSystem, DirectoryEntry Dir, SourceLocation ExternModuleLoc) {
        Lexer L = null;
        ModuleMapParser Parser = null;
        try {
            DenseMapIteratorTypeBool Known = this.ParsedModuleMap.find((Object)File);
            if (Known.$noteq(this.ParsedModuleMap.end())) {
                boolean bl = Known.$arrow().second;
                return bl;
            }
            assert (this.Target != null) : "Missing target information";
            SrcMgr.CharacteristicKind FileCharacter = IsSystem ? SrcMgr.CharacteristicKind.C_System : SrcMgr.CharacteristicKind.C_User;
            int ID = this.SourceMgr.createFileID(File, ExternModuleLoc.getRawEncoding(), FileCharacter);
            MemoryBuffer Buffer = this.SourceMgr.getBuffer(ID);
            if (Buffer == null) {
                boolean bl = this.ParsedModuleMap.$set((Object)File, true);
                return bl;
            }
            L = new Lexer(ID, this.SourceMgr.getBuffer(ID), this.SourceMgr, this.MMapLangOpts);
            int Start = L.getCurCharSourceLocation();
            Parser = new ModuleMapParser(L, this.SourceMgr, this.Target, this.Diags, this, File, Dir, this.BuiltinIncludeDir, IsSystem);
            boolean Result = Parser.parseModuleMapFile();
            this.ParsedModuleMap.$set((Object)File, Result);
            for (std_ptr.unique_ptr Cb : this.Callbacks) {
                ((ModuleMapCallbacks)Cb.$arrow()).moduleMapFileRead(SourceLocation.getFromRawEncoding((int)Start), (FileEntry)Native.$Deref((Object)File), IsSystem);
            }
            boolean bl = Result;
            return bl;
        }
        finally {
            if (Parser != null) {
                Parser.$destroy();
            }
            if (L != null) {
                L.$destroy();
            }
        }
    }

    public void dump() {
        llvm.errs().$out("Modules:");
        StringMapIterator M = this.Modules.begin();
        StringMapIterator MEnd = this.Modules.end();
        while (M.$noteq((StringMapConstIterator)MEnd)) {
            ((Module.B)M.$arrow().getValue()).print(llvm.errs(), 2);
            M.$preInc();
        }
        llvm.errs().$out("Headers:");
        DenseMapIterator H = this.Headers.begin();
        DenseMapIterator HEnd = this.Headers.end();
        while (H.$noteq(HEnd)) {
            llvm.errs().$out("  \"").$out(((FileEntry)H.$arrow().first).getName()).$out("\" -> ");
            type.ptr I = ((SmallVector)H.$arrow().second).begin();
            type.ptr E = ((SmallVector)H.$arrow().second).end();
            while (Native.$noteq_iter((abstract_iterator)I, (abstract_iterator)E)) {
                if (I != ((SmallVector)H.$arrow().second).begin()) {
                    llvm.errs().$out(NativePointer.$COMMA);
                }
                llvm.errs().$out(((KnownHeader)I.$star()).getModule().getFullModuleName());
                I.$preInc();
            }
            llvm.errs().$out(NativePointer.$LF);
            H.$preInc();
        }
    }

    public StringMapIterator<Module.B> module_begin() {
        return this.Modules.begin();
    }

    public StringMapIterator<Module.B> module_end() {
        return this.Modules.end();
    }

    public String toString() {
        return ", LangOpts=" + this.LangOpts + ", Target=" + this.Target + ", HeaderInfo=" + this.HeaderInfo + ", Callbacks=" + this.Callbacks + ", BuiltinIncludeDir=" + this.BuiltinIncludeDir + ", MMapLangOpts=" + this.MMapLangOpts + ", SourceModule=" + this.SourceModule + ", Modules=" + this.Modules + ", NumCreatedModules=" + this.NumCreatedModules + ", Headers=" + this.Headers + ", UmbrellaDirs=" + this.UmbrellaDirs + ", InferredDirectories=" + this.InferredDirectories + ", InferredModuleAllowedBy=" + this.InferredModuleAllowedBy + ", AdditionalModMaps=" + this.AdditionalModMaps + ", ParsedModuleMap=" + this.ParsedModuleMap;
    }

    public static class InferredDirectory
    implements Native.NativePOD<InferredDirectory> {
        public boolean InferModules;
        public Attributes Attrs;
        public FileEntry ModuleMapFile;
        public SmallVector<std.string> ExcludedModules;

        public InferredDirectory() {
            this.InferModules = false;
            this.Attrs = new Attributes();
            this.ExcludedModules = new SmallVector(2, (Object)new std.string());
        }

        public InferredDirectory(JavaDifferentiators.JD$Move _dparam, InferredDirectory $Prm0) {
            this.InferModules = $Prm0.InferModules;
            this.Attrs = new Attributes(JavaDifferentiators.JD$Move.INSTANCE, $Prm0.Attrs);
            this.ModuleMapFile = $Prm0.ModuleMapFile;
            this.ExcludedModules = new SmallVector(JavaDifferentiators.JD$Move.INSTANCE, $Prm0.ExcludedModules);
        }

        public void $destroy() {
            this.ExcludedModules.$destroy();
        }

        private InferredDirectory(InferredDirectory $Prm0) {
            this.InferModules = $Prm0.InferModules;
            this.Attrs = new Attributes($Prm0.Attrs);
            this.ModuleMapFile = $Prm0.ModuleMapFile;
            this.ExcludedModules = new SmallVector($Prm0.ExcludedModules);
        }

        public InferredDirectory $assign(InferredDirectory $Prm0) {
            this.InferModules = $Prm0.InferModules;
            this.Attrs = new Attributes($Prm0.Attrs);
            this.ModuleMapFile = $Prm0.ModuleMapFile;
            this.ExcludedModules = new SmallVector($Prm0.ExcludedModules);
            return this;
        }

        public InferredDirectory clone() {
            return new InferredDirectory(this);
        }

        public boolean $eq(InferredDirectory other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (this.InferModules != other.InferModules) {
                return false;
            }
            if (this.ModuleMapFile != other.ModuleMapFile) {
                return false;
            }
            if (this.ExcludedModules.$noteq(other.ExcludedModules)) {
                return false;
            }
            return !this.Attrs.$noteq(other.Attrs);
        }

        public String toString() {
            return "InferModules=" + this.InferModules + ", Attrs=" + this.Attrs + ", ModuleMapFile=" + this.ModuleMapFile + ", ExcludedModules=" + this.ExcludedModules;
        }
    }

    public static class Attributes
    implements Native.NativePOD<Attributes> {
        public boolean IsSystem;
        public boolean IsExternC;
        public boolean IsExhaustive;

        public Attributes() {
            this.IsSystem = false;
            this.IsExternC = false;
            this.IsExhaustive = false;
        }

        public Attributes(Attributes $Prm0) {
            this.IsSystem = $Prm0.IsSystem;
            this.IsExternC = $Prm0.IsExternC;
            this.IsExhaustive = $Prm0.IsExhaustive;
        }

        public Attributes(JavaDifferentiators.JD$Move _dparam, Attributes $Prm0) {
            this.IsSystem = $Prm0.IsSystem;
            this.IsExternC = $Prm0.IsExternC;
            this.IsExhaustive = $Prm0.IsExhaustive;
        }

        public Attributes $assign(Attributes $Prm0) {
            this.IsSystem = $Prm0.IsSystem;
            this.IsExternC = $Prm0.IsExternC;
            this.IsExhaustive = $Prm0.IsExhaustive;
            return this;
        }

        public Attributes clone() {
            return new Attributes(this);
        }

        public boolean $eq(Attributes other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (this.IsSystem != other.IsSystem) {
                return false;
            }
            if (this.IsExternC != other.IsExternC) {
                return false;
            }
            return this.IsExhaustive == other.IsExhaustive;
        }

        public String toString() {
            return "IsSystem=" + this.IsSystem + ", IsExternC=" + this.IsExternC + ", IsExhaustive=" + this.IsExhaustive;
        }
    }

    public static class KnownHeader
    implements Native.NativePOD<KnownHeader>,
    NativeMoveable<KnownHeader>,
    Native.Native$Bool {
        private ADTAliases.PointerInt2Pair<Module.B> Storage;

        public KnownHeader() {
            this.Storage = new ADTAliases.PointerInt2Pair((Object)null, 0);
        }

        public KnownHeader(Module.B M, int Role) {
            assert (M != null);
            this.Storage = new ADTAliases.PointerInt2Pair((Object)M, Role);
        }

        public static boolean $eq_KnownHeader(KnownHeader A, KnownHeader B2) {
            return A.Storage.$eq(B2.Storage);
        }

        public static boolean $noteq_KnownHeader(KnownHeader A, KnownHeader B2) {
            return A.Storage.$noteq(B2.Storage);
        }

        public Module.B getModule() {
            return (Module.B)this.Storage.getPointer();
        }

        public int getRole() {
            return this.Storage.getInt();
        }

        public boolean isAvailable() {
            return this.getModule().isAvailable();
        }

        public boolean isAccessibleFrom(Module.B M) {
            return (this.getRole() & 1) == 0 || M != null && M.getTopLevelModule() == this.getModule().getTopLevelModule();
        }

        public boolean $bool() {
            return this.Storage.getPointer() != null;
        }

        public KnownHeader(KnownHeader $Prm0) {
            this.Storage = new ADTAliases.PointerInt2Pair($Prm0.Storage);
        }

        public KnownHeader(JavaDifferentiators.JD$Move _dparam, KnownHeader $Prm0) {
            this.Storage = new ADTAliases.PointerInt2Pair(JavaDifferentiators.JD$Move.INSTANCE, $Prm0.Storage);
        }

        public KnownHeader $assign(KnownHeader $Prm0) {
            this.Storage.$assign($Prm0.Storage);
            return this;
        }

        public KnownHeader $assignMove(KnownHeader $Prm0) {
            this.Storage.$assignMove($Prm0.Storage);
            return this;
        }

        public KnownHeader clone() {
            return new KnownHeader(this);
        }

        public KnownHeader move() {
            return new KnownHeader(JavaDifferentiators.JD$Move.INSTANCE, this);
        }

        public boolean $noteq(KnownHeader other) {
            return KnownHeader.$noteq_KnownHeader(this, other);
        }

        public boolean $eq(KnownHeader other) {
            return KnownHeader.$eq_KnownHeader(this, other);
        }

        public String toString() {
            return "Storage=" + this.Storage;
        }
    }

    public static final class ModuleHeaderRole {
        public static final int NormalHeader = 0;
        public static final int PrivateHeader = 1;
        public static final int TextualHeader = 2;
    }
}

