/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote.network;

import com.jetbrains.cef.remote.RemoteServerObjectLocal;
import com.jetbrains.cef.remote.RpcExecutor;
import com.jetbrains.cef.remote.thrift_codegen.RObject;
import java.util.Map;
import org.cef.handler.CefLoadHandler;
import org.cef.misc.CefLog;

public class RemoteResponseImpl
extends RemoteServerObjectLocal {
    public RemoteResponseImpl(RpcExecutor server, RObject resp) {
        super(server, resp);
    }

    @Override
    public void flush() {
        this.myServer.exec(s -> s.Response_Update(this.thriftIdWithCache()));
    }

    public boolean isReadOnly() {
        return this.getBoolVal("IsReadOnly");
    }

    public CefLoadHandler.ErrorCode getError() {
        String sval = (String)this.myCache.get("Error");
        if (sval != null && !sval.isEmpty()) {
            try {
                return CefLoadHandler.ErrorCode.valueOf(sval);
            }
            catch (IllegalArgumentException e) {
                CefLog.Error("getError: ", e.getMessage());
            }
        }
        return CefLoadHandler.ErrorCode.ERR_NONE;
    }

    public void setError(CefLoadHandler.ErrorCode errorCode) {
        this.setLongVal("Error", errorCode.getCode());
    }

    public int getStatus() {
        return (int)this.getLongVal("Status");
    }

    public void setStatus(int status) {
        this.setLongVal("Status", status);
    }

    public String getStatusText() {
        return (String)this.myCache.get("StatusText");
    }

    public void setStatusText(String statusText) {
        this.setStrVal("StatusText", statusText);
    }

    public String getMimeType() {
        return (String)this.myCache.get("MimeType");
    }

    public void setMimeType(String mimeType) {
        this.setStrVal("MimeType", mimeType);
    }

    public String getHeaderByName(String name) {
        return this.myServer.execObj(s -> s.Response_GetHeaderByName(this.thriftId(), name));
    }

    public void setHeaderByName(String name, String value, boolean overwrite) {
        this.myServer.exec(s -> s.Response_SetHeaderByName(this.thriftId(), name, value, overwrite));
    }

    public void getHeaderMap(Map<String, String> headerMap) {
        if (headerMap == null) {
            return;
        }
        Map result = this.myServer.execObj(s -> s.Response_GetHeaderMap(this.thriftId()));
        if (result != null) {
            headerMap.putAll(result);
        }
    }

    public void setHeaderMap(Map<String, String> headerMap) {
        this.myServer.exec(s -> s.Response_SetHeaderMap(this.thriftId(), headerMap));
    }

    public String toString() {
        return this.myCache.toString();
    }
}

