/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.code.files.jvm;

import ai.grazie.code.files.model.Language;
import ai.grazie.code.files.model.LanguageProvider;
import java.io.File;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.io.FilesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0019\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0007\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\b"}, d2={"Lai/grazie/code/files/jvm/JVMLanguageProvider;", "Lai/grazie/code/files/model/LanguageProvider;", "Ljava/io/File;", "()V", "language", "Lai/grazie/code/files/model/Language;", "path", "(Ljava/io/File;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "code-files-jvm"})
public final class JVMLanguageProvider
implements LanguageProvider<File> {
    @NotNull
    public static final JVMLanguageProvider INSTANCE = new JVMLanguageProvider();

    private JVMLanguageProvider() {
    }

    @Nullable
    public Object language(@NotNull File path, @NotNull Continuation<? super Language> $completion) {
        return switch (FilesKt.getExtension((File)path)) {
            case "c", "h" -> Language.C;
            case "cpp", "hpp" -> Language.CPP;
            case "css" -> Language.CSS;
            case "cs" -> Language.CSharp;
            case "go" -> Language.Go;
            case "groovy" -> Language.Groovy;
            case "hcl", "tf" -> Language.HCL;
            case "html" -> Language.HTML;
            case "json" -> Language.JSON;
            case "java" -> Language.Java;
            case "js", "jsx" -> Language.JavaScript;
            case "ipynb" -> Language.Jupyter;
            case "kt" -> Language.Kotlin;
            case "kts" -> Language.KotlinScript;
            case "md" -> Language.Markdown;
            case "php" -> Language.PHP;
            case "py" -> Language.Python;
            case "rb" -> Language.Ruby;
            case "rs" -> Language.Rust;
            case "scala" -> Language.Scala;
            case "sh" -> Language.Shell;
            case "swift" -> Language.Swift;
            case "toml" -> Language.TOML;
            case "tsx", "ts" -> Language.TypeScript;
            case "xml" -> Language.XML;
            case "yaml" -> Language.YAML;
            default -> Language.Unknown;
        };
    }
}

