/*
 * Decompiled with CFR 0.152.
 */
package fleet.frontend.debug;

import androidx.compose.foundation.layout.RowScope;
import androidx.compose.ui.graphics.Color;
import fleet.api.FileAddress;
import fleet.api.FileAddressKt;
import fleet.common.debug.DebugBreakpointEntity;
import fleet.common.fs.FsdKt;
import fleet.common.fs.RelativePath;
import fleet.frontend.debug.BreakpointRenderer;
import fleet.frontend.icons.IconKeys;
import fleet.protocol.debug.FleetBreakpoint;
import fleet.protocol.debug.LineBreakpoint;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import noria.model.ThemeKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0007\u001a\f\u0012\u0004\u0012\u00020\u00040\bj\u0002`\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lfleet/frontend/debug/LineBreakpointRenderer;", "Lfleet/frontend/debug/BreakpointRenderer;", "()V", "groupTitle", "", "getGroupTitle", "()Ljava/lang/String;", "getIcon", "Lnoria/model/ThemeKey;", "Lnoria/model/IconKey;", "breakpoint", "Lfleet/protocol/debug/FleetBreakpoint;", "registered", "", "getTailText", "getTitle", "fleet.debug.frontend"})
@SourceDebugExtension(value={"SMAP\nBreakpointRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BreakpointRenderer.kt\nfleet/frontend/debug/LineBreakpointRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,157:1\n1#2:158\n*E\n"})
public final class LineBreakpointRenderer
implements BreakpointRenderer {
    @NotNull
    private final String groupTitle;

    public LineBreakpointRenderer() {
        this.groupTitle = "Breakpoints";
    }

    @Override
    @NotNull
    public String getGroupTitle() {
        return this.groupTitle;
    }

    @Override
    @NotNull
    public ThemeKey<String> getIcon(@NotNull FleetBreakpoint breakpoint, boolean registered) {
        Intrinsics.checkNotNullParameter((Object)breakpoint, (String)"breakpoint");
        return breakpoint.getEnabled() && registered ? IconKeys.Breakpoints.INSTANCE.getBreakpoint() : IconKeys.Breakpoints.INSTANCE.getBreakpointInactive();
    }

    @Override
    @NotNull
    public String getTitle(@NotNull FleetBreakpoint breakpoint) {
        Intrinsics.checkNotNullParameter((Object)breakpoint, (String)"breakpoint");
        LineBreakpoint lineBreakpoint = (LineBreakpoint)breakpoint;
        return FileAddressKt.getName((FileAddress)lineBreakpoint.getFile()) + ":" + (lineBreakpoint.getLine() + 1);
    }

    @Override
    @Nullable
    public String getTailText(@NotNull FleetBreakpoint breakpoint) {
        Intrinsics.checkNotNullParameter((Object)breakpoint, (String)"breakpoint");
        LineBreakpoint lineBreakpoint = (LineBreakpoint)breakpoint;
        FileAddress $this$getTailText_u24lambda_u240 = lineBreakpoint.getFile();
        boolean bl = false;
        RelativePath relativePath = FsdKt.relativePath$default((FileAddress)$this$getTailText_u24lambda_u240, (boolean)false, (boolean)false, (boolean)false, (int)12, null);
        return relativePath != null ? RelativePath.joinToString$default((RelativePath)relativePath, (boolean)false, (int)1, null) : null;
    }

    @Override
    @Nullable
    public ThemeKey<Color> getTitleColor(@NotNull FleetBreakpoint breakpoint) {
        return BreakpointRenderer.DefaultImpls.getTitleColor(this, breakpoint);
    }

    @Override
    @Nullable
    public Function1<RowScope, Unit> settingsView(@NotNull DebugBreakpointEntity breakpointEntity) {
        return BreakpointRenderer.DefaultImpls.settingsView(this, breakpointEntity);
    }
}

