/*
 * Decompiled with CFR 0.152.
 */
package fleet.frontend.debug;

import androidx.compose.foundation.layout.PaddingKt;
import androidx.compose.foundation.layout.RowKt;
import androidx.compose.foundation.layout.RowScope;
import androidx.compose.foundation.layout.SizeKt;
import androidx.compose.foundation.layout.SpacerKt;
import androidx.compose.runtime.Composable;
import androidx.compose.ui.Alignment;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.unit.Dp;
import fleet.compose.theme.CompositionLocalsKt;
import fleet.compose.theme.components.ItemCellColors;
import fleet.compose.theme.components.TextKt;
import fleet.compose.theme.components.Trim;
import fleet.compose.theme.components.TrimmedTextKt;
import fleet.compose.theme.keys.ThemeKeys;
import fleet.compose.theme.text.TextMatching;
import fleet.frontend.debug.AttachDebugToProcessGotoProviderKt;
import fleet.frontend.debug.AttachToProcessGotoItem;
import fleet.frontend.debug.AttachToProcessGotoResult;
import fleet.frontend.debug.HostPort;
import fleet.frontend.ui.gotoPanel.GotoMatcher;
import fleet.frontend.ui.gotoPanel.GotoPanelKt;
import fleet.util.ListKt;
import fleet.util.logging.KLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import noria.CellKt;
import noria.NoriaContext;
import noria.ReadScope;
import noria.impl.Runtime;
import noria.ui.components.list.ListItem;
import noria.ui.components.list.ListItemOpts;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a(\u0010\n\u001a\u00020\u000b*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a:\u0010\u0013\u001a\u00020\u000b*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\f2\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u00160\u00152\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a(\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u0016*\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0003\u001a.\u0010\u0019\u001a\u00020\u000b*\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\t2\b\u0010\u001d\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0003\u001a \u0010\u001e\u001a\u00020\u000b*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\"\u001b\u0010\u0000\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u001f"}, d2={"logger", "Lfleet/util/logging/KLogger;", "getLogger", "()Lfleet/util/logging/KLogger;", "logger$delegate", "Lkotlin/Lazy;", "resolveAddress", "Lfleet/frontend/debug/HostPort;", "address", "", "addActions", "", "", "Lnoria/ui/components/list/ListItem;", "Lfleet/frontend/debug/AttachToProcessGotoItem;", "result", "Lfleet/frontend/debug/AttachToProcessGotoResult;", "matcher", "Lfleet/frontend/ui/gotoPanel/GotoMatcher;", "addGroupedItems", "map", "", "", "buildItemList", "Lnoria/NoriaContext;", "renderItem", "opts", "Lnoria/ui/components/list/ListItemOpts;", "title", "group", "separator", "fleet.debug.frontend"})
@SourceDebugExtension(value={"SMAP\nAttachDebugToProcessGotoProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AttachDebugToProcessGotoProvider.kt\nfleet/frontend/debug/AttachDebugToProcessGotoProviderKt\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,352:1\n215#2:353\n216#2:358\n1864#3,2:354\n1866#3:357\n1549#3:359\n1620#3,3:360\n1#4:356\n*S KotlinDebug\n*F\n+ 1 AttachDebugToProcessGotoProvider.kt\nfleet/frontend/debug/AttachDebugToProcessGotoProviderKt\n*L\n309#1:353\n309#1:358\n310#1:354,2\n310#1:357\n331#1:359\n331#1:360,3\n*E\n"})
public final class AttachDebugToProcessGotoProviderKt {
    @NotNull
    private static final Lazy logger$delegate = LazyKt.lazy((Function0)logger.2.INSTANCE);

    private static final KLogger getLogger() {
        Lazy lazy = logger$delegate;
        return (KLogger)lazy.getValue();
    }

    @Composable
    private static final void renderItem(NoriaContext $this$renderItem, ListItemOpts opts, String title2, String group, GotoMatcher matcher) {
        Runtime.enterScope((NoriaContext)$this$renderItem, (int)21);
        Object[] objectArray = new Object[]{matcher, title2, group};
        GotoPanelKt.gotoPanelListCell$default((NoriaContext)$this$renderItem, (ListItemOpts)opts, null, (Function2)((Function2)Runtime.closure((Object[])objectArray, (Object)new Function2<RowScope, ItemCellColors, Unit>(matcher, title2, group){
            final /* synthetic */ GotoMatcher $matcher;
            final /* synthetic */ String $title;
            final /* synthetic */ String $group;
            {
                this.$matcher = $matcher;
                this.$title = $title;
                this.$group = $group;
                super(2);
            }

            public final void invoke(@NotNull RowScope $this$gotoPanelListCell, @NotNull ItemCellColors colors) {
                Intrinsics.checkNotNullParameter((Object)$this$gotoPanelListCell, (String)"$this$gotoPanelListCell");
                Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
                Runtime.enterScope((NoriaContext)((NoriaContext)$this$gotoPanelListCell), (int)17);
                NoriaContext noriaContext = (NoriaContext)$this$gotoPanelListCell;
                long l = colors.getText-0d7_KjU();
                TextMatching.Matcher matcher = this.$matcher.toMatcher();
                Runtime.enterScope((NoriaContext)((NoriaContext)$this$gotoPanelListCell), (int)16);
                AnnotatedString annotatedString = TrimmedTextKt.buildStringWithMatcher-H8OBS0Y$default((NoriaContext)((NoriaContext)$this$gotoPanelListCell), (String)this.$title, (TextMatching.Matcher)matcher, null, (long)l, (long)0L, (long)0L, null, null, (int)244, null);
                Runtime.exitScope((NoriaContext)((NoriaContext)$this$gotoPanelListCell));
                TextKt.UiText-Uas3SEs$default((NoriaContext)noriaContext, (AnnotatedString)annotatedString, (long)0L, null, null, null, null, null, null, (Trim)Trim.Middle, null, null, null, (int)3838, null);
                Unit unit = Unit.INSTANCE;
                Runtime.exitScope((NoriaContext)((NoriaContext)$this$gotoPanelListCell));
                Runtime.enterScope((NoriaContext)((NoriaContext)$this$gotoPanelListCell), (int)18);
                SpacerKt.Spacer((NoriaContext)((NoriaContext)$this$gotoPanelListCell), (Modifier)RowScope.DefaultImpls.weight$default((RowScope)$this$gotoPanelListCell, (Modifier)((Modifier)Modifier.Companion), (float)1.0f, (boolean)false, (int)2, null));
                unit = Unit.INSTANCE;
                Runtime.exitScope((NoriaContext)((NoriaContext)$this$gotoPanelListCell));
                if (this.$group != null) {
                    Runtime.enterScope((NoriaContext)((NoriaContext)$this$gotoPanelListCell), (int)20);
                    int $this$dp$iv = 24;
                    boolean $i$f$getDp = false;
                    Modifier modifier2 = SizeKt.height-3ABfNKs((Modifier)((Modifier)Modifier.Companion), (float)Dp.constructor-impl((float)$this$dp$iv));
                    $this$dp$iv = 12;
                    $i$f$getDp = false;
                    Object[] objectArray = new Object[]{this.$group};
                    RowKt.Row$default((NoriaContext)((NoriaContext)$this$gotoPanelListCell), (Modifier)PaddingKt.padding-qDBjuR0$default((Modifier)modifier2, (float)Dp.constructor-impl((float)$this$dp$iv), (float)0.0f, (float)0.0f, (float)0.0f, (int)14, null), null, (Alignment.Vertical)Alignment.Companion.getCenterVertically(), (boolean)false, (Function1)((Function1)Runtime.closure((Object[])objectArray, (Object)new Function1<RowScope, Unit>(this.$group){
                        final /* synthetic */ String $group;
                        {
                            this.$group = $group;
                            super(1);
                        }

                        public final void invoke(@NotNull RowScope $this$Row) {
                            Intrinsics.checkNotNullParameter((Object)$this$Row, (String)"$this$Row");
                            Runtime.enterScope((NoriaContext)((NoriaContext)$this$Row), (int)19);
                            TextKt.UiText-1ODQ_eA$default((NoriaContext)((NoriaContext)$this$Row), (String)this.$group, (long)((Color)CompositionLocalsKt.getTheme((ReadScope)((ReadScope)$this$Row)).get(ThemeKeys.INSTANCE.getTextDimmed())).unbox-impl(), null, null, null, null, null, null, null, null, (int)1020, null);
                            Unit unit = Unit.INSTANCE;
                            Runtime.exitScope((NoriaContext)((NoriaContext)$this$Row));
                        }
                    })), (int)10, null);
                    unit = Unit.INSTANCE;
                    Runtime.exitScope((NoriaContext)((NoriaContext)$this$gotoPanelListCell));
                }
            }
        })), (int)2, null);
        Unit unit = Unit.INSTANCE;
        Runtime.exitScope((NoriaContext)$this$renderItem);
    }

    @Composable
    private static final List<ListItem<AttachToProcessGotoItem>> buildItemList(NoriaContext $this$buildItemList, AttachToProcessGotoResult result, GotoMatcher matcher) {
        Runtime.enterScope((NoriaContext)$this$buildItemList, (int)22);
        Object[] objectArray = new Object[]{result, matcher};
        List list = (List)CellKt.memo((NoriaContext)$this$buildItemList, (Function1)((Function1)Runtime.closure((Object[])objectArray, (Object)new Function1<NoriaContext, List<? extends ListItem<AttachToProcessGotoItem>>>(result, matcher){
            final /* synthetic */ AttachToProcessGotoResult $result;
            final /* synthetic */ GotoMatcher $matcher;
            {
                this.$result = $result;
                this.$matcher = $matcher;
                super(1);
            }

            @NotNull
            public final List<ListItem<AttachToProcessGotoItem>> invoke(@NotNull NoriaContext $this$memo) {
                List list;
                Intrinsics.checkNotNullParameter((Object)$this$memo, (String)"$this$memo");
                AttachToProcessGotoResult attachToProcessGotoResult = this.$result;
                GotoMatcher gotoMatcher = this.$matcher;
                List $this$invoke_u24lambda_u240 = list = CollectionsKt.createListBuilder();
                boolean bl = false;
                boolean needSeparators = ((CharSequence)attachToProcessGotoResult.getQuery()).length() == 0;
                ListKt.updateSeparating((List)$this$invoke_u24lambda_u240, (Function1)((Function1)new Function1<List<ListItem<AttachToProcessGotoItem>>, Unit>(needSeparators, gotoMatcher){
                    final /* synthetic */ boolean $needSeparators;
                    final /* synthetic */ GotoMatcher $matcher;
                    {
                        this.$needSeparators = $needSeparators;
                        this.$matcher = $matcher;
                        super(1);
                    }

                    public final void invoke(@NotNull List<ListItem<AttachToProcessGotoItem>> $this$updateSeparating) {
                        Intrinsics.checkNotNullParameter($this$updateSeparating, (String)"$this$updateSeparating");
                        if (this.$needSeparators) {
                            AttachDebugToProcessGotoProviderKt.access$separator($this$updateSeparating, this.$matcher);
                        }
                    }
                }), (Function2)((Function2)new Function2<List<ListItem<AttachToProcessGotoItem>>, Function0<? extends Unit>, Unit>(attachToProcessGotoResult, gotoMatcher, needSeparators){
                    final /* synthetic */ AttachToProcessGotoResult $result;
                    final /* synthetic */ GotoMatcher $matcher;
                    final /* synthetic */ boolean $needSeparators;
                    {
                        this.$result = $result;
                        this.$matcher = $matcher;
                        this.$needSeparators = $needSeparators;
                        super(2);
                    }

                    public final void invoke(@NotNull List<ListItem<AttachToProcessGotoItem>> $this$updateSeparating, @NotNull Function0<Unit> newGroup) {
                        Intrinsics.checkNotNullParameter($this$updateSeparating, (String)"$this$updateSeparating");
                        Intrinsics.checkNotNullParameter(newGroup, (String)"newGroup");
                        AttachDebugToProcessGotoProviderKt.access$addGroupedItems($this$updateSeparating, this.$result.getProcesses(), this.$matcher);
                        AttachDebugToProcessGotoProviderKt.access$addActions($this$updateSeparating, this.$result, this.$matcher);
                        if (this.$needSeparators && !this.$result.getCompleted()) {
                            newGroup.invoke();
                            $this$updateSeparating.add((ListItem<AttachToProcessGotoItem>)AttachToProcessGotoItem.listItem$default(new AttachToProcessGotoItem.Loading(), this.$matcher, null, null, 6, null));
                        }
                    }
                }));
                return CollectionsKt.build((List)list);
            }
        })));
        Runtime.exitScope((NoriaContext)$this$buildItemList);
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private static final void addGroupedItems(List<ListItem<AttachToProcessGotoItem>> $this$addGroupedItems, Map<String, ? extends List<? extends AttachToProcessGotoItem>> map2, GotoMatcher matcher) {
        Map<String, ? extends List<? extends AttachToProcessGotoItem>> $this$forEach$iv = map2;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ? extends List<? extends AttachToProcessGotoItem>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ? extends List<? extends AttachToProcessGotoItem>> element$iv;
            Map.Entry<String, ? extends List<? extends AttachToProcessGotoItem>> entry = element$iv = iterator.next();
            boolean bl = false;
            String group = entry.getKey();
            List<? extends AttachToProcessGotoItem> items = entry.getValue();
            Iterable $this$forEachIndexed$iv = items;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void item;
                String string;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                AttachToProcessGotoItem attachToProcessGotoItem = (AttachToProcessGotoItem)item$iv;
                int index = n;
                boolean bl2 = false;
                String it = string = group;
                boolean bl3 = false;
                String itemGroup = index == 0 ? string : null;
                $this$addGroupedItems.add((ListItem<AttachToProcessGotoItem>)AttachToProcessGotoItem.listItem$default((AttachToProcessGotoItem)item, matcher, itemGroup, null, 4, null));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void addActions(List<ListItem<AttachToProcessGotoItem>> $this$addActions, AttachToProcessGotoResult result, GotoMatcher matcher) {
        void $this$mapTo$iv$iv;
        if (((CharSequence)result.getQuery()).length() == 0) {
            return;
        }
        HostPort hostPort = AttachDebugToProcessGotoProviderKt.resolveAddress(result.getQuery());
        String host = hostPort.component1();
        Integer port = hostPort.component2();
        if (host == null || port == null) {
            return;
        }
        String address = host + ":" + port;
        Function1 title2 = (Function1)new Function1<AttachToProcessGotoItem.Action, String>(result, address){
            final /* synthetic */ AttachToProcessGotoResult $result;
            final /* synthetic */ String $address;
            {
                this.$result = $result;
                this.$address = $address;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull AttachToProcessGotoItem.Action it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$result.getActions().size() > 1 ? "Attach Manually - " + it.getProcessKind() + ": " + this.$address : "Attach Manually: " + this.$address;
            }
        };
        Iterable $this$map$iv = result.getActions();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AttachToProcessGotoItem.Action action2 = (AttachToProcessGotoItem.Action)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(AttachToProcessGotoItem.listItem$default((AttachToProcessGotoItem)it, matcher, null, (String)title2.invoke((Object)it), 2, null));
        }
        List it = (List)destination$iv$iv;
        boolean bl = false;
        $this$addActions.addAll(it);
    }

    private static final void separator(List<ListItem<AttachToProcessGotoItem>> $this$separator, GotoMatcher matcher) {
        $this$separator.add((ListItem<AttachToProcessGotoItem>)AttachToProcessGotoItem.listItem$default(new AttachToProcessGotoItem.Separator(), matcher, null, null, 6, null));
    }

    @NotNull
    public static final HostPort resolveAddress(@NotNull String address) {
        String port;
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Object object = new char[]{':'};
        List parts = StringsKt.split$default((CharSequence)address, (char[])object, (boolean)false, (int)0, (int)6, null);
        object = switch (parts.size()) {
            case 1 -> TuplesKt.to((Object)"localhost", parts.get(0));
            case 2 -> TuplesKt.to(parts.get(0), parts.get(1));
            default -> TuplesKt.to(null, null);
        };
        String host = (String)object.component1();
        String string = port = (String)object.component2();
        Integer portAsInt = string != null ? StringsKt.toIntOrNull((String)string) : null;
        return new HostPort(host, portAsInt);
    }

    public static final /* synthetic */ KLogger access$getLogger() {
        return AttachDebugToProcessGotoProviderKt.getLogger();
    }

    public static final /* synthetic */ List access$buildItemList(NoriaContext $receiver, AttachToProcessGotoResult result, GotoMatcher matcher) {
        return AttachDebugToProcessGotoProviderKt.buildItemList($receiver, result, matcher);
    }

    public static final /* synthetic */ void access$renderItem(NoriaContext $receiver, ListItemOpts opts, String title2, String group, GotoMatcher matcher) {
        AttachDebugToProcessGotoProviderKt.renderItem($receiver, opts, title2, group, matcher);
    }

    public static final /* synthetic */ void access$separator(List $receiver, GotoMatcher matcher) {
        AttachDebugToProcessGotoProviderKt.separator($receiver, matcher);
    }

    public static final /* synthetic */ void access$addGroupedItems(List $receiver, Map map2, GotoMatcher matcher) {
        AttachDebugToProcessGotoProviderKt.addGroupedItems($receiver, map2, matcher);
    }

    public static final /* synthetic */ void access$addActions(List $receiver, AttachToProcessGotoResult result, GotoMatcher matcher) {
        AttachDebugToProcessGotoProviderKt.addActions($receiver, result, matcher);
    }
}

