/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.fus.reporting.lion3;

import com.jetbrains.fus.reporting.lion3.FeatureUsageLogWriter;
import com.jetbrains.fus.reporting.model.lion3.LogEvent;
import com.jetbrains.fus.reporting.model.lion3.LogEventAction;
import com.jetbrains.fus.reporting.model.lion3.LogEventGroup;
import com.jetbrains.fus.reporting.schema.EventId;
import com.jetbrains.fus.reporting.schema.EventId1;
import com.jetbrains.fus.reporting.schema.EventId2;
import com.jetbrains.fus.reporting.schema.EventId3;
import com.jetbrains.fus.reporting.schema.EventLogGroup;
import com.jetbrains.fus.reporting.schema.FieldListDescription;
import com.jetbrains.fus.reporting.schema.VarargEventId;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ,\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0011H\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J'\u0010\u0012\u001a\u00020\u0013\"\u0004\b\u0000\u0010\u00162\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00160\u00172\u0006\u0010\u0018\u001a\u0002H\u0016\u00a2\u0006\u0002\u0010\u0019J;\u0010\u0012\u001a\u00020\u0013\"\u0004\b\u0000\u0010\u001a\"\u0004\b\u0001\u0010\u001b2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u0002H\u001b0\u001c2\u0006\u0010\u001d\u001a\u0002H\u001a2\u0006\u0010\u001e\u001a\u0002H\u001b\u00a2\u0006\u0002\u0010\u001fJO\u0010\u0012\u001a\u00020\u0013\"\u0004\b\u0000\u0010\u001a\"\u0004\b\u0001\u0010\u001b\"\u0004\b\u0002\u0010 2\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u0002H\u001b\u0012\u0004\u0012\u0002H 0!2\u0006\u0010\u001d\u001a\u0002H\u001a2\u0006\u0010\u001e\u001a\u0002H\u001b2\u0006\u0010\"\u001a\u0002H \u00a2\u0006\u0002\u0010#J\u000e\u0010$\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eJ7\u0010%\u001a\u00020\u0013\"\b\b\u0000\u0010&*\u00020'2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H&0(2\u0017\u0010)\u001a\u0013\u0012\u0004\u0012\u0002H&\u0012\u0004\u0012\u00020\u00130*\u00a2\u0006\u0002\b+R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/jetbrains/fus/reporting/lion3/FeatureUsageLogger;", "", "recorderVersion", "", "session", "", "build", "bucket", "writer", "Lcom/jetbrains/fus/reporting/lion3/FeatureUsageLogWriter;", "(ILjava/lang/String;Ljava/lang/String;ILcom/jetbrains/fus/reporting/lion3/FeatureUsageLogWriter;)V", "createLogEvent", "Lcom/jetbrains/fus/reporting/model/lion3/LogEvent;", "group", "Lcom/jetbrains/fus/reporting/schema/EventLogGroup;", "eventId", "data", "", "log", "", "event", "Lcom/jetbrains/fus/reporting/schema/EventId;", "T", "Lcom/jetbrains/fus/reporting/schema/EventId1;", "value", "(Lcom/jetbrains/fus/reporting/schema/EventId1;Ljava/lang/Object;)V", "T1", "T2", "Lcom/jetbrains/fus/reporting/schema/EventId2;", "value1", "value2", "(Lcom/jetbrains/fus/reporting/schema/EventId2;Ljava/lang/Object;Ljava/lang/Object;)V", "T3", "Lcom/jetbrains/fus/reporting/schema/EventId3;", "value3", "(Lcom/jetbrains/fus/reporting/schema/EventId3;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "logBaseline", "logVararg", "D", "Lcom/jetbrains/fus/reporting/schema/FieldListDescription;", "Lcom/jetbrains/fus/reporting/schema/VarargEventId;", "filler", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "scheme"})
public class FeatureUsageLogger {
    private final int recorderVersion;
    @NotNull
    private final String session;
    @NotNull
    private final String build;
    private final int bucket;
    @NotNull
    private final FeatureUsageLogWriter writer;

    public FeatureUsageLogger(int recorderVersion, @NotNull String session, @NotNull String build, int bucket, @NotNull FeatureUsageLogWriter writer) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)build, (String)"build");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        this.recorderVersion = recorderVersion;
        this.session = session;
        this.build = build;
        this.bucket = bucket;
        this.writer = writer;
    }

    public final void logBaseline(@NotNull EventLogGroup group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        this.writer.writeEvent(this.createLogEvent(group, group.getType() == EventLogGroup.Type.STATE ? "invoked" : "registered", MapsKt.emptyMap()));
    }

    public final void log(@NotNull EventId event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.writer.writeEvent(this.createLogEvent(event.getGroup(), event.getEventId(), MapsKt.emptyMap()));
    }

    public final <T> void log(@NotNull EventId1<T> event, T value) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        this.writer.writeEvent(this.createLogEvent(event.getGroup(), event.getEventId(), event.buildEventData(value)));
    }

    public final <T1, T2> void log(@NotNull EventId2<T1, T2> event, T1 value1, T2 value2) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        this.writer.writeEvent(this.createLogEvent(event.getGroup(), event.getEventId(), event.buildEventData(value1, value2)));
    }

    public final <T1, T2, T3> void log(@NotNull EventId3<T1, T2, T3> event, T1 value1, T2 value2, T3 value3) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        this.writer.writeEvent(this.createLogEvent(event.getGroup(), event.getEventId(), event.buildEventData(value1, value2, value3)));
    }

    public final <D extends FieldListDescription> void logVararg(@NotNull VarargEventId<D> event, @NotNull Function1<? super D, Unit> filler) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        Intrinsics.checkNotNullParameter(filler, (String)"filler");
        this.writer.writeEvent(this.createLogEvent(event.getGroup(), event.getEventId(), event.buildEventData(filler)));
    }

    private final LogEvent createLogEvent(EventLogGroup group, String eventId, Map<String, ? extends Object> data) {
        boolean isState = group.getType() == EventLogGroup.Type.STATE;
        return new LogEvent(this.session, this.build, String.valueOf(this.bucket), System.currentTimeMillis(), new LogEventGroup(group.getId(), String.valueOf(group.getVersion())), String.valueOf(this.recorderVersion), new LogEventAction(eventId, isState, MapsKt.toMutableMap(data), 0, 8, null));
    }
}

