/*
 * Decompiled with CFR 0.152.
 */
package fleet.plugins.smartMode.frontend;

import androidx.compose.foundation.layout.Arrangement;
import androidx.compose.foundation.layout.RowKt;
import androidx.compose.foundation.layout.RowScope;
import androidx.compose.foundation.layout.SizeKt;
import androidx.compose.foundation.layout.SpacerKt;
import androidx.compose.runtime.Composable;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.unit.Dp;
import com.jetbrains.rhizomedb.DbContext;
import com.jetbrains.rhizomedb.EntitiesKt;
import com.jetbrains.rhizomedb.Q;
import com.jetbrains.rhizomedb.impl.EntitiesImplKt;
import fleet.api.ProjectRootStatus;
import fleet.common.fs.SharedProjectRootStatusEntity;
import fleet.common.smartMode.SharedSmartModeStateEntity;
import fleet.compose.theme.components.IconKt;
import fleet.compose.theme.components.TextKt;
import fleet.compose.theme.components.ThemedAnnotatedStringBuilder;
import fleet.compose.theme.components.TooltipKt;
import fleet.compose.theme.keys.TextStyleKeys;
import fleet.compose.theme.text.NoriaParagraphStyle;
import fleet.frontend.icons.IconKeys;
import fleet.plugins.smartMode.common.SmartModeProblemDomain;
import fleet.plugins.smartMode.common.SmartModeProblemEntity;
import fleet.plugins.smartMode.common.SmartModeProblemEntityKt;
import fleet.plugins.smartMode.frontend.SmartModeControlCenterStatusProviderKt;
import fleet.plugins.smartMode.frontend.SmartModeProblemActionEntity;
import fleet.plugins.smartMode.frontend.SmartModeProblemActionEntityKt;
import fleet.util.openmap.SerializableOpenMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KMutableProperty1;
import kotlin.reflect.KProperty1;
import noria.NoriaContext;
import noria.impl.NoriaState;
import noria.impl.NoriaStateKt;
import noria.impl.Runtime;
import noria.model.Action;
import noria.model.ActionContext;
import noria.model.ActionsKt;
import noria.model.CommonTrigger;
import noria.model.ThemeKey;
import noria.ui.events.HandlerScope;
import noria.ui.text.TextComponentsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u001a\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u001a\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\b*\b\u0012\u0004\u0012\u00020\t0\bH\u0002\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\t0\bH\u0002\u001a\u0014\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0003\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\u00a8\u0006\u0011"}, d2={"isReady", "", "Lfleet/api/ProjectRootStatus;", "(Lfleet/api/ProjectRootStatus;)Z", "getKnownBackendProjectRootTypes", "", "", "projectRoots", "", "Lfleet/common/fs/SharedProjectRootStatusEntity;", "labels", "filterIgnored", "renderNotification", "", "Lnoria/NoriaContext;", "problem", "Lfleet/plugins/smartMode/common/SmartModeProblemEntity;", "fleet.plugins.smartMode.frontend"})
@SourceDebugExtension(value={"SMAP\nSmartModeControlCenterStatusProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SmartModeControlCenterStatusProvider.kt\nfleet/plugins/smartMode/frontend/SmartModeControlCenterStatusProviderKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,248:1\n1726#2,3:249\n766#2:252\n857#2,2:253\n766#2:255\n857#2,2:256\n*S KotlinDebug\n*F\n+ 1 SmartModeControlCenterStatusProvider.kt\nfleet/plugins/smartMode/frontend/SmartModeControlCenterStatusProviderKt\n*L\n185#1:249,3\n187#1:252\n187#1:253,2\n191#1:255\n191#1:256,2\n*E\n"})
public final class SmartModeControlCenterStatusProviderKt {
    private static final Set<String> getKnownBackendProjectRootTypes() {
        Object object = (SharedSmartModeStateEntity)EntitiesKt.singletonOrNull((KClass)Reflection.getOrCreateKotlinClass(SharedSmartModeStateEntity.class));
        if (object == null || (object = object.getProjectRootTypes()) == null) {
            object = SetsKt.emptySet();
        }
        return object;
    }

    private static final boolean isReady(List<? extends SharedProjectRootStatusEntity> $this$isReady) {
        boolean bl;
        block3: {
            Iterable $this$all$iv = $this$isReady;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    SharedProjectRootStatusEntity it = (SharedProjectRootStatusEntity)element$iv;
                    boolean bl2 = false;
                    if (SmartModeControlCenterStatusProviderKt.isReady(it.getStatus())) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<SharedProjectRootStatusEntity> filterIgnored(List<? extends SharedProjectRootStatusEntity> $this$filterIgnored) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$filterIgnored;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SharedProjectRootStatusEntity it = (SharedProjectRootStatusEntity)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it.getStatus(), (Object)ProjectRootStatus.Ignored.INSTANCE))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<SharedProjectRootStatusEntity> projectRoots(Set<String> labels) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = EntitiesKt.byEntityType((KClass)Reflection.getOrCreateKotlinClass(SharedProjectRootStatusEntity.class));
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SharedProjectRootStatusEntity it = (SharedProjectRootStatusEntity)element$iv$iv;
            boolean bl = false;
            if (!labels.contains(it.getRoot().getTag().getLabel())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final boolean isReady(ProjectRootStatus $this$isReady) {
        boolean bl;
        ProjectRootStatus projectRootStatus = $this$isReady;
        if (projectRootStatus instanceof ProjectRootStatus.Configuring) {
            bl = true;
        } else if (projectRootStatus instanceof ProjectRootStatus.Failed) {
            bl = true;
        } else if (Intrinsics.areEqual((Object)projectRootStatus, (Object)ProjectRootStatus.Ignored.INSTANCE)) {
            bl = true;
        } else if (Intrinsics.areEqual((Object)projectRootStatus, (Object)ProjectRootStatus.Opening.INSTANCE)) {
            bl = false;
        } else if (Intrinsics.areEqual((Object)projectRootStatus, (Object)ProjectRootStatus.Ready.INSTANCE)) {
            bl = true;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @Composable
    private static final void renderNotification(NoriaContext $this$renderNotification, SmartModeProblemEntity problem) {
        SerializableOpenMap problemData = problem.getProblemData();
        String category = SmartModeProblemEntityKt.getCategory((SerializableOpenMap)problemData);
        String string = SmartModeProblemEntityKt.getExtendedTitle((SerializableOpenMap)problemData);
        if (string == null && (string = SmartModeProblemEntityKt.getTitle((SerializableOpenMap)problemData)) == null) {
            return;
        }
        String title = string;
        Runtime.enterScope((NoriaContext)$this$renderNotification, (int)60);
        Object[] objectArray = new Object[]{problem, category, title, problemData};
        RowKt.Row$default((NoriaContext)$this$renderNotification, null, null, null, (boolean)false, (Function1)((Function1)Runtime.closure((Object[])objectArray, (Object)new Function1<RowScope, Unit>(problem, (SerializableOpenMap<SmartModeProblemDomain>)problemData, category, title){
            final /* synthetic */ SmartModeProblemEntity $problem;
            final /* synthetic */ SerializableOpenMap<SmartModeProblemDomain> $problemData;
            final /* synthetic */ String $category;
            final /* synthetic */ String $title;
            {
                this.$problem = $problem;
                this.$problemData = $problemData;
                this.$category = $category;
                this.$title = $title;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull RowScope $this$Row) {
                void property$iv;
                Intrinsics.checkNotNullParameter((Object)$this$Row, (String)"$this$Row");
                ThemeKey iconKey = switch (renderNotification.WhenMappings.$EnumSwitchMapping$0[this.$problem.getSeverity().ordinal()]) {
                    case 1 -> IconKeys.INSTANCE.getError();
                    case 2 -> IconKeys.INSTANCE.getWarning();
                    case 3 -> IconKeys.INSTANCE.getInfo();
                    default -> throw new NoWhenBranchMatchedException();
                };
                Runtime.enterScope((NoriaContext)((NoriaContext)$this$Row), (int)50);
                IconKt.Icon-USBMPiE$default((NoriaContext)((NoriaContext)$this$Row), (ThemeKey)iconKey, (long)0L, null, null, null, (int)30, null);
                Unit unit = Unit.INSTANCE;
                Runtime.exitScope((NoriaContext)((NoriaContext)$this$Row));
                Runtime.enterScope((NoriaContext)((NoriaContext)$this$Row), (int)51);
                int $this$dp$iv22 = 4;
                boolean $i$f$getDp22 = false;
                SpacerKt.Spacer((NoriaContext)((NoriaContext)$this$Row), (Modifier)SizeKt.width-3ABfNKs((Modifier)((Modifier)Modifier.Companion), (float)Dp.constructor-impl((float)$this$dp$iv22)));
                unit = Unit.INSTANCE;
                Runtime.exitScope((NoriaContext)((NoriaContext)$this$Row));
                Runtime.enterScope((NoriaContext)((NoriaContext)$this$Row), (int)52);
                AnnotatedString $this$dp$iv22 = TextKt.buildThemedAnnotatedString((NoriaContext)((NoriaContext)$this$Row), (Function1)((Function1)new Function1<ThemedAnnotatedStringBuilder, Unit>(this.$category, this.$title){
                    final /* synthetic */ String $category;
                    final /* synthetic */ String $title;
                    {
                        this.$category = $category;
                        this.$title = $title;
                        super(1);
                    }

                    public final void invoke(@NotNull ThemedAnnotatedStringBuilder $this$buildThemedAnnotatedString) {
                        Intrinsics.checkNotNullParameter((Object)$this$buildThemedAnnotatedString, (String)"$this$buildThemedAnnotatedString");
                        if (this.$category != null) {
                            ThemedAnnotatedStringBuilder.text-x3qM97A$default((ThemedAnnotatedStringBuilder)$this$buildThemedAnnotatedString, (String)(this.$category + ":\u00a0"), (ThemeKey)TextStyleKeys.INSTANCE.getDefaultSemiBold(), null, null, null, null, null, null, (int)252, null);
                        }
                        ThemedAnnotatedStringBuilder.text-x3qM97A$default((ThemedAnnotatedStringBuilder)$this$buildThemedAnnotatedString, (String)(this.$title + "\u00a0\u00a0"), null, null, null, null, null, null, null, (int)254, null);
                    }
                }));
                Runtime.exitScope((NoriaContext)((NoriaContext)$this$Row));
                AnnotatedString annotatedTitle2 = $this$dp$iv22;
                KMutableProperty1 $i$f$getDp22 = (KMutableProperty1)renderNotification.actions.1.INSTANCE;
                Object[] value$iv = this.$problem.getId();
                boolean $i$f$lookup = false;
                Set actions2 = EntitiesImplKt.lookupImpl((Q)DbContext.Companion.getThreadBound().getImpl(), (KProperty1)((KProperty1)property$iv), (Object)value$iv, (KClass)Reflection.getOrCreateKotlinClass(SmartModeProblemActionEntity.class));
                Runtime.enterScope((NoriaContext)((NoriaContext)$this$Row), (int)57);
                value$iv = new Object[]{this.$problemData, annotatedTitle2};
                RowKt.Row$default((NoriaContext)((NoriaContext)$this$Row), (Modifier)RowScope.DefaultImpls.weight$default((RowScope)$this$Row, (Modifier)((Modifier)Modifier.Companion), (float)1.0f, (boolean)false, (int)2, null), null, null, (boolean)false, (Function1)((Function1)Runtime.closure((Object[])value$iv, (Object)new Function1<RowScope, Unit>(this.$problemData, annotatedTitle2){
                    final /* synthetic */ SerializableOpenMap<SmartModeProblemDomain> $problemData;
                    final /* synthetic */ AnnotatedString $annotatedTitle;
                    {
                        this.$problemData = $problemData;
                        this.$annotatedTitle = $annotatedTitle;
                        super(1);
                    }

                    public final void invoke(@NotNull RowScope $this$Row) {
                        Intrinsics.checkNotNullParameter((Object)$this$Row, (String)"$this$Row");
                        Runtime.enterScope((NoriaContext)((NoriaContext)$this$Row), (int)54);
                        Object[] objectArray = new Object[]{this.$annotatedTitle};
                        TooltipKt.withTooltip$default((NoriaContext)((NoriaContext)$this$Row), (String)SmartModeProblemEntityKt.getDescriptor(this.$problemData), null, (long)0L, null, null, (Function1)((Function1)Runtime.closure((Object[])objectArray, (Object)new Function1<NoriaContext, Unit>(this.$annotatedTitle){
                            final /* synthetic */ AnnotatedString $annotatedTitle;
                            {
                                this.$annotatedTitle = $annotatedTitle;
                                super(1);
                            }

                            public final void invoke(@NotNull NoriaContext $this$withTooltip) {
                                Intrinsics.checkNotNullParameter((Object)$this$withTooltip, (String)"$this$withTooltip");
                                int $this$dp$iv = 300;
                                boolean $i$f$getDp = false;
                                Modifier modifier = SizeKt.widthIn-VpY3zN4$default((Modifier)((Modifier)Modifier.Companion), (float)0.0f, (float)Dp.constructor-impl((float)$this$dp$iv), (int)1, null);
                                NoriaParagraphStyle noriaParagraphStyle = new NoriaParagraphStyle(2L, "\u2026", null, 4, null);
                                Runtime.enterScope((NoriaContext)$this$withTooltip, (int)53);
                                TextKt.UiText-Uas3SEs$default((NoriaContext)$this$withTooltip, (AnnotatedString)this.$annotatedTitle, (long)0L, null, null, (NoriaParagraphStyle)noriaParagraphStyle, null, null, null, null, (Modifier)modifier, null, null, (int)3566, null);
                                Unit unit = Unit.INSTANCE;
                                Runtime.exitScope((NoriaContext)$this$withTooltip);
                            }
                        })), (int)30, null);
                        Unit unit = Unit.INSTANCE;
                        Runtime.exitScope((NoriaContext)((NoriaContext)$this$Row));
                        Runtime.enterScope((NoriaContext)((NoriaContext)$this$Row), (int)55);
                        int $this$dp$iv = 4;
                        boolean $i$f$getDp = false;
                        SpacerKt.Spacer((NoriaContext)((NoriaContext)$this$Row), (Modifier)SizeKt.width-3ABfNKs((Modifier)((Modifier)Modifier.Companion), (float)Dp.constructor-impl((float)$this$dp$iv)));
                        unit = Unit.INSTANCE;
                        Runtime.exitScope((NoriaContext)((NoriaContext)$this$Row));
                        Runtime.enterScope((NoriaContext)((NoriaContext)$this$Row), (int)56);
                        SpacerKt.Spacer((NoriaContext)((NoriaContext)$this$Row), (Modifier)RowScope.DefaultImpls.weight$default((RowScope)$this$Row, (Modifier)((Modifier)Modifier.Companion), (float)1.0f, (boolean)false, (int)2, null));
                        unit = Unit.INSTANCE;
                        Runtime.exitScope((NoriaContext)((NoriaContext)$this$Row));
                    }
                })), (int)14, null);
                Unit unit2 = Unit.INSTANCE;
                Runtime.exitScope((NoriaContext)((NoriaContext)$this$Row));
                if (!((Collection)actions2).isEmpty()) {
                    Runtime.enterScope((NoriaContext)((NoriaContext)$this$Row), (int)59);
                    int $this$dp$iv = 8;
                    boolean $i$f$getDp = false;
                    Object[] objectArray = new Object[]{actions2, this.$problemData};
                    RowKt.Row$default((NoriaContext)((NoriaContext)$this$Row), null, (Arrangement.Horizontal)((Arrangement.Horizontal)Arrangement.INSTANCE.spacedBy-0680j_4(Dp.constructor-impl((float)$this$dp$iv))), null, (boolean)false, (Function1)((Function1)Runtime.closure((Object[])objectArray, (Object)new Function1<RowScope, Unit>((Set<? extends SmartModeProblemActionEntity>)actions2, this.$problemData){
                        final /* synthetic */ Set<SmartModeProblemActionEntity> $actions;
                        final /* synthetic */ SerializableOpenMap<SmartModeProblemDomain> $problemData;
                        {
                            this.$actions = $actions;
                            this.$problemData = $problemData;
                            super(1);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(@NotNull RowScope $this$Row) {
                            Intrinsics.checkNotNullParameter((Object)$this$Row, (String)"$this$Row");
                            Iterator<SmartModeProblemActionEntity> iterator = this.$actions.iterator();
                            int n = 0;
                            while (iterator.hasNext()) {
                                void $this$scope$iv;
                                int index = n++;
                                SmartModeProblemActionEntity action2 = iterator.next();
                                NoriaContext noriaContext = (NoriaContext)$this$Row;
                                String string = "ActionButton" + index;
                                SerializableOpenMap<SmartModeProblemDomain> serializableOpenMap = this.$problemData;
                                boolean $i$f$scope = false;
                                NoriaState noriaState = $this$scope$iv.getNoriaState();
                                if (noriaState != null) {
                                    void key$iv;
                                    NoriaStateKt.enterScope((NoriaState)noriaState, (Object)key$iv);
                                }
                                RowScope $this$invoke_u24lambda_u240 = (RowScope)$this$scope$iv;
                                boolean bl = false;
                                Runtime.enterScope((NoriaContext)((NoriaContext)$this$invoke_u24lambda_u240), (int)58);
                                Object[] objectArray = new Object[]{serializableOpenMap, action2};
                                TextComponentsKt.Link-wqdebIU$default((NoriaContext)((NoriaContext)$this$invoke_u24lambda_u240), (String)action2.getTitle(), null, null, (boolean)false, (boolean)false, (long)0L, (long)0L, null, null, null, (Function1)((Function1)Runtime.closure((Object[])objectArray, (Object)new Function1<HandlerScope, Unit>(serializableOpenMap, action2){
                                    final /* synthetic */ SerializableOpenMap<SmartModeProblemDomain> $problemData;
                                    final /* synthetic */ SmartModeProblemActionEntity $action;
                                    {
                                        this.$problemData = $problemData;
                                        this.$action = $action;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull HandlerScope $this$Link) {
                                        Intrinsics.checkNotNullParameter((Object)$this$Link, (String)"$this$Link");
                                        ActionsKt.performAction((ActionContext)$this$Link.getActionContext(), (CommonTrigger)CommonTrigger.Cancel);
                                        ActionsKt.performAction((ActionContext)$this$Link.getActionContext().put(SmartModeProblemActionEntityKt.getSmartProblemDataKey(), this.$problemData), (Action)this.$action.getAction());
                                    }
                                })), (int)1022, null);
                                Runtime.exitScope((NoriaContext)((NoriaContext)$this$invoke_u24lambda_u240));
                                Unit returnValue$iv = Unit.INSTANCE;
                                NoriaState noriaState2 = $this$scope$iv.getNoriaState();
                                if (noriaState2 == null) continue;
                                NoriaStateKt.exitScope((NoriaState)noriaState2);
                            }
                        }
                    })), (int)13, null);
                    unit2 = Unit.INSTANCE;
                    Runtime.exitScope((NoriaContext)((NoriaContext)$this$Row));
                }
            }
        })), (int)15, null);
        Unit unit = Unit.INSTANCE;
        Runtime.exitScope((NoriaContext)$this$renderNotification);
    }

    public static final /* synthetic */ Set access$getKnownBackendProjectRootTypes() {
        return SmartModeControlCenterStatusProviderKt.getKnownBackendProjectRootTypes();
    }

    public static final /* synthetic */ List access$filterIgnored(List $receiver) {
        return SmartModeControlCenterStatusProviderKt.filterIgnored($receiver);
    }

    public static final /* synthetic */ List access$projectRoots(Set labels) {
        return SmartModeControlCenterStatusProviderKt.projectRoots(labels);
    }

    public static final /* synthetic */ boolean access$isReady(List $receiver) {
        return SmartModeControlCenterStatusProviderKt.isReady($receiver);
    }

    public static final /* synthetic */ void access$renderNotification(NoriaContext $receiver, SmartModeProblemEntity problem) {
        SmartModeControlCenterStatusProviderKt.renderNotification($receiver, problem);
    }
}

