/*
 * Decompiled with CFR 0.152.
 */
package fleet.plugins.smartMode.frontend;

import androidx.compose.foundation.layout.ColumnKt;
import androidx.compose.foundation.layout.ColumnScope;
import androidx.compose.foundation.layout.PaddingKt;
import androidx.compose.foundation.layout.RowKt;
import androidx.compose.foundation.layout.RowScope;
import androidx.compose.foundation.layout.SizeKt;
import androidx.compose.foundation.layout.SpacerKt;
import androidx.compose.runtime.Composable;
import androidx.compose.runtime.CompositionLocal;
import androidx.compose.ui.Alignment;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.unit.Dp;
import com.jetbrains.rhizomedb.ChangeScope;
import com.jetbrains.rhizomedb.DbContext;
import com.jetbrains.rhizomedb.EntitiesKt;
import com.jetbrains.rhizomedb.Q;
import com.jetbrains.rhizomedb.impl.EntitiesImplKt;
import fleet.common.BackendService;
import fleet.common.WorkspaceEntity;
import fleet.common.WorkspaceEntityKt;
import fleet.common.smartMode.SmartModeEntityKt;
import fleet.common.smartMode.SmartModeState;
import fleet.compose.theme.CompositionLocalsKt;
import fleet.compose.theme.components.IconKt;
import fleet.compose.theme.components.MutableProgressIndicator;
import fleet.compose.theme.components.ProgressIndicatorKt;
import fleet.compose.theme.components.ProgressState;
import fleet.compose.theme.components.TextKt;
import fleet.compose.theme.keys.TextStyleKeys;
import fleet.compose.theme.keys.ThemeKeys;
import fleet.compose.theme.text.NoriaParagraphStyle;
import fleet.frontend.KernelExtKt;
import fleet.frontend.icons.IconKeys;
import fleet.frontend.notifications.NotificationCategoryId;
import fleet.frontend.notifications.NotificationEntity;
import fleet.frontend.notifications.NotificationState;
import fleet.frontend.ui.components.ActionButtonKt;
import fleet.frontend.ui.controlCenter.ControlCenterKt;
import fleet.frontend.ui.controlCenter.ControlCenterProgress;
import fleet.frontend.ui.controlCenter.ControlCenterStatusProvider;
import fleet.kernel.plugins.PluginScope;
import fleet.plugins.smartMode.common.SmartModeProblemEntity;
import fleet.plugins.smartMode.common.SmartModeProblemEntityKt;
import fleet.plugins.smartMode.common.SmartModeProblemSeverity;
import fleet.plugins.smartMode.frontend.SmartModeControlCenterStatusProvider;
import fleet.plugins.smartMode.frontend.SmartModeControlCenterStatusProviderKt;
import fleet.plugins.smartMode.frontend.SmartModeProblemNotificationEntityKt;
import fleet.util.openmap.SerializableOpenMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KMutableProperty1;
import kotlin.reflect.KProperty1;
import noria.NoriaContext;
import noria.NoriaContextKt;
import noria.ReadScope;
import noria.impl.NoriaState;
import noria.impl.NoriaStateKt;
import noria.impl.Runtime;
import noria.model.FleetActionIds;
import noria.model.ThemeKey;
import noria.model.Trigger;
import noria.ui.ApplyModifierKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\u0004H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\f\u0010\u0010\u001a\u00020\r*\u00020\u0011H\u0017R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lfleet/plugins/smartMode/frontend/SmartModeControlCenterStatusProvider;", "Lfleet/frontend/ui/controlCenter/ControlCenterStatusProvider;", "()V", "hasProblems", "", "getHasProblems", "()Z", "progress", "Lfleet/frontend/ui/controlCenter/ControlCenterProgress;", "getProgress", "()Lfleet/frontend/ui/controlCenter/ControlCenterProgress;", "isShown", "markAllSmartModeNotificationsAsRead", "", "pluginScope", "Lfleet/kernel/plugins/PluginScope;", "render", "Lnoria/NoriaContext;", "fleet.plugins.smartMode.frontend"})
@SourceDebugExtension(value={"SMAP\nSmartModeControlCenterStatusProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SmartModeControlCenterStatusProvider.kt\nfleet/plugins/smartMode/frontend/SmartModeControlCenterStatusProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Dp.kt\nandroidx/compose/ui/unit/DpKt\n+ 4 Entities.kt\ncom/jetbrains/rhizomedb/EntitiesKt\n*L\n1#1,248:1\n1747#2,3:249\n766#2:254\n857#2,2:255\n155#3:252\n235#4:253\n*S KotlinDebug\n*F\n+ 1 SmartModeControlCenterStatusProvider.kt\nfleet/plugins/smartMode/frontend/SmartModeControlCenterStatusProvider\n*L\n49#1:249,3\n174#1:254\n174#1:255,2\n82#1:252\n173#1:253\n*E\n"})
public final class SmartModeControlCenterStatusProvider
implements ControlCenterStatusProvider {
    public boolean getHasProblems() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = EntitiesKt.byEntityType((KClass)Reflection.getOrCreateKotlinClass(SmartModeProblemEntity.class));
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    SmartModeProblemEntity it = (SmartModeProblemEntity)element$iv;
                    boolean bl2 = false;
                    if (!(it.getSeverity() == SmartModeProblemSeverity.Error)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public ControlCenterProgress getProgress() {
        SmartModeState smartModeState = SmartModeEntityKt.smartModeState();
        Set backendTypes = SmartModeControlCenterStatusProviderKt.access$getKnownBackendProjectRootTypes();
        List projectRoots = SmartModeControlCenterStatusProviderKt.access$filterIgnored(SmartModeControlCenterStatusProviderKt.access$projectRoots(backendTypes));
        return switch (WhenMappings.$EnumSwitchMapping$0[smartModeState.ordinal()]) {
            case 1 -> ControlCenterProgress.Off;
            case 2 -> {
                if (projectRoots.isEmpty() || !SmartModeControlCenterStatusProviderKt.access$isReady(projectRoots)) {
                    yield ControlCenterProgress.InProgress;
                }
                yield ControlCenterProgress.Finished;
            }
            case 3 -> {
                if (projectRoots.isEmpty()) {
                    yield ControlCenterProgress.Finished;
                }
                yield ControlCenterProgress.Off;
            }
            case 4, 5 -> ControlCenterProgress.InProgress;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public boolean isShown() {
        return true;
    }

    @Composable
    public void render(@NotNull NoriaContext $this$render) {
        Intrinsics.checkNotNullParameter((Object)$this$render, (String)"<this>");
        WorkspaceEntity workspaceEntity = WorkspaceEntityKt.currentWorkspace();
        if (workspaceEntity == null) {
            return;
        }
        WorkspaceEntity currentWorkspace = workspaceEntity;
        Runtime.enterScope((NoriaContext)$this$render, (int)49);
        int $this$dp$iv = 3;
        boolean $i$f$getDp = false;
        Object[] objectArray = new Object[]{this, currentWorkspace};
        ProgressIndicatorKt.ProgressIndicatorBox-2lqI77k$default((NoriaContext)$this$render, null, (boolean)false, (float)Dp.constructor-impl((float)$this$dp$iv), (Function2)((Function2)Runtime.closure((Object[])objectArray, (Object)new Function2<NoriaContext, MutableProgressIndicator, Unit>(this, currentWorkspace){
            final /* synthetic */ SmartModeControlCenterStatusProvider this$0;
            final /* synthetic */ WorkspaceEntity $currentWorkspace;
            {
                this.this$0 = $receiver;
                this.$currentWorkspace = $currentWorkspace;
                super(2);
            }

            public final void invoke(@NotNull NoriaContext $this$ProgressIndicatorBox, @NotNull MutableProgressIndicator progressIndicator) {
                Intrinsics.checkNotNullParameter((Object)$this$ProgressIndicatorBox, (String)"$this$ProgressIndicatorBox");
                Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
                SmartModeState smartModeState = SmartModeEntityKt.smartModeState();
                Set backendTypes = SmartModeControlCenterStatusProviderKt.access$getKnownBackendProjectRootTypes();
                ControlCenterProgress progressState = this.this$0.getProgress();
                ProgressIndicatorKt.setState((MutableProgressIndicator)progressIndicator, (ProgressState)ControlCenterKt.toProgressState((ControlCenterProgress)progressState));
                Runtime.enterScope((NoriaContext)$this$ProgressIndicatorBox, (int)48);
                int $this$dp$iv = 12;
                boolean $i$f$getDp = false;
                Object[] objectArray = new Object[]{backendTypes, smartModeState, this.$currentWorkspace, this.this$0};
                ColumnKt.Column$default((NoriaContext)$this$ProgressIndicatorBox, (Modifier)PaddingKt.padding-3ABfNKs((Modifier)((Modifier)Modifier.Companion), (float)Dp.constructor-impl((float)$this$dp$iv)), null, null, (boolean)false, (Function1)((Function1)Runtime.closure((Object[])objectArray, (Object)new Function1<ColumnScope, Unit>((Set<String>)backendTypes, smartModeState, this.$currentWorkspace, this.this$0){
                    final /* synthetic */ Set<String> $backendTypes;
                    final /* synthetic */ SmartModeState $smartModeState;
                    final /* synthetic */ WorkspaceEntity $currentWorkspace;
                    final /* synthetic */ SmartModeControlCenterStatusProvider this$0;
                    {
                        this.$backendTypes = $backendTypes;
                        this.$smartModeState = $smartModeState;
                        this.$currentWorkspace = $currentWorkspace;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull ColumnScope $this$Column) {
                        int $this$dp$iv;
                        Object object;
                        boolean bl;
                        SmartModeProblemEntity stopRequestedProblem;
                        List restartRequiredBackends;
                        Set smartModeProblems;
                        boolean hasControllerServices;
                        boolean hasAttachedBackendServices;
                        block22: {
                            Object v0;
                            block21: {
                                void $this$mapNotNullTo$iv$iv;
                                Intrinsics.checkNotNullParameter((Object)$this$Column, (String)"$this$Column");
                                hasAttachedBackendServices = !((Collection)EntitiesKt.byEntityType((KClass)Reflection.getOrCreateKotlinClass(BackendService.class))).isEmpty();
                                hasControllerServices = !((Collection)this.$backendTypes).isEmpty();
                                smartModeProblems = EntitiesKt.byEntityType((KClass)Reflection.getOrCreateKotlinClass(SmartModeProblemEntity.class));
                                Iterable $this$mapNotNull$iv = smartModeProblems;
                                boolean $i$f$mapNotNull = false;
                                Iterable iterable = $this$mapNotNull$iv;
                                Collection destination$iv$iv = new ArrayList<E>();
                                boolean $i$f$mapNotNullTo = false;
                                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                                boolean $i$f$forEach = false;
                                Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                                while (iterator.hasNext()) {
                                    String it$iv$iv;
                                    T element$iv$iv$iv;
                                    T element$iv$iv = element$iv$iv$iv = iterator.next();
                                    boolean bl2 = false;
                                    SmartModeProblemEntity it = (SmartModeProblemEntity)element$iv$iv;
                                    boolean bl3 = false;
                                    if (SmartModeProblemEntityKt.getRestartRequiredRootTag((SerializableOpenMap)it.getProblemData()) == null) continue;
                                    boolean bl4 = false;
                                    destination$iv$iv.add(it$iv$iv);
                                }
                                restartRequiredBackends = (List)destination$iv$iv;
                                Iterable $this$firstOrNull$iv = smartModeProblems;
                                boolean $i$f$firstOrNull = false;
                                for (E element$iv : $this$firstOrNull$iv) {
                                    SmartModeProblemEntity it = (SmartModeProblemEntity)element$iv;
                                    boolean bl5 = false;
                                    if (!(SmartModeProblemEntityKt.getStopRequestedRootTag((SerializableOpenMap)it.getProblemData()) != null)) continue;
                                    v0 = element$iv;
                                    break block21;
                                }
                                v0 = null;
                            }
                            stopRequestedProblem = v0;
                            Iterable $this$any$iv = smartModeProblems;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (T element$iv : $this$any$iv) {
                                    SmartModeProblemEntity it = (SmartModeProblemEntity)element$iv;
                                    boolean bl6 = false;
                                    if (!(it.getSeverity() == SmartModeProblemSeverity.Error && SmartModeProblemEntityKt.getStopRequestedRootTag((SerializableOpenMap)it.getProblemData()) == null)) continue;
                                    bl = true;
                                    break block22;
                                }
                                bl = false;
                            }
                        }
                        boolean hasProblems = bl;
                        boolean canBeEnabled = hasControllerServices || hasAttachedBackendServices;
                        String state = "Smart Mode is " + (switch (render.WhenMappings.$EnumSwitchMapping$0[this.$smartModeState.ordinal()]) {
                            case 1 -> "off";
                            case 2, 3 -> {
                                if (hasProblems) {
                                    yield "partially on";
                                }
                                yield "on";
                            }
                            case 4 -> "starting\u2026";
                            case 5 -> "stopping\u2026";
                            default -> throw new NoWhenBranchMatchedException();
                        });
                        Runtime.enterScope((NoriaContext)((NoriaContext)$this$Column), (int)26);
                        TextKt.UiText-1ODQ_eA$default((NoriaContext)((NoriaContext)$this$Column), (String)state, (long)0L, (ThemeKey)TextStyleKeys.INSTANCE.getDefaultSemiBold(), null, null, null, null, null, null, null, (int)1018, null);
                        Unit element$iv = Unit.INSTANCE;
                        Runtime.exitScope((NoriaContext)((NoriaContext)$this$Column));
                        Runtime.enterScope((NoriaContext)((NoriaContext)$this$Column), (int)27);
                        int $this$dp$iv2 = 4;
                        boolean $i$f$getDp = false;
                        SpacerKt.Spacer((NoriaContext)((NoriaContext)$this$Column), (Modifier)SizeKt.height-3ABfNKs((Modifier)((Modifier)Modifier.Companion), (float)Dp.constructor-impl((float)$this$dp$iv2)));
                        element$iv = Unit.INSTANCE;
                        Runtime.exitScope((NoriaContext)((NoriaContext)$this$Column));
                        if (!((Collection)restartRequiredBackends).isEmpty()) {
                            String backends = restartRequiredBackends.size() == 1 ? CollectionsKt.first((List)restartRequiredBackends) + " backend" : CollectionsKt.joinToString$default((Iterable)restartRequiredBackends, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + " backends";
                            object = backends + " restart is required because some settings were changed";
                        } else {
                            SmartModeProblemEntity smartModeProblemEntity = stopRequestedProblem;
                            if ((smartModeProblemEntity != null && (smartModeProblemEntity = smartModeProblemEntity.getProblemData()) != null ? SmartModeProblemEntityKt.getTitle((SerializableOpenMap)smartModeProblemEntity) : null) != null) {
                                String string = SmartModeProblemEntityKt.getTitle((SerializableOpenMap)stopRequestedProblem.getProblemData());
                                object = string;
                                Intrinsics.checkNotNull((Object)string);
                            } else {
                                object = hasProblems ? "Some of Smart Mode functionality didn't start properly" : "Analyzes code to provide completion, error detection, fixes, and refactorings";
                            }
                        }
                        String stateText = object;
                        Runtime.enterScope((NoriaContext)((NoriaContext)$this$Column), (int)28);
                        TextKt.UiText-1ODQ_eA$default((NoriaContext)((NoriaContext)$this$Column), (String)stateText, (long)((Color)CompositionLocalsKt.getTheme((ReadScope)((ReadScope)$this$Column)).get(ThemeKeys.INSTANCE.getTextDimmed())).unbox-impl(), (ThemeKey)TextStyleKeys.INSTANCE.getSmall(), null, (NoriaParagraphStyle)NoriaParagraphStyle.Companion.getMultiline(), null, null, null, null, null, (int)1000, null);
                        Unit backends = Unit.INSTANCE;
                        Runtime.exitScope((NoriaContext)((NoriaContext)$this$Column));
                        if (canBeEnabled && this.$smartModeState == SmartModeState.OFF && !this.$currentWorkspace.getTrusted()) {
                            Runtime.enterScope((NoriaContext)((NoriaContext)$this$Column), (int)29);
                            $this$dp$iv = 8;
                            boolean $i$f$getDp2 = false;
                            SpacerKt.Spacer((NoriaContext)((NoriaContext)$this$Column), (Modifier)SizeKt.height-3ABfNKs((Modifier)((Modifier)Modifier.Companion), (float)Dp.constructor-impl((float)$this$dp$iv)));
                            backends = Unit.INSTANCE;
                            Runtime.exitScope((NoriaContext)((NoriaContext)$this$Column));
                            Runtime.enterScope((NoriaContext)((NoriaContext)$this$Column), (int)33);
                            RowKt.Row$default((NoriaContext)((NoriaContext)$this$Column), null, null, (Alignment.Vertical)Alignment.Companion.getCenterVertically(), (boolean)false, (Function1)((Function1)Runtime.closure((Object[])new Object[0], (Object)((Object)render.1.INSTANCE))), (int)11, null);
                            backends = Unit.INSTANCE;
                            Runtime.exitScope((NoriaContext)((NoriaContext)$this$Column));
                        }
                        Runtime.enterScope((NoriaContext)((NoriaContext)$this$Column), (int)34);
                        $this$dp$iv = 8;
                        boolean $i$f$getDp3 = false;
                        SpacerKt.Spacer((NoriaContext)((NoriaContext)$this$Column), (Modifier)SizeKt.height-3ABfNKs((Modifier)((Modifier)Modifier.Companion), (float)Dp.constructor-impl((float)$this$dp$iv)));
                        backends = Unit.INSTANCE;
                        Runtime.exitScope((NoriaContext)((NoriaContext)$this$Column));
                        Runtime.enterScope((NoriaContext)((NoriaContext)$this$Column), (int)40);
                        Object object2 = new Object[]{canBeEnabled, this.$currentWorkspace};
                        RowKt.Row$default((NoriaContext)((NoriaContext)$this$Column), null, null, (Alignment.Vertical)Alignment.Companion.getCenterVertically(), (boolean)false, (Function1)((Function1)Runtime.closure((Object[])object2, (Object)new Function1<RowScope, Unit>(canBeEnabled, this.$currentWorkspace){
                            final /* synthetic */ boolean $canBeEnabled;
                            final /* synthetic */ WorkspaceEntity $currentWorkspace;
                            {
                                this.$canBeEnabled = $canBeEnabled;
                                this.$currentWorkspace = $currentWorkspace;
                                super(1);
                            }

                            public final void invoke(@NotNull RowScope $this$Row) {
                                Intrinsics.checkNotNullParameter((Object)$this$Row, (String)"$this$Row");
                                if (this.$canBeEnabled) {
                                    if (this.$currentWorkspace.getSmartModeEnabled()) {
                                        Runtime.enterScope((NoriaContext)((NoriaContext)$this$Row), (int)35);
                                        ActionButtonKt.actionButton$default((NoriaContext)((NoriaContext)$this$Row), (Trigger)((Trigger)FleetActionIds.ToggleSmartMode.getId()), (String)"Disable", null, null, (boolean)false, null, (int)44, null);
                                        Unit unit = Unit.INSTANCE;
                                        Runtime.exitScope((NoriaContext)((NoriaContext)$this$Row));
                                    } else {
                                        Runtime.enterScope((NoriaContext)((NoriaContext)$this$Row), (int)36);
                                        ActionButtonKt.primaryActionButton$default((NoriaContext)((NoriaContext)$this$Row), (Trigger)((Trigger)FleetActionIds.ToggleSmartMode.getId()), (String)"Enable", null, null, (boolean)false, null, (int)44, null);
                                        Unit unit = Unit.INSTANCE;
                                        Runtime.exitScope((NoriaContext)((NoriaContext)$this$Row));
                                    }
                                } else {
                                    Runtime.enterScope((NoriaContext)((NoriaContext)$this$Row), (int)37);
                                    IconKt.Icon-USBMPiE$default((NoriaContext)((NoriaContext)$this$Row), (ThemeKey)IconKeys.INSTANCE.getInfo(), (long)0L, null, null, null, (int)30, null);
                                    Unit unit = Unit.INSTANCE;
                                    Runtime.exitScope((NoriaContext)((NoriaContext)$this$Row));
                                    Runtime.enterScope((NoriaContext)((NoriaContext)$this$Row), (int)38);
                                    int $this$dp$iv = 4;
                                    boolean $i$f$getDp = false;
                                    SpacerKt.Spacer((NoriaContext)((NoriaContext)$this$Row), (Modifier)SizeKt.width-3ABfNKs((Modifier)((Modifier)Modifier.Companion), (float)Dp.constructor-impl((float)$this$dp$iv)));
                                    unit = Unit.INSTANCE;
                                    Runtime.exitScope((NoriaContext)((NoriaContext)$this$Row));
                                    Runtime.enterScope((NoriaContext)((NoriaContext)$this$Row), (int)39);
                                    TextKt.UiText-1ODQ_eA$default((NoriaContext)((NoriaContext)$this$Row), (String)"No smart backends to run", (long)0L, (ThemeKey)TextStyleKeys.INSTANCE.getSmall(), null, null, null, null, null, null, null, (int)1018, null);
                                    unit = Unit.INSTANCE;
                                    Runtime.exitScope((NoriaContext)((NoriaContext)$this$Row));
                                }
                            }
                        })), (int)11, null);
                        backends = Unit.INSTANCE;
                        Runtime.exitScope((NoriaContext)((NoriaContext)$this$Column));
                        PluginScope pluginScope = (PluginScope)$this$Column.getCurrent((CompositionLocal)KernelExtKt.getLocalPluginScope());
                        Runtime.enterScope((NoriaContext)((NoriaContext)$this$Column), (int)41);
                        NoriaContextKt.sideEffect((NoriaContext)((NoriaContext)$this$Column), (Object[])new Object[0], (Function0)((Function0)new Function0<Unit>(this.this$0, pluginScope){
                            final /* synthetic */ SmartModeControlCenterStatusProvider this$0;
                            final /* synthetic */ PluginScope $pluginScope;
                            {
                                this.this$0 = $receiver;
                                this.$pluginScope = $pluginScope;
                                super(0);
                            }

                            public final void invoke() {
                                SmartModeControlCenterStatusProvider.access$markAllSmartModeNotificationsAsRead(this.this$0, this.$pluginScope);
                            }
                        }));
                        object2 = Unit.INSTANCE;
                        Runtime.exitScope((NoriaContext)((NoriaContext)$this$Column));
                        if (!((Collection)smartModeProblems).isEmpty()) {
                            Runtime.enterScope((NoriaContext)((NoriaContext)$this$Column), (int)42);
                            int $this$dp$iv3 = 12;
                            boolean $i$f$getDp4 = false;
                            SpacerKt.Spacer((NoriaContext)((NoriaContext)$this$Column), (Modifier)SizeKt.height-3ABfNKs((Modifier)((Modifier)Modifier.Companion), (float)Dp.constructor-impl((float)$this$dp$iv3)));
                            object2 = Unit.INSTANCE;
                            Runtime.exitScope((NoriaContext)((NoriaContext)$this$Column));
                            Runtime.enterScope((NoriaContext)((NoriaContext)$this$Column), (int)44);
                            ApplyModifierKt.withModifier((NoriaContext)((NoriaContext)$this$Column), (Modifier)SizeKt.fillMaxWidth$default((Modifier)((Modifier)Modifier.Companion), (float)0.0f, (int)1, null), (Function1)((Function1)Runtime.closure((Object[])new Object[0], (Object)((Object)render.4.INSTANCE))));
                            object2 = Unit.INSTANCE;
                            Runtime.exitScope((NoriaContext)((NoriaContext)$this$Column));
                            Runtime.enterScope((NoriaContext)((NoriaContext)$this$Column), (int)45);
                            $this$dp$iv3 = 4;
                            $i$f$getDp4 = false;
                            SpacerKt.Spacer((NoriaContext)((NoriaContext)$this$Column), (Modifier)SizeKt.height-3ABfNKs((Modifier)((Modifier)Modifier.Companion), (float)Dp.constructor-impl((float)$this$dp$iv3)));
                            object2 = Unit.INSTANCE;
                            Runtime.exitScope((NoriaContext)((NoriaContext)$this$Column));
                            object2 = smartModeProblems.iterator();
                            int n = 0;
                            while (object2.hasNext()) {
                                int index = n++;
                                SmartModeProblemEntity notification2 = (SmartModeProblemEntity)object2.next();
                                NoriaContext $this$scope$iv = (NoriaContext)$this$Column;
                                boolean $i$f$scope = false;
                                NoriaState noriaState = $this$scope$iv.getNoriaState();
                                if (noriaState != null) {
                                    NoriaStateKt.enterScope((NoriaState)noriaState, (int)index);
                                }
                                ColumnScope $this$invoke_u24lambda_u243 = (ColumnScope)$this$scope$iv;
                                boolean bl7 = false;
                                Runtime.enterScope((NoriaContext)((NoriaContext)$this$invoke_u24lambda_u243), (int)46);
                                int $this$dp$iv4 = 8;
                                boolean $i$f$getDp5 = false;
                                SpacerKt.Spacer((NoriaContext)((NoriaContext)$this$invoke_u24lambda_u243), (Modifier)SizeKt.height-3ABfNKs((Modifier)((Modifier)Modifier.Companion), (float)Dp.constructor-impl((float)$this$dp$iv4)));
                                Runtime.exitScope((NoriaContext)((NoriaContext)$this$invoke_u24lambda_u243));
                                Runtime.enterScope((NoriaContext)((NoriaContext)$this$invoke_u24lambda_u243), (int)47);
                                SmartModeControlCenterStatusProviderKt.access$renderNotification((NoriaContext)$this$invoke_u24lambda_u243, notification2);
                                Runtime.exitScope((NoriaContext)((NoriaContext)$this$invoke_u24lambda_u243));
                                Unit returnValue$iv = Unit.INSTANCE;
                                NoriaState noriaState2 = $this$scope$iv.getNoriaState();
                                if (noriaState2 != null) {
                                    NoriaStateKt.exitScope((NoriaState)noriaState2);
                                }
                            }
                        }
                    }
                })), (int)14, null);
                Unit unit = Unit.INSTANCE;
                Runtime.exitScope((NoriaContext)$this$ProgressIndicatorBox);
            }
        })), (int)1, null);
        Unit unit = Unit.INSTANCE;
        Runtime.exitScope((NoriaContext)$this$render);
    }

    /*
     * WARNING - void declaration
     */
    private final void markAllSmartModeNotificationsAsRead(PluginScope pluginScope) {
        void $this$filterTo$iv$iv;
        void property$iv;
        KMutableProperty1 kMutableProperty1 = (KMutableProperty1)markAllSmartModeNotificationsAsRead.notReadNotifications.1.INSTANCE;
        NotificationCategoryId value$iv = NotificationCategoryId.box-impl((String)SmartModeProblemNotificationEntityKt.getSmartModeNotificationProblemCategory().getId-L6wPaKM());
        boolean $i$f$lookup22 = false;
        Iterable $this$filter$iv = EntitiesImplKt.lookupImpl((Q)DbContext.Companion.getThreadBound().getImpl(), (KProperty1)((KProperty1)property$iv), (Object)value$iv, (KClass)Reflection.getOrCreateKotlinClass(NotificationEntity.class));
        boolean $i$f$filter = false;
        Iterable $i$f$lookup22 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            NotificationEntity it = (NotificationEntity)element$iv$iv;
            boolean bl = false;
            if (!(it.getState() == NotificationState.NEW)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List notReadNotifications2 = (List)destination$iv$iv;
        if (!((Collection)notReadNotifications2).isEmpty()) {
            pluginScope.changeAsync((Function1)new Function1<ChangeScope, Unit>((List<? extends NotificationEntity>)notReadNotifications2){
                final /* synthetic */ List<NotificationEntity> $notReadNotifications;
                {
                    this.$notReadNotifications = $notReadNotifications;
                    super(1);
                }

                public final void invoke(@NotNull ChangeScope $this$changeAsync) {
                    Intrinsics.checkNotNullParameter((Object)$this$changeAsync, (String)"$this$changeAsync");
                    Iterable $this$forEach$iv = this.$notReadNotifications;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        NotificationEntity it = (NotificationEntity)element$iv;
                        boolean bl = false;
                        it.setState(NotificationState.READ);
                    }
                }
            });
        }
    }

    public static final /* synthetic */ void access$markAllSmartModeNotificationsAsRead(SmartModeControlCenterStatusProvider $this, PluginScope pluginScope) {
        $this.markAllSmartModeNotificationsAsRead(pluginScope);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SmartModeState.values().length];
            try {
                nArray[SmartModeState.OFF.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SmartModeState.RUNNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SmartModeState.IDLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SmartModeState.STARTING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SmartModeState.STOPPING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

