/*
 * Decompiled with CFR 0.152.
 */
package fleet.lang.intellij.common;

import andel.lexer.Token;
import andel.lexer.Tokenizer;
import fleet.com.intellij.lexer.Lexer;
import fleet.com.intellij.lexer.LexerPosition;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.lang.intellij.common.LexPos;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010(\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0013\u0010\u0018\u001a\u00020\u000f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0003H\u0096\u0002J\b\u0010\u001a\u001a\u00020\tH\u0016J\b\u0010\u001b\u001a\u00020\u000bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\tH\u0016J\b\u0010\u001f\u001a\u00020\tH\u0016J\b\u0010 \u001a\u00020\tH\u0016J\n\u0010!\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010\"\u001a\u00020\tH\u0016J\u0010\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u001dH\u0016J(\u0010%\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020\t2\u0006\u0010)\u001a\u00020\tH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\r0\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006*"}, d2={"Lfleet/lang/intellij/common/TokenizerLexer;", "Lfleet/com/intellij/lexer/Lexer;", "key", "", "tokenizer", "Landel/lexer/Tokenizer;", "Lfleet/com/intellij/psi/tree/IElementType;", "(Ljava/lang/Object;Landel/lexer/Tokenizer;)V", "bufferEndOffset", "", "charSequence", "", "cur", "Landel/lexer/Token;", "finished", "", "iterator", "", "getKey", "()Ljava/lang/Object;", "getTokenizer", "()Landel/lexer/Tokenizer;", "advance", "", "equals", "other", "getBufferEnd", "getBufferSequence", "getCurrentPosition", "Lfleet/com/intellij/lexer/LexerPosition;", "getState", "getTokenEnd", "getTokenStart", "getTokenType", "hashCode", "restore", "position", "start", "buffer", "startOffset", "endOffset", "initialState", "fleet.plugins.ij.parsing.common"})
public final class TokenizerLexer
extends Lexer {
    @NotNull
    private final Object key;
    @NotNull
    private final Tokenizer<IElementType> tokenizer;
    private Token<IElementType> cur;
    private Iterator<Token<IElementType>> iterator;
    private CharSequence charSequence;
    private int bufferEndOffset;
    private boolean finished;

    public TokenizerLexer(@NotNull Object key, @NotNull Tokenizer<IElementType> tokenizer) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(tokenizer, (String)"tokenizer");
        this.key = key;
        this.tokenizer = tokenizer;
        this.bufferEndOffset = -1;
    }

    @NotNull
    public final Object getKey() {
        return this.key;
    }

    @NotNull
    public final Tokenizer<IElementType> getTokenizer() {
        return this.tokenizer;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof TokenizerLexer && Intrinsics.areEqual((Object)((TokenizerLexer)((Object)other)).key, (Object)this.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.charSequence = buffer;
        this.iterator = this.tokenizer.tokenize(buffer, startOffset, endOffset, initialState).iterator();
        this.bufferEndOffset = endOffset;
        this.advance();
    }

    public int getState() {
        Token<IElementType> token = this.cur;
        if (token == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cur");
            token = null;
        }
        return token.getState();
    }

    @Nullable
    public IElementType getTokenType() {
        IElementType iElementType;
        if (this.finished) {
            iElementType = null;
        } else {
            Token<IElementType> token = this.cur;
            if (token == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cur");
                token = null;
            }
            iElementType = (IElementType)token.getType();
        }
        return iElementType;
    }

    public int getTokenStart() {
        Token<IElementType> token = this.cur;
        if (token == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cur");
            token = null;
        }
        return token.getStart();
    }

    public int getTokenEnd() {
        Token<IElementType> token = this.cur;
        if (token == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cur");
            token = null;
        }
        return token.getEnd();
    }

    public void advance() {
        if (!this.finished) {
            Iterator<Token<IElementType>> iterator = this.iterator;
            if (iterator == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"iterator");
                iterator = null;
            }
            if (iterator.hasNext()) {
                Iterator<Token<IElementType>> iterator2 = this.iterator;
                if (iterator2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"iterator");
                    iterator2 = null;
                }
                this.cur = iterator2.next();
            } else {
                this.finished = true;
            }
        }
    }

    @NotNull
    public LexerPosition getCurrentPosition() {
        Token<IElementType> token = this.cur;
        if (token == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cur");
            token = null;
        }
        int n = token.getStart();
        Token<IElementType> token2 = this.cur;
        if (token2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cur");
            token2 = null;
        }
        return new LexPos(n, token2.getState());
    }

    public void restore(@NotNull LexerPosition position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        this.finished = false;
    }

    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence2 = this.charSequence;
        if (charSequence2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"charSequence");
            charSequence2 = null;
        }
        return charSequence2;
    }

    public int getBufferEnd() {
        return this.bufferEndOffset;
    }
}

