/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.doctor.diagnostics.xcode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.internal.LinkedHashMapSerializer;
import kotlinx.serialization.internal.StringSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.doctor.diagnostics.MultiStepsEnvironmentDiagnosis;
import org.jetbrains.kotlin.doctor.diagnostics.MultiStepsEnvironmentDiagnosisKt;
import org.jetbrains.kotlin.doctor.diagnostics.xcode.AppleSdk;
import org.jetbrains.kotlin.doctor.diagnostics.xcode.AppleSimulatorRuntime;
import org.jetbrains.kotlin.doctor.diagnostics.xcode.AppleSimulatorRuntimesDiagnosis;
import org.jetbrains.kotlin.doctor.diagnostics.xcode.ListRuntimeResult;
import org.jetbrains.kotlin.doctor.diagnostics.xcode.RuntimeMatchListValue;
import org.jetbrains.kotlin.doctor.diagnostics.xcode.SimctlUtilKt;
import org.jetbrains.kotlin.doctor.diagnostics.xcode.XcodeEnvironmentDiagnosis;
import org.jetbrains.kotlin.doctor.diagnostics.xcode.XcodeModelKt;
import org.jetbrains.kotlin.doctor.entity.Diagnosis;
import org.jetbrains.kotlin.doctor.entity.ProcessResult;
import org.jetbrains.kotlin.doctor.entity.System;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0096@\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/doctor/diagnostics/xcode/AppleSimulatorRuntimesDiagnosis;", "Lorg/jetbrains/kotlin/doctor/diagnostics/xcode/XcodeEnvironmentDiagnosis;", "()V", "check", "Lorg/jetbrains/kotlin/doctor/diagnostics/MultiStepsEnvironmentDiagnosis$Result;", "builder", "Lorg/jetbrains/kotlin/doctor/entity/Diagnosis$Builder;", "context", "Lorg/jetbrains/kotlin/doctor/diagnostics/xcode/XcodeEnvironmentDiagnosis$Context;", "(Lorg/jetbrains/kotlin/doctor/entity/Diagnosis$Builder;Lorg/jetbrains/kotlin/doctor/diagnostics/xcode/XcodeEnvironmentDiagnosis$Context;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "kdoctor-checks"})
@SourceDebugExtension(value={"SMAP\nAppleSimulatorRuntimesDiagnosis.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppleSimulatorRuntimesDiagnosis.kt\norg/jetbrains/kotlin/doctor/diagnostics/xcode/AppleSimulatorRuntimesDiagnosis\n+ 2 SimctlUtil.kt\norg/jetbrains/kotlin/doctor/diagnostics/xcode/SimctlUtilKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 4 Json.kt\nkotlinx/serialization/json/Json\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n16#2:77\n17#2:86\n408#3,4:78\n384#3,4:82\n96#4:87\n766#5:88\n857#5,2:89\n1747#5,3:91\n*S KotlinDebug\n*F\n+ 1 AppleSimulatorRuntimesDiagnosis.kt\norg/jetbrains/kotlin/doctor/diagnostics/xcode/AppleSimulatorRuntimesDiagnosis\n*L\n41#1:77\n41#1:86\n41#1:78,4\n41#1:82,4\n41#1:87\n46#1:88\n46#1:89,2\n58#1:91,3\n*E\n"})
public final class AppleSimulatorRuntimesDiagnosis
implements XcodeEnvironmentDiagnosis {
    @NotNull
    public static final AppleSimulatorRuntimesDiagnosis INSTANCE = new AppleSimulatorRuntimesDiagnosis();

    private AppleSimulatorRuntimesDiagnosis() {
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object check(@NotNull Diagnosis.Builder var1_1, @NotNull XcodeEnvironmentDiagnosis.Context var2_2, @NotNull Continuation<? super MultiStepsEnvironmentDiagnosis.Result> var3_3) {
        if (!(var3_3 instanceof check.1)) ** GOTO lbl-1000
        var28_4 = var3_3;
        if ((var28_4.label & -2147483648) != 0) {
            var28_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ AppleSimulatorRuntimesDiagnosis this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.check(null, null, (Continuation<? super MultiStepsEnvironmentDiagnosis.Result>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var29_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$check_u24lambda_u242 = context.getSystem();
                $i$a$-with-AppleSimulatorRuntimesDiagnosis$check$2 = false;
                $continuation.L$0 = builder;
                $continuation.L$1 = context;
                $continuation.L$2 = $this$check_u24lambda_u242;
                $continuation.label = 1;
                v0 = SimctlUtilKt.listAvailableRuntimes($this$check_u24lambda_u242, context.getPlatform(), (Continuation<? super ListRuntimeResult>)$continuation);
                if (v0 == var29_6) {
                    return var29_6;
                }
                ** GOTO lbl29
            }
            case 1: {
                $i$a$-with-AppleSimulatorRuntimesDiagnosis$check$2 = false;
                $this$check_u24lambda_u242 = (System)$continuation.L$2;
                context = (XcodeEnvironmentDiagnosis.Context)$continuation.L$1;
                builder = (Diagnosis.Builder)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl29:
                // 2 sources

                if (Intrinsics.areEqual((Object)(result = (ListRuntimeResult)v0), (Object)ListRuntimeResult.ErrorList.INSTANCE)) {
                    var7_10 = new String[]{"Couldn't list available Apple Simulator Runtimes"};
                    return MultiStepsEnvironmentDiagnosisKt.stopWithFailure(builder, var7_10);
                }
                if (result instanceof ListRuntimeResult.ErrorDecode) {
                    var7_11 = new String[]{SimctlUtilKt.reportUnableToDecode("available Apple Simulator Runtimes", ((ListRuntimeResult.ErrorDecode)result).getTriedDecoding())};
                    return MultiStepsEnvironmentDiagnosisKt.stopWithFailure(builder, var7_11);
                }
                if (!(result instanceof ListRuntimeResult.Runtimes)) {
                    throw new NoWhenBranchMatchedException();
                }
                runtimes = ((ListRuntimeResult.Runtimes)result).getRuntimes();
                if (!runtimes.isEmpty()) break;
                result = new String[3];
                result[0] = "No Apple Simulator Runtime found.";
                result[1] = "Install missing Apple Simulator Runtimes for missing platform with:";
                var9_14 = 2;
                var10_16 = result;
                var11_18 = builder;
                $continuation.L$0 = result;
                $continuation.L$1 = var10_16;
                $continuation.L$2 = var11_18;
                $continuation.I$0 = var9_14;
                $continuation.label = 2;
                v1 = SimctlUtilKt.suggestCommandWithCurrentXcode($this$check_u24lambda_u242, "xcodebuild -downloadPlatform " + context.getPlatform().name(), (Continuation<? super String>)$continuation);
                if (v1 == var29_6) {
                    return var29_6;
                }
                ** GOTO lbl62
            }
            case 2: {
                $i$a$-with-AppleSimulatorRuntimesDiagnosis$check$2 = false;
                var9_14 = $continuation.I$0;
                var11_18 = (Diagnosis.Builder)$continuation.L$2;
                var10_16 = (String[])$continuation.L$1;
                result = (String[])$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl62:
                // 2 sources

                var10_16[var9_14] = var12_20 = v1;
                return MultiStepsEnvironmentDiagnosisKt.stopWithFailure(var11_18, result);
            }
        }
        sdkType = XcodeModelKt.toAppleSdkType(context.getPlatform(), true);
        $continuation.L$0 = builder;
        $continuation.L$1 = context;
        $continuation.L$2 = $this$check_u24lambda_u242;
        $continuation.L$3 = sdkType;
        $continuation.L$4 = runtimes;
        $continuation.label = 3;
        v2 = AppleSdk.Companion.findAppleSdk($this$check_u24lambda_u242, sdkType, (Continuation<? super AppleSdk>)$continuation);
        if (v2 == var29_6) {
            return var29_6;
        }
        ** GOTO lbl84
        {
            case 3: {
                $i$a$-with-AppleSimulatorRuntimesDiagnosis$check$2 = false;
                runtimes = (List<AppleSimulatorRuntime>)$continuation.L$4;
                sdkType = (AppleSdk.Type)$continuation.L$3;
                $this$check_u24lambda_u242 = (System)$continuation.L$2;
                context = (XcodeEnvironmentDiagnosis.Context)$continuation.L$1;
                builder = (Diagnosis.Builder)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl84:
                // 2 sources

                v3 = (AppleSdk)v2;
                if (v3 == null) {
                    var14_22 = new String[]{"Couldn't find Apple SDK for " + sdkType};
                    return MultiStepsEnvironmentDiagnosisKt.stopWithFailure(builder, var14_22);
                }
                sdk = v3;
                var15_24 = new String[]{"runtime", "match", "list", "-j"};
                $continuation.L$0 = builder;
                $continuation.L$1 = context;
                $continuation.L$2 = $this$check_u24lambda_u242;
                $continuation.L$3 = sdk;
                $continuation.L$4 = runtimes;
                $continuation.label = 4;
                v4 = SimctlUtilKt.simctl($this$check_u24lambda_u242, var15_24, (Continuation<? super ProcessResult>)$continuation);
                if (v4 == var29_6) {
                    return var29_6;
                }
                ** GOTO lbl109
            }
            case 4: {
                $i$a$-with-AppleSimulatorRuntimesDiagnosis$check$2 = false;
                runtimes = (List)$continuation.L$4;
                sdk = (AppleSdk)$continuation.L$3;
                $this$check_u24lambda_u242 = (System)$continuation.L$2;
                context = (XcodeEnvironmentDiagnosis.Context)$continuation.L$1;
                builder = (Diagnosis.Builder)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl109:
                // 2 sources

                v5 = ((ProcessResult)v4).getOutput();
                if (v5 == null) {
                    var15_24 = new String[]{"Couldn't find Apple Simulator Runtimes' compatibility list"};
                    return MultiStepsEnvironmentDiagnosisKt.stopWithFailure(builder, var15_24);
                }
                runtimeMatchList = v5;
                try {
                    $i$f$simctlDecodeFromString = false;
                    $this$dropWhile$iv$iv = runtimeMatchList;
                    $i$f$dropWhile = false;
                    var19_37 = $this$dropWhile$iv$iv.length();
                    for (index$iv$iv = 0; index$iv$iv < var19_37; ++index$iv$iv) {
                        it$iv = $this$dropWhile$iv$iv.charAt(index$iv$iv);
                        $i$a$-dropWhile-SimctlUtilKt$simctlDecodeFromString$cleanedString$1$iv = 0;
                        if (it$iv != '{') continue;
                        v6 = $this$dropWhile$iv$iv.substring(index$iv$iv);
                        v7 = v6;
                        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"substring(...)");
                        ** GOTO lbl129
                    }
                    v7 = "";
lbl129:
                    // 2 sources

                    $this$dropLastWhile$iv$iv = v7;
                    $i$f$dropLastWhile = false;
                    for (index$iv$iv = StringsKt.getLastIndex((CharSequence)$this$dropLastWhile$iv$iv); -1 < index$iv$iv; --index$iv$iv) {
                        it$iv = $this$dropLastWhile$iv$iv.charAt(index$iv$iv);
                        $i$a$-dropLastWhile-SimctlUtilKt$simctlDecodeFromString$cleanedString$2$iv = 0;
                        if (it$iv != '}') continue;
                        it$iv = $this$dropLastWhile$iv$iv;
                        $i$a$-dropLastWhile-SimctlUtilKt$simctlDecodeFromString$cleanedString$2$iv = 0;
                        $i$a$-dropWhile-SimctlUtilKt$simctlDecodeFromString$cleanedString$1$iv = index$iv$iv + 1;
                        v8 = it$iv.substring($i$a$-dropLastWhile-SimctlUtilKt$simctlDecodeFromString$cleanedString$2$iv, $i$a$-dropWhile-SimctlUtilKt$simctlDecodeFromString$cleanedString$1$iv);
                        v9 = v8;
                        Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"substring(...)");
                        ** GOTO lbl143
                    }
                    v9 = "";
lbl143:
                    // 2 sources

                    cleanedString$iv = v9;
                    this_$iv$iv = SimctlUtilKt.access$getSimctlJson$p();
                    $i$f$decodeFromString = false;
                    this_$iv$iv.getSerializersModule();
                    $i$f$simctlDecodeFromString = (Map)this_$iv$iv.decodeFromString((DeserializationStrategy)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, RuntimeMatchListValue.Companion.serializer()), cleanedString$iv);
                }
                catch (IllegalArgumentException this_$iv$iv) {
                    $i$f$decodeFromString = new String[]{SimctlUtilKt.reportUnableToDecode("matching Apple Simulator Runtimes", runtimeMatchList)};
                    return MultiStepsEnvironmentDiagnosisKt.stopWithFailure(builder, $i$f$decodeFromString);
                }
                matching = $i$f$simctlDecodeFromString;
                $this$filter$iv = runtimes;
                $i$f$filter = false;
                index$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    runtime = (AppleSimulatorRuntime)element$iv$iv;
                    $i$a$-filter-AppleSimulatorRuntimesDiagnosis$check$2$sdkSupportedRuntimes$1 = false;
                    v10 = !Intrinsics.areEqual((Object)runtime.getVersion(), (Object)sdk.getVersion()) ? true : ((RuntimeMatchListValue)matching.get(key = XcodeModelKt.toAppleSdkType(runtime.getPlatform(), false).name() + runtime.getVersion()) == null ? false : (value.getPreferredBuild() == null ? true : Intrinsics.areEqual((Object)value.getChosenRuntimeBuild(), (Object)value.getPreferredBuild())));
                    if (!v10) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                sdkSupportedRuntimes = (List)destination$iv$iv;
                $this$any$iv = sdkSupportedRuntimes;
                $i$f$any = false;
                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl175
                v11 = false;
                ** GOTO lbl182
lbl175:
                // 2 sources

                for (T element$iv : $this$any$iv) {
                    it = (AppleSimulatorRuntime)element$iv;
                    $i$a$-any-AppleSimulatorRuntimesDiagnosis$check$2$hasRuntimeMatchingVersionSdk$1 = false;
                    if (!Intrinsics.areEqual((Object)it.getVersion(), (Object)sdk.getVersion())) continue;
                    v11 = true;
                    ** GOTO lbl182
                }
                v11 = hasRuntimeMatchingVersionSdk = false;
lbl182:
                // 3 sources

                if (hasRuntimeMatchingVersionSdk) break;
                var17_33 = new String[4];
                var17_33[0] = "No compatible Apple Simulator Runtime found for used SDK: " + sdk;
                var17_33[1] = "Found Apple Simulator Runtimes:" + CollectionsKt.joinToString$default((Iterable)runtimes, (CharSequence)",\n- ", (CharSequence)"\n- ", (CharSequence)".", (int)0, null, null, (int)56, null);
                var17_33[2] = "Install missing Apple Simulator Runtimes for missing platform with:";
                var9_15 = 3;
                var10_17 = var17_33;
                var11_19 = var1_1;
                $continuation.L$0 = var10_17;
                $continuation.L$1 = var11_19;
                $continuation.L$2 = var17_33;
                $continuation.L$3 = null;
                $continuation.L$4 = null;
                $continuation.I$0 = var9_15;
                $continuation.label = 5;
                v12 = SimctlUtilKt.suggestCommandWithCurrentXcode($this$check_u24lambda_u242, "xcodebuild -downloadPlatform " + context.getPlatform().name(), (Continuation<? super String>)$continuation);
                if (v12 == var29_6) {
                    return var29_6;
                }
                ** GOTO lbl209
            }
            case 5: {
                $i$a$-with-AppleSimulatorRuntimesDiagnosis$check$2 = false;
                var9_15 = $continuation.I$0;
                var17_33 = (String[])$continuation.L$2;
                var11_19 = (Diagnosis.Builder)$continuation.L$1;
                var10_17 = (String[])$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v12 = $result;
lbl209:
                // 2 sources

                var10_17[var9_15] = var12_21 = v12;
                return MultiStepsEnvironmentDiagnosisKt.stopWithFailure(var11_19, var17_33);
            }
        }
        return MultiStepsEnvironmentDiagnosis.Result.Success;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }
}

