/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.doctor.diagnostics;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.doctor.diagnostics.CocoapodsDiagnostic;
import org.jetbrains.kotlin.doctor.diagnostics.Diagnostic;
import org.jetbrains.kotlin.doctor.entity.BinApplication;
import org.jetbrains.kotlin.doctor.entity.Diagnosis;
import org.jetbrains.kotlin.doctor.entity.DiagnosisEntry;
import org.jetbrains.kotlin.doctor.entity.DiagnosisResult;
import org.jetbrains.kotlin.doctor.entity.EnvironmentPiece;
import org.jetbrains.kotlin.doctor.entity.ProcessResult;
import org.jetbrains.kotlin.doctor.entity.Shell;
import org.jetbrains.kotlin.doctor.entity.System;
import org.jetbrains.kotlin.doctor.entity.SystemKt;
import org.jetbrains.kotlin.doctor.entity.Version;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\nH\u0096@\u00a2\u0006\u0002\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/doctor/diagnostics/CocoapodsDiagnostic;", "Lorg/jetbrains/kotlin/doctor/diagnostics/Diagnostic;", "system", "Lorg/jetbrains/kotlin/doctor/entity/System;", "(Lorg/jetbrains/kotlin/doctor/entity/System;)V", "title", "", "getTitle", "()Ljava/lang/String;", "diagnose", "Lorg/jetbrains/kotlin/doctor/entity/Diagnosis;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "kdoctor-checks"})
@SourceDebugExtension(value={"SMAP\nCocoapodsDiagnostic.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CocoapodsDiagnostic.kt\norg/jetbrains/kotlin/doctor/diagnostics/CocoapodsDiagnostic\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,120:1\n288#2,2:121\n288#2,2:123\n*S KotlinDebug\n*F\n+ 1 CocoapodsDiagnostic.kt\norg/jetbrains/kotlin/doctor/diagnostics/CocoapodsDiagnostic\n*L\n94#1:121,2\n95#1:123,2\n*E\n"})
public final class CocoapodsDiagnostic
extends Diagnostic {
    @NotNull
    private final System system;
    @NotNull
    private final String title;

    public CocoapodsDiagnostic(@NotNull System system) {
        Intrinsics.checkNotNullParameter((Object)system, (String)"system");
        this.system = system;
        this.title = "CocoaPods";
    }

    @Override
    @NotNull
    public String getTitle() {
        return this.title;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    @Nullable
    public Object diagnose(@NotNull Continuation<? super Diagnosis> var1_1) {
        if (!(var1_1 instanceof diagnose.1)) ** GOTO lbl-1000
        var22_2 = var1_1;
        if ((var22_2.label & -2147483648) != 0) {
            var22_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                /* synthetic */ Object result;
                final /* synthetic */ CocoapodsDiagnostic this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.diagnose((Continuation<? super Diagnosis>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var23_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                result = new Diagnosis.Builder(this.getTitle());
                $continuation.L$0 = this;
                $continuation.L$1 = result;
                $continuation.label = 1;
                v0 = this.system.which("ruby", (Continuation<? super String>)$continuation);
                if (v0 == var23_4) {
                    return var23_4;
                }
                ** GOTO lbl25
            }
            case 1: {
                result = (Diagnosis.Builder)$continuation.L$1;
                this = (CocoapodsDiagnostic)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                rubyLocation = (String)v0;
                var5_7 = new String[]{"-v"};
                $continuation.L$0 = this;
                $continuation.L$1 = result;
                $continuation.L$2 = rubyLocation;
                $continuation.label = 2;
                v1 = this.system.execute("ruby", var5_7, (Continuation<? super ProcessResult>)$continuation);
                if (v1 == var23_4) {
                    return var23_4;
                }
                ** GOTO lbl41
            }
            case 2: {
                rubyLocation = (String)$continuation.L$2;
                result = (Diagnosis.Builder)$continuation.L$1;
                this = (CocoapodsDiagnostic)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl41:
                // 2 sources

                rubyVersion = ((ProcessResult)v1).getOutput();
                if (rubyLocation == null || rubyVersion == null) {
                    var5_7 = new String[]{"ruby not found", "Get ruby from https://www.ruby-lang.org/en/documentation/installation/"};
                    result.addFailure(var5_7);
                    return CocoapodsDiagnostic.diagnose$buildWithRecommendation(result);
                }
                ruby = new BinApplication("ruby", new Version(rubyVersion), rubyLocation);
                var6_9 = new String[]{ruby.getName() + " (" + ruby.getVersion() + ")"};
                result.addSuccess(var6_9);
                if (!Intrinsics.areEqual((Object)ruby.getLocation(), (Object)"/usr/bin/ruby")) ** GOTO lbl73
                title = "System ruby is currently used";
                $continuation.L$0 = this;
                $continuation.L$1 = result;
                $continuation.L$2 = ruby;
                $continuation.L$3 = title;
                $continuation.label = 3;
                v2 = SystemKt.isUsingM1(this.system, (Continuation<? super Boolean>)$continuation);
                if (v2 == var23_4) {
                    return var23_4;
                }
                ** GOTO lbl67
            }
            case 3: {
                title = (String)$continuation.L$3;
                ruby = (BinApplication)$continuation.L$2;
                result = (Diagnosis.Builder)$continuation.L$1;
                this = (CocoapodsDiagnostic)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl67:
                // 2 sources

                if (((Boolean)v2).booleanValue()) {
                    var7_10 = new String[]{title, "CocoaPods is not compatible with system ruby installation on Apple M1 computers.", "Please install ruby via Homebrew, rvm, rbenv or other tool and make it default", "Detailed information: https://stackoverflow.com/questions/64901180/how-to-run-cocoapods-on-apple-silicon-m1/66556339#66556339"};
                    result.addFailure(var7_10);
                } else {
                    var7_10 = new String[]{title, "Consider installing ruby via Homebrew, rvm or other package manager in case of issues with CocoaPods installation"};
                    result.addInfo(var7_10);
                }
lbl73:
                // 3 sources

                var7_10 = new String[]{"-v"};
                $continuation.L$0 = this;
                $continuation.L$1 = result;
                $continuation.L$2 = ruby;
                $continuation.L$3 = null;
                $continuation.label = 4;
                v3 = this.system.execute("gem", var7_10, (Continuation<? super ProcessResult>)$continuation);
                if (v3 == var23_4) {
                    return var23_4;
                }
                ** GOTO lbl89
            }
            case 4: {
                ruby = (BinApplication)$continuation.L$2;
                result = (Diagnosis.Builder)$continuation.L$1;
                this = (CocoapodsDiagnostic)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl89:
                // 2 sources

                if ((rubyGemsVersion = ((ProcessResult)v3).getOutput()) == null) {
                    var7_10 = new String[]{"ruby gems not found", "Get ruby gems from https://rubygems.org/pages/download"};
                    result.addFailure(var7_10);
                    return CocoapodsDiagnostic.diagnose$buildWithRecommendation(result);
                }
                gems = new BinApplication("ruby gems", new Version(rubyGemsVersion), null, 4, null);
                var8_11 = new String[]{gems.getName() + " (" + gems.getVersion() + ")"};
                result.addSuccess(var8_11);
                cocoapods = null;
                var11_12 = new String[]{"--version"};
                $continuation.L$0 = this;
                $continuation.L$1 = result;
                $continuation.L$2 = ruby;
                $continuation.L$3 = gems;
                $continuation.label = 5;
                v4 = this.system.execute("pod", var11_12, (Continuation<? super ProcessResult>)$continuation);
                if (v4 == var23_4) {
                    return var23_4;
                }
                ** GOTO lbl115
            }
            case 5: {
                cocoapods = null;
                gems = (BinApplication)$continuation.L$3;
                ruby = (BinApplication)$continuation.L$2;
                result = (Diagnosis.Builder)$continuation.L$1;
                this = (CocoapodsDiagnostic)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl115:
                // 2 sources

                v5 = (v6 = ((ProcessResult)v4).getOutput()) != null && (v6 = StringsKt.lines((CharSequence)((CharSequence)v6))) != null ? (String)CollectionsKt.last((List)v6) : (cocoapodsVersionOutput = null);
                if (cocoapodsVersionOutput != null) {
                    cocoapodsVersion = new Version(cocoapodsVersionOutput);
                    cocoapods = new BinApplication("cocoapods", cocoapodsVersion, null, 4, null);
                }
                if (cocoapods != null) break;
                var11_12 = new String[]{"list", "cocoapods", "--versions"};
                $continuation.L$0 = result;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.L$3 = null;
                $continuation.label = 6;
                v7 = this.system.execute("brew", var11_12, (Continuation<? super ProcessResult>)$continuation);
                if (v7 == var23_4) {
                    return var23_4;
                }
                ** GOTO lbl134
            }
            case 6: {
                result = (Diagnosis.Builder)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v7 = $result;
lbl134:
                // 2 sources

                v8 = cocoapodsBrewInstallation != null ? StringsKt.isBlank((CharSequence)((CharSequence)(cocoapodsBrewInstallation = ((ProcessResult)v7).getOutput()))) == false : false;
                if (v8) {
                    var11_12 = new String[]{"CocoaPods are installed via Homebrew but not linked to /usr/local/bin", "Execute 'brew link --overwrite cocoapods'"};
                    result.addFailure(var11_12);
                } else {
                    var11_12 = new String[]{"cocoapods not found", "Get cocoapods from https://guides.cocoapods.org/using/getting-started.html#installation"};
                    result.addFailure(var11_12);
                }
                return CocoapodsDiagnostic.diagnose$buildWithRecommendation(result);
            }
        }
        cocoapodsBrewInstallation = new String[]{cocoapods.getName() + " (" + cocoapods.getVersion() + ")"};
        result.addSuccess(cocoapodsBrewInstallation);
        $continuation.L$0 = this;
        $continuation.L$1 = result;
        $continuation.L$2 = ruby;
        $continuation.L$3 = gems;
        $continuation.L$4 = cocoapods;
        $continuation.label = 7;
        v9 = this.system.execute("/usr/bin/locale", new String[0], (Continuation<? super ProcessResult>)$continuation);
        if (v9 == var23_4) {
            return var23_4;
        }
        ** GOTO lbl162
        {
            case 7: {
                cocoapods = (BinApplication)$continuation.L$4;
                gems = (BinApplication)$continuation.L$3;
                ruby = (BinApplication)$continuation.L$2;
                result = (Diagnosis.Builder)$continuation.L$1;
                this = (CocoapodsDiagnostic)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v9 = $result;
lbl162:
                // 2 sources

                if ((v10 = (locale = ((ProcessResult)v9).getOutput())) == null || (v10 = StringsKt.lines((CharSequence)((CharSequence)v10))) == null) ** GOTO lbl-1000
                $this$firstOrNull$iv = (Iterable)v10;
                $i$f$firstOrNull = false;
                var16_19 = $this$firstOrNull$iv.iterator();
                while (var16_19.hasNext()) {
                    element$iv = var16_19.next();
                    it = (String)element$iv;
                    $i$a$-firstOrNull-CocoapodsDiagnostic$diagnose$lang$1 = false;
                    if (!StringsKt.startsWith$default((String)it, (String)"LANG=", (boolean)false, (int)2, null)) continue;
                    v11 = element$iv;
                    ** GOTO lbl174
                }
                v11 = null;
lbl174:
                // 2 sources

                if ((v10 = (String)v11) != null) {
                    v12 = StringsKt.substringAfter$default((String)v10, (String)"=", null, (int)2, null);
                } else lbl-1000:
                // 2 sources

                {
                    v12 = lang = null;
                }
                if ((v13 = locale) == null || (v13 = StringsKt.lines((CharSequence)((CharSequence)v13))) == null) ** GOTO lbl-1000
                $this$firstOrNull$iv = (Iterable)v13;
                $i$f$firstOrNull = false;
                for (E element$iv : $this$firstOrNull$iv) {
                    it = (String)element$iv;
                    $i$a$-firstOrNull-CocoapodsDiagnostic$diagnose$lcAll$1 = false;
                    if (!StringsKt.startsWith$default((String)it, (String)"LC_ALL=", (boolean)false, (int)2, null)) continue;
                    v14 = element$iv;
                    ** GOTO lbl188
                }
                v14 = null;
lbl188:
                // 2 sources

                if ((v13 = (String)v14) != null) {
                    v15 = StringsKt.substringAfter$default((String)v13, (String)"=", null, (int)2, null);
                } else lbl-1000:
                // 2 sources

                {
                    v15 = null;
                }
                lcAll = v15;
                $this$diagnose_u24lambda_u242 = $this$firstOrNull$iv = new StringBuilder();
                $i$a$-buildString-CocoapodsDiagnostic$diagnose$exportHint$1 = false;
                var17_22 = lang;
                if (var17_22 == null || var17_22.length() == 0 || !StringsKt.contains$default((CharSequence)lang, (CharSequence)"UTF-8", (boolean)false, (int)2, null)) {
                    v16 = $this$diagnose_u24lambda_u242.append("export LANG=en_US.UTF-8");
                    Intrinsics.checkNotNullExpressionValue((Object)v16, (String)"append(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)v16.append('\n'), (String)"append(...)");
                }
                if ((var17_22 = (CharSequence)lcAll) == null || var17_22.length() == 0 || !StringsKt.contains$default((CharSequence)lcAll, (CharSequence)"UTF-8", (boolean)false, (int)2, null)) {
                    v17 = $this$diagnose_u24lambda_u242.append("export LC_ALL=en_US.UTF-8");
                    Intrinsics.checkNotNullExpressionValue((Object)v17, (String)"append(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)v17.append('\n'), (String)"append(...)");
                }
                v18 = $this$firstOrNull$iv.toString();
                Intrinsics.checkNotNullExpressionValue((Object)v18, (String)"toString(...)");
                exportHint = StringsKt.trim((CharSequence)v18).toString();
                if (!(((CharSequence)exportHint).length() > 0)) ** GOTO lbl238
                $continuation.L$0 = result;
                $continuation.L$1 = ruby;
                $continuation.L$2 = gems;
                $continuation.L$3 = cocoapods;
                $continuation.L$4 = exportHint;
                $continuation.label = 8;
                v19 = this.system.getShell().await((Continuation)$continuation);
                if (v19 == var23_4) {
                    return var23_4;
                }
                ** GOTO lbl229
            }
            case 8: {
                exportHint = (String)$continuation.L$4;
                cocoapods = (BinApplication)$continuation.L$3;
                gems = (BinApplication)$continuation.L$2;
                ruby = (BinApplication)$continuation.L$1;
                result = (Diagnosis.Builder)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v19 = $result;
lbl229:
                // 2 sources

                if ((v20 /* !! */  = (Shell)v19) == null || (v20 /* !! */  = v20 /* !! */ .getProfile()) == null) {
                    v20 /* !! */  = "shell profile";
                }
                hint = "Consider adding the following to " + (String)v20 /* !! */ ;
                if (cocoapods.getVersion().compareTo(new Version(1, 10, Boxing.boxInt((int)2), null, null, 24, null)) > 0) {
                    var15_18 = new String[]{"CocoaPods requires your terminal to be using UTF-8 encoding.", hint, exportHint};
                    result.addFailure(var15_18);
                } else {
                    var15_18 = new String[]{"CocoaPods requires your terminal to be using UTF-8 encoding.", hint, exportHint};
                    result.addWarning(var15_18);
                }
lbl238:
                // 3 sources

                var14_15 = new EnvironmentPiece[]{EnvironmentPiece.Companion.Ruby(ruby.getVersion()), EnvironmentPiece.Companion.RubyGems(gems.getVersion()), EnvironmentPiece.Companion.Cocoapods(cocoapods.getVersion())};
                result.addEnvironment(var14_15);
                return CocoapodsDiagnostic.diagnose$buildWithRecommendation(result);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final Diagnosis diagnose$buildWithRecommendation(Diagnosis.Builder $this$diagnose_u24buildWithRecommendation) {
        Diagnosis original = $this$diagnose_u24buildWithRecommendation.build();
        if (original.getConclusion() == DiagnosisResult.Failure) {
            DiagnosisEntry info = new DiagnosisEntry(DiagnosisResult.Warning, "CocoaPods configuration is not required, but highly recommended for full-fledged development");
            DiagnosisResult diagnosisResult = DiagnosisResult.Warning;
            List list2 = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)info), (Iterable)original.getEntries());
            return Diagnosis.copy$default(original, null, list2, null, diagnosisResult, 5, null);
        }
        return original;
    }
}

