/*
 * Decompiled with CFR 0.152.
 */
package fleet.git.frontend;

import fleet.git.frontend.GitLogEntitiesKt;
import fleet.git.protocol.VcsRemoteBranch;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\tJ\t\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lfleet/git/frontend/GitRemoteBranch;", "", "remote", "Lfleet/git/protocol/VcsRemoteBranch;", "(Lfleet/git/protocol/VcsRemoteBranch;)V", "ref", "", "remoteName", "branchName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getBranchName", "()Ljava/lang/String;", "getRef", "getRemoteName", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "fleet.git.frontend"})
public final class GitRemoteBranch {
    @NotNull
    private final String ref;
    @NotNull
    private final String remoteName;
    @NotNull
    private final String branchName;

    public GitRemoteBranch(@NotNull String ref2, @NotNull String remoteName, @NotNull String branchName) {
        Intrinsics.checkNotNullParameter((Object)ref2, (String)"ref");
        Intrinsics.checkNotNullParameter((Object)remoteName, (String)"remoteName");
        Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
        this.ref = ref2;
        this.remoteName = remoteName;
        this.branchName = branchName;
    }

    @NotNull
    public final String getRef() {
        return this.ref;
    }

    @NotNull
    public final String getRemoteName() {
        return this.remoteName;
    }

    @NotNull
    public final String getBranchName() {
        return this.branchName;
    }

    public GitRemoteBranch(@NotNull VcsRemoteBranch remote) {
        Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
        this(remote.getRef(), remote.getRemoteName(), StringsKt.removePrefix((String)GitLogEntitiesKt.stripRefsPrefix(remote.getRef()), (CharSequence)(remote.getRemoteName() + "/")));
    }

    @NotNull
    public final String component1() {
        return this.ref;
    }

    @NotNull
    public final String component2() {
        return this.remoteName;
    }

    @NotNull
    public final String component3() {
        return this.branchName;
    }

    @NotNull
    public final GitRemoteBranch copy(@NotNull String ref2, @NotNull String remoteName, @NotNull String branchName) {
        Intrinsics.checkNotNullParameter((Object)ref2, (String)"ref");
        Intrinsics.checkNotNullParameter((Object)remoteName, (String)"remoteName");
        Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
        return new GitRemoteBranch(ref2, remoteName, branchName);
    }

    public static /* synthetic */ GitRemoteBranch copy$default(GitRemoteBranch gitRemoteBranch, String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = gitRemoteBranch.ref;
        }
        if ((n & 2) != 0) {
            string2 = gitRemoteBranch.remoteName;
        }
        if ((n & 4) != 0) {
            string3 = gitRemoteBranch.branchName;
        }
        return gitRemoteBranch.copy(string, string2, string3);
    }

    @NotNull
    public String toString() {
        return "GitRemoteBranch(ref=" + this.ref + ", remoteName=" + this.remoteName + ", branchName=" + this.branchName + ")";
    }

    public int hashCode() {
        int result2 = this.ref.hashCode();
        result2 = result2 * 31 + this.remoteName.hashCode();
        result2 = result2 * 31 + this.branchName.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GitRemoteBranch)) {
            return false;
        }
        GitRemoteBranch gitRemoteBranch = (GitRemoteBranch)other;
        if (!Intrinsics.areEqual((Object)this.ref, (Object)gitRemoteBranch.ref)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.remoteName, (Object)gitRemoteBranch.remoteName)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.branchName, (Object)gitRemoteBranch.branchName);
    }
}

