/*
 * Decompiled with CFR 0.152.
 */
package fleet.plugins.devkit.frontend;

import androidx.compose.runtime.Composable;
import androidx.compose.runtime.CompositionLocal;
import fleet.frontend.layout.WindowEntity;
import fleet.frontend.layout.WindowEntityKt;
import fleet.frontend.ui.gotoPanel.GotoProvider;
import fleet.frontend.ui.gotoPanel.GotoProviderFactory;
import fleet.frontend.ui.gotoPanel.GotoProviderWithTextDescription;
import fleet.frontend.ui.layout.window.WindowViewKt;
import fleet.plugins.devkit.frontend.ResizeWindowGotoProviderKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import noria.NoriaContext;
import noria.ReadScope;
import noria.model.ActionContext;
import noria.model.ActionsKt;
import noria.model.CommonTrigger;
import noria.model.Trigger;
import noria.windowManagement.api.Size;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J+\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\b\u0010\u0012\u001a\u00020\bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u0014"}, d2={"Lfleet/plugins/devkit/frontend/ResizeWindowGotoProvider;", "Lfleet/frontend/ui/gotoPanel/GotoProviderWithTextDescription;", "oldSize", "Lnoria/windowManagement/api/Size;", "(Lnoria/windowManagement/api/Size;)V", "SIZE", "Lkotlin/text/Regex;", "initialQuery", "", "getInitialQuery", "()Ljava/lang/String;", "confirm", "Lkotlin/Result;", "actionContext", "Lnoria/model/ActionContext;", "query", "confirm-gIAlu-s", "(Lnoria/model/ActionContext;Ljava/lang/String;)Ljava/lang/Object;", "descriptionText", "Companion", "fleet.plugins.devkit.frontend"})
final class ResizeWindowGotoProvider
extends GotoProviderWithTextDescription {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Size oldSize;
    @NotNull
    private final Regex SIZE;
    @NotNull
    private static final GotoProviderFactory.ID ID = new GotoProviderFactory.ID("resize-window");

    public ResizeWindowGotoProvider(@NotNull Size oldSize) {
        Intrinsics.checkNotNullParameter((Object)oldSize, (String)"oldSize");
        this.oldSize = oldSize;
        this.SIZE = new Regex("(\\d+) (\\d+)");
    }

    @NotNull
    public String descriptionText() {
        return "Enter new window size: [width] [height]";
    }

    @NotNull
    public Object confirm-gIAlu-s(@NotNull ActionContext actionContext, @NotNull String query) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)actionContext, (String)"actionContext");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        MatchResult match = this.SIZE.matchEntire((CharSequence)query);
        if (match != null) {
            MatchGroup matchGroup = match.getGroups().get(1);
            Intrinsics.checkNotNull((Object)matchGroup);
            float width = Float.parseFloat(matchGroup.getValue());
            MatchGroup matchGroup2 = match.getGroups().get(2);
            Intrinsics.checkNotNull((Object)matchGroup2);
            float height = Float.parseFloat(matchGroup2.getValue());
            ActionsKt.performAction((ActionContext)actionContext.put(ResizeWindowGotoProviderKt.access$getNewSizeKey$p(), (Object)new Size(width, height)), (CommonTrigger)CommonTrigger.ResizeWindow);
            object = Result.constructor-impl((Object)"Resized");
        } else {
            object = Result.constructor-impl((Object)"Incorrect size");
        }
        return object;
    }

    @NotNull
    public String getInitialQuery() {
        return (int)this.oldSize.getWidth() + " " + (int)this.oldSize.getHeight();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u001a*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0018\u0010\u0015\u001a\u00020\u0002*\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001e"}, d2={"Lfleet/plugins/devkit/frontend/ResizeWindowGotoProvider$Companion;", "Lfleet/frontend/ui/gotoPanel/GotoProviderFactory;", "", "()V", "ID", "Lfleet/frontend/ui/gotoPanel/GotoProviderFactory$ID;", "getID", "()Lfleet/frontend/ui/gotoPanel/GotoProviderFactory$ID;", "name", "getName", "()Ljava/lang/String;", "plaqueText", "getPlaqueText", "trigger", "Lnoria/model/Trigger;", "getTrigger", "()Lnoria/model/Trigger;", "useSelectionForInitialQuery", "", "getUseSelectionForInitialQuery", "()Z", "placeholderText", "Lnoria/ReadScope;", "getPlaceholderText", "(Lnoria/ReadScope;)Ljava/lang/String;", "createProvider", "Lfleet/frontend/ui/gotoPanel/GotoProvider;", "Lnoria/NoriaContext;", "actionContext", "Lnoria/model/ActionContext;", "fleet.plugins.devkit.frontend"})
    public static final class Companion
    implements GotoProviderFactory<String> {
        private Companion() {
        }

        @NotNull
        public final GotoProviderFactory.ID getID() {
            return ID;
        }

        @NotNull
        public String getName() {
            return "Resize Window";
        }

        @NotNull
        public String getPlaqueText() {
            return "New size";
        }

        @Nullable
        public Trigger getTrigger() {
            return (Trigger)CommonTrigger.ShowResizeWindowDialog;
        }

        public boolean getUseSelectionForInitialQuery() {
            return false;
        }

        @Composable
        @NotNull
        public GotoProvider<String> createProvider(@NotNull NoriaContext $this$createProvider, @NotNull ActionContext actionContext) {
            Intrinsics.checkNotNullParameter((Object)$this$createProvider, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)actionContext, (String)"actionContext");
            return (GotoProvider)new ResizeWindowGotoProvider(WindowEntityKt.getWindowPosition((WindowEntity)((WindowEntity)$this$createProvider.getCurrent((CompositionLocal)WindowViewKt.getLocalWindowEntity()))).getSize());
        }

        @NotNull
        public String getPlaceholderText(@NotNull ReadScope $this$placeholderText) {
            Intrinsics.checkNotNullParameter((Object)$this$placeholderText, (String)"<this>");
            return "width height";
        }

        @NotNull
        public List<GotoProviderFactory.ID> getChildScopes() {
            return GotoProviderFactory.DefaultImpls.getChildScopes((GotoProviderFactory)this);
        }

        public boolean getReuseQueryFromOtherProviders() {
            return GotoProviderFactory.DefaultImpls.getReuseQueryFromOtherProviders((GotoProviderFactory)this);
        }

        @Composable
        @Nullable
        public String queryHint(@NotNull NoriaContext $this$queryHint) {
            return GotoProviderFactory.DefaultImpls.queryHint((GotoProviderFactory)this, (NoriaContext)$this$queryHint);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

