/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support.yaml;

import java.util.Iterator;
import org.clank.java.std_ptr;
import org.clank.support.JavaCleaner;
import org.clank.support.Native;
import org.clank.support.aliases.JavaIterator;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.support.java.MappingSequenceInterface;
import org.llvm.support.yaml.Document;
import org.llvm.support.yaml.KeyValueNode;
import org.llvm.support.yaml.Node;
import org.llvm.support.yaml.YamlGlobals;
import org.llvm.support.yaml.basic_collection_iterator;
import org.llvm.support.yaml.impl.Token;

public final class MappingNode
extends Node
implements Iterable<KeyValueNode>,
MappingSequenceInterface {
    private MappingType Type;
    private boolean IsAtBeginning;
    private boolean IsAtEnd;
    private KeyValueNode CurrentEntry;

    @Override
    protected void anchor() {
    }

    public MappingNode(std_ptr.unique_ptr<Document> D, StringRef Anchor, StringRef Tag2, MappingType MT) {
        super(Node.NodeKind.NK_Mapping.getValue(), D, new StringRef(Anchor), new StringRef(Tag2));
        this.Type = MT;
        this.IsAtBeginning = true;
        this.IsAtEnd = false;
        this.CurrentEntry = null;
    }

    public basic_collection_iterator<MappingNode, KeyValueNode> begin() {
        return YamlGlobals.begin(this);
    }

    public basic_collection_iterator<MappingNode, KeyValueNode> end() {
        return new basic_collection_iterator<MappingNode, KeyValueNode>();
    }

    @Override
    public void skip() {
        YamlGlobals.skip(this);
    }

    public static boolean classof(Node N) {
        return N.getType() == Node.NodeKind.NK_Mapping.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void increment() {
        Token T4 = null;
        if (this.failed()) {
            this.IsAtEnd = true;
            this.CurrentEntry = null;
            return;
        }
        if (this.CurrentEntry != null) {
            this.CurrentEntry.skip();
            if (this.Type == MappingType.MT_Inline) {
                this.IsAtEnd = true;
                this.CurrentEntry = null;
                return;
            }
        }
        T4 = new Token(this.peekNext());
        if (T4.Kind == Token.TokenKind.TK_Key || T4.Kind == Token.TokenKind.TK_Scalar) {
            this.CurrentEntry = (KeyValueNode)Node.$new(this.getAllocator(), New$Mem -> new KeyValueNode((std_ptr.unique_ptr<Document>)this.Doc));
            return;
        }
        if (this.Type == MappingType.MT_Block) {
            switch (T4.Kind) {
                case TK_BlockEnd: {
                    JavaCleaner $c$ = Native.$createJavaCleaner();
                    try {
                        $c$.clean((Object)((Token)$c$.track((Object)this.getNext())));
                        this.IsAtEnd = true;
                        this.CurrentEntry = null;
                        return;
                    }
                    finally {
                        $c$.$destroy();
                    }
                }
                default: {
                    this.setError(new Twine("Unexpected token. Expected Key or Block End"), T4);
                }
                case TK_Error: 
            }
            this.IsAtEnd = true;
            this.CurrentEntry = null;
            return;
        }
        switch (T4.Kind) {
            case TK_FlowEntry: {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean((Object)((Token)$c$.track((Object)this.getNext())));
                    this.increment();
                    return;
                }
                finally {
                    $c$.$destroy();
                }
            }
            case TK_FlowMappingEnd: {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean((Object)((Token)$c$.track((Object)this.getNext())));
                }
                finally {
                    $c$.$destroy();
                }
            }
            case TK_Error: {
                this.IsAtEnd = true;
                this.CurrentEntry = null;
                return;
            }
        }
        this.setError(new Twine("Unexpected token. Expected Key, Flow Entry, or Flow Mapping End."), T4);
        this.IsAtEnd = true;
        this.CurrentEntry = null;
        return;
        finally {
            if (T4 != null) {
                T4.$destroy();
            }
        }
    }

    @Override
    public Iterator<KeyValueNode> iterator() {
        return new JavaIterator(this.begin(), this.end());
    }

    @Override
    public boolean isAtBeginning() {
        return this.IsAtBeginning;
    }

    @Override
    public void setAtBeginning(boolean v) {
        this.IsAtBeginning = v;
    }

    @Override
    public boolean isAtEnd() {
        return this.IsAtEnd;
    }

    @Override
    public void setAtEnd(boolean v) {
        this.IsAtEnd = v;
    }

    @Override
    public KeyValueNode getCurrentEntry() {
        return this.CurrentEntry;
    }

    @Override
    public String toString() {
        return ", IsAtBeginning=" + this.IsAtBeginning + ", IsAtEnd=" + this.IsAtEnd + super.toString();
    }

    public static final class MappingType
    extends Enum<MappingType>
    implements Native.NativeUIntEnum {
        public static final /* enum */ MappingType MT_Block = new MappingType(0);
        public static final /* enum */ MappingType MT_Flow = new MappingType(MT_Block.getValue() + 1);
        public static final /* enum */ MappingType MT_Inline = new MappingType(MT_Flow.getValue() + 1);
        private final int value;
        private static final /* synthetic */ MappingType[] $VALUES;

        public static MappingType[] values() {
            return (MappingType[])$VALUES.clone();
        }

        public static MappingType valueOf(String name) {
            return Enum.valueOf(MappingType.class, name);
        }

        public static MappingType valueOf(int val) {
            MappingType out;
            MappingType mappingType = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private MappingType(int val) {
            this.value = val;
        }

        public final int getValue() {
            return this.value;
        }

        static {
            $VALUES = new MappingType[]{MT_Block, MT_Flow, MT_Inline};
        }

        private static final class Values {
            private static final MappingType[] VALUES;
            private static final MappingType[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (MappingType kind : MappingType.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new MappingType[min < 0 ? 1 - min : 0];
                VALUES = new MappingType[max >= 0 ? 1 + max : 0];
                for (MappingType kind : MappingType.values()) {
                    if (kind.value < 0) {
                        if (_VALUES[-kind.value] != null) continue;
                        Values._VALUES[-((MappingType)kind).value] = kind;
                        continue;
                    }
                    if (VALUES[kind.value] != null) continue;
                    Values.VALUES[((MappingType)kind).value] = kind;
                }
            }
        }
    }
}

