/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support.yaml;

import org.clank.java.std;
import org.clank.java.std_errors;
import org.clank.java.std_ptr;
import org.clank.java.stdimpl.aliases.StdVectorBool;
import org.clank.support.Casts;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.llvm.adt.ADTFunctionPointers;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.StringMap;
import org.llvm.adt.aliases.StringMapEntry;
import org.llvm.adt.java.ADTRTTI;
import org.llvm.support.BumpPtrAllocatorImpl;
import org.llvm.support.SourceMgr;
import org.llvm.support.llvm;
import org.llvm.support.yaml.BlockScalarNode;
import org.llvm.support.yaml.Document;
import org.llvm.support.yaml.IO;
import org.llvm.support.yaml.KeyValueNode;
import org.llvm.support.yaml.MappingNode;
import org.llvm.support.yaml.Node;
import org.llvm.support.yaml.NullNode;
import org.llvm.support.yaml.ScalarNode;
import org.llvm.support.yaml.SequenceNode;
import org.llvm.support.yaml.Stream;
import org.llvm.support.yaml.YamlGlobals;
import org.llvm.support.yaml.document_iterator;

public class Input
extends IO
implements Destructors.ClassWithDestructor {
    private SourceMgr SrcMgr = new SourceMgr();
    private std_ptr.unique_ptr<Stream> Strm;
    private std_ptr.unique_ptr<HNode> TopNode;
    private std_errors.error_code EC;
    private BumpPtrAllocatorImpl StringAllocator;
    private document_iterator DocIterator;
    private std.vectorBool BitValuesUsed;
    private HNode CurrentNode;
    private boolean ScalarMatchFound;

    public Input(StringRef InputContent) {
        this(InputContent, null, null, null);
    }

    public Input(StringRef InputContent, Object Ctxt) {
        this(InputContent, Ctxt, null, null);
    }

    public Input(StringRef InputContent, Object Ctxt, ADTFunctionPointers.DiagHandlerTy DiagHandler) {
        this(InputContent, Ctxt, DiagHandler, null);
    }

    public Input(StringRef InputContent, Object Ctxt, ADTFunctionPointers.DiagHandlerTy DiagHandler, Object DiagHandlerCtxt) {
        super(Ctxt);
        this.Strm = new std_ptr.unique_ptr((Object)new Stream(new StringRef(InputContent), this.SrcMgr));
        this.TopNode = new std_ptr.unique_ptr();
        this.EC = new std_errors.error_code();
        this.StringAllocator = new BumpPtrAllocatorImpl();
        this.DocIterator = new document_iterator();
        this.BitValuesUsed = new std.vectorBool();
        this.CurrentNode = null;
        if (DiagHandler != null) {
            this.SrcMgr.setDiagHandler(DiagHandler, DiagHandlerCtxt);
        }
        this.DocIterator.$assignMove(((Stream)this.Strm.$arrow()).begin());
    }

    @Override
    public void $destroy() {
        this.BitValuesUsed.$destroy();
        this.StringAllocator.$destroy();
        this.TopNode.$destroy();
        this.Strm.$destroy();
        this.SrcMgr.$destroy();
        super.$destroy();
    }

    public std_errors.error_code error() {
        return new std_errors.error_code(this.EC);
    }

    @Override
    public boolean outputting() {
        return false;
    }

    @Override
    public boolean mapTag(StringRef Tag2, boolean Default) {
        std.string foundTag = this.CurrentNode._node.getVerbatimTag();
        if (foundTag.empty()) {
            return Default;
        }
        return Tag2.equals(new StringRef(foundTag));
    }

    @Override
    public void beginMapping() {
        if (this.EC.$bool()) {
            return;
        }
        MapHNode MN = ADTRTTI.dyn_cast_or_null_MapHNode(this.CurrentNode);
        if (MN != null) {
            MN.ValidKeys.clear();
        }
    }

    @Override
    public void endMapping() {
        if (this.EC.$bool()) {
            return;
        }
        MapHNode MN = ADTRTTI.dyn_cast_or_null_MapHNode(this.CurrentNode);
        if (MN == null) {
            return;
        }
        for (StringMapEntry<std_ptr.unique_ptr<HNode>> stringMapEntry : MN.Mapping) {
            if (MN.isValidKey(stringMapEntry.first())) continue;
            this.setError((HNode)((std_ptr.unique_ptr)stringMapEntry.second).get(), llvm.$add_Twine$C(llvm.$add_Twine$C(new Twine("unknown key '"), new Twine(stringMapEntry.first())), new Twine(NativePointer.$SGL_QUOTE)));
            break;
        }
    }

    @Override
    public boolean preflightKey(char.ptr Key, boolean Required, boolean $Prm2, bool.ref UseDefault, type.ref<Object> SaveInfo) {
        UseDefault.$set(false);
        if (this.EC.$bool()) {
            return false;
        }
        if (this.CurrentNode == null) {
            if (Required) {
                this.EC.$assignMove(llvm.make_error_code(std_errors.errc.invalid_argument));
            }
            return false;
        }
        MapHNode MN = ADTRTTI.dyn_cast_MapHNode(this.CurrentNode);
        if (MN == null) {
            this.setError(this.CurrentNode, new Twine("not a mapping"));
            return false;
        }
        MN.ValidKeys.push_back(Key);
        HNode Value = (HNode)MN.Mapping.$at(Key).get();
        if (Value == null) {
            if (Required) {
                this.setError(this.CurrentNode, llvm.$add_Twine$C(llvm.$add_Twine$C(new Twine("missing required key '"), new Twine(Key)), new Twine(NativePointer.$SGL_QUOTE)));
            } else {
                UseDefault.$set(true);
            }
            return false;
        }
        SaveInfo.$set((Object)this.CurrentNode);
        this.CurrentNode = Value;
        return true;
    }

    @Override
    public void postflightKey(Object saveInfo) {
        this.CurrentNode = (HNode)Casts.reinterpret_cast(HNode.class, (Object)saveInfo);
    }

    @Override
    public void beginFlowMapping() {
        this.beginMapping();
    }

    @Override
    public void endFlowMapping() {
        this.endMapping();
    }

    @Override
    public int beginSequence() {
        SequenceHNode SQ = ADTRTTI.dyn_cast_SequenceHNode(this.CurrentNode);
        if (SQ != null) {
            return SQ.Entries.size();
        }
        if (ADTRTTI.isa_EmptyHNode(this.CurrentNode)) {
            return 0;
        }
        ScalarHNode SN = ADTRTTI.dyn_cast_ScalarHNode(this.CurrentNode);
        if (SN != null && YamlGlobals.isNull(SN.value())) {
            return 0;
        }
        this.setError(this.CurrentNode, new Twine("not a sequence"));
        return 0;
    }

    @Override
    public void endSequence() {
    }

    @Override
    public boolean preflightElement(int Index, type.ref<Object> SaveInfo) {
        if (this.EC.$bool()) {
            return false;
        }
        SequenceHNode SQ = ADTRTTI.dyn_cast_SequenceHNode(this.CurrentNode);
        if (SQ != null) {
            SaveInfo.$set((Object)this.CurrentNode);
            this.CurrentNode = (HNode)((std_ptr.unique_ptr)SQ.Entries.$at(Index)).get();
            return true;
        }
        return false;
    }

    @Override
    public void postflightElement(Object SaveInfo) {
        this.CurrentNode = (HNode)Casts.reinterpret_cast(HNode.class, (Object)SaveInfo);
    }

    @Override
    public int beginFlowSequence() {
        return this.beginSequence();
    }

    @Override
    public boolean preflightFlowElement(int index, type.ref<Object> SaveInfo) {
        if (this.EC.$bool()) {
            return false;
        }
        SequenceHNode SQ = ADTRTTI.dyn_cast_SequenceHNode(this.CurrentNode);
        if (SQ != null) {
            SaveInfo.$set((Object)this.CurrentNode);
            this.CurrentNode = (HNode)((std_ptr.unique_ptr)SQ.Entries.$at(index)).get();
            return true;
        }
        return false;
    }

    @Override
    public void postflightFlowElement(Object SaveInfo) {
        this.CurrentNode = (HNode)Casts.reinterpret_cast(HNode.class, (Object)SaveInfo);
    }

    @Override
    public void endFlowSequence() {
    }

    @Override
    public void beginEnumScalar() {
        this.ScalarMatchFound = false;
    }

    @Override
    public boolean matchEnumScalar(char.ptr Str, boolean $Prm1) {
        if (this.ScalarMatchFound) {
            return false;
        }
        ScalarHNode SN = ADTRTTI.dyn_cast_ScalarHNode(this.CurrentNode);
        if (SN != null && SN.value().equals(Str)) {
            this.ScalarMatchFound = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean matchEnumFallback() {
        if (this.ScalarMatchFound) {
            return false;
        }
        this.ScalarMatchFound = true;
        return true;
    }

    @Override
    public void endEnumScalar() {
        if (!this.ScalarMatchFound) {
            this.setError(this.CurrentNode, new Twine("unknown enumerated scalar"));
        }
    }

    @Override
    public boolean beginBitSetScalar(bool.ref DoClear) {
        this.BitValuesUsed.clear();
        SequenceHNode SQ = ADTRTTI.dyn_cast_SequenceHNode(this.CurrentNode);
        if (SQ != null) {
            this.BitValuesUsed.insert(new StdVectorBool.iterator(this.BitValuesUsed.begin()), SQ.Entries.size(), false);
        } else {
            this.setError(this.CurrentNode, new Twine("expected sequence of bit values"));
        }
        DoClear.$set(true);
        return true;
    }

    @Override
    public boolean bitSetMatch(char.ptr Str, boolean $Prm1) {
        if (this.EC.$bool()) {
            return false;
        }
        SequenceHNode SQ = ADTRTTI.dyn_cast_SequenceHNode(this.CurrentNode);
        if (SQ != null) {
            int Index = 0;
            for (std_ptr.unique_ptr N : SQ.Entries) {
                ScalarHNode SN = ADTRTTI.dyn_cast_ScalarHNode((HNode)N.get());
                if (SN != null) {
                    if (SN.value().equals(Str)) {
                        this.BitValuesUsed.assign(Index, true);
                        return true;
                    }
                } else {
                    this.setError(this.CurrentNode, new Twine("unexpected scalar in sequence of bit values"));
                }
                ++Index;
            }
        } else {
            this.setError(this.CurrentNode, new Twine("expected sequence of bit values"));
        }
        return false;
    }

    @Override
    public void endBitSetScalar() {
        if (this.EC.$bool()) {
            return;
        }
        SequenceHNode SQ = ADTRTTI.dyn_cast_SequenceHNode(this.CurrentNode);
        if (SQ != null) {
            assert (this.BitValuesUsed.size() == SQ.Entries.size());
            int i = 0;
            while (Unsigned.$less_uint((int)i, (int)SQ.Entries.size())) {
                if (!this.BitValuesUsed.$at(i)) {
                    this.setError((HNode)((std_ptr.unique_ptr)SQ.Entries.$at(i)).get(), new Twine("unknown bit value"));
                    return;
                }
                ++i;
            }
        }
    }

    @Override
    public void scalarString(StringRef S2, boolean $Prm1) {
        ScalarHNode SN = ADTRTTI.dyn_cast_ScalarHNode(this.CurrentNode);
        if (SN != null) {
            S2.$assignMove(SN.value());
        } else {
            this.setError(this.CurrentNode, new Twine("unexpected scalar"));
        }
    }

    @Override
    public void blockScalarString(StringRef S2) {
        this.scalarString(S2, false);
    }

    @Override
    public void setError(Twine Message) {
        this.setError(this.CurrentNode, Message);
    }

    @Override
    public boolean canElideEmptySequence() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private std_ptr.unique_ptr<HNode> createHNodes(Node N) {
        SmallString StringStorage = new SmallString(128);
        ScalarNode SN = ADTRTTI.dyn_cast_ScalarNode(N);
        if (SN != null) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                StringRef KeyStr = SN.getValue(StringStorage);
                if (!StringStorage.empty()) {
                    KeyStr.$assignMove(StringStorage.str().copy(this.StringAllocator));
                }
                std_ptr.unique_ptr unique_ptr2 = (std_ptr.unique_ptr)$c$.clean((Object)new std_ptr.unique_ptr(JavaDifferentiators.JD$Unique_ptr$_Up$_Ep.INSTANCE, $c$.track(llvm.make_unique(new ScalarHNode(N, KeyStr)))));
                return unique_ptr2;
            }
            finally {
                $c$.$destroy();
            }
        }
        BlockScalarNode BSN = ADTRTTI.dyn_cast_BlockScalarNode(N);
        if (BSN != null) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                StringRef ValueCopy = BSN.getValue().copy(this.StringAllocator);
                std_ptr.unique_ptr unique_ptr3 = (std_ptr.unique_ptr)$c$.clean((Object)new std_ptr.unique_ptr(JavaDifferentiators.JD$Unique_ptr$_Up$_Ep.INSTANCE, $c$.track(llvm.make_unique(new ScalarHNode(N, ValueCopy)))));
                return unique_ptr3;
            }
            finally {
                $c$.$destroy();
            }
        }
        SequenceNode SQ = ADTRTTI.dyn_cast_SequenceNode(N);
        if (SQ != null) {
            std_ptr.unique_ptr<SequenceHNode> SQHNode = null;
            try {
                SQHNode = llvm.make_unique(new SequenceHNode(N));
                for (Node SN$1 : (SequenceNode)Native.$Deref((Object)SQ)) {
                    std_ptr.unique_ptr<HNode> Entry2 = null;
                    try {
                        Entry2 = this.createHNodes((Node)Native.$AddrOf((Object)SN$1));
                        if (this.EC.$bool()) break;
                        ((SequenceHNode)SQHNode.$arrow()).Entries.push_back_T$RR((Object)((std_ptr.unique_ptr)std.move(Entry2)));
                    }
                    finally {
                        if (Entry2 == null) continue;
                        Entry2.$destroy();
                    }
                }
                std_ptr.unique_ptr unique_ptr4 = new std_ptr.unique_ptr(JavaDifferentiators.JD$Unique_ptr$_Up$_Ep.INSTANCE, (std_ptr.unique_ptr)std.move(SQHNode));
                return unique_ptr4;
            }
            finally {
                if (SQHNode != null) {
                    SQHNode.$destroy();
                }
            }
        }
        MappingNode Map2 = ADTRTTI.dyn_cast_MappingNode(N);
        if (Map2 != null) {
            std_ptr.unique_ptr<MapHNode> mapHNode = null;
            try {
                mapHNode = llvm.make_unique(new MapHNode(N));
                for (KeyValueNode KVN : (MappingNode)Native.$Deref((Object)Map2)) {
                    std_ptr.unique_ptr<HNode> ValueHNode = null;
                    try {
                        Node KeyNode = KVN.getKey();
                        ScalarNode KeyScalar = ADTRTTI.dyn_cast_ScalarNode(KeyNode);
                        if (KeyScalar == null) {
                            this.setError(KeyNode, new Twine("Map key must be a scalar"));
                            break;
                        }
                        StringStorage.clear();
                        StringRef KeyStr = KeyScalar.getValue(StringStorage);
                        if (!StringStorage.empty()) {
                            KeyStr.$assignMove(StringStorage.str().copy(this.StringAllocator));
                        }
                        ValueHNode = this.createHNodes(KVN.getValue());
                        if (this.EC.$bool()) break;
                        ((MapHNode)mapHNode.$arrow()).Mapping.$at(KeyStr).$assignMove((std_ptr.unique_ptr)std.move(ValueHNode));
                    }
                    finally {
                        if (ValueHNode == null) continue;
                        ValueHNode.$destroy();
                    }
                }
                std_ptr.unique_ptr unique_ptr5 = new std_ptr.unique_ptr(JavaDifferentiators.JD$Unique_ptr$_Up$_Ep.INSTANCE, (std_ptr.unique_ptr)std.move(mapHNode));
                return unique_ptr5;
            }
            finally {
                if (mapHNode != null) {
                    mapHNode.$destroy();
                }
            }
        }
        if (ADTRTTI.isa_NullNode(N)) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                std_ptr.unique_ptr unique_ptr6 = (std_ptr.unique_ptr)$c$.clean((Object)new std_ptr.unique_ptr(JavaDifferentiators.JD$Unique_ptr$_Up$_Ep.INSTANCE, $c$.track(llvm.make_unique(new EmptyHNode(N)))));
                return unique_ptr6;
            }
            finally {
                $c$.$destroy();
            }
        }
        this.setError(N, new Twine("unknown node kind"));
        return new std_ptr.unique_ptr(JavaDifferentiators.JD$NullPtr.INSTANCE, null);
    }

    private void setError(HNode hnode, Twine message) {
        assert (hnode != null) : "HNode must not be NULL";
        this.setError(hnode._node, message);
    }

    private void setError(Node node2, Twine message) {
        ((Stream)this.Strm.$arrow()).printError(node2, message);
        this.EC.$assignMove(llvm.make_error_code(std_errors.errc.invalid_argument));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setCurrentDocument() {
        if (this.DocIterator.$noteq(((Stream)this.Strm.$arrow()).end())) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                Node N = ((Document)this.DocIterator.$arrow().$arrow()).getRoot();
                if (N == null) {
                    assert (((Stream)this.Strm.$arrow()).failed()) : "Root is NULL iff parsing failed";
                    this.EC.$assignMove(llvm.make_error_code(std_errors.errc.invalid_argument));
                    boolean bl = false;
                    return bl;
                }
                if (ADTRTTI.isa_NullNode(N)) {
                    this.DocIterator.$preInc();
                    boolean bl = this.setCurrentDocument();
                    return bl;
                }
                $c$.clean((Object)this.TopNode.$assignMove($c$.track(this.createHNodes(N))));
                this.CurrentNode = (HNode)this.TopNode.get();
                boolean bl = true;
                return bl;
            }
            finally {
                $c$.$destroy();
            }
        }
        return false;
    }

    public boolean nextDocument() {
        return this.DocIterator.$preInc().$noteq(((Stream)this.Strm.$arrow()).end());
    }

    public Node getCurrentNode() {
        return this.CurrentNode != null ? this.CurrentNode._node : null;
    }

    @Override
    public String toString() {
        return "SrcMgr=" + this.SrcMgr + ", TopNode=" + this.TopNode + ", EC=" + this.EC + ", StringAllocator=[BumpPtrAllocatorImpl], BitValuesUsed=" + this.BitValuesUsed + ", CurrentNode=" + this.CurrentNode + ", ScalarMatchFound=" + this.ScalarMatchFound + super.toString();
    }

    public static class SequenceHNode
    extends HNode
    implements Destructors.ClassWithDestructor {
        public std.vector<std_ptr.unique_ptr<HNode>> Entries = new std.vector((Object)new std_ptr.unique_ptr());

        @Override
        protected void anchor() {
        }

        public SequenceHNode(Node n) {
            super(n);
        }

        public static boolean classof(HNode n) {
            return SequenceNode.classof(n._node);
        }

        public static boolean classof(SequenceHNode $Prm0) {
            return true;
        }

        @Override
        public void $destroy() {
            this.Entries.$destroy();
            super.$destroy();
        }

        @Override
        public String toString() {
            return "Entries=" + this.Entries + super.toString();
        }
    }

    public static class MapHNode
    extends HNode
    implements Destructors.ClassWithDestructor {
        public StringMap<std_ptr.unique_ptr<HNode>> Mapping = new StringMap<std_ptr.unique_ptr>(new std_ptr.unique_ptr());
        public SmallVector<char.ptr> ValidKeys = new SmallVector<Object>(6, null);

        @Override
        protected void anchor() {
        }

        public MapHNode(Node n) {
            super(n);
        }

        public static boolean classof(HNode n) {
            return MappingNode.classof(n._node);
        }

        public static boolean classof(MapHNode $Prm0) {
            return true;
        }

        public boolean isValidKey(StringRef Key) {
            for (char.ptr K : this.ValidKeys) {
                if (!Key.equals(K)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void $destroy() {
            this.ValidKeys.$destroy();
            this.Mapping.$destroy();
            super.$destroy();
        }

        @Override
        public String toString() {
            return "Mapping=" + this.Mapping + ", ValidKeys=" + this.ValidKeys + super.toString();
        }
    }

    public static class ScalarHNode
    extends HNode
    implements Destructors.ClassWithDestructor {
        protected StringRef _value;

        @Override
        protected void anchor() {
        }

        public ScalarHNode(Node n, StringRef s) {
            super(n);
            this._value = new StringRef(s);
        }

        public StringRef value() {
            return new StringRef(this._value);
        }

        public static boolean classof(HNode n) {
            return ScalarNode.classof(n._node) || BlockScalarNode.classof(n._node);
        }

        public static boolean classof(ScalarHNode $Prm0) {
            return true;
        }

        @Override
        public void $destroy() {
            super.$destroy();
        }

        @Override
        public String toString() {
            return "_value=" + this._value + super.toString();
        }
    }

    public static class EmptyHNode
    extends HNode
    implements Destructors.ClassWithDestructor {
        @Override
        protected void anchor() {
        }

        public EmptyHNode(Node n) {
            super(n);
        }

        public static boolean classof(HNode n) {
            return NullNode.classof(n._node);
        }

        public static boolean classof(EmptyHNode $Prm0) {
            return true;
        }

        @Override
        public void $destroy() {
            super.$destroy();
        }

        @Override
        public String toString() {
            return "" + super.toString();
        }
    }

    public static class HNode
    implements Destructors.ClassWithDestructor {
        public Node _node;

        protected void anchor() {
        }

        public HNode(Node n) {
            this._node = n;
        }

        public void $destroy() {
        }

        public static boolean classof(HNode $Prm0) {
            return true;
        }

        public String toString() {
            return "_node=" + this._node;
        }
    }
}

