/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support.sys.impl;

import org.clank.java.io;
import org.clank.java.std;
import org.clank.java.std_errors;
import org.clank.java.std_time;
import org.clank.support.Casts;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.NativeType;
import org.clank.support.Unsigned;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.clank.support.aliases.int;
import org.clank.support.void;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.support.impl.FSEntity;
import org.llvm.support.impl.PathStatics;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.sys.TimeValue;
import org.llvm.support.sys.fs;
import org.llvm.support.sys.impl.PathFsStatics;
import org.llvm.support.sys.path;

public final class PathFsGlobals {
    public static std_errors.error_code make_absolute(Twine current_directory, SmallString _path, boolean use_current_directory) {
        StringRef p = new StringRef(_path.data(), _path.size());
        boolean rootDirectory = path.has_root_directory(p);
        boolean rootName = true;
        if (!llvm.LLVM_ON_WIN32) {
            // empty if block
        }
        if ((rootName = path.has_root_name(p)) && rootDirectory) {
            return std_errors.error_code.success();
        }
        SmallString current_dir = new SmallString(128);
        if (use_current_directory) {
            current_directory.toVector(current_dir);
        } else {
            std_errors.error_code ec = PathFsGlobals.current_path(current_dir);
            if (ec.$bool()) {
                return ec;
            }
        }
        if (!rootName && !rootDirectory) {
            path.append(current_dir, p);
            _path.swap(current_dir);
            return std_errors.error_code.success();
        }
        if (!rootName && rootDirectory) {
            StringRef cdrn = path.root_name(current_dir.$StringRef());
            SmallString curDirRootName = new SmallString(cdrn.begin(), cdrn.end(), 128);
            path.append(curDirRootName, p);
            _path.swap(curDirRootName);
            return std_errors.error_code.success();
        }
        if (rootName && !rootDirectory) {
            StringRef pRootName = path.root_name(p);
            StringRef bRootDirectory = path.root_directory(current_dir.$StringRef());
            StringRef bRelativePath = path.relative_path(current_dir.$StringRef());
            StringRef pRelativePath = path.relative_path(p);
            SmallString res = new SmallString(128);
            path.append(res, pRootName, bRootDirectory, bRelativePath, pRelativePath);
            _path.swap(res);
            return std_errors.error_code.success();
        }
        throw new llvm_unreachable("All rootName and rootDirectory combinations should have occurred above!");
    }

    public static std_errors.error_code create_directories(Twine Path2) {
        return PathFsGlobals.create_directories(Path2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static std_errors.error_code create_directories(Twine Path2, boolean IgnoreExisting) {
        SmallString PathStorage = null;
        try {
            PathStorage = new SmallString(128);
            StringRef P2 = Path2.toStringRef(PathStorage);
            std_errors.error_code EC = PathFsGlobals.create_directory(new Twine(P2), IgnoreExisting);
            if (std.$noteq_error_code((std_errors.error_code)EC, (std_errors.error_code)std_errors.errc.no_such_file_or_directory.make_error_code())) {
                std_errors.error_code error_code2 = EC;
                return error_code2;
            }
            StringRef Parent = path.parent_path(new StringRef(P2));
            if (Parent.empty()) {
                std_errors.error_code error_code3 = EC;
                return error_code3;
            }
            if (EC.$assign(PathFsGlobals.create_directories(new Twine(Parent))).$bool()) {
                std_errors.error_code error_code4 = EC;
                return error_code4;
            }
            std_errors.error_code error_code5 = PathFsGlobals.create_directory(new Twine(P2), IgnoreExisting);
            return error_code5;
        }
        finally {
            if (PathStorage != null) {
                PathStorage.$destroy();
            }
        }
    }

    public static std_errors.error_code create_directory(Twine path2) {
        return PathFsGlobals.create_directory(path2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static std_errors.error_code create_directory(Twine path2, boolean IgnoreExisting) {
        SmallString path_storage = null;
        try {
            path_storage = new SmallString(128);
            StringRef p = path2.toNullTerminatedStringRef(path_storage);
            if (!(std.mkdir((char.iterator)p.begin(), (int)504) != -1 || std.errno() == 17 && IgnoreExisting)) {
                std_errors.error_code error_code2 = new std_errors.error_code(std.errno(), std.generic_category());
                return error_code2;
            }
            std_errors.error_code error_code3 = new std_errors.error_code();
            return error_code3;
        }
        finally {
            if (path_storage != null) {
                path_storage.$destroy();
            }
        }
    }

    public static std_errors.error_code create_link(Twine to, Twine from) {
        SmallString from_storage = new SmallString(128);
        SmallString to_storage = new SmallString(128);
        StringRef f = from.toNullTerminatedStringRef(from_storage);
        StringRef t = to.toNullTerminatedStringRef(to_storage);
        if (std.symlink((char.iterator)t.begin(), (char.iterator)f.begin()) == -1) {
            return new std_errors.error_code(std.errno(), std.generic_category());
        }
        return new std_errors.error_code();
    }

    public static std_errors.error_code current_path(SmallString result) {
        result.clear();
        char.ptr pwd = std.getenv((char.ptr)NativePointer.$((String)"PWD"));
        fs.file_status PWDStatus = new fs.file_status();
        fs.file_status DotStatus = new fs.file_status();
        if (pwd != null && path.is_absolute(new Twine(pwd)) && !fs.status(new Twine(pwd), PWDStatus).$bool() && !fs.status(new Twine(NativePointer.$DOT), DotStatus).$bool() && PWDStatus.getUniqueID().$eq(DotStatus.getUniqueID())) {
            result.append(pwd, std.strlen((char.ptr)pwd));
            return std_errors.error_code.success();
        }
        result.reserve(1024);
        while (Native.$eq_ptr((void.ptr)std.getcwd((char.ptr)result.data(), (int)result.capacity()), null)) {
            if (std.errno() != 12) {
                return new std_errors.error_code(std.errno(), std.generic_category());
            }
            result.reserve(result.capacity() * 2);
        }
        result.set_size(std.strlen((char.ptr)result.data()));
        return std_errors.error_code.success();
    }

    public static std_errors.error_code remove(Twine path2) {
        return PathFsGlobals.remove(path2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static std_errors.error_code remove(Twine path2, boolean IgnoreNonExisting) {
        SmallString path_storage = null;
        try {
            path_storage = new SmallString(128);
            StringRef p = path2.toNullTerminatedStringRef(path_storage);
            io.stat buf = new io.stat();
            if (io.lstat((char.ptr)p.begin(), (io.stat)((io.stat)Native.$AddrOf((Object)buf))) != 0) {
                if (std.errno() != 2 || !IgnoreNonExisting) {
                    std_errors.error_code error_code2 = new std_errors.error_code(std.errno(), std.generic_category());
                    return error_code2;
                }
                std_errors.error_code error_code3 = new std_errors.error_code();
                return error_code3;
            }
            if (!(std.S_ISREG((long)buf.st_mode) || std.S_ISDIR((long)buf.st_mode) || std.S_ISLNK((long)buf.st_mode))) {
                std_errors.error_code error_code4 = llvm.make_error_code(std_errors.errc.operation_not_permitted);
                return error_code4;
            }
            if (!(io.remove((char.iterator)p.begin()) != -1 || std.errno() == 2 && IgnoreNonExisting)) {
                std_errors.error_code error_code5 = new std_errors.error_code(std.errno(), std.generic_category());
                return error_code5;
            }
            std_errors.error_code error_code6 = new std_errors.error_code();
            return error_code6;
        }
        finally {
            if (path_storage != null) {
                path_storage.$destroy();
            }
        }
    }

    public static std_errors.error_code rename(Twine from, Twine to) {
        SmallString from_storage = new SmallString(128);
        SmallString to_storage = new SmallString(128);
        StringRef f = from.toNullTerminatedStringRef(from_storage);
        StringRef t = to.toNullTerminatedStringRef(to_storage);
        if (io.rename((char.iterator)f.begin(), (char.iterator)t.begin()) == -1) {
            return new std_errors.error_code(std.errno(), std.system_category());
        }
        return std_errors.error_code.success();
    }

    public static std_errors.error_code copy_file(Twine From, Twine To) {
        int.ref ReadFD = NativePointer.create_int$ref();
        int.ref WriteFD = NativePointer.create_int$ref();
        std_errors.error_code EC = PathFsGlobals.openFileForRead(From, ReadFD);
        if (EC.$bool()) {
            return EC;
        }
        EC = PathFsGlobals.openFileForWrite(To, WriteFD, 0);
        if (EC.$bool()) {
            std.close((int)ReadFD.$deref());
            return EC;
        }
        int BufSize = 4096;
        char.ptr Buf = NativePointer.create_char$ptr((byte[])NativePointer.new$char((int)BufSize, (byte[])new byte[0]));
        int BytesRead = 0;
        int BytesWritten = 0;
        while ((BytesRead = (int)std.read((int)ReadFD.$deref(), (char.iterator)Buf, (int)BufSize)) > 0) {
            while (BytesRead != 0 && (BytesWritten = (int)std.write((int)WriteFD.$deref(), (char.ptr)Buf, (int)BytesRead)) >= 0) {
                BytesRead -= BytesWritten;
            }
            if (BytesWritten >= 0) continue;
        }
        std.close((int)ReadFD.$deref());
        std.close((int)WriteFD.$deref());
        Destructors.$destroyArray((Object)Buf);
        if (BytesRead < 0 || BytesWritten < 0) {
            return new std_errors.error_code(std.errno(), std.generic_category());
        }
        return new std_errors.error_code();
    }

    public static std_errors.error_code resize_file(int FD, long Size) {
        if (std.ftruncate((int)FD, (long)Size) == -1) {
            return new std_errors.error_code(std.errno(), std.generic_category());
        }
        return new std_errors.error_code();
    }

    public static boolean exists(fs.file_status status) {
        return PathFsGlobals.status_known(new fs.file_status(status)) && status.type() != fs.file_type.file_not_found;
    }

    public static std_errors.error_code access(Twine Path2, fs.AccessMode Mode) {
        SmallString PathStorage = new SmallString(128);
        StringRef P2 = Path2.toNullTerminatedStringRef(PathStorage);
        if (io.access((char.iterator)P2.begin(), (long)fs.convertAccessMode(Mode)) == -1) {
            return new std_errors.error_code(std.errno(), std.generic_category());
        }
        if (Mode == fs.AccessMode.Execute) {
            io.stat buf = new io.stat();
            if (0 != std.stat((char.ptr)P2.begin(), (io.stat)((io.stat)Native.$AddrOf((Object)buf)))) {
                return new std_errors.error_code(std_errors.errc.permission_denied);
            }
            if (!std.S_ISREG((long)buf.st_mode)) {
                return new std_errors.error_code(std_errors.errc.permission_denied);
            }
        }
        return new std_errors.error_code();
    }

    public static boolean equivalent(fs.file_status A, fs.file_status B) {
        assert (PathFsGlobals.status_known(A) && PathFsGlobals.status_known(B));
        return A.fs_st_dev == B.fs_st_dev && A.fs_st_ino == B.fs_st_ino;
    }

    public static std_errors.error_code equivalent(Twine A, Twine B, bool.ref result) {
        fs.file_status fsA = new fs.file_status();
        fs.file_status fsB = new fs.file_status();
        std_errors.error_code ec = PathFsGlobals.status(A, fsA);
        if (ec.$Void2Void() != null) {
            return ec;
        }
        ec = PathFsGlobals.status(B, fsB);
        if (ec.$Void2Void() != null) {
            return ec;
        }
        result.$set(PathFsGlobals.equivalent(fsA, fsB));
        return std_errors.error_code.success();
    }

    public static boolean is_directory(fs.file_status status) {
        return status.type().getValue() == fs.file_type.directory_file.getValue();
    }

    public static std_errors.error_code is_directory(Twine path2, bool.ref result) {
        fs.file_status st = new fs.file_status();
        std_errors.error_code ec = PathFsGlobals.status(path2, st);
        if (ec.$Void2Void() != null) {
            return ec;
        }
        result.$set(PathFsGlobals.is_directory(st));
        return std_errors.error_code.success();
    }

    public static boolean is_regular_file(fs.file_status status) {
        return status.type().getValue() == fs.file_type.regular_file.getValue();
    }

    public static std_errors.error_code is_regular_file(Twine path2, bool.ref result) {
        fs.file_status st = new fs.file_status();
        std_errors.error_code ec = PathFsGlobals.status(path2, st);
        if (ec.$Void2Void() != null) {
            return ec;
        }
        result.$set(PathFsGlobals.is_regular_file(st));
        return std_errors.error_code.success();
    }

    public static boolean is_other(fs.file_status status) {
        return PathFsGlobals.exists(new fs.file_status(status)) && !PathFsGlobals.is_regular_file(new fs.file_status(status)) && !PathFsGlobals.is_directory(new fs.file_status(status));
    }

    public static std_errors.error_code is_other(Twine Path2, bool.ref Result) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static std_errors.error_code status(Twine Path2, fs.file_status Result) {
        SmallString PathStorage = new SmallString(128);
        StringRef P2 = Path2.toNullTerminatedStringRef(PathStorage);
        io.stat Status2 = new io.stat();
        int StatRet = std.stat((char.ptr)P2.begin(), (io.stat)((io.stat)Native.$AddrOf((Object)Status2)));
        return fs.fillStatus(StatRet, Status2, Result);
    }

    public static std_errors.error_code status(int FD, fs.file_status Result) {
        io.stat Status2 = new io.stat();
        int StatRet = std.fstat((int)FD, (io.stat)((io.stat)Native.$AddrOf((Object)Status2)));
        return fs.fillStatus(StatRet, Status2, Result);
    }

    public static std_errors.error_code setLastModificationAndAccessTime(int FD, TimeValue Time) {
        std_time.timespec[] Times = new std_time.timespec[2];
        Times[0].tv_sec = Time.toEpochTime();
        Times[0].tv_nsec = 0L;
        Times[1].$assign(Times[0]);
        if (std.futimens((int)FD, (std_time.timespec[])Times) != 0) {
            return new std_errors.error_code(std.errno(), std.system_category());
        }
        return std_errors.error_code.success();
    }

    public static boolean status_known(fs.file_status s) {
        return s.type().getValue() != fs.file_type.status_error.getValue();
    }

    public static std_errors.error_code createUniqueFile(Twine Model2, int.ref ResultFd, SmallString ResultPath) {
        return PathFsGlobals.createUniqueFile(Model2, ResultFd, ResultPath, fs.$bitor_perms(292, 146));
    }

    public static std_errors.error_code createUniqueFile(Twine Model2, int.ref ResultFd, SmallString ResultPath, int Mode) {
        return PathStatics.createUniqueEntity(Model2, ResultFd, ResultPath, false, Mode, FSEntity.FS_File);
    }

    public static std_errors.error_code createUniqueFile(Twine Model2, SmallString ResultPath) {
        int.ref Dummy = NativePointer.create_int$ref();
        return PathStatics.createUniqueEntity(Model2, Dummy, ResultPath, false, 0, FSEntity.FS_Name);
    }

    public static std_errors.error_code createTemporaryFile(Twine Prefix, StringRef Suffix, int.ref ResultFD, SmallString ResultPath) {
        return PathFsStatics.createTemporaryFile(Prefix, Suffix, ResultFD, ResultPath, FSEntity.FS_File);
    }

    public static std_errors.error_code createTemporaryFile(Twine Prefix, StringRef Suffix, SmallString ResultPath) {
        int.ref Dummy = NativePointer.create_int$ref();
        return PathFsStatics.createTemporaryFile(Prefix, Suffix, Dummy, ResultPath, FSEntity.FS_Name);
    }

    public static std_errors.error_code createUniqueDirectory(Twine Prefix, SmallString ResultPath) {
        int.ref Dummy = NativePointer.create_int$ref();
        return PathStatics.createUniqueEntity(llvm.$add_Twine(Prefix, new Twine("-%%%%%%")), Dummy, ResultPath, true, 0, FSEntity.FS_Dir);
    }

    public static std_errors.error_code openFileForWrite(Twine Name2, int.ref ResultFD, int Flags) {
        return PathFsGlobals.openFileForWrite(Name2, ResultFD, Flags, 438);
    }

    public static std_errors.error_code openFileForWrite(Twine Name2, int.ref ResultFD, int Flags, int Mode) {
        assert ((Flags & 1) == 0 || (Flags & 2) == 0) : "Cannot specify both 'excl' and 'append' file creation flags!";
        int OpenFlags2 = 256;
        OpenFlags2 = (Flags & 8) != 0 ? (OpenFlags2 |= 2) : (OpenFlags2 |= 1);
        OpenFlags2 = (Flags & 2) != 0 ? (OpenFlags2 |= 8) : (OpenFlags2 |= 0x200);
        if ((Flags & 1) != 0) {
            OpenFlags2 |= 0x400;
        }
        SmallString Storage = new SmallString(128);
        StringRef P2 = Name2.toNullTerminatedStringRef(Storage);
        while (ResultFD.$set(std.open((char.iterator)P2.begin(), (int)OpenFlags2, (int[])new int[]{Mode})) < 0) {
            if (std.errno() == 4) continue;
            return new std_errors.error_code(std.errno(), std.generic_category());
        }
        return new std_errors.error_code();
    }

    public static std_errors.error_code openFileForRead(Twine Name2, int.ref ResultFD) {
        return PathFsGlobals.openFileForRead(Name2, ResultFD, null);
    }

    public static std_errors.error_code openFileForRead(Twine Name2, int.ref ResultFD, SmallString RealPath) {
        SmallString Storage = new SmallString(128);
        StringRef P2 = Name2.toNullTerminatedStringRef(Storage);
        while (ResultFD.$set(std.open((char.iterator)P2.begin(), (int)0, (int[])new int[0])) < 0) {
            if (std.errno() == 4) continue;
            return new std_errors.error_code(std.errno(), std.generic_category());
        }
        if (RealPath == null) {
            return new std_errors.error_code();
        }
        RealPath.clear();
        byte[] Buffer = NativePointer.new$char((int)4096, (byte[])new byte[0]);
        if (Native.$noteq_ptr((void.ptr)std.realpath((char.ptr)P2.begin(), (byte[])Buffer), null)) {
            RealPath.append(Buffer, 0, std.strlen((byte[])Buffer));
        }
        return new std_errors.error_code();
    }

    public static fs.file_magic identify_magic(StringRef Magic) {
        if (Magic.size() < 4) {
            return new fs.file_magic(fs.file_magic.Impl.unknown);
        }
        block0 : switch (Casts.$char((byte)Magic.$at(0))) {
            case '\u0000': {
                if (Magic.$at(1) == 0 && Magic.$at(2) == -1 && Magic.$at(3) == -1) {
                    return new fs.file_magic(fs.file_magic.Impl.coff_import_library);
                }
                byte[] Expected2 = new byte[]{0, 0, 0, 0, 32, 0, 0, 0, -1};
                if (Magic.size() >= NativeType.sizeof((byte[])Expected2) && std.memcmp((char.ptr)Magic.data(), (char.ptr)NativePointer.create_char$ptr((byte[])Expected2), (int)NativeType.sizeof((byte[])Expected2)) == 0) {
                    return new fs.file_magic(fs.file_magic.Impl.windows_resource);
                }
                if (Magic.$at(1) != 0) break;
                return new fs.file_magic(fs.file_magic.Impl.coff_object);
            }
            case '\u00de': {
                if (Magic.$at(1) != -64 || Magic.$at(2) != 23 || Magic.$at(3) != 11) break;
                return new fs.file_magic(fs.file_magic.Impl.bitcode);
            }
            case 'B': {
                if (Magic.$at(1) != NativePointer.$((char)'C') || Magic.$at(2) != -64 || Magic.$at(3) != -34) break;
                return new fs.file_magic(fs.file_magic.Impl.bitcode);
            }
            case '!': {
                if (Magic.size() < 8 || std.memcmp((char.ptr)Magic.data(), (CharSequence)"!<arch>\n", (int)8) != 0) break;
                return new fs.file_magic(fs.file_magic.Impl.archive);
            }
            case '\u007f': {
                int low;
                if (Magic.size() < 18 || Magic.$at(1) != NativePointer.$((char)'E') || Magic.$at(2) != NativePointer.$((char)'L') || Magic.$at(3) != NativePointer.$((char)'F')) break;
                boolean Data2MSB = Magic.$at(5) == 2;
                int high = Data2MSB ? 16 : 17;
                int n = low = Data2MSB ? 17 : 16;
                if (Magic.$at(high) != 0) break;
                switch (Magic.$at(low)) {
                    default: {
                        break block0;
                    }
                    case 1: {
                        return new fs.file_magic(fs.file_magic.Impl.elf_relocatable);
                    }
                    case 2: {
                        return new fs.file_magic(fs.file_magic.Impl.elf_executable);
                    }
                    case 3: {
                        return new fs.file_magic(fs.file_magic.Impl.elf_shared_object);
                    }
                    case 4: 
                }
                return new fs.file_magic(fs.file_magic.Impl.elf_core);
            }
            case '\u00ca': {
                if (Magic.$at(1) != -2 || Magic.$at(2) != -70 || Magic.$at(3) != -66 || Magic.size() < 8 || Magic.$at(7) >= 43) break;
                return new fs.file_magic(fs.file_magic.Impl.macho_universal_binary);
            }
            case '\u00ce': 
            case '\u00cf': 
            case '\u00fe': {
                int type2 = 0;
                if (Magic.$at(0) == -2 && Magic.$at(1) == -19 && Magic.$at(2) == -6 && (Magic.$at(3) == -50 || Magic.$at(3) == -49)) {
                    if (Magic.size() >= 16) {
                        type2 = (char)(Magic.$at(14) << 8 | Magic.$at(15));
                    }
                } else if ((Magic.$at(0) == -50 || Magic.$at(0) == -49) && Magic.$at(1) == -6 && Magic.$at(2) == -19 && Magic.$at(3) == -2 && Magic.size() >= 14) {
                    type2 = (char)(Magic.$at(13) << 8 | Magic.$at(12));
                }
                switch (type2) {
                    default: {
                        break block0;
                    }
                    case 1: {
                        return new fs.file_magic(fs.file_magic.Impl.macho_object);
                    }
                    case 2: {
                        return new fs.file_magic(fs.file_magic.Impl.macho_executable);
                    }
                    case 3: {
                        return new fs.file_magic(fs.file_magic.Impl.macho_fixed_virtual_memory_shared_lib);
                    }
                    case 4: {
                        return new fs.file_magic(fs.file_magic.Impl.macho_core);
                    }
                    case 5: {
                        return new fs.file_magic(fs.file_magic.Impl.macho_preload_executable);
                    }
                    case 6: {
                        return new fs.file_magic(fs.file_magic.Impl.macho_dynamically_linked_shared_lib);
                    }
                    case 7: {
                        return new fs.file_magic(fs.file_magic.Impl.macho_dynamic_linker);
                    }
                    case 8: {
                        return new fs.file_magic(fs.file_magic.Impl.macho_bundle);
                    }
                    case 9: {
                        return new fs.file_magic(fs.file_magic.Impl.macho_dynamic_linker);
                    }
                    case 10: 
                }
                return new fs.file_magic(fs.file_magic.Impl.macho_dsym_companion);
            }
            case 'L': 
            case 'P': 
            case 'f': 
            case '\u0083': 
            case '\u0084': 
            case '\u00f0': {
                if (Magic.$at(1) == 1) {
                    return new fs.file_magic(fs.file_magic.Impl.coff_object);
                }
            }
            case 'h': 
            case '\u0090': {
                if (Magic.$at(1) != 2) break;
                return new fs.file_magic(fs.file_magic.Impl.coff_object);
            }
            case 'M': {
                int off;
                if (Magic.$at(1) != 90 || (off = ((Integer)new llvm.support.ulittle32_t((char.ptr)Magic.data().$add(60)).$value()).intValue()) >= Magic.size() || std.memcmp((char.ptr)((char.ptr)Magic.data().$add(off)), (CharSequence)"PE\u0000\u0000", (int)4) != 0) break;
                return new fs.file_magic(fs.file_magic.Impl.pecoff_executable);
            }
            case 'd': {
                if (Magic.$at(1) != -122) break;
                return new fs.file_magic(fs.file_magic.Impl.coff_object);
            }
        }
        return new fs.file_magic(fs.file_magic.Impl.unknown);
    }

    public static std_errors.error_code identify_magic(Twine Path2, fs.file_magic Result) {
        int.ref FD = NativePointer.create_int$ref();
        std_errors.error_code EC = PathFsGlobals.openFileForRead(Path2, FD);
        if (EC.$bool()) {
            return EC;
        }
        int BufSize = 32;
        char.ptr Buffer = NativePointer.create_char$ptr((byte[])NativePointer.new$char((int)BufSize, (byte[])new byte[0]));
        long Length = std.read((int)FD.$deref(), (char.iterator)Buffer, (int)BufSize);
        if (std.close((int)FD.$deref()) != 0 || Length < 0L) {
            return new std_errors.error_code(std.errno(), std.generic_category());
        }
        Result.$assignMove(PathFsGlobals.identify_magic(new StringRef(Buffer, Unsigned.$long2uint((long)Length))));
        return new std_errors.error_code();
    }

    public static std_errors.error_code getUniqueID(Twine Path2, fs.UniqueID Result) {
        fs.file_status Status2 = new fs.file_status();
        std_errors.error_code EC = PathFsGlobals.status(Path2, Status2);
        if (EC.$Void2Void() != null) {
            return EC;
        }
        Result.$assign(Status2.getUniqueID());
        return std_errors.error_code.success();
    }

    public static std.string getMainExecutable(char.ptr argv0, Object MainAddr) {
        if (argv0 != null) {
            return new std.string(argv0);
        }
        io.Dl_info DLInfo = new io.Dl_info();
        int err = io.dladdr((Object)MainAddr, (io.Dl_info)((io.Dl_info)Native.$AddrOf((Object)DLInfo)));
        if (err == 0) {
            return new std.string((CharSequence)"");
        }
        byte[] link_path = NativePointer.new$char((int)1024, (byte[])new byte[0]);
        if (std.realpath((char.ptr)DLInfo.dli_fname, (byte[])link_path) != null) {
            return new std.string(link_path);
        }
        return new std.string((CharSequence)"");
    }
}

