/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support.impl;

import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.Destructors;
import org.clank.support.literal_constants;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.StringMap;
import org.llvm.cl.ClGlobals;
import org.llvm.cl.OptionHidden;
import org.llvm.cl.aliases.optBool;
import org.llvm.cl.aliases.optString;
import org.llvm.cl.desc;
import org.llvm.cl.opt;
import org.llvm.cl.value_desc;
import org.llvm.support.ManagedStatic;
import org.llvm.support.ManagedStaticInfo;
import org.llvm.support.Timer;
import org.llvm.support.TimerGroup;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;
import org.llvm.support.sys.ManagedStaticInfoImpl;
import org.llvm.support.sys.Process;
import org.llvm.support.sys.SmartMutex;
import org.llvm.support.sys.sys;

public final class TimerStatics {
    public static final ManagedStaticInfo<std.vector<Timer>> StaticStdVectorTimer = new ManagedStaticInfoImpl<std.vector<Timer>>(){

        @Override
        protected std.vector<Timer> create() {
            return new std.vector((Object)null);
        }
    };
    public static final ManagedStaticInfo<StringMap<Timer>> StaticStringMapTimer = new ManagedStaticInfoImpl<StringMap<Timer>>(){

        @Override
        protected StringMap<Timer> create() {
            return new StringMap<Object>(null);
        }
    };
    public static ManagedStatic<std.string> LibSupportInfoOutputFilename = new ManagedStatic<std.string>(sys.StaticStdString);
    public static ManagedStatic<SmartMutex> TimerLock = new ManagedStatic<SmartMutex>(sys.StaticSmartMutexTrue);
    public static opt<Boolean> TrackSpace = new optBool(new Object[]{"track-memory", new desc("Enable -time-passes memory tracking (this may be slow)"), OptionHidden.Hidden});
    public static opt<std.string> InfoOutputFilename = new optString(opt.StorageKind.External, new Object[]{literal_constants.$((String)"info-output-file"), new value_desc("filename"), new desc("File to append -stats and -timer output to"), OptionHidden.Hidden, ClGlobals.location(TimerStatics.getLibSupportInfoOutputFilename())});
    public static TimerGroup DefaultTimerGroup = null;
    public static ManagedStatic<std.vector<Timer>> ActiveTimers = new ManagedStatic<std.vector<Timer>>(StaticStdVectorTimer);
    public static final ManagedStaticInfo<Name2PairMap> StaticName2PairMap = new ManagedStaticInfoImpl<Name2PairMap>(){

        @Override
        protected Name2PairMap create() {
            return new Name2PairMap();
        }
    };
    public static ManagedStatic<StringMap<Timer>> NamedTimers = new ManagedStatic<StringMap<Timer>>(StaticStringMapTimer);
    public static ManagedStatic<Name2PairMap> NamedGroupedTimers = new ManagedStatic<Name2PairMap>(StaticName2PairMap);
    public static TimerGroup TimerGroupList = null;

    public static std.string getLibSupportInfoOutputFilename() {
        return LibSupportInfoOutputFilename.$star();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimerGroup getDefaultTimerGroup() {
        Class<TimerStatics> clazz = TimerStatics.class;
        synchronized (TimerStatics.class) {
            if (DefaultTimerGroup == null) {
                DefaultTimerGroup = new TimerGroup(new StringRef("Miscellaneous Ungrouped Timers"));
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return DefaultTimerGroup;
        }
    }

    public static int getMemUsage() {
        if (!TrackSpace.$T().booleanValue()) {
            return 0;
        }
        return Process.GetMallocUsage();
    }

    public static void printVal(double Val, double Total, raw_ostream OS) {
        if (Total < 1.0E-7) {
            OS.$out("        -----     ");
        } else {
            OS.$out(llvm.format("  %7.4f (%5.1f%%)", Val, Val * 100.0 / Total));
        }
    }

    public static Timer getNamedRegionTimer(StringRef Name2) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static void java$shutdown() {
        while (TimerGroupList != null) {
            TimerGroupList.$destroy();
        }
        assert (TimerGroupList == null);
        InfoOutputFilename.reset();
        assert (InfoOutputFilename.$T().$eq((Object)new std.string((CharSequence)"")));
        TrackSpace.reset();
        assert (!TrackSpace.$T().booleanValue());
        DefaultTimerGroup = null;
    }

    public static class Name2PairMap
    implements Destructors.ClassWithDestructor {
        private StringMap<std_pair.pair<TimerGroup, StringMap<Timer>>> Map;

        public void $destroy() {
            throw new UnsupportedOperationException("EmptyBody");
        }

        public Timer get(StringRef Name2, StringRef GroupName) {
            throw new UnsupportedOperationException("EmptyBody");
        }

        public Name2PairMap() {
            throw new UnsupportedOperationException("EmptyBody");
        }
    }
}

