/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support.impl;

import org.clank.java.std;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.llvm.support.ZeroBehavior;
import org.llvm.support.sys.sys;

public final class MathExtrasLlvmGlobals {
    public static <T> int countTrailingZeros(T Val) {
        return MathExtrasLlvmGlobals.countTrailingZeros(Val, ZeroBehavior.ZB_Width);
    }

    public static <T> int countTrailingZeros(T Val, ZeroBehavior ZB) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static int countLeadingZeros(long Val) {
        return MathExtrasLlvmGlobals.countLeadingZeros(Val, ZeroBehavior.ZB_Width);
    }

    public static int countLeadingZeros(long Val, ZeroBehavior ZB) {
        if (ZB != ZeroBehavior.ZB_Undefined && Val == 0L) {
            return 64;
        }
        return Long.numberOfLeadingZeros(Val);
    }

    public static int countLeadingZeros(int Val) {
        return MathExtrasLlvmGlobals.countLeadingZeros(Val, ZeroBehavior.ZB_Width);
    }

    public static int countLeadingZeros(int Val, ZeroBehavior ZB) {
        if (ZB != ZeroBehavior.ZB_Undefined && Val == 0) {
            return 32;
        }
        return Integer.numberOfLeadingZeros(Val);
    }

    public static int countLeadingZeros(short Val) {
        return MathExtrasLlvmGlobals.countLeadingZeros(Val, ZeroBehavior.ZB_Width);
    }

    public static int countLeadingZeros(short Val, ZeroBehavior ZB) {
        if (ZB != ZeroBehavior.ZB_Undefined && Val == 0) {
            return 16;
        }
        throw new UnsupportedOperationException();
    }

    public static int countLeadingZeros_uint64_t_ZeroBehavior(long Val) {
        return MathExtrasLlvmGlobals.countLeadingZeros_uint64_t_ZeroBehavior(Val, ZeroBehavior.ZB_Width);
    }

    public static int countLeadingZeros_uint64_t_ZeroBehavior(long Val, ZeroBehavior ZB) {
        return MathExtrasLlvmGlobals.countLeadingZeros(Val, ZB);
    }

    public static <T> T findFirstSet(T Val) {
        return MathExtrasLlvmGlobals.findFirstSet(Val, ZeroBehavior.ZB_Max);
    }

    public static <T> T findFirstSet(T Val, ZeroBehavior ZB) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <T> T findLastSet(T Val) {
        return MathExtrasLlvmGlobals.findLastSet(Val, ZeroBehavior.ZB_Max);
    }

    public static <T> T findLastSet(T Val, ZeroBehavior ZB) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <T> T reverseBits(T Val) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static int Hi_32(long Value) {
        return Unsigned.$ulong2uint((long)(Value >>> 32));
    }

    public static int Lo_32(long Value) {
        return Unsigned.$ulong2uint((long)Value);
    }

    public static long Make_64(int High, int Low) {
        return Unsigned.$uint2ulong((int)High) << 32 | Unsigned.$uint2ulong((int)Low);
    }

    public static boolean isInt(int N, long x) {
        return Unsigned.$greatereq_uint((int)N, (int)64) || -(1L << N - 1) <= x && x < 1L << N - 1;
    }

    public static boolean isInt(long x) {
        return (long)((byte)x) == x;
    }

    public static boolean isShiftedInt(int N, int S2, long x) {
        std.static_assert((boolean)Unsigned.$greater_uint((int)N, (int)0), (char.ptr)NativePointer.$((String)"isShiftedInt<0> doesn't make sense (refers to a 0-bit number."));
        std.static_assert((boolean)Unsigned.$lesseq_uint((int)(N + S2), (int)64), (char.ptr)NativePointer.$((String)"isShiftedInt<N, S> with N + S > 64 is too wide."));
        return Native.$bool((boolean)MathExtrasLlvmGlobals.isInt(N + S2, x)) && Unsigned.$rem_ullong((long)x, (long)(1L << S2)) == Unsigned.$int2ullong((int)0);
    }

    public static boolean isUInt(int N, long x) {
        std.static_assert((boolean)Unsigned.$greater_uint((int)N, (int)0), (char.ptr)NativePointer.$((String)"isUInt<0> doesn't make sense."));
        return Unsigned.$greatereq_uint((int)N, (int)64) || Unsigned.$less_ulong_ullong((long)x, (long)(1L << N));
    }

    public static boolean isUInt(long x) {
        throw new UnsupportedOperationException("Use fast specializations llvm.isUint8/16/24/32 or general llvm.isUIntN(N, x)");
    }

    public static boolean isUInt8(long x) {
        return (x & 0xFFFFFFFFFFFFFF00L) == 0L;
    }

    public static boolean isUInt16(long x) {
        return (x & 0xFFFFFFFFFFFF0000L) == 0L;
    }

    public static boolean isUInt24(long x) {
        return (x & 0xFFFFFFFFFF000000L) == 0L;
    }

    public static boolean isUInt32(long x) {
        return (x & 0xFFFFFFFF00000000L) == 0L;
    }

    public static boolean isShiftedUInt(int N, int S2, long x) {
        std.static_assert((boolean)Unsigned.$greater_uint((int)N, (int)0), (char.ptr)NativePointer.$((String)"isShiftedUInt<0> doesn't make sense (refers to a 0-bit number)"));
        std.static_assert((boolean)Unsigned.$lesseq_uint((int)(N + S2), (int)64), (char.ptr)NativePointer.$((String)"isShiftedUInt<N, S> with N + S > 64 is too wide."));
        return Native.$bool((boolean)MathExtrasLlvmGlobals.isUInt(N + S2, x)) && Unsigned.$rem_ulong_ullong((long)x, (long)(1L << S2)) == Unsigned.$int2ullong((int)0);
    }

    public static long maxUIntN(long N) {
        assert (Unsigned.$greater_ulong_ullong((long)N, (long)Unsigned.$int2ullong((int)0)) && Unsigned.$lesseq_ulong_ullong((long)N, (long)Unsigned.$int2ullong((int)64))) : "integer width out of range";
        return -1L >>> (int)(Unsigned.$int2ullong((int)64) - N);
    }

    public static long minIntN(long N) {
        assert (N > 0L && N <= 64L) : "integer width out of range";
        return -(1L << (int)(N - 1L));
    }

    public static long maxIntN(long N) {
        assert (N > 0L && N <= 64L) : "integer width out of range";
        return (1L << (int)(N - 1L)) - Unsigned.$int2ullong((int)1);
    }

    public static boolean isUIntN(int N, long x) {
        return Unsigned.$greatereq_uint((int)N, (int)64) || Unsigned.$lesseq_ulong((long)x, (long)MathExtrasLlvmGlobals.maxUIntN(Unsigned.$uint2ulong((int)N)));
    }

    public static boolean isIntN(int N, long x) {
        return Unsigned.$greatereq_uint((int)N, (int)64) || MathExtrasLlvmGlobals.minIntN(Unsigned.$uint2long((int)N)) <= x && x <= MathExtrasLlvmGlobals.maxIntN(Unsigned.$uint2long((int)N));
    }

    public static boolean isMask_32(int Value) {
        return Value != 0 && (Value + 1 & Value) == 0;
    }

    public static boolean isMask_64(long Value) {
        return Value != 0L && (Value + Unsigned.$int2ullong((int)1) & Value) == Unsigned.$int2ullong((int)0);
    }

    public static boolean isShiftedMask_32(int Value) {
        return Value != 0 && MathExtrasLlvmGlobals.isMask_32(Value - 1 | Value);
    }

    public static boolean isShiftedMask_64(long Value) {
        return Value != 0L && MathExtrasLlvmGlobals.isMask_64(Value - Unsigned.$int2ullong((int)1) | Value);
    }

    public static boolean isPowerOf2_32(int Value) {
        return Value != 0 && (Value & Value - 1) == 0;
    }

    public static boolean isPowerOf2_64(long Value) {
        return Value != 0L && (Value & Value - 1L) == 0L;
    }

    public static char ByteSwap_16(char Value) {
        return sys.SwapByteOrder_16(Value);
    }

    public static int ByteSwap_32(int Value) {
        return sys.SwapByteOrder_32(Value);
    }

    public static long ByteSwap_64(long Value) {
        return sys.SwapByteOrder_64(Value);
    }

    public static <T> int countLeadingOnes(T Value) {
        return MathExtrasLlvmGlobals.countLeadingOnes(Value, ZeroBehavior.ZB_Width);
    }

    public static <T> int countLeadingOnes(T Value, ZeroBehavior ZB) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <T> int countTrailingOnes(T Value) {
        return MathExtrasLlvmGlobals.countTrailingOnes(Value, ZeroBehavior.ZB_Width);
    }

    public static <T> int countTrailingOnes(T Value, ZeroBehavior ZB) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <T> int countPopulation(T Value) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static double Log2(double Value) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static int Log2_32(int Value) {
        return 31 - MathExtrasLlvmGlobals.countLeadingZeros(Value);
    }

    public static int Log2_64(long Value) {
        return 63 - MathExtrasLlvmGlobals.countLeadingZeros(Value);
    }

    public static int Log2_32_Ceil(int Value) {
        return 32 - MathExtrasLlvmGlobals.countLeadingZeros(Value - 1);
    }

    public static int Log2_64_Ceil(long Value) {
        return 64 - MathExtrasLlvmGlobals.countLeadingZeros(Value - Unsigned.$int2ullong((int)1));
    }

    public static long GreatestCommonDivisor64(long A, long B) {
        while (B != 0L) {
            long T4 = B;
            B = Unsigned.$rem_ulong((long)A, (long)B);
            A = T4;
        }
        return A;
    }

    public static double BitsToDouble(long Bits) {
        class Unnamed_union {
            public long L;
            public double D;

            public String toString() {
                return "L=" + this.L + ", D=" + this.D;
            }
        }
        Unnamed_union T4 = new Unnamed_union();
        T4.L = Bits;
        return T4.D;
    }

    public static float BitsToFloat(int Bits) {
        class Unnamed_union {
            public int I;
            public float F;

            public String toString() {
                return "I=" + this.I + ", F=" + this.F;
            }
        }
        Unnamed_union T4 = new Unnamed_union();
        T4.I = Bits;
        return T4.F;
    }

    public static long DoubleToBits(double Double2) {
        class Unnamed_union {
            public long L;
            public double D;

            public String toString() {
                return "L=" + this.L + ", D=" + this.D;
            }
        }
        Unnamed_union T4 = new Unnamed_union();
        T4.D = Double2;
        return T4.L;
    }

    public static int FloatToBits(float Float2) {
        class Unnamed_union {
            public int I;
            public float F;

            public String toString() {
                return "I=" + this.I + ", F=" + this.F;
            }
        }
        Unnamed_union T4 = new Unnamed_union();
        T4.F = Float2;
        return T4.I;
    }

    public static long MinAlign(long A, long B) {
        return (A | B) & Unsigned.$int2ullong((int)1) + ((A | B) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static Object alignAddr(Object Addr, int Alignment) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static int alignmentAdjustment(Object Ptr2, int Alignment) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static long NextPowerOf2(long A) {
        A |= A >>> 1;
        A |= A >>> 2;
        A |= A >>> 4;
        A |= A >>> 8;
        A |= A >>> 16;
        A |= A >>> 32;
        return A + Unsigned.$int2ullong((int)1);
    }

    public static long PowerOf2Floor(long A) {
        if (A == 0L) {
            return Unsigned.$int2ulong((int)0);
        }
        return 1L << 63 - MathExtrasLlvmGlobals.countLeadingZeros(A, ZeroBehavior.ZB_Undefined);
    }

    public static long alignTo(long Value, long Align) {
        return MathExtrasLlvmGlobals.alignTo(Value, Align, Unsigned.$int2ulong((int)0));
    }

    public static long alignTo(long Value, long Align, long Skew) {
        Skew = Unsigned.$rem_ulong((long)Skew, (long)Align);
        return Unsigned.$div_ullong_ulong((long)(Value + Align - Unsigned.$int2ullong((int)1) - Skew), (long)Align) * Align + Skew;
    }

    public static long alignDown(long Value, long Align) {
        return MathExtrasLlvmGlobals.alignDown(Value, Align, Unsigned.$int2ulong((int)0));
    }

    public static long alignDown(long Value, long Align, long Skew) {
        Skew = Unsigned.$rem_ulong((long)Skew, (long)Align);
        return Unsigned.$div_ullong_ulong((long)(Value - Skew), (long)Align) * Align + Skew;
    }

    public static long OffsetToAlignment(long Value, long Align) {
        return MathExtrasLlvmGlobals.alignTo(Value, Align) - Value;
    }

    public static int SignExtend32$T(int B, int X2) {
        std.static_assert((boolean)Unsigned.$greater_uint((int)B, (int)0), (char.ptr)NativePointer.$((String)"Bit width can't be 0."));
        std.static_assert((boolean)Unsigned.$lesseq_uint((int)B, (int)32), (char.ptr)NativePointer.$((String)"Bit width out of range."));
        return X2 << 32 - B >> 32 - B;
    }

    public static int SignExtend32(int X2, int B) {
        assert (Unsigned.$greater_uint((int)B, (int)0)) : "Bit width can't be 0.";
        assert (Unsigned.$lesseq_uint((int)B, (int)32)) : "Bit width out of range.";
        return X2 << 32 - B >> 32 - B;
    }

    public static long SignExtend64$T(int B, long x) {
        std.static_assert((boolean)Unsigned.$greater_uint((int)B, (int)0), (char.ptr)NativePointer.$((String)"Bit width can't be 0."));
        std.static_assert((boolean)Unsigned.$lesseq_uint((int)B, (int)64), (char.ptr)NativePointer.$((String)"Bit width out of range."));
        return x << 64 - B >> 64 - B;
    }

    public static long SignExtend64(long X2, int B) {
        assert (Unsigned.$greater_uint((int)B, (int)0)) : "Bit width can't be 0.";
        assert (Unsigned.$lesseq_uint((int)B, (int)64)) : "Bit width out of range.";
        return X2 << 64 - B >> 64 - B;
    }

    public static <T> T AbsoluteDifference$Unsigned(T X2, T Y) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <T> T SaturatingAdd$Unsigned(T X2, T Y) {
        return MathExtrasLlvmGlobals.SaturatingAdd$Unsigned(X2, Y, null);
    }

    public static <T> T SaturatingAdd$Unsigned(T X2, T Y, bool.ptr ResultOverflowed) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <T> T SaturatingMultiply$Unsigned(T X2, T Y) {
        return MathExtrasLlvmGlobals.SaturatingMultiply$Unsigned(X2, Y, null);
    }

    public static <T> T SaturatingMultiply$Unsigned(T X2, T Y, bool.ptr ResultOverflowed) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <T> T SaturatingMultiplyAdd$Unsigned(T X2, T Y, T A) {
        return MathExtrasLlvmGlobals.SaturatingMultiplyAdd$Unsigned(X2, Y, A, null);
    }

    public static <T> T SaturatingMultiplyAdd$Unsigned(T X2, T Y, T A, bool.ptr ResultOverflowed) {
        throw new UnsupportedOperationException("EmptyBody");
    }
}

