/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support.impl;

import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.clank.support.literal_constants;
import org.clank.support.void;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.StringMap;
import org.llvm.cl.ClGlobals;
import org.llvm.cl.Option;
import org.llvm.cl.SubCommand;
import org.llvm.support.impl.CommandLineStatics;
import org.llvm.support.llvm;

public class HelpPrinter
implements type.ref<Boolean>,
Destructors.ClassWithDestructor {
    protected final boolean ShowHidden;

    protected void printOptions(SmallVector<std_pair.pairTypePtr<char.ptr, Option>> Opts, int MaxArgLen) {
        int e = Opts.size();
        for (int i = 0; i != e; ++i) {
            ((Option)((std_pair.pairTypePtr)Opts.$at((int)i)).second).printOptionInfo(MaxArgLen);
        }
    }

    protected void printSubCommands(SmallVector<std_pair.pairTypePtr<char.ptr, SubCommand>> Subs, int MaxSubLen) {
        for (std_pair.pairTypePtr pairTypePtr2 : Subs) {
            llvm.outs().$out("  ").$out((char.ptr)pairTypePtr2.first);
            if (Native.$bool((Native.Native$Bool)((SubCommand)pairTypePtr2.second).getDescription())) {
                llvm.outs().indent(MaxSubLen - std.strlen((char.ptr)((char.ptr)pairTypePtr2.first)));
                llvm.outs().$out(" - ").$out(((SubCommand)pairTypePtr2.second).getDescription());
            }
            llvm.outs().$out(literal_constants.$LF);
        }
    }

    public HelpPrinter(boolean showHidden) {
        this.ShowHidden = showHidden;
    }

    public void $destroy() {
    }

    public void $assign(boolean Value) {
        int e;
        if (!Value) {
            return;
        }
        SubCommand Sub = CommandLineStatics.GlobalParser.$arrow().getActiveSubCommand();
        StringMap<Option> OptionsMap = Sub.OptionsMap;
        SmallVector<Option> PositionalOpts = Sub.PositionalOpts;
        Option ConsumeAfterOpt = Sub.ConsumeAfterOpt;
        SmallVector<std_pair.pairTypePtr<char.ptr, Option>> Opts = new SmallVector<std_pair.pairTypePtr<char.ptr, Option>>(128, new std_pair.pairTypePtr());
        CommandLineStatics.sortOpts(OptionsMap, Opts, this.ShowHidden);
        SmallVector<std_pair.pairTypePtr<char.ptr, SubCommand>> Subs = new SmallVector<std_pair.pairTypePtr<char.ptr, SubCommand>>(128, new std_pair.pairTypePtr());
        CommandLineStatics.sortSubCommands(CommandLineStatics.GlobalParser.$arrow().RegisteredSubCommands, Subs);
        if (Native.$bool((Native.Native$Bool)CommandLineStatics.GlobalParser.$arrow().ProgramOverview)) {
            llvm.outs().$out("OVERVIEW: ").$out(CommandLineStatics.GlobalParser.$arrow().ProgramOverview).$out(literal_constants.$LF);
        }
        if (Sub == Native.$AddrOf((Object)ClGlobals.TopLevelSubCommand.$star())) {
            llvm.outs().$out("USAGE: ").$out(CommandLineStatics.GlobalParser.$arrow().ProgramName).$out(" [subcommand] [options]");
        } else {
            if (Native.$noteq_ptr((void.ptr)Sub.getDescription(), null)) {
                llvm.outs().$out("SUBCOMMAND '").$out(Sub.getName()).$out("': ").$out(Sub.getDescription()).$out("\n\n");
            }
            llvm.outs().$out("USAGE: ").$out(CommandLineStatics.GlobalParser.$arrow().ProgramName).$out(literal_constants.$SPACE).$out(Sub.getName()).$out(" [options]");
        }
        for (Option Opt : PositionalOpts) {
            if (Opt.hasArgStr()) {
                llvm.outs().$out(" --").$out(Opt.ArgStr);
            }
            llvm.outs().$out(literal_constants.$SPACE).$out(Opt.HelpStr);
        }
        if (ConsumeAfterOpt != null) {
            llvm.outs().$out(literal_constants.$SPACE).$out(ConsumeAfterOpt.HelpStr);
        }
        if (Sub == Native.$AddrOf((Object)ClGlobals.TopLevelSubCommand.$star()) && Unsigned.$greater_uint((int)Subs.size(), (int)2)) {
            int MaxSubLen = 0;
            e = Subs.size();
            for (int i = 0; i != e; ++i) {
                MaxSubLen = std.max((int)MaxSubLen, (int)std.strlen((char.ptr)((char.ptr)((std_pair.pairTypePtr)Subs.$at((int)i)).first)));
            }
            llvm.outs().$out("\n\n");
            llvm.outs().$out("SUBCOMMANDS:\n\n");
            this.printSubCommands(Subs, MaxSubLen);
            llvm.outs().$out(literal_constants.$LF);
            llvm.outs().$out("  Type \"").$out(CommandLineStatics.GlobalParser.$arrow().ProgramName).$out(" <subcommand> -help\" to get more help on a specific subcommand");
        }
        llvm.outs().$out("\n\n");
        int MaxArgLen = 0;
        e = Opts.size();
        for (int i = 0; i != e; ++i) {
            MaxArgLen = std.max((int)MaxArgLen, (int)((Option)((std_pair.pairTypePtr)Opts.$at((int)i)).second).getOptionWidth());
        }
        llvm.outs().$out("OPTIONS:\n");
        this.printOptions(Opts, MaxArgLen);
        for (char.ptr I : CommandLineStatics.GlobalParser.$arrow().MoreHelp) {
            llvm.outs().$out(I);
        }
        CommandLineStatics.GlobalParser.$arrow().MoreHelp.clear();
        std.exit((int)0);
    }

    public Boolean $deref() {
        return this.ShowHidden;
    }

    public Boolean $set(Boolean value) {
        assert (this.ShowHidden == value);
        return value;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{ShowHidden=" + this.ShowHidden + '}' + System.identityHashCode(this);
    }
}

