/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support.impl;

import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.java.std_ptr;
import org.clank.support.Native;
import org.clank.support.NativeCallback;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.Unsigned;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.clank.support.aliases.int;
import org.clank.support.aliases.type;
import org.clank.support.void;
import org.llvm.adt.SmallPtrSet;
import org.llvm.adt.SmallPtrSetImpl;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.ArrayRefChar;
import org.llvm.adt.aliases.DenseMapInfo$LikePtr;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.adt.aliases.StringMap;
import org.llvm.adt.aliases.StringMapEntry;
import org.llvm.adt.aliases.StringMapIterator;
import org.llvm.cl.ClGlobals;
import org.llvm.cl.FormattingFlags;
import org.llvm.cl.NumOccurrencesFlag;
import org.llvm.cl.Option;
import org.llvm.cl.OptionCategory;
import org.llvm.cl.OptionHidden;
import org.llvm.cl.SubCommand;
import org.llvm.cl.ValueExpected;
import org.llvm.cl.aliases.optBool;
import org.llvm.cl.cat;
import org.llvm.cl.desc;
import org.llvm.cl.opt;
import org.llvm.cl.parserBoolean;
import org.llvm.cl.sub;
import org.llvm.support.ErrorOr;
import org.llvm.support.ManagedStatic;
import org.llvm.support.ManagedStaticInfo;
import org.llvm.support.MemoryBuffer;
import org.llvm.support.StringSaver;
import org.llvm.support.impl.CategorizedHelpPrinter;
import org.llvm.support.impl.CommandLineParser;
import org.llvm.support.impl.HelpPrinter;
import org.llvm.support.impl.HelpPrinterWrapper;
import org.llvm.support.impl.VersionPrinter;
import org.llvm.support.llvm;
import org.llvm.support.sys.ManagedStaticInfoImpl;
import org.llvm.support.sys.sys;

public final class CommandLineStatics {
    public static final ManagedStatic<CommandLineParser> GlobalParser = new ManagedStatic<CommandLineParser>(new ManagedStaticInfoImpl<CommandLineParser>(){

        @Override
        protected CommandLineParser create() {
            return new CommandLineParser();
        }
    });
    public static final boolean USE_NEW_CL_PARSER = false;
    private static final String PREMAIN = "<premain>";
    public static final char.ptr ProgramName;
    public static char.ptr ProgramOverview;
    public static final ManagedStatic<std.vectorCharPtr> MoreHelp;
    public static boolean OptionListChanged;
    public static Option RegisteredOptionList;
    private static final ManagedStaticInfo<SmallPtrSet<OptionCategory>> StaticOptionCatSet;
    public static final ManagedStatic<SmallPtrSet<OptionCategory>> RegisteredOptionCategories;
    private static final NativeCallback.BoolPredicate<Option> isGroupingCallback;
    private static final NativeCallback.BoolPredicate<Option> isPrefixedOrGroupingCallback;
    public static final int MaxOptWidth = 8;
    public static final HelpPrinter UncategorizedNormalPrinter;
    public static final HelpPrinter UncategorizedHiddenPrinter;
    public static final CategorizedHelpPrinter CategorizedNormalPrinter;
    public static final CategorizedHelpPrinter CategorizedHiddenPrinter;
    public static final HelpPrinterWrapper WrappedNormalPrinter;
    public static final HelpPrinterWrapper WrappedHiddenPrinter;
    public static final OptionCategory GenericCategory;
    public static optBool HLOp;
    public static optBool HLHOp;
    public static final opt<Boolean> PrintOptions;
    public static final opt<Boolean> PrintAllOptions;
    public static NativeCallback.Void2Void OverrideVersionPrinter;
    public static std.vector<NativeCallback.Void2Void> ExtraVersionPrinters;
    public static final VersionPrinter VersionPrinterInstance;

    public static void MarkOptionsChanged() {
        OptionListChanged = true;
    }

    public static boolean CommaSeparateAndAddOccurrence(Option Handler, int pos, StringRef ArgName, StringRef Value) {
        return CommandLineStatics.CommaSeparateAndAddOccurrence(Handler, pos, ArgName, Value, false);
    }

    public static boolean CommaSeparateAndAddOccurrence(Option Handler, int pos, StringRef ArgName, StringRef Value, boolean MultiArg) {
        if ((Handler.getMiscFlags() & 1) != 0) {
            StringRef Val = new StringRef(Value);
            int Pos2 = Val.find((byte)44);
            while (Pos2 != StringRef.npos) {
                if (Handler.addOccurrence(pos, ArgName, Val.substr(0, Pos2), MultiArg)) {
                    return true;
                }
                Val.$assign$substr(Pos2 + 1);
                Value.substr(Pos2 + 1);
                Pos2 = Val.find((byte)44);
            }
            Value.$assign(Val);
        }
        return Handler.addOccurrence(pos, new StringRef(ArgName), new StringRef(Value), MultiArg);
    }

    public static boolean ProvideOption(Option Handler, StringRef ArgName, StringRef Value, int argc, type.ptr<char.ptr> argv, int.ref i) {
        int NumAdditionalVals = Handler.getNumAdditionalVals();
        switch (Handler.getValueExpectedFlag()) {
            case ValueRequired: {
                if (Value.data() != null) break;
                if (i.$deref() + 1 >= argc) {
                    return Handler.error(new Twine("requires a value!"));
                }
                Value.$assign(new StringRef((char.ptr)argv.$at(i.$set(i.$deref() + 1))));
                break;
            }
            case ValueDisallowed: {
                if (NumAdditionalVals > 0) {
                    return Handler.error(new Twine("multi-valued option specified with ValueDisallowed modifier!"));
                }
                if (Value.data() == null) break;
                return Handler.error(llvm.$add_Twine(llvm.$add_Twine(new Twine("does not allow a value! '"), new Twine(Value)), new Twine("' specified.")));
            }
        }
        if (NumAdditionalVals == 0) {
            return CommandLineStatics.CommaSeparateAndAddOccurrence(Handler, i.$deref(), ArgName, Value);
        }
        boolean MultiArg = false;
        if (Value.data() != null) {
            if (CommandLineStatics.CommaSeparateAndAddOccurrence(Handler, i.$deref(), ArgName, Value, MultiArg)) {
                return true;
            }
            --NumAdditionalVals;
            MultiArg = true;
        }
        while (NumAdditionalVals > 0) {
            if (i.$deref() + 1 >= argc) {
                return Handler.error(new Twine("not enough values!"));
            }
            Value.$assign(new StringRef((char.ptr)argv.$at(i.$set(i.$deref() + 1))));
            if (CommandLineStatics.CommaSeparateAndAddOccurrence(Handler, i.$deref(), ArgName, Value, MultiArg)) {
                return true;
            }
            MultiArg = true;
            --NumAdditionalVals;
        }
        return false;
    }

    public static boolean ProvidePositionalOption(Option Handler, StringRef Arg, int i) {
        int.ref Dummy = NativePointer.create_int$ref((int)i);
        return CommandLineStatics.ProvideOption(Handler, new StringRef(Handler.ArgStr), Arg, 0, null, Dummy);
    }

    public static boolean isGrouping(Option O) {
        return O.getFormattingFlag() == FormattingFlags.Grouping;
    }

    public static boolean isPrefixedOrGrouping(Option O) {
        return CommandLineStatics.isGrouping(O) || O.getFormattingFlag() == FormattingFlags.Prefix;
    }

    public static Option getOptionPred(StringRef Name2, int.ref Length, NativeCallback.BoolPredicate<Option> Pred, StringMap<Option> OptionsMap) {
        StringMapIterator OMI = (StringMapIterator)Native.$tryClone(OptionsMap.find(Name2));
        while (OMI.$eq(OptionsMap.end()) && Name2.size() > 1) {
            Name2.$assign$substr(0, Name2.size() - 1);
            OMI.$assign(OptionsMap.find(Name2));
        }
        if (OMI.$noteq(OptionsMap.end()) && Pred.$call((Object)((Option)((StringMapEntry)OMI.$arrow()).second))) {
            Length.$set(Name2.size());
            return (Option)((StringMapEntry)OMI.$arrow()).second;
        }
        return null;
    }

    public static Option HandlePrefixedOrGroupedOption(StringRef Arg, StringRef Value, bool.ref ErrorParsing, StringMap<Option> OptionsMap) {
        if (Arg.size() == 1) {
            return null;
        }
        int.ref $Length = NativePointer.create_int$ref((int)0);
        Option PGOpt = CommandLineStatics.getOptionPred(Arg, $Length, isPrefixedOrGroupingCallback, OptionsMap);
        int Length = $Length.$deref();
        if (PGOpt == null) {
            return null;
        }
        if (PGOpt.getFormattingFlag() == FormattingFlags.Prefix) {
            Value.$assign(Arg.substr(Length));
            Arg.$assign$substr(0, Length);
            assert (OptionsMap.count(Arg) != 0 && ((StringMapEntry)OptionsMap.find((StringRef)Arg).$arrow()).second == PGOpt);
            return PGOpt;
        }
        assert (CommandLineStatics.isGrouping(PGOpt)) : "Broken getOptionPred!";
        do {
            StringRef OneArgName = Arg.substr(0, Length);
            Arg.$assign$substr(Length);
            assert (PGOpt.getValueExpectedFlag() != ValueExpected.ValueRequired) : "Option can not be cl::Grouping AND cl::ValueRequired!";
            int.ref Dummy = NativePointer.create_int$ref((int)0);
            boolean _ErrorParsing = ErrorParsing.$deref();
            ErrorParsing.$set(ErrorParsing.$deref() | (_ErrorParsing |= CommandLineStatics.ProvideOption(PGOpt, OneArgName, new StringRef(), 0, null, Dummy)));
            $Length.$set(Length);
            PGOpt = CommandLineStatics.getOptionPred(Arg, $Length, isGroupingCallback, OptionsMap);
            Length = $Length.$deref();
        } while (PGOpt != null && Length != Arg.size());
        return PGOpt;
    }

    public static boolean RequiresValue(Option O) {
        return O.getNumOccurrencesFlag() == NumOccurrencesFlag.Required || O.getNumOccurrencesFlag() == NumOccurrencesFlag.OneOrMore;
    }

    public static boolean EatsUnboundedNumberOfValues(Option O) {
        return O.getNumOccurrencesFlag() == NumOccurrencesFlag.ZeroOrMore || O.getNumOccurrencesFlag() == NumOccurrencesFlag.OneOrMore;
    }

    public static boolean isWhitespace(byte C2) {
        return std.strchr((CharSequence)" \t\n\r\f\u000b", (int)C2) != null;
    }

    public static boolean isQuote(byte C2) {
        return C2 == 34 || C2 == 39;
    }

    public static boolean isGNUSpecial(byte C2) {
        return std.strchr((CharSequence)"\\\"' ", (int)C2) != null;
    }

    public static int parseBackslash(StringRef Src, int I, SmallString Token2) {
        boolean FollowedByDoubleQuote;
        int E = Src.size();
        int BackslashCount = 0;
        do {
            ++BackslashCount;
        } while (++I != E && Src.$at(I) == 92);
        boolean bl = FollowedByDoubleQuote = I != E && Src.$at(I) == 34;
        if (FollowedByDoubleQuote) {
            Token2.append(BackslashCount / 2, (byte)92);
            if (BackslashCount % 2 == 0) {
                return I - 1;
            }
            Token2.push_back((byte)34);
            return I;
        }
        Token2.append(BackslashCount, (byte)92);
        return I - 1;
    }

    public static boolean hasUTF8ByteOrderMark(ArrayRefChar S2) {
        return Unsigned.$greatereq_uint((int)S2.size(), (int)3) && S2.$at(0) == -17 && S2.$at(1) == -69 && S2.$at(2) == -65;
    }

    public static boolean ExpandResponseFile(char.ptr FName, StringSaver Saver, ClGlobals.TokenizerCallback Tokenizer, SmallVectorImpl<char.ptr> NewArgv) {
        return CommandLineStatics.ExpandResponseFile(FName, Saver, Tokenizer, NewArgv, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean ExpandResponseFile(char.ptr FName, StringSaver Saver, ClGlobals.TokenizerCallback Tokenizer, SmallVectorImpl<char.ptr> NewArgv, boolean MarkEOLs) {
        std.string UTF8Buf = null;
        try {
            ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> MemBufOrErr = MemoryBuffer.getFile(new Twine(FName));
            if (!MemBufOrErr.$bool()) {
                boolean bl = false;
                return bl;
            }
            MemoryBuffer MemBuf = (MemoryBuffer)MemBufOrErr.get().$star();
            StringRef Str = new StringRef(MemBuf.getBufferStart(), MemBuf.getBufferSize());
            ArrayRefChar BufRef = new ArrayRefChar(MemBuf.getBufferStart(), MemBuf.getBufferEnd());
            UTF8Buf = new std.string();
            if (llvm.hasUTF16ByteOrderMark(new ArrayRefChar(BufRef))) {
                if (!llvm.convertUTF16ToUTF8String(new ArrayRefChar(BufRef), UTF8Buf)) {
                    boolean bl = false;
                    return bl;
                }
                Str.$assign(new StringRef(UTF8Buf));
            }
            Tokenizer.$call(new StringRef(Str), Saver, NewArgv, MarkEOLs);
            boolean bl = true;
            return bl;
        }
        finally {
            if (UTF8Buf != null) {
                UTF8Buf.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void GetOptionInfo(SmallVectorImpl<Option> PositionalOpts, SmallVectorImpl<Option> SinkOpts, StringMap<Option> OptionsMap) {
        SmallVector<StringRef> OptionNames = null;
        try {
            boolean HadErrors = false;
            OptionNames = new SmallVector<StringRef>(16, new StringRef());
            Option CAOpt = null;
            for (Option O = RegisteredOptionList; O != null; O = O.getNextRegisteredOption()) {
                O.getExtraOptionNames(OptionNames);
                if (O.hasArgStr()) {
                    OptionNames.push_back(O.ArgStr);
                }
                int e = OptionNames.size();
                for (int i = 0; i != e; ++i) {
                    if (OptionsMap.insert((std_pair.pair<StringRef, Option>)std.make_pair((Object)new StringRef((StringRef)((StringRef)OptionNames.$at((int)i))), (Object)O)).second) continue;
                    llvm.errs().$out(ProgramName).$out(NativePointer.$((String)": CommandLine Error: Option '")).$out((StringRef)OptionNames.$at(i)).$out(NativePointer.$((String)"' registered more than once!\n"));
                    HadErrors = true;
                }
                OptionNames.clear();
                if (O.getFormattingFlag() == FormattingFlags.Positional) {
                    PositionalOpts.push_back(O);
                    continue;
                }
                if ((O.getMiscFlags() & 4) != 0) {
                    SinkOpts.push_back(O);
                    continue;
                }
                if (O.getNumOccurrencesFlag() != NumOccurrencesFlag.ConsumeAfter) continue;
                if (CAOpt != null) {
                    O.error(new Twine(NativePointer.$((String)"Cannot specify more than one option with cl::ConsumeAfter!")));
                    HadErrors = true;
                }
                CAOpt = O;
            }
            if (CAOpt != null) {
                PositionalOpts.push_back(CAOpt);
            }
            std.reverse(PositionalOpts.begin(), PositionalOpts.end());
            if (HadErrors) {
                llvm.report_fatal_error(NativePointer.$((String)"inconsistency in registered CommandLine options"));
            }
        }
        finally {
            if (OptionNames != null) {
                OptionNames.$destroy();
            }
        }
    }

    public static Option LookupOption(StringRef Arg, StringRef Value, StringMap<Option> OptionsMap) {
        if (Arg.empty()) {
            return null;
        }
        int EqualPos = Arg.find(NativePointer.$((char)'='));
        if (EqualPos == StringRef.npos) {
            StringMapIterator I = (StringMapIterator)Native.$tryClone(OptionsMap.find(Arg));
            return I.$noteq(OptionsMap.end()) ? (Option)((StringMapEntry)I.$arrow()).second : null;
        }
        StringMapIterator I = (StringMapIterator)Native.$tryClone(OptionsMap.find(Arg.substr(0, EqualPos)));
        if (I.$eq(OptionsMap.end())) {
            return null;
        }
        Value.$assign(Arg.substr(EqualPos + 1));
        Arg.$assign$substr(0, EqualPos);
        return (Option)((StringMapEntry)I.$arrow()).second;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Option LookupNearestOption(StringRef Arg, StringMap<Option> OptionsMap, std.string NearestString) {
        if (Arg.empty()) {
            return null;
        }
        std_pair.pairTypeType<StringRef, StringRef> SplitArg = Arg.split('=');
        StringRef LHS = (StringRef)SplitArg.first;
        StringRef RHS = (StringRef)SplitArg.second;
        Option Best = null;
        int BestDistance = 0;
        StringMapIterator it = (StringMapIterator)Native.$tryClone(OptionsMap.begin());
        StringMapIterator ie = (StringMapIterator)Native.$tryClone(OptionsMap.end());
        while (it.$noteq(ie)) {
            SmallVector<StringRef> OptionNames = null;
            try {
                Option O = (Option)((StringMapEntry)it.$arrow()).second;
                OptionNames = new SmallVector<StringRef>(16, new StringRef());
                O.getExtraOptionNames(OptionNames);
                if (O.hasArgStr()) {
                    OptionNames.push_back(O.ArgStr);
                }
                boolean PermitValue = O.getValueExpectedFlag() != ValueExpected.ValueDisallowed;
                StringRef Flag = PermitValue ? LHS : Arg;
                int e = OptionNames.size();
                for (int i = 0; i != e; ++i) {
                    StringRef Name2 = new StringRef((StringRef)OptionNames.$at(i));
                    int Distance = new StringRef(Name2).edit_distance(Flag, true, BestDistance);
                    if (Best != null && Distance >= BestDistance) continue;
                    Best = O;
                    BestDistance = Distance;
                    if (RHS.empty() || !PermitValue) {
                        NearestString.$assignMove(Name2.$string());
                        continue;
                    }
                    NearestString.$assignMove(llvm.$add_Twine$C(llvm.$add_Twine$C(new Twine(Name2), new Twine(NativePointer.$EQ)), new Twine(RHS)).str());
                }
            }
            finally {
                if (OptionNames != null) {
                    OptionNames.$destroy();
                }
            }
            it.$preInc();
        }
        return Best;
    }

    public static StringRef getValueStr(Option O, StringRef DefaultMsg) {
        if (O.ValueStr.empty()) {
            return DefaultMsg;
        }
        return new StringRef(O.ValueStr);
    }

    public static void printHelpStr(StringRef HelpStr, int Indent, int FirstLineIndentedBy) {
        std_pair.pairTypeType<StringRef, StringRef> Split = HelpStr.split((byte)10);
        llvm.outs().indent(Indent - FirstLineIndentedBy).$out(" - ").$out((StringRef)Split.first).$out(NativePointer.$LF);
        while (!((StringRef)Split.second).empty()) {
            Split.$assignMove(((StringRef)Split.second).split((byte)10));
            llvm.outs().indent(Indent).$out((StringRef)Split.first).$out(NativePointer.$LF);
        }
    }

    public static boolean parseDouble(Option O, StringRef Arg, type.ref<Double> Value) {
        NativeTrace.traceNotImplemented((String)"CommandLineStatics.parseDouble");
        SmallString TmpStr = new SmallString(Arg.begin(), Arg.end(), 32);
        char.ptr ArgStart = Native.$tryClone((char.ptr)TmpStr.c_str());
        char.ptr End2 = NativePointer.create_char$ptr((byte[])NativePointer.new$char((int)0, (byte[])new byte[0]));
        Value.$set((Object)std.strtod((char.ptr)ArgStart, (type.ptr)End2.$addr()));
        if (End2.$star() != 0) {
            return O.error(llvm.$add_Twine(llvm.$add_T_StringRef("'", Arg), new Twine("' value invalid for floating point argument!")));
        }
        return false;
    }

    public static int OptNameCompare(std_pair.pairTypePtr<char.ptr, Option> LHS, std_pair.pairTypePtr<char.ptr, Option> RHS) {
        return std.strcmp((char.ptr)((char.ptr)LHS.first), (char.ptr)((char.ptr)RHS.first));
    }

    public static int SubNameCompare(std_pair.pairTypePtr<char.ptr, SubCommand> LHS, std_pair.pairTypePtr<char.ptr, SubCommand> RHS) {
        return std.strcmp((char.ptr)((char.ptr)LHS.first), (char.ptr)((char.ptr)RHS.first));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sortOpts(StringMap<Option> OptMap, SmallVectorImpl<std_pair.pairTypePtr<char.ptr, Option>> Opts, boolean ShowHidden) {
        SmallPtrSet OptionSet = null;
        try {
            OptionSet = new SmallPtrSet(DenseMapInfo$LikePtr.$Info(), 128);
            StringMapIterator I = (StringMapIterator)Native.$tryClone(OptMap.begin());
            StringMapIterator E = (StringMapIterator)Native.$tryClone(OptMap.end());
            while (I.$noteq(E)) {
                if (((Option)((StringMapEntry)I.$arrow()).second).getOptionHiddenFlag() != OptionHidden.ReallyHidden && (((Option)((StringMapEntry)I.$arrow()).second).getOptionHiddenFlag() != OptionHidden.Hidden || ShowHidden) && OptionSet.insert((Option)((StringMapEntry)I.$arrow()).second).second) {
                    Opts.push_back((std_pair.pairTypePtr<char.ptr, Option>)new std_pair.pairTypePtr((Object)((StringMapEntry)I.$arrow()).getKey().data(), (Object)((Option)((StringMapEntry)I.$arrow()).second)));
                }
                I.$preInc();
            }
            std.qsort(Opts.data(), (int)Opts.size(), (int)-1, CommandLineStatics::OptNameCompare);
        }
        finally {
            if (OptionSet != null) {
                OptionSet.$destroy();
            }
        }
    }

    public static void sortSubCommands(SmallPtrSetImpl<SubCommand> SubMap, SmallVectorImpl<std_pair.pairTypePtr<char.ptr, SubCommand>> Subs) {
        for (SubCommand S2 : SubMap) {
            if (Native.$eq_ptr((void.ptr)S2.getName(), null)) continue;
            Subs.push_back((std_pair.pairTypePtr<char.ptr, SubCommand>)std.make_pair_T_Ptr((Object)S2.getName(), (Object)S2));
        }
        llvm.array_pod_sort(Subs.begin(), Subs.end(), CommandLineStatics::SubNameCompare);
    }

    public static void resetAllOptionsPre39() {
        for (Option O = RegisteredOptionList; O != null; O = O.getNextRegisteredOption()) {
            O.reset();
        }
    }

    public static void java$shutdown() {
        ClGlobals.ResetAllOptionOccurrences();
        ClGlobals.ResetCommandLineParser();
        OverrideVersionPrinter = null;
        if (ExtraVersionPrinters != null) {
            ExtraVersionPrinters.clear();
            ExtraVersionPrinters = null;
        }
        assert (!PrintAllOptions.$T().booleanValue()) : "generated with initial false: " + PrintAllOptions.$T();
        assert (!PrintOptions.$T().booleanValue()) : "generated with initial false: " + PrintOptions.$T();
        assert (!CommandLineStatics.UncategorizedNormalPrinter.ShowHidden) : "generated with initial false";
        assert ((Boolean)HLOp.$T() == CommandLineStatics.UncategorizedNormalPrinter.ShowHidden) : "generated with initial " + UncategorizedNormalPrinter.$deref();
        assert (CommandLineStatics.UncategorizedHiddenPrinter.ShowHidden) : "generated with initial true";
        assert ((Boolean)HLHOp.$T() == CommandLineStatics.UncategorizedHiddenPrinter.ShowHidden) : "generated with initial " + UncategorizedHiddenPrinter.$deref();
        OptionListChanged = false;
        ProgramOverview = null;
    }

    static {
        byte[] array2 = NativePointer.new$char((int)80, (byte[])new byte[0]);
        for (int i = 0; i < PREMAIN.length(); ++i) {
            array2[i] = (byte)PREMAIN.charAt(i);
        }
        array2[PREMAIN.length()] = 0;
        ProgramName = NativePointer.create_char$ptr((byte[])array2);
        ProgramOverview = null;
        MoreHelp = new ManagedStatic<std.vectorCharPtr>(sys.StaticStdVectorCharPtr);
        OptionListChanged = false;
        RegisteredOptionList = null;
        StaticOptionCatSet = new ManagedStaticInfoImpl<SmallPtrSet<OptionCategory>>(){

            @Override
            protected SmallPtrSet<OptionCategory> create() {
                return new SmallPtrSet<OptionCategory>(DenseMapInfo$LikePtr.$Info(), 16);
            }
        };
        RegisteredOptionCategories = new ManagedStatic<SmallPtrSet<OptionCategory>>(StaticOptionCatSet);
        isGroupingCallback = new NativeCallback.BoolPredicate<Option>(){

            public boolean $call(Option param) {
                return CommandLineStatics.isGrouping(param);
            }
        };
        isPrefixedOrGroupingCallback = new NativeCallback.BoolPredicate<Option>(){

            public boolean $call(Option param) {
                return CommandLineStatics.isPrefixedOrGrouping(param);
            }
        };
        UncategorizedNormalPrinter = new HelpPrinter(false);
        UncategorizedHiddenPrinter = new HelpPrinter(true);
        CategorizedNormalPrinter = new CategorizedHelpPrinter(false);
        CategorizedHiddenPrinter = new CategorizedHelpPrinter(true);
        WrappedNormalPrinter = new HelpPrinterWrapper(UncategorizedNormalPrinter, CategorizedNormalPrinter);
        WrappedHiddenPrinter = new HelpPrinterWrapper(UncategorizedHiddenPrinter, CategorizedHiddenPrinter);
        GenericCategory = new OptionCategory(NativePointer.$((String)"Generic Options"));
        HLOp = new optBool(opt.StorageKind.External, new parserBoolean(), new Object[]{NativePointer.$((String)"help-list"), new desc(NativePointer.$((String)"Display list of available options (-help-list-hidden for more)")), ClGlobals.location(UncategorizedNormalPrinter), OptionHidden.Hidden, ValueExpected.ValueDisallowed, new cat(GenericCategory), new sub(ClGlobals.AllSubCommands.$star())});
        HLHOp = new optBool(opt.StorageKind.External, new parserBoolean(), new Object[]{NativePointer.$((String)"help-list-hidden"), new desc(NativePointer.$((String)"Display list of all available options")), ClGlobals.location(UncategorizedHiddenPrinter), OptionHidden.Hidden, ValueExpected.ValueDisallowed, new cat(GenericCategory), new sub(ClGlobals.AllSubCommands.$star())});
        PrintOptions = new optBool(new Object[]{"print-options", new desc("Print non-default options after command line parsing"), OptionHidden.Hidden, ClGlobals.init(false)});
        PrintAllOptions = new optBool(new Object[]{"print-all-options", new desc("Print all option values after command line parsing"), OptionHidden.Hidden, ClGlobals.init(false)});
        OverrideVersionPrinter = null;
        ExtraVersionPrinters = null;
        VersionPrinterInstance = new VersionPrinter();
    }
}

