/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support.impl;

import org.clank.java.std;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.NativeType;
import org.clank.support.Unsigned;
import org.clank.support.aliases.uint;
import org.clank.support.aliases.ulong;
import org.clank.support.void;
import org.llvm.support.ZeroBehavior;
import org.llvm.support.llvm;

public final class APIntStatics {
    public static ulong.ptr getClearedMemory(int numWords) {
        assert (numWords >= 0) : "must be non negative " + numWords;
        ulong.ptr result = NativePointer.create_ulong$ptr((long[])NativePointer.new$ulong((int)numWords));
        assert (Native.$bool((Native.Native$Bool)result)) : "APInt memory allocation fails!";
        std.memset((ulong.ptr)result, (long)0L, (int)(numWords * NativeType.$sizeof_ULong()));
        return result;
    }

    public static ulong.ptr getMemory(int numWords) {
        assert (numWords >= 0) : "must be non negative " + numWords;
        ulong.ptr result = NativePointer.create_ulong$ptr((long[])NativePointer.new$ulong((int)numWords));
        assert (Native.$bool((Native.Native$Bool)result)) : "APInt memory allocation fails!";
        return result;
    }

    public static int getDigit(byte cdigit, int radix) {
        int r;
        assert (radix >= 0) : "must be non negative " + radix;
        if (radix == 16 || radix == 36) {
            r = cdigit - 48;
            if (r <= 9) {
                return r;
            }
            r = cdigit - 65;
            if (r <= radix - 11) {
                return r + 10;
            }
            r = cdigit - 97;
            if (r <= radix - 11) {
                return r + 10;
            }
            radix = 10;
        }
        if ((r = cdigit - 48) < radix) {
            return r;
        }
        return -1;
    }

    public static boolean add_1(ulong.ptr dest, ulong.ptr x, int len, long y) {
        assert (len >= 0) : "must be non negative " + len;
        int i = 0;
        while (Unsigned.$less_uint((int)i, (int)len)) {
            dest.$set(i, y + x.$at(i));
            if (!Unsigned.$less_ulong((long)dest.$at(i), (long)y)) {
                y = 0L;
                break;
            }
            y = 1L;
            ++i;
        }
        return y != 0L;
    }

    public static boolean sub_1(ulong.ptr x, int len, long y) {
        assert (len >= 0) : "must be non negative " + len;
        int i = 0;
        while (Unsigned.$less_uint((int)i, (int)len)) {
            long X2 = x.$at(i);
            x.$set$minusassign(i, y);
            if (!Unsigned.$greater_ulong((long)y, (long)X2)) {
                y = 0L;
                break;
            }
            y = 1L;
            ++i;
        }
        return y != 0L;
    }

    public static boolean add(ulong.ptr dest, ulong.ptr x, ulong.ptr y, int len) {
        assert (len >= 0) : "must be non negative " + len;
        boolean carry = false;
        int i = 0;
        while (Unsigned.$less_uint((int)i, (int)len)) {
            long limit = std.min((long)x.$at(i), (long)y.$at(i));
            dest.$set(i, x.$at(i) + y.$at(i) + (long)(carry ? 1 : 0));
            carry = Unsigned.$less_ulong((long)dest.$at(i), (long)limit) || carry && dest.$at(i) == limit;
            ++i;
        }
        return carry;
    }

    public static boolean sub(ulong.ptr dest, ulong.ptr x, ulong.ptr y, int len) {
        assert (len >= 0) : "must be non negative " + len;
        boolean borrow = false;
        int i = 0;
        while (Unsigned.$less_uint((int)i, (int)len)) {
            long x_tmp = borrow ? x.$at(i) - Unsigned.$int2ullong((int)1) : x.$at(i);
            borrow = Unsigned.$greater_ulong((long)y.$at(i), (long)x_tmp) || borrow && x.$at(i) == Unsigned.$int2ullong((int)0);
            dest.$set(i, x_tmp - y.$at(i));
            ++i;
        }
        return borrow;
    }

    public static long mul_1(ulong.ptr dest, ulong.ptr x, int len, long y) {
        assert (len >= 0) : "must be non negative " + len;
        long ly = y & 0xFFFFFFFFL;
        long hy = y >>> 32;
        long carry = Unsigned.$int2ulong((int)0);
        for (int i = 0; i < len; ++i) {
            long lx = x.$at(i) & 0xFFFFFFFFL;
            long hx = x.$at(i) >>> 32;
            byte hasCarry = 0;
            dest.$set(i, carry + lx * ly);
            hasCarry = (byte)(Unsigned.$less_ulong((long)dest.$at(i), (long)carry) ? 1 : 0);
            carry = hx * ly + (dest.$at(i) >>> 32) + (hasCarry != 0 ? 0x100000000L : 0L);
            hasCarry = (byte)(carry == 0L && hasCarry != 0 ? 1 : (carry == 0L ? 2 : 0));
            dest.$set(i, (carry += lx * hy & 0xFFFFFFFFL) << 32 | dest.$at(i) & 0xFFFFFFFFL);
            carry = (carry == 0L && Unsigned.$uchar2int((byte)hasCarry) != 2 || Unsigned.$uchar2int((byte)hasCarry) == 1 ? 0x100000000L : Unsigned.$int2ullong((int)0)) + (carry >>> 32) + (lx * hy >>> 32) + hx * hy;
        }
        return carry;
    }

    public static void mul(ulong.ptr dest, ulong.ptr x, int xlen, ulong.ptr y, int ylen) {
        assert (xlen >= 0) : "must be non negative " + xlen;
        assert (ylen >= 0) : "must be non negative " + ylen;
        dest.$set(xlen, APIntStatics.mul_1(dest, x, xlen, y.$at(0)));
        int i = 1;
        while (Unsigned.$less_uint((int)i, (int)ylen)) {
            long ly = y.$at(i) & 0xFFFFFFFFL;
            long hy = y.$at(i) >>> 32;
            long carry = Unsigned.$int2ulong((int)0);
            long lx = Unsigned.$int2ulong((int)0);
            long hx = Unsigned.$int2ulong((int)0);
            int j = 0;
            while (Unsigned.$less_uint((int)j, (int)xlen)) {
                lx = x.$at(j) & 0xFFFFFFFFL;
                hx = x.$at(j) >>> 32;
                byte hasCarry = 0;
                long resul = carry + lx * ly;
                hasCarry = (byte)(Unsigned.$less_ulong((long)resul, (long)carry) ? 1 : 0);
                hasCarry = (byte)((carry = (hasCarry != 0 ? 0x100000000L : 0L) + hx * ly + (resul >>> 32)) == 0L && hasCarry != 0 ? 1 : (carry == 0L ? 2 : 0));
                resul = (carry += lx * hy & 0xFFFFFFFFL) << 32 | resul & 0xFFFFFFFFL;
                dest.$set$addassign(i + j, resul);
                carry = (carry == 0L && Unsigned.$uchar2int((byte)hasCarry) != 2 || Unsigned.$uchar2int((byte)hasCarry) == 1 ? 0x100000000L : Unsigned.$int2ullong((int)0)) + (carry >>> 32) + Unsigned.$int2ullong((int)(Unsigned.$less_ulong((long)dest.$at(i + j), (long)resul) ? 1 : 0)) + (lx * hy >>> 32) + hx * hy;
                ++j;
            }
            dest.$set(i + xlen, carry);
            ++i;
        }
    }

    public static void lshrNear(ulong.ptr Dst, ulong.ptr Src, int Words, int Shift) {
        assert (Words >= 0) : "must be non negative " + Words;
        assert (Shift >= 0) : "must be non negative " + Shift;
        long Carry = 0L;
        for (int I = Words - 1; I >= 0; --I) {
            long Tmp = Src.$at(I);
            Dst.$set(I, Tmp >>> Shift | Carry);
            Carry = Tmp << 64 - Shift;
        }
    }

    public static void KnuthDiv(uint.ptr u, uint.ptr v, uint.ptr q, uint.ptr r, int m, int n) {
        block18: {
            assert (m >= 0) : "must be non negative " + m;
            assert (n >= 0) : "must be non negative " + n;
            assert (Native.$bool((Native.Native$Bool)u)) : "Must provide dividend";
            assert (Native.$bool((Native.Native$Bool)v)) : "Must provide divisor";
            assert (Native.$bool((Native.Native$Bool)q)) : "Must provide quotient";
            assert (Native.$noteq_ptr((void.ptr)u, (void.ptr)v) && Native.$noteq_ptr((void.ptr)u, (void.ptr)q) && Native.$noteq_ptr((void.ptr)v, (void.ptr)q)) : "Must use different memory";
            assert (Unsigned.$greater_uint((int)n, (int)1)) : "n must be > 1";
            long b = 0x100000000L;
            int shift = llvm.countLeadingZeros(v.$at(n - 1));
            int v_carry = 0;
            int u_carry = 0;
            if (shift != 0) {
                int i = 0;
                while (Unsigned.$less_uint((int)i, (int)(m + n))) {
                    int u_tmp = u.$at(i) >>> 32 - shift;
                    u.$set(i, u.$at(i) << shift | u_carry);
                    u_carry = u_tmp;
                    ++i;
                }
                i = 0;
                while (Unsigned.$less_uint((int)i, (int)n)) {
                    int v_tmp = v.$at(i) >>> 32 - shift;
                    v.$set(i, v.$at(i) << shift | v_carry);
                    v_carry = v_tmp;
                    ++i;
                }
            }
            u.$set(m + n, u_carry);
            int j = m;
            do {
                long dividend = (Unsigned.$uint2ulong((int)u.$at(j + n)) << 32) + Unsigned.$uint2ullong((int)u.$at(j + n - 1));
                long qp = Unsigned.$div_ulong_uint((long)dividend, (int)v.$at(n - 1));
                long rp = Unsigned.$rem_ulong_uint((long)dividend, (int)v.$at(n - 1));
                if ((qp == b || Unsigned.$greater_ullong((long)(qp * Unsigned.$uint2ullong((int)v.$at(n - 2))), (long)(b * rp + Unsigned.$uint2ullong((int)u.$at(j + n - 2))))) && Unsigned.$less_ulong((long)(rp += Unsigned.$uint2ullong((int)v.$at(n - 1))), (long)b) && (--qp == b || Unsigned.$greater_ullong((long)(qp * Unsigned.$uint2ullong((int)v.$at(n - 2))), (long)(b * rp + Unsigned.$uint2ullong((int)u.$at(j + n - 2)))))) {
                    --qp;
                }
                long borrow = 0L;
                int i = 0;
                while (Unsigned.$less_uint((int)i, (int)n)) {
                    long p = qp * Unsigned.$uint2ulong((int)v.$at(i));
                    long subres = Unsigned.$uint2long((int)u.$at(j + i)) - borrow - Unsigned.$uint2llong((int)((int)p));
                    u.$set(j + i, (int)subres);
                    borrow = (p >>> 32) - (subres >> 32);
                    ++i;
                }
                boolean isNeg = Unsigned.$uint2llong((int)u.$at(j + n)) < borrow;
                u.$set$minusassign(j + n, (int)borrow);
                q.$set(j, (int)qp);
                if (!isNeg) continue;
                q.$set$postDec(j);
                boolean carry = false;
                int i2 = 0;
                while (Unsigned.$less_uint((int)i2, (int)n)) {
                    int limit = std.min_uint((int)u.$at(j + i2), (int)v.$at(i2));
                    u.$set$addassign(j + i2, v.$at(i2) + (carry ? 1 : 0));
                    carry = Unsigned.$less_uint((int)u.$at(j + i2), (int)limit) || carry && u.$at(j + i2) == limit;
                    ++i2;
                }
                u.$set$addassign(j + n, carry ? 1 : 0);
            } while (--j >= 0);
            if (!Native.$bool((Native.Native$Bool)r)) break block18;
            if (shift != 0) {
                int carry = 0;
                for (int i = n - 1; i >= 0; --i) {
                    r.$set(i, u.$at(i) >>> shift | carry);
                    carry = u.$at(i) << 32 - shift;
                }
            } else {
                for (int i = n - 1; i >= 0; --i) {
                    r.$set(i, u.$at(i));
                }
            }
        }
    }

    public static long lowBitMask(int bits) {
        assert (bits >= 0) : "must be non negative " + bits;
        assert (bits != 0 && Unsigned.$lesseq_uint((int)bits, (int)llvm.integerPartWidth));
        return -1L >>> llvm.integerPartWidth - bits;
    }

    public static long lowHalf(long part) {
        return part & APIntStatics.lowBitMask(Unsigned.$div_uint((int)llvm.integerPartWidth, (int)2));
    }

    public static long highHalf(long part) {
        return part >>> Unsigned.$div_uint((int)llvm.integerPartWidth, (int)2);
    }

    public static int partMSB(long value) {
        return llvm.findLastSet(value, ZeroBehavior.ZB_Max);
    }

    public static int partLSB(long value) {
        return llvm.findFirstSet(value, ZeroBehavior.ZB_Max);
    }
}

