/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support.endian;

import org.clank.java.built_in;
import org.clank.java.std;
import org.clank.support.Casts;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.NativeType;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.clank.support.void;
import org.llvm.support.llvm;
import org.llvm.support.sys.sys;

public class EndianGlobals {
    public static <value_type> value_type byte_swap(value_type value, llvm.support.endianness endian2) {
        if (endian2 != llvm.support.endianness.__native && sys.IsBigEndianHost != (endian2 == llvm.support.endianness.big)) {
            throw new UnsupportedOperationException("Use specialization from sys to swap " + (value == null ? null : value.getClass()));
        }
        return value;
    }

    public static char byte_swap$UShort(llvm.support.endianness endian2, char value) {
        if (endian2 != llvm.support.endianness.__native && sys.IsBigEndianHost != (endian2 == llvm.support.endianness.big)) {
            throw new UnsupportedOperationException("Use specialization from sys to swap UShort");
        }
        return value;
    }

    public static int byte_swap$UInt(llvm.support.endianness endian2, int value) {
        if (endian2 != llvm.support.endianness.__native && sys.IsBigEndianHost != (endian2 == llvm.support.endianness.big)) {
            throw new UnsupportedOperationException("Use specialization from sys to swap UInt");
        }
        return value;
    }

    public static long byte_swap$ULLong(llvm.support.endianness endian2, long value) {
        if (endian2 != llvm.support.endianness.__native && sys.IsBigEndianHost != (endian2 == llvm.support.endianness.big)) {
            throw new UnsupportedOperationException("Use specialization from sys to swap ULLong");
        }
        return value;
    }

    public static <value_type> value_type read(Class<value_type> Type2, llvm.support.endianness endian2, int alignment, char.ptr memory2) {
        throw new UnsupportedOperationException("Use specialization to read_* " + Type2);
    }

    public static long read_uint64(llvm.support.endianness endian2, int alignment, byte[] memory2) {
        return EndianGlobals.read_uint64(endian2, alignment, NativePointer.create_char$ptr((byte[])memory2), 0);
    }

    public static long read_uint64(llvm.support.endianness endian2, int alignment, char.ptr memory2, int fromPos) {
        long ret = 0L;
        assert (endian2 == llvm.support.endianness.little);
        try {
            ret = (long)Casts.$char((byte)memory2.$at(fromPos + 7)) << 54 | (long)Casts.$char((byte)memory2.$at(fromPos + 6)) << 48 | (long)Casts.$char((byte)memory2.$at(fromPos + 5)) << 40 | (long)Casts.$char((byte)memory2.$at(fromPos + 4)) << 32;
            ret |= (long)(Casts.$char((byte)memory2.$at(fromPos + 3)) << 24 | Casts.$char((byte)memory2.$at(fromPos + 2)) << 16 | Casts.$char((byte)memory2.$at(fromPos + 1)) << 8 | Casts.$char((byte)memory2.$at(fromPos + 0)));
        }
        catch (IndexOutOfBoundsException e) {
            llvm.errs().$out("reading out of boundary " + memory2.toString() + "\n");
        }
        return ret;
    }

    public static int read_uint32(llvm.support.endianness endian2, int alignment, char.ptr memory2, int fromPos) {
        int ret = 0;
        assert (endian2 == llvm.support.endianness.little);
        try {
            ret = Casts.$char((byte)memory2.$at(fromPos + 3)) << 24 | Casts.$char((byte)memory2.$at(fromPos + 2)) << 16 | Casts.$char((byte)memory2.$at(fromPos + 1)) << 8 | Casts.$char((byte)memory2.$at(fromPos + 0));
        }
        catch (IndexOutOfBoundsException e) {
            llvm.errs().$out("reading out of boundary " + memory2.toString() + "\n");
        }
        return ret;
    }

    public static char read_uint16(llvm.support.endianness endian2, int alignment, char.ptr memory2, int fromPos) {
        char ret = '\u0000';
        assert (endian2 == llvm.support.endianness.little);
        try {
            ret = (char)(Casts.$char((byte)memory2.$at(fromPos + 1)) << 8 | Casts.$char((byte)memory2.$at(fromPos + 0)));
        }
        catch (IndexOutOfBoundsException e) {
            llvm.errs().$out("reading out of boundary " + memory2.toString() + "\n");
        }
        return ret;
    }

    public static byte read_uchar(llvm.support.endianness endian2, int alignment, char.ptr memory2, int fromPos) {
        byte ret = 0;
        try {
            ret = memory2.$at(fromPos + 0);
        }
        catch (IndexOutOfBoundsException e) {
            llvm.errs().$out("reading out of boundary " + memory2.toString() + "\n");
        }
        return ret;
    }

    public static <value_type> value_type readNext(Class<value_type> Type2, llvm.support.endianness endian2, int alignment, char.ptr memory2) {
        throw new UnsupportedOperationException("Use specialization to readNext_* " + Type2);
    }

    public static long readNext_uint64(llvm.support.endianness endian2, int alignment, char.ptr memory2) {
        long ret = EndianGlobals.read_uint64(endian2, alignment, memory2, 0);
        memory2.$inc(NativeType.sizeof((long)ret));
        return ret;
    }

    public static int readNext_uint32(llvm.support.endianness endian2, int alignment, char.ptr memory2) {
        int ret = EndianGlobals.read_uint32(endian2, alignment, memory2, 0);
        memory2.$inc(NativeType.sizeof((int)ret));
        return ret;
    }

    public static char readNext_uint16(llvm.support.endianness endian2, int alignment, char.ptr memory2) {
        char ret = EndianGlobals.read_uint16(endian2, alignment, memory2, 0);
        memory2.$inc(NativeType.sizeof((char)ret));
        return ret;
    }

    public static <value_type> void write(llvm.support.endianness endian2, int alignment, Object memory2, value_type value) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <value_type> void write(char.ptr memory2, value_type value, Class<value_type> Type2, llvm.support.endianness endian2, int alignment) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <value_type> value_type readAtBitAlignment(llvm.support.endianness endian2, int alignment, Object memory2, long startBit) {
        throw new UnsupportedOperationException("Use readAtBitAlignment$... specialization");
    }

    public static int readAtBitAlignment$UInt(llvm.support.endianness endian2, int alignment, char.ptr memory2, long startBit) {
        assert (Unsigned.$less_ulong_ullong((long)startBit, (long)Unsigned.$int2ullong((int)8)));
        if (startBit == Unsigned.$int2ullong((int)0)) {
            return EndianGlobals.read_uint32(endian2, alignment, memory2, 0);
        }
        int[] val = new int[2];
        std.memcpy((char.ptr)((char.ptr)Casts.reinterpret_cast(char.ptr.class, (void.ptr)((void.ptr)Native.$AddrOf((Object)NativePointer.create_uint$ptr((int[])val, (int)0))))), (char.ptr)built_in.__builtin_assume_aligned((char.ptr)memory2, (int)1), (int)(NativeType.$sizeof_UInt() * 2));
        val[0] = EndianGlobals.byte_swap$UInt(endian2, val[0]);
        val[1] = EndianGlobals.byte_swap$UInt(endian2, val[1]);
        int lowerVal = val[0] >>> (int)startBit;
        int numBitsFirstVal = Unsigned.$ullong2uint((long)(Unsigned.$uint2ullong((int)(NativeType.$sizeof_UInt() * 8)) - startBit));
        int upperVal = val[1] & (1 << (int)startBit) - 1;
        return (lowerVal &= (1 << numBitsFirstVal) - 1) | (upperVal <<= numBitsFirstVal);
    }

    public static <value_type> void writeAtBitAlignment(llvm.support.endianness endian2, int alignment, Object memory2, value_type value, long startBit) {
        assert (Unsigned.$less_ulong_ullong((long)startBit, (long)Unsigned.$int2ullong((int)8)));
        throw new UnsupportedOperationException("Use writeAtBitAlignment$... specialization");
    }

    public static void writeAtBitAlignment$UInt(llvm.support.endianness endian2, int alignment, char.ptr memory2, int value, long startBit) {
        assert (Unsigned.$less_ulong_ullong((long)startBit, (long)Unsigned.$int2ullong((int)8)));
        if (startBit == Unsigned.$int2ullong((int)0)) {
            EndianGlobals.write$UInt(endian2, alignment, memory2, value);
        } else {
            int[] val = new int[2];
            std.memcpy((char.ptr)((char.ptr)Casts.reinterpret_cast(char.ptr.class, (void.ptr)((void.ptr)Native.$AddrOf((Object)NativePointer.create_uint$ptr((int[])val, (int)0))))), (char.ptr)built_in.__builtin_assume_aligned((char.ptr)memory2, (int)1), (int)(NativeType.$sizeof_UInt() * 2));
            val[0] = EndianGlobals.byte_swap$UInt(endian2, val[0]);
            val[1] = EndianGlobals.byte_swap$UInt(endian2, val[1]);
            val[0] = val[0] & (1 << (int)startBit) - 1;
            int numBitsFirstVal = Unsigned.$ullong2uint((long)(Unsigned.$uint2ullong((int)(NativeType.$sizeof_UInt() * 8)) - startBit));
            int lowerVal = value;
            if (Unsigned.$greater_ulong_ullong((long)startBit, (long)Unsigned.$int2ullong((int)0))) {
                lowerVal &= (1 << numBitsFirstVal) - 1;
                lowerVal <<= (int)startBit;
            }
            val[0] = val[0] | lowerVal;
            val[1] = val[1] & ~((1 << (int)startBit) - 1);
            int upperVal = value >>> numBitsFirstVal;
            val[1] = val[1] | (upperVal &= (1 << (int)startBit) - 1);
            val[0] = EndianGlobals.byte_swap$UInt(endian2, val[0]);
            val[1] = EndianGlobals.byte_swap$UInt(endian2, val[1]);
            std.memcpy((char.ptr)built_in.__builtin_assume_aligned((char.ptr)memory2, (int)1), (char.ptr)((char.ptr)Casts.reinterpret_cast(char.ptr.class, (void.ptr)((void.ptr)Native.$AddrOf((Object)NativePointer.create_uint$ptr((int[])val, (int)0))))), (int)(NativeType.$sizeof_UInt() * 2));
        }
    }

    public static <T> T read(llvm.support.endianness E, char.ptr P2) {
        throw new UnsupportedOperationException("use specialized read$... method");
    }

    public static char read$UShort(llvm.support.endianness E, char.ptr P2) {
        return new llvm.support.detail.packed_endian_specific_integral<Character>(P2, Character.class, E, 1).$value().charValue();
    }

    public static int read$UInt(llvm.support.endianness E, char.ptr P2) {
        return new llvm.support.detail.packed_endian_specific_integral<Integer>(P2, Integer.class, E, 1).$value();
    }

    public static long read$ULLong(llvm.support.endianness E, char.ptr P2) {
        return new llvm.support.detail.packed_endian_specific_integral<Long>(P2, Long.class, E, 1).$value();
    }

    public static char read16(llvm.support.endianness E, char.ptr P2) {
        return EndianGlobals.read$UShort(E, P2);
    }

    public static int read32(llvm.support.endianness E, char.ptr P2) {
        return EndianGlobals.read$UInt(E, P2);
    }

    public static long read64(llvm.support.endianness E, char.ptr P2) {
        return EndianGlobals.read$ULLong(E, P2);
    }

    public static char read16le(char.ptr P2) {
        return EndianGlobals.read16(llvm.support.endianness.little, P2);
    }

    public static int read32le(char.ptr P2) {
        return EndianGlobals.read32(llvm.support.endianness.little, P2);
    }

    public static long read64le(char.ptr P2) {
        return EndianGlobals.read64(llvm.support.endianness.little, P2);
    }

    public static char read16be(char.ptr P2) {
        return EndianGlobals.read16(llvm.support.endianness.big, P2);
    }

    public static int read32be(char.ptr P2) {
        return EndianGlobals.read32(llvm.support.endianness.big, P2);
    }

    public static long read64be(char.ptr P2) {
        return EndianGlobals.read64(llvm.support.endianness.big, P2);
    }

    public static <T> void write(llvm.support.endianness E, char.ptr P2, T V) {
        throw new UnsupportedOperationException("Use one of specialized write$... for " + NativeTrace.getIdentityStr(V));
    }

    public static void write$UShort(llvm.support.endianness E, char.ptr P2, char V) {
        EndianGlobals.write$UShort(E, 1, P2, V);
    }

    public static void write$UShort(llvm.support.endianness E, int alignment, char.ptr P2, char V) {
        new llvm.support.detail.packed_endian_specific_integral<Character>(P2, Character.class, E, alignment).$assign(Character.valueOf(V));
    }

    public static void write$UInt(llvm.support.endianness E, char.ptr P2, int V) {
        EndianGlobals.write$UInt(E, 1, P2, V);
    }

    public static void write$UInt(llvm.support.endianness E, int alignment, char.ptr P2, int V) {
        if (E == llvm.support.endianness.little && alignment == 1) {
            P2.$set(0, (byte)V);
            P2.$set(1, (byte)(V >>>= 8));
            P2.$set(2, (byte)(V >>>= 8));
            P2.$set(3, (byte)(V >>>= 8));
        } else {
            new llvm.support.detail.packed_endian_specific_integral<Integer>(P2, Integer.class, E, alignment).$assign(V);
        }
    }

    public static void write$ULLong(llvm.support.endianness E, char.ptr P2, long V) {
        EndianGlobals.write$ULLong(E, 1, P2, V);
    }

    public static void write$ULLong(llvm.support.endianness E, int alignment, char.ptr P2, long V) {
        new llvm.support.detail.packed_endian_specific_integral<Long>(P2, Long.class, E, alignment).$assign(V);
    }

    public static void write16(llvm.support.endianness E, char.ptr P2, char V) {
        EndianGlobals.write$UShort(E, P2, V);
    }

    public static void write32(llvm.support.endianness E, char.ptr P2, int V) {
        EndianGlobals.write$UInt(E, P2, V);
    }

    public static void write64(llvm.support.endianness E, char.ptr P2, long V) {
        EndianGlobals.write$ULLong(E, P2, V);
    }

    public static void write16le(char.ptr P2, char V) {
        EndianGlobals.write16(llvm.support.endianness.little, P2, V);
    }

    public static void write32le(char.ptr P2, int V) {
        EndianGlobals.write32(llvm.support.endianness.little, P2, V);
    }

    public static void write64le(char.ptr P2, long V) {
        EndianGlobals.write64(llvm.support.endianness.little, P2, V);
    }

    public static void write16be(char.ptr P2, char V) {
        EndianGlobals.write16(llvm.support.endianness.big, P2, V);
    }

    public static void write32be(char.ptr P2, int V) {
        EndianGlobals.write32(llvm.support.endianness.big, P2, V);
    }

    public static void write64be(char.ptr P2, long V) {
        EndianGlobals.write64(llvm.support.endianness.big, P2, V);
    }
}

