/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support.dwarf;

import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSwitchUInt;
import org.llvm.support.dwarf.AcceleratorTable;
import org.llvm.support.dwarf.GDBIndexEntryKind;
import org.llvm.support.dwarf.GDBIndexEntryLinkage;
import org.llvm.support.dwarf.LLVMConstants;
import org.llvm.support.llvm_unreachable;

public final class DwarfGlobals {
    public static int DW_CIE_ID = -1;
    public static long DW64_CIE_ID = -1L;

    public static boolean isType(char T4) {
        switch (T4) {
            case '\u0001': 
            case '\u0002': 
            case '\u0004': 
            case '\u000f': 
            case '\u0010': 
            case '\u0012': 
            case '\u0013': 
            case '\u0015': 
            case '\u0016': 
            case '\u0017': 
            case '\u001f': 
            case ' ': 
            case '!': 
            case '$': 
            case '&': 
            case ')': 
            case '-': 
            case '5': 
            case '8': 
            case 'B': {
                return true;
            }
        }
        return false;
    }

    public static char.ptr TagString(int _Tag) {
        switch (_Tag) {
            default: {
                return null;
            }
            case 1: {
                return NativePointer.$((String)"DW_TAG_array_type");
            }
            case 2: {
                return NativePointer.$((String)"DW_TAG_class_type");
            }
            case 3: {
                return NativePointer.$((String)"DW_TAG_entry_point");
            }
            case 4: {
                return NativePointer.$((String)"DW_TAG_enumeration_type");
            }
            case 5: {
                return NativePointer.$((String)"DW_TAG_formal_parameter");
            }
            case 8: {
                return NativePointer.$((String)"DW_TAG_imported_declaration");
            }
            case 10: {
                return NativePointer.$((String)"DW_TAG_label");
            }
            case 11: {
                return NativePointer.$((String)"DW_TAG_lexical_block");
            }
            case 13: {
                return NativePointer.$((String)"DW_TAG_member");
            }
            case 15: {
                return NativePointer.$((String)"DW_TAG_pointer_type");
            }
            case 16: {
                return NativePointer.$((String)"DW_TAG_reference_type");
            }
            case 17: {
                return NativePointer.$((String)"DW_TAG_compile_unit");
            }
            case 18: {
                return NativePointer.$((String)"DW_TAG_string_type");
            }
            case 19: {
                return NativePointer.$((String)"DW_TAG_structure_type");
            }
            case 21: {
                return NativePointer.$((String)"DW_TAG_subroutine_type");
            }
            case 22: {
                return NativePointer.$((String)"DW_TAG_typedef");
            }
            case 23: {
                return NativePointer.$((String)"DW_TAG_union_type");
            }
            case 24: {
                return NativePointer.$((String)"DW_TAG_unspecified_parameters");
            }
            case 25: {
                return NativePointer.$((String)"DW_TAG_variant");
            }
            case 26: {
                return NativePointer.$((String)"DW_TAG_common_block");
            }
            case 27: {
                return NativePointer.$((String)"DW_TAG_common_inclusion");
            }
            case 28: {
                return NativePointer.$((String)"DW_TAG_inheritance");
            }
            case 29: {
                return NativePointer.$((String)"DW_TAG_inlined_subroutine");
            }
            case 30: {
                return NativePointer.$((String)"DW_TAG_module");
            }
            case 31: {
                return NativePointer.$((String)"DW_TAG_ptr_to_member_type");
            }
            case 32: {
                return NativePointer.$((String)"DW_TAG_set_type");
            }
            case 33: {
                return NativePointer.$((String)"DW_TAG_subrange_type");
            }
            case 34: {
                return NativePointer.$((String)"DW_TAG_with_stmt");
            }
            case 35: {
                return NativePointer.$((String)"DW_TAG_access_declaration");
            }
            case 36: {
                return NativePointer.$((String)"DW_TAG_base_type");
            }
            case 37: {
                return NativePointer.$((String)"DW_TAG_catch_block");
            }
            case 38: {
                return NativePointer.$((String)"DW_TAG_const_type");
            }
            case 39: {
                return NativePointer.$((String)"DW_TAG_constant");
            }
            case 40: {
                return NativePointer.$((String)"DW_TAG_enumerator");
            }
            case 41: {
                return NativePointer.$((String)"DW_TAG_file_type");
            }
            case 42: {
                return NativePointer.$((String)"DW_TAG_friend");
            }
            case 43: {
                return NativePointer.$((String)"DW_TAG_namelist");
            }
            case 44: {
                return NativePointer.$((String)"DW_TAG_namelist_item");
            }
            case 45: {
                return NativePointer.$((String)"DW_TAG_packed_type");
            }
            case 46: {
                return NativePointer.$((String)"DW_TAG_subprogram");
            }
            case 47: {
                return NativePointer.$((String)"DW_TAG_template_type_parameter");
            }
            case 48: {
                return NativePointer.$((String)"DW_TAG_template_value_parameter");
            }
            case 49: {
                return NativePointer.$((String)"DW_TAG_thrown_type");
            }
            case 50: {
                return NativePointer.$((String)"DW_TAG_try_block");
            }
            case 51: {
                return NativePointer.$((String)"DW_TAG_variant_part");
            }
            case 52: {
                return NativePointer.$((String)"DW_TAG_variable");
            }
            case 53: {
                return NativePointer.$((String)"DW_TAG_volatile_type");
            }
            case 54: {
                return NativePointer.$((String)"DW_TAG_dwarf_procedure");
            }
            case 55: {
                return NativePointer.$((String)"DW_TAG_restrict_type");
            }
            case 56: {
                return NativePointer.$((String)"DW_TAG_interface_type");
            }
            case 57: {
                return NativePointer.$((String)"DW_TAG_namespace");
            }
            case 58: {
                return NativePointer.$((String)"DW_TAG_imported_module");
            }
            case 59: {
                return NativePointer.$((String)"DW_TAG_unspecified_type");
            }
            case 60: {
                return NativePointer.$((String)"DW_TAG_partial_unit");
            }
            case 61: {
                return NativePointer.$((String)"DW_TAG_imported_unit");
            }
            case 63: {
                return NativePointer.$((String)"DW_TAG_condition");
            }
            case 64: {
                return NativePointer.$((String)"DW_TAG_shared_type");
            }
            case 65: {
                return NativePointer.$((String)"DW_TAG_type_unit");
            }
            case 66: {
                return NativePointer.$((String)"DW_TAG_rvalue_reference_type");
            }
            case 67: {
                return NativePointer.$((String)"DW_TAG_template_alias");
            }
            case 68: {
                return NativePointer.$((String)"DW_TAG_coarray_type");
            }
            case 69: {
                return NativePointer.$((String)"DW_TAG_generic_subrange");
            }
            case 70: {
                return NativePointer.$((String)"DW_TAG_dynamic_type");
            }
            case 16513: {
                return NativePointer.$((String)"DW_TAG_MIPS_loop");
            }
            case 16641: {
                return NativePointer.$((String)"DW_TAG_format_label");
            }
            case 16642: {
                return NativePointer.$((String)"DW_TAG_function_template");
            }
            case 16643: {
                return NativePointer.$((String)"DW_TAG_class_template");
            }
            case 16646: {
                return NativePointer.$((String)"DW_TAG_GNU_template_template_param");
            }
            case 16647: {
                return NativePointer.$((String)"DW_TAG_GNU_template_parameter_pack");
            }
            case 16648: {
                return NativePointer.$((String)"DW_TAG_GNU_formal_parameter_pack");
            }
            case 16896: {
                return NativePointer.$((String)"DW_TAG_APPLE_property");
            }
            case 45056: {
                return NativePointer.$((String)"DW_TAG_BORLAND_property");
            }
            case 45057: {
                return NativePointer.$((String)"DW_TAG_BORLAND_Delphi_string");
            }
            case 45058: {
                return NativePointer.$((String)"DW_TAG_BORLAND_Delphi_dynamic_array");
            }
            case 45059: {
                return NativePointer.$((String)"DW_TAG_BORLAND_Delphi_set");
            }
            case 45060: 
        }
        return NativePointer.$((String)"DW_TAG_BORLAND_Delphi_variant");
    }

    public static char.ptr ChildrenString(int Children) {
        switch (Children) {
            case 0: {
                return NativePointer.$((String)"DW_CHILDREN_no");
            }
            case 1: {
                return NativePointer.$((String)"DW_CHILDREN_yes");
            }
        }
        return null;
    }

    public static char.ptr AttributeString(int _Attribute) {
        switch (_Attribute) {
            case 1: {
                return NativePointer.$((String)"DW_AT_sibling");
            }
            case 2: {
                return NativePointer.$((String)"DW_AT_location");
            }
            case 3: {
                return NativePointer.$((String)"DW_AT_name");
            }
            case 9: {
                return NativePointer.$((String)"DW_AT_ordering");
            }
            case 11: {
                return NativePointer.$((String)"DW_AT_byte_size");
            }
            case 12: {
                return NativePointer.$((String)"DW_AT_bit_offset");
            }
            case 13: {
                return NativePointer.$((String)"DW_AT_bit_size");
            }
            case 16: {
                return NativePointer.$((String)"DW_AT_stmt_list");
            }
            case 17: {
                return NativePointer.$((String)"DW_AT_low_pc");
            }
            case 18: {
                return NativePointer.$((String)"DW_AT_high_pc");
            }
            case 19: {
                return NativePointer.$((String)"DW_AT_language");
            }
            case 21: {
                return NativePointer.$((String)"DW_AT_discr");
            }
            case 22: {
                return NativePointer.$((String)"DW_AT_discr_value");
            }
            case 23: {
                return NativePointer.$((String)"DW_AT_visibility");
            }
            case 24: {
                return NativePointer.$((String)"DW_AT_import");
            }
            case 25: {
                return NativePointer.$((String)"DW_AT_string_length");
            }
            case 26: {
                return NativePointer.$((String)"DW_AT_common_reference");
            }
            case 27: {
                return NativePointer.$((String)"DW_AT_comp_dir");
            }
            case 28: {
                return NativePointer.$((String)"DW_AT_const_value");
            }
            case 29: {
                return NativePointer.$((String)"DW_AT_containing_type");
            }
            case 30: {
                return NativePointer.$((String)"DW_AT_default_value");
            }
            case 32: {
                return NativePointer.$((String)"DW_AT_inline");
            }
            case 33: {
                return NativePointer.$((String)"DW_AT_is_optional");
            }
            case 34: {
                return NativePointer.$((String)"DW_AT_lower_bound");
            }
            case 37: {
                return NativePointer.$((String)"DW_AT_producer");
            }
            case 39: {
                return NativePointer.$((String)"DW_AT_prototyped");
            }
            case 42: {
                return NativePointer.$((String)"DW_AT_return_addr");
            }
            case 44: {
                return NativePointer.$((String)"DW_AT_start_scope");
            }
            case 46: {
                return NativePointer.$((String)"DW_AT_bit_stride");
            }
            case 47: {
                return NativePointer.$((String)"DW_AT_upper_bound");
            }
            case 49: {
                return NativePointer.$((String)"DW_AT_abstract_origin");
            }
            case 50: {
                return NativePointer.$((String)"DW_AT_accessibility");
            }
            case 51: {
                return NativePointer.$((String)"DW_AT_address_class");
            }
            case 52: {
                return NativePointer.$((String)"DW_AT_artificial");
            }
            case 53: {
                return NativePointer.$((String)"DW_AT_base_types");
            }
            case 54: {
                return NativePointer.$((String)"DW_AT_calling_convention");
            }
            case 55: {
                return NativePointer.$((String)"DW_AT_count");
            }
            case 56: {
                return NativePointer.$((String)"DW_AT_data_member_location");
            }
            case 57: {
                return NativePointer.$((String)"DW_AT_decl_column");
            }
            case 58: {
                return NativePointer.$((String)"DW_AT_decl_file");
            }
            case 59: {
                return NativePointer.$((String)"DW_AT_decl_line");
            }
            case 60: {
                return NativePointer.$((String)"DW_AT_declaration");
            }
            case 61: {
                return NativePointer.$((String)"DW_AT_discr_list");
            }
            case 62: {
                return NativePointer.$((String)"DW_AT_encoding");
            }
            case 63: {
                return NativePointer.$((String)"DW_AT_external");
            }
            case 64: {
                return NativePointer.$((String)"DW_AT_frame_base");
            }
            case 65: {
                return NativePointer.$((String)"DW_AT_friend");
            }
            case 66: {
                return NativePointer.$((String)"DW_AT_identifier_case");
            }
            case 67: {
                return NativePointer.$((String)"DW_AT_macro_info");
            }
            case 68: {
                return NativePointer.$((String)"DW_AT_namelist_item");
            }
            case 69: {
                return NativePointer.$((String)"DW_AT_priority");
            }
            case 70: {
                return NativePointer.$((String)"DW_AT_segment");
            }
            case 71: {
                return NativePointer.$((String)"DW_AT_specification");
            }
            case 72: {
                return NativePointer.$((String)"DW_AT_static_link");
            }
            case 73: {
                return NativePointer.$((String)"DW_AT_type");
            }
            case 74: {
                return NativePointer.$((String)"DW_AT_use_location");
            }
            case 75: {
                return NativePointer.$((String)"DW_AT_variable_parameter");
            }
            case 76: {
                return NativePointer.$((String)"DW_AT_virtuality");
            }
            case 77: {
                return NativePointer.$((String)"DW_AT_vtable_elem_location");
            }
            case 78: {
                return NativePointer.$((String)"DW_AT_allocated");
            }
            case 79: {
                return NativePointer.$((String)"DW_AT_associated");
            }
            case 80: {
                return NativePointer.$((String)"DW_AT_data_location");
            }
            case 81: {
                return NativePointer.$((String)"DW_AT_byte_stride");
            }
            case 82: {
                return NativePointer.$((String)"DW_AT_entry_pc");
            }
            case 83: {
                return NativePointer.$((String)"DW_AT_use_UTF8");
            }
            case 84: {
                return NativePointer.$((String)"DW_AT_extension");
            }
            case 85: {
                return NativePointer.$((String)"DW_AT_ranges");
            }
            case 86: {
                return NativePointer.$((String)"DW_AT_trampoline");
            }
            case 87: {
                return NativePointer.$((String)"DW_AT_call_column");
            }
            case 88: {
                return NativePointer.$((String)"DW_AT_call_file");
            }
            case 89: {
                return NativePointer.$((String)"DW_AT_call_line");
            }
            case 90: {
                return NativePointer.$((String)"DW_AT_description");
            }
            case 91: {
                return NativePointer.$((String)"DW_AT_binary_scale");
            }
            case 92: {
                return NativePointer.$((String)"DW_AT_decimal_scale");
            }
            case 93: {
                return NativePointer.$((String)"DW_AT_small");
            }
            case 94: {
                return NativePointer.$((String)"DW_AT_decimal_sign");
            }
            case 95: {
                return NativePointer.$((String)"DW_AT_digit_count");
            }
            case 96: {
                return NativePointer.$((String)"DW_AT_picture_string");
            }
            case 97: {
                return NativePointer.$((String)"DW_AT_mutable");
            }
            case 98: {
                return NativePointer.$((String)"DW_AT_threads_scaled");
            }
            case 99: {
                return NativePointer.$((String)"DW_AT_explicit");
            }
            case 100: {
                return NativePointer.$((String)"DW_AT_object_pointer");
            }
            case 101: {
                return NativePointer.$((String)"DW_AT_endianity");
            }
            case 102: {
                return NativePointer.$((String)"DW_AT_elemental");
            }
            case 103: {
                return NativePointer.$((String)"DW_AT_pure");
            }
            case 104: {
                return NativePointer.$((String)"DW_AT_recursive");
            }
            case 105: {
                return NativePointer.$((String)"DW_AT_signature");
            }
            case 106: {
                return NativePointer.$((String)"DW_AT_main_subprogram");
            }
            case 107: {
                return NativePointer.$((String)"DW_AT_data_bit_offset");
            }
            case 108: {
                return NativePointer.$((String)"DW_AT_const_expr");
            }
            case 109: {
                return NativePointer.$((String)"DW_AT_enum_class");
            }
            case 110: {
                return NativePointer.$((String)"DW_AT_linkage_name");
            }
            case 111: {
                return NativePointer.$((String)"DW_AT_string_length_bit_size");
            }
            case 112: {
                return NativePointer.$((String)"DW_AT_string_length_byte_size");
            }
            case 113: {
                return NativePointer.$((String)"DW_AT_rank");
            }
            case 114: {
                return NativePointer.$((String)"DW_AT_str_offsets_base");
            }
            case 115: {
                return NativePointer.$((String)"DW_AT_addr_base");
            }
            case 116: {
                return NativePointer.$((String)"DW_AT_ranges_base");
            }
            case 117: {
                return NativePointer.$((String)"DW_AT_dwo_id");
            }
            case 118: {
                return NativePointer.$((String)"DW_AT_dwo_name");
            }
            case 119: {
                return NativePointer.$((String)"DW_AT_reference");
            }
            case 120: {
                return NativePointer.$((String)"DW_AT_rvalue_reference");
            }
            case 8194: {
                return NativePointer.$((String)"DW_AT_MIPS_loop_begin");
            }
            case 8195: {
                return NativePointer.$((String)"DW_AT_MIPS_tail_loop_begin");
            }
            case 8196: {
                return NativePointer.$((String)"DW_AT_MIPS_epilog_begin");
            }
            case 8197: {
                return NativePointer.$((String)"DW_AT_MIPS_loop_unroll_factor");
            }
            case 8198: {
                return NativePointer.$((String)"DW_AT_MIPS_software_pipeline_depth");
            }
            case 8199: {
                return NativePointer.$((String)"DW_AT_MIPS_linkage_name");
            }
            case 8200: {
                return NativePointer.$((String)"DW_AT_MIPS_stride");
            }
            case 8201: {
                return NativePointer.$((String)"DW_AT_MIPS_abstract_name");
            }
            case 8202: {
                return NativePointer.$((String)"DW_AT_MIPS_clone_origin");
            }
            case 8203: {
                return NativePointer.$((String)"DW_AT_MIPS_has_inlines");
            }
            case 8204: {
                return NativePointer.$((String)"DW_AT_MIPS_stride_byte");
            }
            case 8205: {
                return NativePointer.$((String)"DW_AT_MIPS_stride_elem");
            }
            case 8206: {
                return NativePointer.$((String)"DW_AT_MIPS_ptr_dopetype");
            }
            case 8207: {
                return NativePointer.$((String)"DW_AT_MIPS_allocatable_dopetype");
            }
            case 8208: {
                return NativePointer.$((String)"DW_AT_MIPS_assumed_shape_dopetype");
            }
            case 8449: {
                return NativePointer.$((String)"DW_AT_sf_names");
            }
            case 8450: {
                return NativePointer.$((String)"DW_AT_src_info");
            }
            case 8451: {
                return NativePointer.$((String)"DW_AT_mac_info");
            }
            case 8452: {
                return NativePointer.$((String)"DW_AT_src_coords");
            }
            case 8453: {
                return NativePointer.$((String)"DW_AT_body_begin");
            }
            case 8454: {
                return NativePointer.$((String)"DW_AT_body_end");
            }
            case 8455: {
                return NativePointer.$((String)"DW_AT_GNU_vector");
            }
            case 8464: {
                return NativePointer.$((String)"DW_AT_GNU_template_name");
            }
            case 8463: {
                return NativePointer.$((String)"DW_AT_GNU_odr_signature");
            }
            case 8209: {
                return NativePointer.$((String)"DW_AT_MIPS_assumed_size");
            }
            case 8192: {
                return NativePointer.$((String)"DW_AT_lo_user");
            }
            case 16383: {
                return NativePointer.$((String)"DW_AT_hi_user");
            }
            case 15121: {
                return NativePointer.$((String)"DW_AT_BORLAND_property_read");
            }
            case 15122: {
                return NativePointer.$((String)"DW_AT_BORLAND_property_write");
            }
            case 15123: {
                return NativePointer.$((String)"DW_AT_BORLAND_property_implements");
            }
            case 15124: {
                return NativePointer.$((String)"DW_AT_BORLAND_property_index");
            }
            case 15125: {
                return NativePointer.$((String)"DW_AT_BORLAND_property_default");
            }
            case 15136: {
                return NativePointer.$((String)"DW_AT_BORLAND_Delphi_unit");
            }
            case 15137: {
                return NativePointer.$((String)"DW_AT_BORLAND_Delphi_class");
            }
            case 15138: {
                return NativePointer.$((String)"DW_AT_BORLAND_Delphi_record");
            }
            case 15139: {
                return NativePointer.$((String)"DW_AT_BORLAND_Delphi_metaclass");
            }
            case 15140: {
                return NativePointer.$((String)"DW_AT_BORLAND_Delphi_constructor");
            }
            case 15141: {
                return NativePointer.$((String)"DW_AT_BORLAND_Delphi_destructor");
            }
            case 15142: {
                return NativePointer.$((String)"DW_AT_BORLAND_Delphi_anonymous_method");
            }
            case 15143: {
                return NativePointer.$((String)"DW_AT_BORLAND_Delphi_interface");
            }
            case 15144: {
                return NativePointer.$((String)"DW_AT_BORLAND_Delphi_ABI");
            }
            case 15145: {
                return NativePointer.$((String)"DW_AT_BORLAND_Delphi_return");
            }
            case 15152: {
                return NativePointer.$((String)"DW_AT_BORLAND_Delphi_frameptr");
            }
            case 15153: {
                return NativePointer.$((String)"DW_AT_BORLAND_closure");
            }
            case 16353: {
                return NativePointer.$((String)"DW_AT_APPLE_optimized");
            }
            case 16354: {
                return NativePointer.$((String)"DW_AT_APPLE_flags");
            }
            case 16355: {
                return NativePointer.$((String)"DW_AT_APPLE_isa");
            }
            case 16356: {
                return NativePointer.$((String)"DW_AT_APPLE_block");
            }
            case 16357: {
                return NativePointer.$((String)"DW_AT_APPLE_major_runtime_vers");
            }
            case 16358: {
                return NativePointer.$((String)"DW_AT_APPLE_runtime_class");
            }
            case 16359: {
                return NativePointer.$((String)"DW_AT_APPLE_omit_frame_ptr");
            }
            case 16360: {
                return NativePointer.$((String)"DW_AT_APPLE_property_name");
            }
            case 16361: {
                return NativePointer.$((String)"DW_AT_APPLE_property_getter");
            }
            case 16362: {
                return NativePointer.$((String)"DW_AT_APPLE_property_setter");
            }
            case 16363: {
                return NativePointer.$((String)"DW_AT_APPLE_property_attribute");
            }
            case 16365: {
                return NativePointer.$((String)"DW_AT_APPLE_property");
            }
            case 16364: {
                return NativePointer.$((String)"DW_AT_APPLE_objc_complete_type");
            }
            case 15872: {
                return NativePointer.$((String)"DW_AT_LLVM_include_path");
            }
            case 15873: {
                return NativePointer.$((String)"DW_AT_LLVM_config_macros");
            }
            case 15874: {
                return NativePointer.$((String)"DW_AT_LLVM_isysroot");
            }
            case 8496: {
                return NativePointer.$((String)"DW_AT_GNU_dwo_name");
            }
            case 8497: {
                return NativePointer.$((String)"DW_AT_GNU_dwo_id");
            }
            case 8498: {
                return NativePointer.$((String)"DW_AT_GNU_ranges_base");
            }
            case 8499: {
                return NativePointer.$((String)"DW_AT_GNU_addr_base");
            }
            case 8500: {
                return NativePointer.$((String)"DW_AT_GNU_pubnames");
            }
            case 8501: {
                return NativePointer.$((String)"DW_AT_GNU_pubtypes");
            }
            case 8502: {
                return NativePointer.$((String)"DW_AT_GNU_discriminator");
            }
        }
        return null;
    }

    public static char.ptr FormEncodingString(int _Encoding) {
        switch (_Encoding) {
            case 1: {
                return NativePointer.$((String)"DW_FORM_addr");
            }
            case 3: {
                return NativePointer.$((String)"DW_FORM_block2");
            }
            case 4: {
                return NativePointer.$((String)"DW_FORM_block4");
            }
            case 5: {
                return NativePointer.$((String)"DW_FORM_data2");
            }
            case 6: {
                return NativePointer.$((String)"DW_FORM_data4");
            }
            case 7: {
                return NativePointer.$((String)"DW_FORM_data8");
            }
            case 8: {
                return NativePointer.$((String)"DW_FORM_string");
            }
            case 9: {
                return NativePointer.$((String)"DW_FORM_block");
            }
            case 10: {
                return NativePointer.$((String)"DW_FORM_block1");
            }
            case 11: {
                return NativePointer.$((String)"DW_FORM_data1");
            }
            case 12: {
                return NativePointer.$((String)"DW_FORM_flag");
            }
            case 13: {
                return NativePointer.$((String)"DW_FORM_sdata");
            }
            case 14: {
                return NativePointer.$((String)"DW_FORM_strp");
            }
            case 15: {
                return NativePointer.$((String)"DW_FORM_udata");
            }
            case 16: {
                return NativePointer.$((String)"DW_FORM_ref_addr");
            }
            case 17: {
                return NativePointer.$((String)"DW_FORM_ref1");
            }
            case 18: {
                return NativePointer.$((String)"DW_FORM_ref2");
            }
            case 19: {
                return NativePointer.$((String)"DW_FORM_ref4");
            }
            case 20: {
                return NativePointer.$((String)"DW_FORM_ref8");
            }
            case 21: {
                return NativePointer.$((String)"DW_FORM_ref_udata");
            }
            case 22: {
                return NativePointer.$((String)"DW_FORM_indirect");
            }
            case 23: {
                return NativePointer.$((String)"DW_FORM_sec_offset");
            }
            case 24: {
                return NativePointer.$((String)"DW_FORM_exprloc");
            }
            case 25: {
                return NativePointer.$((String)"DW_FORM_flag_present");
            }
            case 32: {
                return NativePointer.$((String)"DW_FORM_ref_sig8");
            }
            case 7937: {
                return NativePointer.$((String)"DW_FORM_GNU_addr_index");
            }
            case 7938: {
                return NativePointer.$((String)"DW_FORM_GNU_str_index");
            }
            case 7968: {
                return NativePointer.$((String)"DW_FORM_GNU_ref_alt");
            }
            case 7969: {
                return NativePointer.$((String)"DW_FORM_GNU_strp_alt");
            }
        }
        return null;
    }

    public static char.ptr OperationEncodingString(int Encoding) {
        switch (Encoding) {
            default: {
                return null;
            }
            case 3: {
                return NativePointer.$((String)"DW_OP_addr");
            }
            case 6: {
                return NativePointer.$((String)"DW_OP_deref");
            }
            case 8: {
                return NativePointer.$((String)"DW_OP_const1u");
            }
            case 9: {
                return NativePointer.$((String)"DW_OP_const1s");
            }
            case 10: {
                return NativePointer.$((String)"DW_OP_const2u");
            }
            case 11: {
                return NativePointer.$((String)"DW_OP_const2s");
            }
            case 12: {
                return NativePointer.$((String)"DW_OP_const4u");
            }
            case 13: {
                return NativePointer.$((String)"DW_OP_const4s");
            }
            case 14: {
                return NativePointer.$((String)"DW_OP_const8u");
            }
            case 15: {
                return NativePointer.$((String)"DW_OP_const8s");
            }
            case 16: {
                return NativePointer.$((String)"DW_OP_constu");
            }
            case 17: {
                return NativePointer.$((String)"DW_OP_consts");
            }
            case 18: {
                return NativePointer.$((String)"DW_OP_dup");
            }
            case 19: {
                return NativePointer.$((String)"DW_OP_drop");
            }
            case 20: {
                return NativePointer.$((String)"DW_OP_over");
            }
            case 21: {
                return NativePointer.$((String)"DW_OP_pick");
            }
            case 22: {
                return NativePointer.$((String)"DW_OP_swap");
            }
            case 23: {
                return NativePointer.$((String)"DW_OP_rot");
            }
            case 24: {
                return NativePointer.$((String)"DW_OP_xderef");
            }
            case 25: {
                return NativePointer.$((String)"DW_OP_abs");
            }
            case 26: {
                return NativePointer.$((String)"DW_OP_and");
            }
            case 27: {
                return NativePointer.$((String)"DW_OP_div");
            }
            case 28: {
                return NativePointer.$((String)"DW_OP_minus");
            }
            case 29: {
                return NativePointer.$((String)"DW_OP_mod");
            }
            case 30: {
                return NativePointer.$((String)"DW_OP_mul");
            }
            case 31: {
                return NativePointer.$((String)"DW_OP_neg");
            }
            case 32: {
                return NativePointer.$((String)"DW_OP_not");
            }
            case 33: {
                return NativePointer.$((String)"DW_OP_or");
            }
            case 34: {
                return NativePointer.$((String)"DW_OP_plus");
            }
            case 35: {
                return NativePointer.$((String)"DW_OP_plus_uconst");
            }
            case 36: {
                return NativePointer.$((String)"DW_OP_shl");
            }
            case 37: {
                return NativePointer.$((String)"DW_OP_shr");
            }
            case 38: {
                return NativePointer.$((String)"DW_OP_shra");
            }
            case 39: {
                return NativePointer.$((String)"DW_OP_xor");
            }
            case 47: {
                return NativePointer.$((String)"DW_OP_skip");
            }
            case 40: {
                return NativePointer.$((String)"DW_OP_bra");
            }
            case 41: {
                return NativePointer.$((String)"DW_OP_eq");
            }
            case 42: {
                return NativePointer.$((String)"DW_OP_ge");
            }
            case 43: {
                return NativePointer.$((String)"DW_OP_gt");
            }
            case 44: {
                return NativePointer.$((String)"DW_OP_le");
            }
            case 45: {
                return NativePointer.$((String)"DW_OP_lt");
            }
            case 46: {
                return NativePointer.$((String)"DW_OP_ne");
            }
            case 48: {
                return NativePointer.$((String)"DW_OP_lit0");
            }
            case 49: {
                return NativePointer.$((String)"DW_OP_lit1");
            }
            case 50: {
                return NativePointer.$((String)"DW_OP_lit2");
            }
            case 51: {
                return NativePointer.$((String)"DW_OP_lit3");
            }
            case 52: {
                return NativePointer.$((String)"DW_OP_lit4");
            }
            case 53: {
                return NativePointer.$((String)"DW_OP_lit5");
            }
            case 54: {
                return NativePointer.$((String)"DW_OP_lit6");
            }
            case 55: {
                return NativePointer.$((String)"DW_OP_lit7");
            }
            case 56: {
                return NativePointer.$((String)"DW_OP_lit8");
            }
            case 57: {
                return NativePointer.$((String)"DW_OP_lit9");
            }
            case 58: {
                return NativePointer.$((String)"DW_OP_lit10");
            }
            case 59: {
                return NativePointer.$((String)"DW_OP_lit11");
            }
            case 60: {
                return NativePointer.$((String)"DW_OP_lit12");
            }
            case 61: {
                return NativePointer.$((String)"DW_OP_lit13");
            }
            case 62: {
                return NativePointer.$((String)"DW_OP_lit14");
            }
            case 63: {
                return NativePointer.$((String)"DW_OP_lit15");
            }
            case 64: {
                return NativePointer.$((String)"DW_OP_lit16");
            }
            case 65: {
                return NativePointer.$((String)"DW_OP_lit17");
            }
            case 66: {
                return NativePointer.$((String)"DW_OP_lit18");
            }
            case 67: {
                return NativePointer.$((String)"DW_OP_lit19");
            }
            case 68: {
                return NativePointer.$((String)"DW_OP_lit20");
            }
            case 69: {
                return NativePointer.$((String)"DW_OP_lit21");
            }
            case 70: {
                return NativePointer.$((String)"DW_OP_lit22");
            }
            case 71: {
                return NativePointer.$((String)"DW_OP_lit23");
            }
            case 72: {
                return NativePointer.$((String)"DW_OP_lit24");
            }
            case 73: {
                return NativePointer.$((String)"DW_OP_lit25");
            }
            case 74: {
                return NativePointer.$((String)"DW_OP_lit26");
            }
            case 75: {
                return NativePointer.$((String)"DW_OP_lit27");
            }
            case 76: {
                return NativePointer.$((String)"DW_OP_lit28");
            }
            case 77: {
                return NativePointer.$((String)"DW_OP_lit29");
            }
            case 78: {
                return NativePointer.$((String)"DW_OP_lit30");
            }
            case 79: {
                return NativePointer.$((String)"DW_OP_lit31");
            }
            case 80: {
                return NativePointer.$((String)"DW_OP_reg0");
            }
            case 81: {
                return NativePointer.$((String)"DW_OP_reg1");
            }
            case 82: {
                return NativePointer.$((String)"DW_OP_reg2");
            }
            case 83: {
                return NativePointer.$((String)"DW_OP_reg3");
            }
            case 84: {
                return NativePointer.$((String)"DW_OP_reg4");
            }
            case 85: {
                return NativePointer.$((String)"DW_OP_reg5");
            }
            case 86: {
                return NativePointer.$((String)"DW_OP_reg6");
            }
            case 87: {
                return NativePointer.$((String)"DW_OP_reg7");
            }
            case 88: {
                return NativePointer.$((String)"DW_OP_reg8");
            }
            case 89: {
                return NativePointer.$((String)"DW_OP_reg9");
            }
            case 90: {
                return NativePointer.$((String)"DW_OP_reg10");
            }
            case 91: {
                return NativePointer.$((String)"DW_OP_reg11");
            }
            case 92: {
                return NativePointer.$((String)"DW_OP_reg12");
            }
            case 93: {
                return NativePointer.$((String)"DW_OP_reg13");
            }
            case 94: {
                return NativePointer.$((String)"DW_OP_reg14");
            }
            case 95: {
                return NativePointer.$((String)"DW_OP_reg15");
            }
            case 96: {
                return NativePointer.$((String)"DW_OP_reg16");
            }
            case 97: {
                return NativePointer.$((String)"DW_OP_reg17");
            }
            case 98: {
                return NativePointer.$((String)"DW_OP_reg18");
            }
            case 99: {
                return NativePointer.$((String)"DW_OP_reg19");
            }
            case 100: {
                return NativePointer.$((String)"DW_OP_reg20");
            }
            case 101: {
                return NativePointer.$((String)"DW_OP_reg21");
            }
            case 102: {
                return NativePointer.$((String)"DW_OP_reg22");
            }
            case 103: {
                return NativePointer.$((String)"DW_OP_reg23");
            }
            case 104: {
                return NativePointer.$((String)"DW_OP_reg24");
            }
            case 105: {
                return NativePointer.$((String)"DW_OP_reg25");
            }
            case 106: {
                return NativePointer.$((String)"DW_OP_reg26");
            }
            case 107: {
                return NativePointer.$((String)"DW_OP_reg27");
            }
            case 108: {
                return NativePointer.$((String)"DW_OP_reg28");
            }
            case 109: {
                return NativePointer.$((String)"DW_OP_reg29");
            }
            case 110: {
                return NativePointer.$((String)"DW_OP_reg30");
            }
            case 111: {
                return NativePointer.$((String)"DW_OP_reg31");
            }
            case 112: {
                return NativePointer.$((String)"DW_OP_breg0");
            }
            case 113: {
                return NativePointer.$((String)"DW_OP_breg1");
            }
            case 114: {
                return NativePointer.$((String)"DW_OP_breg2");
            }
            case 115: {
                return NativePointer.$((String)"DW_OP_breg3");
            }
            case 116: {
                return NativePointer.$((String)"DW_OP_breg4");
            }
            case 117: {
                return NativePointer.$((String)"DW_OP_breg5");
            }
            case 118: {
                return NativePointer.$((String)"DW_OP_breg6");
            }
            case 119: {
                return NativePointer.$((String)"DW_OP_breg7");
            }
            case 120: {
                return NativePointer.$((String)"DW_OP_breg8");
            }
            case 121: {
                return NativePointer.$((String)"DW_OP_breg9");
            }
            case 122: {
                return NativePointer.$((String)"DW_OP_breg10");
            }
            case 123: {
                return NativePointer.$((String)"DW_OP_breg11");
            }
            case 124: {
                return NativePointer.$((String)"DW_OP_breg12");
            }
            case 125: {
                return NativePointer.$((String)"DW_OP_breg13");
            }
            case 126: {
                return NativePointer.$((String)"DW_OP_breg14");
            }
            case 127: {
                return NativePointer.$((String)"DW_OP_breg15");
            }
            case 128: {
                return NativePointer.$((String)"DW_OP_breg16");
            }
            case 129: {
                return NativePointer.$((String)"DW_OP_breg17");
            }
            case 130: {
                return NativePointer.$((String)"DW_OP_breg18");
            }
            case 131: {
                return NativePointer.$((String)"DW_OP_breg19");
            }
            case 132: {
                return NativePointer.$((String)"DW_OP_breg20");
            }
            case 133: {
                return NativePointer.$((String)"DW_OP_breg21");
            }
            case 134: {
                return NativePointer.$((String)"DW_OP_breg22");
            }
            case 135: {
                return NativePointer.$((String)"DW_OP_breg23");
            }
            case 136: {
                return NativePointer.$((String)"DW_OP_breg24");
            }
            case 137: {
                return NativePointer.$((String)"DW_OP_breg25");
            }
            case 138: {
                return NativePointer.$((String)"DW_OP_breg26");
            }
            case 139: {
                return NativePointer.$((String)"DW_OP_breg27");
            }
            case 140: {
                return NativePointer.$((String)"DW_OP_breg28");
            }
            case 141: {
                return NativePointer.$((String)"DW_OP_breg29");
            }
            case 142: {
                return NativePointer.$((String)"DW_OP_breg30");
            }
            case 143: {
                return NativePointer.$((String)"DW_OP_breg31");
            }
            case 144: {
                return NativePointer.$((String)"DW_OP_regx");
            }
            case 145: {
                return NativePointer.$((String)"DW_OP_fbreg");
            }
            case 146: {
                return NativePointer.$((String)"DW_OP_bregx");
            }
            case 147: {
                return NativePointer.$((String)"DW_OP_piece");
            }
            case 148: {
                return NativePointer.$((String)"DW_OP_deref_size");
            }
            case 149: {
                return NativePointer.$((String)"DW_OP_xderef_size");
            }
            case 150: {
                return NativePointer.$((String)"DW_OP_nop");
            }
            case 151: {
                return NativePointer.$((String)"DW_OP_push_object_address");
            }
            case 152: {
                return NativePointer.$((String)"DW_OP_call2");
            }
            case 153: {
                return NativePointer.$((String)"DW_OP_call4");
            }
            case 154: {
                return NativePointer.$((String)"DW_OP_call_ref");
            }
            case 155: {
                return NativePointer.$((String)"DW_OP_form_tls_address");
            }
            case 156: {
                return NativePointer.$((String)"DW_OP_call_frame_cfa");
            }
            case 157: {
                return NativePointer.$((String)"DW_OP_bit_piece");
            }
            case 158: {
                return NativePointer.$((String)"DW_OP_implicit_value");
            }
            case 159: {
                return NativePointer.$((String)"DW_OP_stack_value");
            }
            case 224: {
                return NativePointer.$((String)"DW_OP_GNU_push_tls_address");
            }
            case 251: {
                return NativePointer.$((String)"DW_OP_GNU_addr_index");
            }
            case 252: 
        }
        return NativePointer.$((String)"DW_OP_GNU_const_index");
    }

    public static char.ptr AttributeEncodingString(int Encoding) {
        switch (Encoding) {
            default: {
                return null;
            }
            case 1: {
                return NativePointer.$((String)"DW_ATE_address");
            }
            case 2: {
                return NativePointer.$((String)"DW_ATE_boolean");
            }
            case 3: {
                return NativePointer.$((String)"DW_ATE_complex_float");
            }
            case 4: {
                return NativePointer.$((String)"DW_ATE_float");
            }
            case 5: {
                return NativePointer.$((String)"DW_ATE_signed");
            }
            case 6: {
                return NativePointer.$((String)"DW_ATE_signed_char");
            }
            case 7: {
                return NativePointer.$((String)"DW_ATE_unsigned");
            }
            case 8: {
                return NativePointer.$((String)"DW_ATE_unsigned_char");
            }
            case 9: {
                return NativePointer.$((String)"DW_ATE_imaginary_float");
            }
            case 10: {
                return NativePointer.$((String)"DW_ATE_packed_decimal");
            }
            case 11: {
                return NativePointer.$((String)"DW_ATE_numeric_string");
            }
            case 12: {
                return NativePointer.$((String)"DW_ATE_edited");
            }
            case 13: {
                return NativePointer.$((String)"DW_ATE_signed_fixed");
            }
            case 14: {
                return NativePointer.$((String)"DW_ATE_unsigned_fixed");
            }
            case 15: {
                return NativePointer.$((String)"DW_ATE_decimal_float");
            }
            case 16: 
        }
        return NativePointer.$((String)"DW_ATE_UTF");
    }

    public static char.ptr DecimalSignString(int Sign) {
        switch (Sign) {
            case 1: {
                return NativePointer.$((String)"DW_DS_unsigned");
            }
            case 2: {
                return NativePointer.$((String)"DW_DS_leading_overpunch");
            }
            case 3: {
                return NativePointer.$((String)"DW_DS_trailing_overpunch");
            }
            case 4: {
                return NativePointer.$((String)"DW_DS_leading_separate");
            }
            case 5: {
                return NativePointer.$((String)"DW_DS_trailing_separate");
            }
        }
        return null;
    }

    public static char.ptr EndianityString(int Endian) {
        switch (Endian) {
            case 0: {
                return NativePointer.$((String)"DW_END_default");
            }
            case 1: {
                return NativePointer.$((String)"DW_END_big");
            }
            case 2: {
                return NativePointer.$((String)"DW_END_little");
            }
            case 64: {
                return NativePointer.$((String)"DW_END_lo_user");
            }
            case 255: {
                return NativePointer.$((String)"DW_END_hi_user");
            }
        }
        return null;
    }

    public static char.ptr AccessibilityString(int Access) {
        switch (Access) {
            case 1: {
                return NativePointer.$((String)"DW_ACCESS_public");
            }
            case 2: {
                return NativePointer.$((String)"DW_ACCESS_protected");
            }
            case 3: {
                return NativePointer.$((String)"DW_ACCESS_private");
            }
        }
        return null;
    }

    public static char.ptr VisibilityString(int Visibility) {
        switch (Visibility) {
            case 1: {
                return NativePointer.$((String)"DW_VIS_local");
            }
            case 2: {
                return NativePointer.$((String)"DW_VIS_exported");
            }
            case 3: {
                return NativePointer.$((String)"DW_VIS_qualified");
            }
        }
        return null;
    }

    public static char.ptr VirtualityString(int Virtuality) {
        switch (Virtuality) {
            default: {
                return null;
            }
            case 0: {
                return NativePointer.$((String)"DW_VIRTUALITY_none");
            }
            case 1: {
                return NativePointer.$((String)"DW_VIRTUALITY_virtual");
            }
            case 2: 
        }
        return NativePointer.$((String)"DW_VIRTUALITY_pure_virtual");
    }

    public static char.ptr LanguageString(int Language) {
        switch (Language) {
            default: {
                return null;
            }
            case 1: {
                return NativePointer.$((String)"DW_LANG_C89");
            }
            case 2: {
                return NativePointer.$((String)"DW_LANG_C");
            }
            case 3: {
                return NativePointer.$((String)"DW_LANG_Ada83");
            }
            case 4: {
                return NativePointer.$((String)"DW_LANG_C_plus_plus");
            }
            case 5: {
                return NativePointer.$((String)"DW_LANG_Cobol74");
            }
            case 6: {
                return NativePointer.$((String)"DW_LANG_Cobol85");
            }
            case 7: {
                return NativePointer.$((String)"DW_LANG_Fortran77");
            }
            case 8: {
                return NativePointer.$((String)"DW_LANG_Fortran90");
            }
            case 9: {
                return NativePointer.$((String)"DW_LANG_Pascal83");
            }
            case 10: {
                return NativePointer.$((String)"DW_LANG_Modula2");
            }
            case 11: {
                return NativePointer.$((String)"DW_LANG_Java");
            }
            case 12: {
                return NativePointer.$((String)"DW_LANG_C99");
            }
            case 13: {
                return NativePointer.$((String)"DW_LANG_Ada95");
            }
            case 14: {
                return NativePointer.$((String)"DW_LANG_Fortran95");
            }
            case 15: {
                return NativePointer.$((String)"DW_LANG_PLI");
            }
            case 16: {
                return NativePointer.$((String)"DW_LANG_ObjC");
            }
            case 17: {
                return NativePointer.$((String)"DW_LANG_ObjC_plus_plus");
            }
            case 18: {
                return NativePointer.$((String)"DW_LANG_UPC");
            }
            case 19: {
                return NativePointer.$((String)"DW_LANG_D");
            }
            case 20: {
                return NativePointer.$((String)"DW_LANG_Python");
            }
            case 21: {
                return NativePointer.$((String)"DW_LANG_OpenCL");
            }
            case 22: {
                return NativePointer.$((String)"DW_LANG_Go");
            }
            case 23: {
                return NativePointer.$((String)"DW_LANG_Modula3");
            }
            case 24: {
                return NativePointer.$((String)"DW_LANG_Haskell");
            }
            case 25: {
                return NativePointer.$((String)"DW_LANG_C_plus_plus_03");
            }
            case 26: {
                return NativePointer.$((String)"DW_LANG_C_plus_plus_11");
            }
            case 27: {
                return NativePointer.$((String)"DW_LANG_OCaml");
            }
            case 28: {
                return NativePointer.$((String)"DW_LANG_Rust");
            }
            case 29: {
                return NativePointer.$((String)"DW_LANG_C11");
            }
            case 30: {
                return NativePointer.$((String)"DW_LANG_Swift");
            }
            case 31: {
                return NativePointer.$((String)"DW_LANG_Julia");
            }
            case 32: {
                return NativePointer.$((String)"DW_LANG_Dylan");
            }
            case 33: {
                return NativePointer.$((String)"DW_LANG_C_plus_plus_14");
            }
            case 34: {
                return NativePointer.$((String)"DW_LANG_Fortran03");
            }
            case 35: {
                return NativePointer.$((String)"DW_LANG_Fortran08");
            }
            case 32769: {
                return NativePointer.$((String)"DW_LANG_Mips_Assembler");
            }
            case 36439: {
                return NativePointer.$((String)"DW_LANG_GOOGLE_RenderScript");
            }
            case 45056: 
        }
        return NativePointer.$((String)"DW_LANG_BORLAND_Delphi");
    }

    public static char.ptr CaseString(int Case) {
        switch (Case) {
            case 0: {
                return NativePointer.$((String)"DW_ID_case_sensitive");
            }
            case 1: {
                return NativePointer.$((String)"DW_ID_up_case");
            }
            case 2: {
                return NativePointer.$((String)"DW_ID_down_case");
            }
            case 3: {
                return NativePointer.$((String)"DW_ID_case_insensitive");
            }
        }
        return null;
    }

    public static char.ptr ConventionString(int CC) {
        switch (CC) {
            default: {
                return null;
            }
            case 1: {
                return NativePointer.$((String)"DW_CC_normal");
            }
            case 2: {
                return NativePointer.$((String)"DW_CC_program");
            }
            case 3: {
                return NativePointer.$((String)"DW_CC_nocall");
            }
            case 65: {
                return NativePointer.$((String)"DW_CC_GNU_borland_fastcall_i386");
            }
            case 176: {
                return NativePointer.$((String)"DW_CC_BORLAND_safecall");
            }
            case 177: {
                return NativePointer.$((String)"DW_CC_BORLAND_stdcall");
            }
            case 178: {
                return NativePointer.$((String)"DW_CC_BORLAND_pascal");
            }
            case 179: {
                return NativePointer.$((String)"DW_CC_BORLAND_msfastcall");
            }
            case 180: {
                return NativePointer.$((String)"DW_CC_BORLAND_msreturn");
            }
            case 181: {
                return NativePointer.$((String)"DW_CC_BORLAND_thiscall");
            }
            case 182: {
                return NativePointer.$((String)"DW_CC_BORLAND_fastcall");
            }
            case 192: 
        }
        return NativePointer.$((String)"DW_CC_LLVM_vectorcall");
    }

    public static char.ptr InlineCodeString(int Code) {
        switch (Code) {
            case 0: {
                return NativePointer.$((String)"DW_INL_not_inlined");
            }
            case 1: {
                return NativePointer.$((String)"DW_INL_inlined");
            }
            case 2: {
                return NativePointer.$((String)"DW_INL_declared_not_inlined");
            }
            case 3: {
                return NativePointer.$((String)"DW_INL_declared_inlined");
            }
        }
        return null;
    }

    public static char.ptr ArrayOrderString(int Order) {
        switch (Order) {
            case 0: {
                return NativePointer.$((String)"DW_ORD_row_major");
            }
            case 1: {
                return NativePointer.$((String)"DW_ORD_col_major");
            }
        }
        return null;
    }

    public static char.ptr DiscriminantString(int Discriminant) {
        switch (Discriminant) {
            case 0: {
                return NativePointer.$((String)"DW_DSC_label");
            }
            case 1: {
                return NativePointer.$((String)"DW_DSC_range");
            }
        }
        return null;
    }

    public static char.ptr LNStandardString(int Standard) {
        switch (Standard) {
            case 1: {
                return NativePointer.$((String)"DW_LNS_copy");
            }
            case 2: {
                return NativePointer.$((String)"DW_LNS_advance_pc");
            }
            case 3: {
                return NativePointer.$((String)"DW_LNS_advance_line");
            }
            case 4: {
                return NativePointer.$((String)"DW_LNS_set_file");
            }
            case 5: {
                return NativePointer.$((String)"DW_LNS_set_column");
            }
            case 6: {
                return NativePointer.$((String)"DW_LNS_negate_stmt");
            }
            case 7: {
                return NativePointer.$((String)"DW_LNS_set_basic_block");
            }
            case 8: {
                return NativePointer.$((String)"DW_LNS_const_add_pc");
            }
            case 9: {
                return NativePointer.$((String)"DW_LNS_fixed_advance_pc");
            }
            case 10: {
                return NativePointer.$((String)"DW_LNS_set_prologue_end");
            }
            case 11: {
                return NativePointer.$((String)"DW_LNS_set_epilogue_begin");
            }
            case 12: {
                return NativePointer.$((String)"DW_LNS_set_isa");
            }
        }
        return null;
    }

    public static char.ptr LNExtendedString(int Encoding) {
        switch (Encoding) {
            case 1: {
                return NativePointer.$((String)"DW_LNE_end_sequence");
            }
            case 2: {
                return NativePointer.$((String)"DW_LNE_set_address");
            }
            case 3: {
                return NativePointer.$((String)"DW_LNE_define_file");
            }
            case 4: {
                return NativePointer.$((String)"DW_LNE_set_discriminator");
            }
            case 128: {
                return NativePointer.$((String)"DW_LNE_lo_user");
            }
            case 255: {
                return NativePointer.$((String)"DW_LNE_hi_user");
            }
        }
        return null;
    }

    public static char.ptr MacinfoString(int Encoding) {
        switch (LLVMConstants.valueOf(Encoding).getValue()) {
            case 1: {
                return NativePointer.$((String)"DW_MACINFO_define");
            }
            case 2: {
                return NativePointer.$((String)"DW_MACINFO_undef");
            }
            case 3: {
                return NativePointer.$((String)"DW_MACINFO_start_file");
            }
            case 4: {
                return NativePointer.$((String)"DW_MACINFO_end_file");
            }
            case 255: {
                return NativePointer.$((String)"DW_MACINFO_vendor_ext");
            }
            case -1: {
                return NativePointer.$((String)"DW_MACINFO_invalid");
            }
        }
        return null;
    }

    public static char.ptr CallFrameString(int Encoding) {
        switch (Encoding) {
            case 0: {
                return NativePointer.$((String)"DW_CFA_nop");
            }
            case 64: {
                return NativePointer.$((String)"DW_CFA_advance_loc");
            }
            case 128: {
                return NativePointer.$((String)"DW_CFA_offset");
            }
            case 192: {
                return NativePointer.$((String)"DW_CFA_restore");
            }
            case 1: {
                return NativePointer.$((String)"DW_CFA_set_loc");
            }
            case 2: {
                return NativePointer.$((String)"DW_CFA_advance_loc1");
            }
            case 3: {
                return NativePointer.$((String)"DW_CFA_advance_loc2");
            }
            case 4: {
                return NativePointer.$((String)"DW_CFA_advance_loc4");
            }
            case 5: {
                return NativePointer.$((String)"DW_CFA_offset_extended");
            }
            case 6: {
                return NativePointer.$((String)"DW_CFA_restore_extended");
            }
            case 7: {
                return NativePointer.$((String)"DW_CFA_undefined");
            }
            case 8: {
                return NativePointer.$((String)"DW_CFA_same_value");
            }
            case 9: {
                return NativePointer.$((String)"DW_CFA_register");
            }
            case 10: {
                return NativePointer.$((String)"DW_CFA_remember_state");
            }
            case 11: {
                return NativePointer.$((String)"DW_CFA_restore_state");
            }
            case 12: {
                return NativePointer.$((String)"DW_CFA_def_cfa");
            }
            case 13: {
                return NativePointer.$((String)"DW_CFA_def_cfa_register");
            }
            case 14: {
                return NativePointer.$((String)"DW_CFA_def_cfa_offset");
            }
            case 15: {
                return NativePointer.$((String)"DW_CFA_def_cfa_expression");
            }
            case 16: {
                return NativePointer.$((String)"DW_CFA_expression");
            }
            case 17: {
                return NativePointer.$((String)"DW_CFA_offset_extended_sf");
            }
            case 18: {
                return NativePointer.$((String)"DW_CFA_def_cfa_sf");
            }
            case 19: {
                return NativePointer.$((String)"DW_CFA_def_cfa_offset_sf");
            }
            case 20: {
                return NativePointer.$((String)"DW_CFA_val_offset");
            }
            case 21: {
                return NativePointer.$((String)"DW_CFA_val_offset_sf");
            }
            case 22: {
                return NativePointer.$((String)"DW_CFA_val_expression");
            }
            case 29: {
                return NativePointer.$((String)"DW_CFA_MIPS_advance_loc8");
            }
            case 45: {
                return NativePointer.$((String)"DW_CFA_GNU_window_save");
            }
            case 46: {
                return NativePointer.$((String)"DW_CFA_GNU_args_size");
            }
            case 28: {
                return NativePointer.$((String)"DW_CFA_lo_user");
            }
            case 63: {
                return NativePointer.$((String)"DW_CFA_hi_user");
            }
        }
        return null;
    }

    public static char.ptr ApplePropertyString(int Prop) {
        switch (Prop) {
            case 1: {
                return NativePointer.$((String)"DW_APPLE_PROPERTY_readonly");
            }
            case 2: {
                return NativePointer.$((String)"DW_APPLE_PROPERTY_getter");
            }
            case 4: {
                return NativePointer.$((String)"DW_APPLE_PROPERTY_assign");
            }
            case 8: {
                return NativePointer.$((String)"DW_APPLE_PROPERTY_readwrite");
            }
            case 16: {
                return NativePointer.$((String)"DW_APPLE_PROPERTY_retain");
            }
            case 32: {
                return NativePointer.$((String)"DW_APPLE_PROPERTY_copy");
            }
            case 64: {
                return NativePointer.$((String)"DW_APPLE_PROPERTY_nonatomic");
            }
            case 128: {
                return NativePointer.$((String)"DW_APPLE_PROPERTY_setter");
            }
            case 256: {
                return NativePointer.$((String)"DW_APPLE_PROPERTY_atomic");
            }
            case 512: {
                return NativePointer.$((String)"DW_APPLE_PROPERTY_weak");
            }
            case 1024: {
                return NativePointer.$((String)"DW_APPLE_PROPERTY_strong");
            }
            case 2048: {
                return NativePointer.$((String)"DW_APPLE_PROPERTY_unsafe_unretained");
            }
            case 4096: {
                return NativePointer.$((String)"DW_APPLE_PROPERTY_nullability");
            }
            case 8192: {
                return NativePointer.$((String)"DW_APPLE_PROPERTY_null_resettable");
            }
            case 16384: {
                return NativePointer.$((String)"DW_APPLE_PROPERTY_class");
            }
        }
        return null;
    }

    public static char.ptr AtomTypeString(int AT) {
        switch (AcceleratorTable.valueOf(AT)) {
            case DW_ATOM_null: {
                return NativePointer.$((String)"DW_ATOM_null");
            }
            case DW_ATOM_die_offset: {
                return NativePointer.$((String)"DW_ATOM_die_offset");
            }
            case DW_ATOM_cu_offset: {
                return NativePointer.$((String)"DW_ATOM_cu_offset");
            }
            case DW_ATOM_die_tag: {
                return NativePointer.$((String)"DW_ATOM_die_tag");
            }
            case DW_ATOM_type_flags: {
                return NativePointer.$((String)"DW_ATOM_type_flags");
            }
        }
        return null;
    }

    public static char.ptr GDBIndexEntryKindString(GDBIndexEntryKind Kind2) {
        switch (Kind2) {
            case GIEK_NONE: {
                return NativePointer.$((String)"NONE");
            }
            case GIEK_TYPE: {
                return NativePointer.$((String)"TYPE");
            }
            case GIEK_VARIABLE: {
                return NativePointer.$((String)"VARIABLE");
            }
            case GIEK_FUNCTION: {
                return NativePointer.$((String)"FUNCTION");
            }
            case GIEK_OTHER: {
                return NativePointer.$((String)"OTHER");
            }
            case GIEK_UNUSED5: {
                return NativePointer.$((String)"UNUSED5");
            }
            case GIEK_UNUSED6: {
                return NativePointer.$((String)"UNUSED6");
            }
            case GIEK_UNUSED7: {
                return NativePointer.$((String)"UNUSED7");
            }
        }
        throw new llvm_unreachable("Unknown GDBIndexEntryKind value");
    }

    public static char.ptr GDBIndexEntryLinkageString(GDBIndexEntryLinkage Linkage) {
        switch (Linkage) {
            case GIEL_EXTERNAL: {
                return NativePointer.$((String)"EXTERNAL");
            }
            case GIEL_STATIC: {
                return NativePointer.$((String)"STATIC");
            }
        }
        throw new llvm_unreachable("Unknown GDBIndexEntryLinkage value");
    }

    public static int getTag(StringRef TagString) {
        return new StringSwitchUInt(TagString).Case("DW_TAG_array_type", Unsigned.$ushort2uint((char)'\u0001')).Case("DW_TAG_class_type", Unsigned.$ushort2uint((char)'\u0002')).Case("DW_TAG_entry_point", Unsigned.$ushort2uint((char)'\u0003')).Case("DW_TAG_enumeration_type", Unsigned.$ushort2uint((char)'\u0004')).Case("DW_TAG_formal_parameter", Unsigned.$ushort2uint((char)'\u0005')).Case("DW_TAG_imported_declaration", Unsigned.$ushort2uint((char)'\b')).Case("DW_TAG_label", Unsigned.$ushort2uint((char)'\n')).Case("DW_TAG_lexical_block", Unsigned.$ushort2uint((char)'\u000b')).Case("DW_TAG_member", Unsigned.$ushort2uint((char)'\r')).Case("DW_TAG_pointer_type", Unsigned.$ushort2uint((char)'\u000f')).Case("DW_TAG_reference_type", Unsigned.$ushort2uint((char)'\u0010')).Case("DW_TAG_compile_unit", Unsigned.$ushort2uint((char)'\u0011')).Case("DW_TAG_string_type", Unsigned.$ushort2uint((char)'\u0012')).Case("DW_TAG_structure_type", Unsigned.$ushort2uint((char)'\u0013')).Case("DW_TAG_subroutine_type", Unsigned.$ushort2uint((char)'\u0015')).Case("DW_TAG_typedef", Unsigned.$ushort2uint((char)'\u0016')).Case("DW_TAG_union_type", Unsigned.$ushort2uint((char)'\u0017')).Case("DW_TAG_unspecified_parameters", Unsigned.$ushort2uint((char)'\u0018')).Case("DW_TAG_variant", Unsigned.$ushort2uint((char)'\u0019')).Case("DW_TAG_common_block", Unsigned.$ushort2uint((char)'\u001a')).Case("DW_TAG_common_inclusion", Unsigned.$ushort2uint((char)'\u001b')).Case("DW_TAG_inheritance", Unsigned.$ushort2uint((char)'\u001c')).Case("DW_TAG_inlined_subroutine", Unsigned.$ushort2uint((char)'\u001d')).Case("DW_TAG_module", Unsigned.$ushort2uint((char)'\u001e')).Case("DW_TAG_ptr_to_member_type", Unsigned.$ushort2uint((char)'\u001f')).Case("DW_TAG_set_type", Unsigned.$ushort2uint((char)' ')).Case("DW_TAG_subrange_type", Unsigned.$ushort2uint((char)'!')).Case("DW_TAG_with_stmt", Unsigned.$ushort2uint((char)'\"')).Case("DW_TAG_access_declaration", Unsigned.$ushort2uint((char)'#')).Case("DW_TAG_base_type", Unsigned.$ushort2uint((char)'$')).Case("DW_TAG_catch_block", Unsigned.$ushort2uint((char)'%')).Case("DW_TAG_const_type", Unsigned.$ushort2uint((char)'&')).Case("DW_TAG_constant", Unsigned.$ushort2uint((char)'\'')).Case("DW_TAG_enumerator", Unsigned.$ushort2uint((char)'(')).Case("DW_TAG_file_type", Unsigned.$ushort2uint((char)')')).Case("DW_TAG_friend", Unsigned.$ushort2uint((char)'*')).Case("DW_TAG_namelist", Unsigned.$ushort2uint((char)'+')).Case("DW_TAG_namelist_item", Unsigned.$ushort2uint((char)',')).Case("DW_TAG_packed_type", Unsigned.$ushort2uint((char)'-')).Case("DW_TAG_subprogram", Unsigned.$ushort2uint((char)'.')).Case("DW_TAG_template_type_parameter", Unsigned.$ushort2uint((char)'/')).Case("DW_TAG_template_value_parameter", Unsigned.$ushort2uint((char)'0')).Case("DW_TAG_thrown_type", Unsigned.$ushort2uint((char)'1')).Case("DW_TAG_try_block", Unsigned.$ushort2uint((char)'2')).Case("DW_TAG_variant_part", Unsigned.$ushort2uint((char)'3')).Case("DW_TAG_variable", Unsigned.$ushort2uint((char)'4')).Case("DW_TAG_volatile_type", Unsigned.$ushort2uint((char)'5')).Case("DW_TAG_dwarf_procedure", Unsigned.$ushort2uint((char)'6')).Case("DW_TAG_restrict_type", Unsigned.$ushort2uint((char)'7')).Case("DW_TAG_interface_type", Unsigned.$ushort2uint((char)'8')).Case("DW_TAG_namespace", Unsigned.$ushort2uint((char)'9')).Case("DW_TAG_imported_module", Unsigned.$ushort2uint((char)':')).Case("DW_TAG_unspecified_type", Unsigned.$ushort2uint((char)';')).Case("DW_TAG_partial_unit", Unsigned.$ushort2uint((char)'<')).Case("DW_TAG_imported_unit", Unsigned.$ushort2uint((char)'=')).Case("DW_TAG_condition", Unsigned.$ushort2uint((char)'?')).Case("DW_TAG_shared_type", Unsigned.$ushort2uint((char)'@')).Case("DW_TAG_type_unit", Unsigned.$ushort2uint((char)'A')).Case("DW_TAG_rvalue_reference_type", Unsigned.$ushort2uint((char)'B')).Case("DW_TAG_template_alias", Unsigned.$ushort2uint((char)'C')).Case("DW_TAG_coarray_type", Unsigned.$ushort2uint((char)'D')).Case("DW_TAG_generic_subrange", Unsigned.$ushort2uint((char)'E')).Case("DW_TAG_dynamic_type", Unsigned.$ushort2uint((char)'F')).Case("DW_TAG_MIPS_loop", Unsigned.$ushort2uint((char)'\u4081')).Case("DW_TAG_format_label", Unsigned.$ushort2uint((char)'\u4101')).Case("DW_TAG_function_template", Unsigned.$ushort2uint((char)'\u4102')).Case("DW_TAG_class_template", Unsigned.$ushort2uint((char)'\u4103')).Case("DW_TAG_GNU_template_template_param", Unsigned.$ushort2uint((char)'\u4106')).Case("DW_TAG_GNU_template_parameter_pack", Unsigned.$ushort2uint((char)'\u4107')).Case("DW_TAG_GNU_formal_parameter_pack", Unsigned.$ushort2uint((char)'\u4108')).Case("DW_TAG_APPLE_property", Unsigned.$ushort2uint((char)'\u4200')).Case("DW_TAG_BORLAND_property", Unsigned.$ushort2uint((char)'\ub000')).Case("DW_TAG_BORLAND_Delphi_string", Unsigned.$ushort2uint((char)'\ub001')).Case("DW_TAG_BORLAND_Delphi_dynamic_array", Unsigned.$ushort2uint((char)'\ub002')).Case("DW_TAG_BORLAND_Delphi_set", Unsigned.$ushort2uint((char)'\ub003')).Case("DW_TAG_BORLAND_Delphi_variant", Unsigned.$ushort2uint((char)'\ub004')).Default(LLVMConstants.DW_TAG_invalid.getValue());
    }

    public static int getOperationEncoding(StringRef OperationEncodingString) {
        return new StringSwitchUInt(OperationEncodingString).Case("DW_OP_addr", 3).Case("DW_OP_deref", 6).Case("DW_OP_const1u", 8).Case("DW_OP_const1s", 9).Case("DW_OP_const2u", 10).Case("DW_OP_const2s", 11).Case("DW_OP_const4u", 12).Case("DW_OP_const4s", 13).Case("DW_OP_const8u", 14).Case("DW_OP_const8s", 15).Case("DW_OP_constu", 16).Case("DW_OP_consts", 17).Case("DW_OP_dup", 18).Case("DW_OP_drop", 19).Case("DW_OP_over", 20).Case("DW_OP_pick", 21).Case("DW_OP_swap", 22).Case("DW_OP_rot", 23).Case("DW_OP_xderef", 24).Case("DW_OP_abs", 25).Case("DW_OP_and", 26).Case("DW_OP_div", 27).Case("DW_OP_minus", 28).Case("DW_OP_mod", 29).Case("DW_OP_mul", 30).Case("DW_OP_neg", 31).Case("DW_OP_not", 32).Case("DW_OP_or", 33).Case("DW_OP_plus", 34).Case("DW_OP_plus_uconst", 35).Case("DW_OP_shl", 36).Case("DW_OP_shr", 37).Case("DW_OP_shra", 38).Case("DW_OP_xor", 39).Case("DW_OP_skip", 47).Case("DW_OP_bra", 40).Case("DW_OP_eq", 41).Case("DW_OP_ge", 42).Case("DW_OP_gt", 43).Case("DW_OP_le", 44).Case("DW_OP_lt", 45).Case("DW_OP_ne", 46).Case("DW_OP_lit0", 48).Case("DW_OP_lit1", 49).Case("DW_OP_lit2", 50).Case("DW_OP_lit3", 51).Case("DW_OP_lit4", 52).Case("DW_OP_lit5", 53).Case("DW_OP_lit6", 54).Case("DW_OP_lit7", 55).Case("DW_OP_lit8", 56).Case("DW_OP_lit9", 57).Case("DW_OP_lit10", 58).Case("DW_OP_lit11", 59).Case("DW_OP_lit12", 60).Case("DW_OP_lit13", 61).Case("DW_OP_lit14", 62).Case("DW_OP_lit15", 63).Case("DW_OP_lit16", 64).Case("DW_OP_lit17", 65).Case("DW_OP_lit18", 66).Case("DW_OP_lit19", 67).Case("DW_OP_lit20", 68).Case("DW_OP_lit21", 69).Case("DW_OP_lit22", 70).Case("DW_OP_lit23", 71).Case("DW_OP_lit24", 72).Case("DW_OP_lit25", 73).Case("DW_OP_lit26", 74).Case("DW_OP_lit27", 75).Case("DW_OP_lit28", 76).Case("DW_OP_lit29", 77).Case("DW_OP_lit30", 78).Case("DW_OP_lit31", 79).Case("DW_OP_reg0", 80).Case("DW_OP_reg1", 81).Case("DW_OP_reg2", 82).Case("DW_OP_reg3", 83).Case("DW_OP_reg4", 84).Case("DW_OP_reg5", 85).Case("DW_OP_reg6", 86).Case("DW_OP_reg7", 87).Case("DW_OP_reg8", 88).Case("DW_OP_reg9", 89).Case("DW_OP_reg10", 90).Case("DW_OP_reg11", 91).Case("DW_OP_reg12", 92).Case("DW_OP_reg13", 93).Case("DW_OP_reg14", 94).Case("DW_OP_reg15", 95).Case("DW_OP_reg16", 96).Case("DW_OP_reg17", 97).Case("DW_OP_reg18", 98).Case("DW_OP_reg19", 99).Case("DW_OP_reg20", 100).Case("DW_OP_reg21", 101).Case("DW_OP_reg22", 102).Case("DW_OP_reg23", 103).Case("DW_OP_reg24", 104).Case("DW_OP_reg25", 105).Case("DW_OP_reg26", 106).Case("DW_OP_reg27", 107).Case("DW_OP_reg28", 108).Case("DW_OP_reg29", 109).Case("DW_OP_reg30", 110).Case("DW_OP_reg31", 111).Case("DW_OP_breg0", 112).Case("DW_OP_breg1", 113).Case("DW_OP_breg2", 114).Case("DW_OP_breg3", 115).Case("DW_OP_breg4", 116).Case("DW_OP_breg5", 117).Case("DW_OP_breg6", 118).Case("DW_OP_breg7", 119).Case("DW_OP_breg8", 120).Case("DW_OP_breg9", 121).Case("DW_OP_breg10", 122).Case("DW_OP_breg11", 123).Case("DW_OP_breg12", 124).Case("DW_OP_breg13", 125).Case("DW_OP_breg14", 126).Case("DW_OP_breg15", 127).Case("DW_OP_breg16", 128).Case("DW_OP_breg17", 129).Case("DW_OP_breg18", 130).Case("DW_OP_breg19", 131).Case("DW_OP_breg20", 132).Case("DW_OP_breg21", 133).Case("DW_OP_breg22", 134).Case("DW_OP_breg23", 135).Case("DW_OP_breg24", 136).Case("DW_OP_breg25", 137).Case("DW_OP_breg26", 138).Case("DW_OP_breg27", 139).Case("DW_OP_breg28", 140).Case("DW_OP_breg29", 141).Case("DW_OP_breg30", 142).Case("DW_OP_breg31", 143).Case("DW_OP_regx", 144).Case("DW_OP_fbreg", 145).Case("DW_OP_bregx", 146).Case("DW_OP_piece", 147).Case("DW_OP_deref_size", 148).Case("DW_OP_xderef_size", 149).Case("DW_OP_nop", 150).Case("DW_OP_push_object_address", 151).Case("DW_OP_call2", 152).Case("DW_OP_call4", 153).Case("DW_OP_call_ref", 154).Case("DW_OP_form_tls_address", 155).Case("DW_OP_call_frame_cfa", 156).Case("DW_OP_bit_piece", 157).Case("DW_OP_implicit_value", 158).Case("DW_OP_stack_value", 159).Case("DW_OP_GNU_push_tls_address", 224).Case("DW_OP_GNU_addr_index", 251).Case("DW_OP_GNU_const_index", 252).Default(0);
    }

    public static int getVirtuality(StringRef VirtualityString) {
        return new StringSwitchUInt(VirtualityString).Case("DW_VIRTUALITY_none", 0).Case("DW_VIRTUALITY_virtual", 1).Case("DW_VIRTUALITY_pure_virtual", 2).Default(LLVMConstants.DW_VIRTUALITY_invalid.getValue());
    }

    public static int getLanguage(StringRef LanguageString) {
        return new StringSwitchUInt(LanguageString).Case("DW_LANG_C89", 1).Case("DW_LANG_C", 2).Case("DW_LANG_Ada83", 3).Case("DW_LANG_C_plus_plus", 4).Case("DW_LANG_Cobol74", 5).Case("DW_LANG_Cobol85", 6).Case("DW_LANG_Fortran77", 7).Case("DW_LANG_Fortran90", 8).Case("DW_LANG_Pascal83", 9).Case("DW_LANG_Modula2", 10).Case("DW_LANG_Java", 11).Case("DW_LANG_C99", 12).Case("DW_LANG_Ada95", 13).Case("DW_LANG_Fortran95", 14).Case("DW_LANG_PLI", 15).Case("DW_LANG_ObjC", 16).Case("DW_LANG_ObjC_plus_plus", 17).Case("DW_LANG_UPC", 18).Case("DW_LANG_D", 19).Case("DW_LANG_Python", 20).Case("DW_LANG_OpenCL", 21).Case("DW_LANG_Go", 22).Case("DW_LANG_Modula3", 23).Case("DW_LANG_Haskell", 24).Case("DW_LANG_C_plus_plus_03", 25).Case("DW_LANG_C_plus_plus_11", 26).Case("DW_LANG_OCaml", 27).Case("DW_LANG_Rust", 28).Case("DW_LANG_C11", 29).Case("DW_LANG_Swift", 30).Case("DW_LANG_Julia", 31).Case("DW_LANG_Dylan", 32).Case("DW_LANG_C_plus_plus_14", 33).Case("DW_LANG_Fortran03", 34).Case("DW_LANG_Fortran08", 35).Case("DW_LANG_Mips_Assembler", 32769).Case("DW_LANG_GOOGLE_RenderScript", 36439).Case("DW_LANG_BORLAND_Delphi", 45056).Default(0);
    }

    public static int getCallingConvention(StringRef CCString) {
        return new StringSwitchUInt(CCString).Case("DW_CC_normal", 1).Case("DW_CC_program", 2).Case("DW_CC_nocall", 3).Case("DW_CC_GNU_borland_fastcall_i386", 65).Case("DW_CC_BORLAND_safecall", 176).Case("DW_CC_BORLAND_stdcall", 177).Case("DW_CC_BORLAND_pascal", 178).Case("DW_CC_BORLAND_msfastcall", 179).Case("DW_CC_BORLAND_msreturn", 180).Case("DW_CC_BORLAND_thiscall", 181).Case("DW_CC_BORLAND_fastcall", 182).Case("DW_CC_LLVM_vectorcall", 192).Default(0);
    }

    public static int getAttributeEncoding(StringRef EncodingString) {
        return new StringSwitchUInt(EncodingString).Case("DW_ATE_address", 1).Case("DW_ATE_boolean", 2).Case("DW_ATE_complex_float", 3).Case("DW_ATE_float", 4).Case("DW_ATE_signed", 5).Case("DW_ATE_signed_char", 6).Case("DW_ATE_unsigned", 7).Case("DW_ATE_unsigned_char", 8).Case("DW_ATE_imaginary_float", 9).Case("DW_ATE_packed_decimal", 10).Case("DW_ATE_numeric_string", 11).Case("DW_ATE_edited", 12).Case("DW_ATE_signed_fixed", 13).Case("DW_ATE_unsigned_fixed", 14).Case("DW_ATE_decimal_float", 15).Case("DW_ATE_UTF", 16).Default(0);
    }

    public static int getMacinfo(StringRef MacinfoString) {
        return new StringSwitchUInt(MacinfoString).Case("DW_MACINFO_define", 1).Case("DW_MACINFO_undef", 2).Case("DW_MACINFO_start_file", 3).Case("DW_MACINFO_end_file", 4).Case("DW_MACINFO_vendor_ext", 255).Default(LLVMConstants.DW_MACINFO_invalid.getValue());
    }

    public static char.ptr AttributeValueString(char Attr, int Val) {
        switch (Unsigned.$ushort2int((char)Attr)) {
            case 50: {
                return DwarfGlobals.AccessibilityString(Val);
            }
            case 76: {
                return DwarfGlobals.VirtualityString(Val);
            }
            case 19: {
                return DwarfGlobals.LanguageString(Val);
            }
            case 62: {
                return DwarfGlobals.AttributeEncodingString(Val);
            }
            case 94: {
                return DwarfGlobals.DecimalSignString(Val);
            }
            case 101: {
                return DwarfGlobals.EndianityString(Val);
            }
            case 23: {
                return DwarfGlobals.VisibilityString(Val);
            }
            case 66: {
                return DwarfGlobals.CaseString(Val);
            }
            case 54: {
                return DwarfGlobals.ConventionString(Val);
            }
            case 32: {
                return DwarfGlobals.InlineCodeString(Val);
            }
            case 9: {
                return DwarfGlobals.ArrayOrderString(Val);
            }
            case 22: {
                return DwarfGlobals.DiscriminantString(Val);
            }
        }
        return null;
    }
}

