/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support;

import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.llvm.support.impl.TimerStatics;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;
import org.llvm.support.sys.Process;
import org.llvm.support.sys.TimeValue;

public class TimeRecord
implements Native.NativePOD<TimeRecord>,
Native.ComparableLower {
    private double WallTime;
    private double UserTime;
    private double SystemTime;
    private int MemUsed;

    public TimeRecord() {
        this.WallTime = 0.0;
        this.UserTime = 0.0;
        this.SystemTime = 0.0;
        this.MemUsed = 0;
    }

    public static TimeRecord getCurrentTime() {
        return TimeRecord.getCurrentTime(true);
    }

    public static TimeRecord getCurrentTime(boolean Start2) {
        TimeRecord Result = new TimeRecord();
        TimeValue now = new TimeValue(0L, 0);
        TimeValue user = new TimeValue(0L, 0);
        TimeValue sys2 = new TimeValue(0L, 0);
        if (Start2) {
            Result.MemUsed = TimerStatics.getMemUsage();
            Process.GetTimeUsage(now, user, sys2);
        } else {
            Process.GetTimeUsage(now, user, sys2);
            Result.MemUsed = TimerStatics.getMemUsage();
        }
        Result.WallTime = (double)now.seconds() + (double)now.microseconds() / 1000000.0;
        Result.UserTime = (double)user.seconds() + (double)user.microseconds() / 1000000.0;
        Result.SystemTime = (double)sys2.seconds() + (double)sys2.microseconds() / 1000000.0;
        return Result;
    }

    public double getProcessTime() {
        return this.UserTime + this.SystemTime;
    }

    public double getUserTime() {
        return this.UserTime;
    }

    public double getSystemTime() {
        return this.SystemTime;
    }

    public double getWallTime() {
        return this.WallTime;
    }

    public int getMemUsed() {
        return this.MemUsed;
    }

    public boolean $less(TimeRecord T4) {
        return this.WallTime < T4.WallTime;
    }

    public void $addassign(TimeRecord RHS) {
        this.WallTime += RHS.WallTime;
        this.UserTime += RHS.UserTime;
        this.SystemTime += RHS.SystemTime;
        this.MemUsed += RHS.MemUsed;
    }

    public void $minusassign(TimeRecord RHS) {
        this.WallTime -= RHS.WallTime;
        this.UserTime -= RHS.UserTime;
        this.SystemTime -= RHS.SystemTime;
        this.MemUsed -= RHS.MemUsed;
    }

    public void print(TimeRecord Total, raw_ostream OS) {
        if (Total.getUserTime() != 0.0) {
            TimerStatics.printVal(this.getUserTime(), Total.getUserTime(), OS);
        }
        if (Total.getSystemTime() != 0.0) {
            TimerStatics.printVal(this.getSystemTime(), Total.getSystemTime(), OS);
        }
        if (Total.getProcessTime() != 0.0) {
            TimerStatics.printVal(this.getProcessTime(), Total.getProcessTime(), OS);
        }
        TimerStatics.printVal(this.getWallTime(), Total.getWallTime(), OS);
        OS.$out("  ");
        if (Total.getMemUsed() != 0) {
            OS.$out(llvm.format(NativePointer.$((String)"%9lld  "), (long)this.getMemUsed()));
        }
    }

    public TimeRecord(TimeRecord $Prm0) {
        this.WallTime = $Prm0.WallTime;
        this.UserTime = $Prm0.UserTime;
        this.SystemTime = $Prm0.SystemTime;
        this.MemUsed = $Prm0.MemUsed;
    }

    public TimeRecord(JavaDifferentiators.JD.Move _dparam, TimeRecord $Prm0) {
        this.WallTime = $Prm0.WallTime;
        this.UserTime = $Prm0.UserTime;
        this.SystemTime = $Prm0.SystemTime;
        this.MemUsed = $Prm0.MemUsed;
    }

    public TimeRecord $assign(TimeRecord $Prm0) {
        this.WallTime = $Prm0.WallTime;
        this.UserTime = $Prm0.UserTime;
        this.SystemTime = $Prm0.SystemTime;
        this.MemUsed = $Prm0.MemUsed;
        return this;
    }

    public TimeRecord $assignMove(TimeRecord $Prm0) {
        this.WallTime = $Prm0.WallTime;
        this.UserTime = $Prm0.UserTime;
        this.SystemTime = $Prm0.SystemTime;
        this.MemUsed = $Prm0.MemUsed;
        return this;
    }

    public TimeRecord clone() {
        return new TimeRecord(this);
    }

    public boolean $less(Object obj) {
        return this.$less((TimeRecord)obj);
    }

    public String toString() {
        return "WallTime=" + this.WallTime + ", UserTime=" + this.UserTime + ", SystemTime=" + this.SystemTime + ", MemUsed=" + this.MemUsed;
    }
}

