/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support;

import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.Unsigned;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.char;
import org.clank.support.void;
import org.llvm.adt.ADTFunctionPointers;
import org.llvm.adt.NoneType;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.support.ErrorOr;
import org.llvm.support.MemoryBuffer;
import org.llvm.support.SMDiagnostic;
import org.llvm.support.SMFixIt;
import org.llvm.support.SMLoc;
import org.llvm.support.SMRange;
import org.llvm.support.impl.LineNoCacheTy;
import org.llvm.support.impl.SourceMgrStatics;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;
import org.llvm.support.sys.path;

public class SourceMgr
implements Destructors.ClassWithDestructor {
    private std.vector<SrcBuffer> Buffers;
    private std.vectorString IncludeDirectories;
    private Object LineNoCache;
    private ADTFunctionPointers.DiagHandlerTy DiagHandler;
    private Object DiagContext;

    private boolean isValidBufferID(int i) {
        return i != 0 && Unsigned.$lesseq_uint((int)i, (int)this.Buffers.size());
    }

    protected SourceMgr(SourceMgr $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    protected void $assign(SourceMgr $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    public SourceMgr() {
        this.Buffers = new std.vector((Object)new SrcBuffer());
        this.IncludeDirectories = new std.vectorString(std.string.EMPTY);
        this.LineNoCache = null;
        this.DiagHandler = null;
        this.DiagContext = null;
    }

    public void $destroy() {
        LineNoCacheTy Cache2 = SourceMgrStatics.getCache(this.LineNoCache);
        if (Cache2 != null) {
            Destructors.$destroy((Object)Cache2);
        }
        this.IncludeDirectories.$destroy();
        this.Buffers.$destroy();
    }

    public void setIncludeDirs(std.vectorString Dirs) {
        this.IncludeDirectories.$assign(Dirs);
    }

    public void setDiagHandler(ADTFunctionPointers.DiagHandlerTy DH) {
        this.setDiagHandler(DH, null);
    }

    public void setDiagHandler(ADTFunctionPointers.DiagHandlerTy DH, Object Ctx) {
        this.DiagHandler = (ADTFunctionPointers.DiagHandlerTy)Native.$tryClone((Object)DH);
        this.DiagContext = Ctx;
    }

    public ADTFunctionPointers.DiagHandlerTy getDiagHandler() {
        return this.DiagHandler;
    }

    public Object getDiagContext() {
        return this.DiagContext;
    }

    public SrcBuffer getBufferInfo(int i) {
        assert (this.isValidBufferID(i));
        return (SrcBuffer)this.Buffers.$at$Const(i - 1);
    }

    public MemoryBuffer getMemoryBuffer(int i) {
        assert (this.isValidBufferID(i));
        return (MemoryBuffer)((SrcBuffer)this.Buffers.$at$Const((int)(i - 1))).Buffer.get();
    }

    public int getNumBuffers() {
        return this.Buffers.size();
    }

    public int getMainFileID() {
        assert (Native.$bool((int)this.getNumBuffers()));
        return 1;
    }

    public SMLoc getParentIncludeLoc(int i) {
        assert (this.isValidBufferID(i));
        return new SMLoc(((SrcBuffer)this.Buffers.$at$Const((int)(i - 1))).IncludeLoc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AddNewSourceBuffer(std_ptr.unique_ptr<MemoryBuffer> F, SMLoc IncludeLoc) {
        SrcBuffer NB = null;
        try {
            NB = new SrcBuffer();
            NB.Buffer.$assignMove((std_ptr.unique_ptr)std.move(F));
            NB.IncludeLoc.$assign(IncludeLoc);
            this.Buffers.push_back_T$RR((Object)((SrcBuffer)std.move((Object)NB)));
            int n = this.Buffers.size();
            return n;
        }
        finally {
            if (NB != null) {
                NB.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AddIncludeFile(std.string Filename, SMLoc IncludeLoc, std.string IncludedFile) {
        ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> NewBufOrErr = null;
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            int n;
            IncludedFile.$assign(Filename);
            NewBufOrErr = MemoryBuffer.getFile(new Twine(IncludedFile));
            int e = this.IncludeDirectories.size();
            for (int i = 0; i != e && !NewBufOrErr.$bool(); ++i) {
                IncludedFile.$assignMove(std.$add_string_string$C((std.string)std.$add_string$C_T$C$P((std.string)this.IncludeDirectories.$at(i), (String)path.get_separator().toJavaString()), (std.string)Filename));
                $c$.clean(NewBufOrErr.$assignMove((ErrorOr)$c$.track(MemoryBuffer.getFile(new Twine(IncludedFile)))));
            }
            if (!NewBufOrErr.$bool()) {
                n = 0;
                return n;
            }
            n = $c$.clean(this.AddNewSourceBuffer((std_ptr.unique_ptr<MemoryBuffer>)$c$.track(new std_ptr.unique_ptr(JavaDifferentiators.JD.Move.INSTANCE, (std_ptr.unique_ptr)std.move(NewBufOrErr.$star()))), new SMLoc(IncludeLoc)));
            return n;
        }
        finally {
            if (NewBufOrErr != null) {
                NewBufOrErr.$destroy();
            }
            $c$.$destroy();
        }
    }

    public int FindBufferContainingLoc(SMLoc Loc) {
        int e = this.Buffers.size();
        for (int i = 0; i != e; ++i) {
            if (!Loc.getPointer().$greatereq((Object)((MemoryBuffer)((SrcBuffer)this.Buffers.$at$Const((int)i)).Buffer.$arrow()).getBufferStart()) || !Loc.getPointer().$lesseq((Object)((MemoryBuffer)((SrcBuffer)this.Buffers.$at$Const((int)i)).Buffer.$arrow()).getBufferEnd())) continue;
            return i + 1;
        }
        return 0;
    }

    public int FindLineNumber(SMLoc Loc) {
        return this.FindLineNumber(Loc, 0);
    }

    public int FindLineNumber(SMLoc Loc, int BufferID) {
        return this.getLineAndColumn((SMLoc)new SMLoc((SMLoc)Loc), (int)BufferID).first;
    }

    public std_pair.pairUIntUInt getLineAndColumn(SMLoc Loc) {
        return this.getLineAndColumn(Loc, 0);
    }

    public std_pair.pairUIntUInt getLineAndColumn(SMLoc Loc, int BufferID) {
        if (BufferID == 0) {
            BufferID = this.FindBufferContainingLoc(new SMLoc(Loc));
        }
        assert (BufferID != 0) : "Invalid Location!";
        MemoryBuffer Buff = this.getMemoryBuffer(BufferID);
        int LineNo = 1;
        char.ptr BufStart = Native.$tryClone((char.ptr)Buff.getBufferStart());
        char.ptr Ptr2 = Native.$tryClone((char.ptr)BufStart);
        LineNoCacheTy Cache2 = SourceMgrStatics.getCache(this.LineNoCache);
        if (Cache2 != null && Cache2.LastQueryBufferID == BufferID && Cache2.LastQuery.$lesseq((Object)Loc.getPointer())) {
            Ptr2 = Native.$tryClone((char.ptr)Cache2.LastQuery);
            LineNo = Cache2.LineNoOfQuery;
        }
        while (SMLoc.getFromPointer(Ptr2).$noteq(Loc)) {
            if (Ptr2.$star() == 10) {
                ++LineNo;
            }
            Ptr2.$preInc();
        }
        if (this.LineNoCache == null) {
            this.LineNoCache = new LineNoCacheTy();
        }
        Cache2 = (LineNoCacheTy)Native.$Deref((Object)SourceMgrStatics.getCache(this.LineNoCache));
        Cache2.LastQueryBufferID = BufferID;
        Cache2.LastQuery = Native.$tryClone((char.ptr)Ptr2);
        Cache2.LineNoOfQuery = LineNo;
        int NewlineOffs = new StringRef(BufStart, Ptr2.$sub((abstract_iterator)BufStart)).find_last_of("\n\r");
        if (NewlineOffs == StringRef.npos) {
            NewlineOffs = -1;
        }
        return std.make_pair_uint_uint((int)LineNo, (int)(Ptr2.$sub((abstract_iterator)BufStart) - NewlineOffs));
    }

    public void PrintMessage(raw_ostream OS, SMLoc Loc, DiagKind Kind2, Twine Msg) {
        this.PrintMessage(OS, Loc, Kind2, Msg, new ArrayRef<NoneType>(llvm.None, false), new ArrayRef<NoneType>(llvm.None, false), true);
    }

    public void PrintMessage(raw_ostream OS, SMLoc Loc, DiagKind Kind2, Twine Msg, ArrayRef<SMRange> Ranges) {
        this.PrintMessage(OS, Loc, Kind2, Msg, Ranges, new ArrayRef<NoneType>(llvm.None, false), true);
    }

    public void PrintMessage(raw_ostream OS, SMLoc Loc, DiagKind Kind2, Twine Msg, ArrayRef<SMRange> Ranges, ArrayRef<SMFixIt> FixIts) {
        this.PrintMessage(OS, Loc, Kind2, Msg, Ranges, FixIts, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void PrintMessage(raw_ostream OS, SMLoc Loc, DiagKind Kind2, Twine Msg, ArrayRef<SMRange> Ranges, ArrayRef<SMFixIt> FixIts, boolean ShowColors) {
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            this.PrintMessage(OS, (SMDiagnostic)$c$.track((Object)this.GetMessage(new SMLoc(Loc), Kind2, Msg, new ArrayRef<SMRange>(Ranges), new ArrayRef<SMFixIt>(FixIts))), ShowColors);
            $c$.clean();
        }
        finally {
            $c$.$destroy();
        }
    }

    public void PrintMessage(SMLoc Loc, DiagKind Kind2, Twine Msg) {
        this.PrintMessage(Loc, Kind2, Msg, new ArrayRef<NoneType>(llvm.None, false), new ArrayRef<NoneType>(llvm.None, false), true);
    }

    public void PrintMessage(SMLoc Loc, DiagKind Kind2, Twine Msg, ArrayRef<SMRange> Ranges) {
        this.PrintMessage(Loc, Kind2, Msg, Ranges, new ArrayRef<NoneType>(llvm.None, false), true);
    }

    public void PrintMessage(SMLoc Loc, DiagKind Kind2, Twine Msg, ArrayRef<SMRange> Ranges, ArrayRef<SMFixIt> FixIts) {
        this.PrintMessage(Loc, Kind2, Msg, Ranges, FixIts, true);
    }

    public void PrintMessage(SMLoc Loc, DiagKind Kind2, Twine Msg, ArrayRef<SMRange> Ranges, ArrayRef<SMFixIt> FixIts, boolean ShowColors) {
        this.PrintMessage(llvm.errs(), new SMLoc(Loc), Kind2, Msg, new ArrayRef<SMRange>(Ranges), new ArrayRef<SMFixIt>(FixIts), ShowColors);
    }

    public void PrintMessage(raw_ostream OS, SMDiagnostic Diagnostic) {
        this.PrintMessage(OS, Diagnostic, true);
    }

    public void PrintMessage(raw_ostream OS, SMDiagnostic Diagnostic, boolean ShowColors) {
        if (this.DiagHandler != null) {
            this.DiagHandler.$call(Diagnostic, this.DiagContext);
            return;
        }
        if (Diagnostic.getLoc().isValid()) {
            int CurBuf = this.FindBufferContainingLoc(Diagnostic.getLoc());
            assert (CurBuf != 0) : "Invalid or unspecified location!";
            this.PrintIncludeStack(new SMLoc(this.getBufferInfo((int)CurBuf).IncludeLoc), OS);
        }
        Diagnostic.print(null, OS, ShowColors);
    }

    public SMDiagnostic GetMessage(SMLoc Loc, DiagKind Kind2, Twine Msg) {
        return this.GetMessage(Loc, Kind2, Msg, new ArrayRef<NoneType>(llvm.None, false), new ArrayRef<NoneType>(llvm.None, false));
    }

    public SMDiagnostic GetMessage(SMLoc Loc, DiagKind Kind2, Twine Msg, ArrayRef<SMRange> Ranges) {
        return this.GetMessage(Loc, Kind2, Msg, Ranges, new ArrayRef<NoneType>(llvm.None, false));
    }

    public SMDiagnostic GetMessage(SMLoc Loc, DiagKind Kind2, Twine Msg, ArrayRef<SMRange> Ranges, ArrayRef<SMFixIt> FixIts) {
        SmallVector<std_pair.pairUIntUInt> ColRanges = new SmallVector<std_pair.pairUIntUInt>(4, new std_pair.pairUIntUInt());
        std_pair.pairUIntUInt LineAndCol = new std_pair.pairUIntUInt();
        char.ptr BufferID = NativePointer.$((String)"<unknown>");
        std.string LineStr = new std.string();
        if (Loc.isValid()) {
            int CurBuf = this.FindBufferContainingLoc(new SMLoc(Loc));
            assert (CurBuf != 0) : "Invalid or unspecified location!";
            MemoryBuffer CurMB = this.getMemoryBuffer(CurBuf);
            BufferID = Native.$tryClone((char.ptr)CurMB.getBufferIdentifier());
            char.ptr LineStart = Native.$tryClone((char.ptr)Loc.getPointer());
            char.ptr BufStart = Native.$tryClone((char.ptr)CurMB.getBufferStart());
            while (Native.$noteq_ptr((void.ptr)LineStart, (void.ptr)BufStart) && LineStart.$at(-1) != 10 && LineStart.$at(-1) != 13) {
                LineStart.$preDec();
            }
            char.ptr LineEnd = Native.$tryClone((char.ptr)Loc.getPointer());
            char.ptr BufEnd = Native.$tryClone((char.ptr)CurMB.getBufferEnd());
            while (Native.$noteq_ptr((void.ptr)LineEnd, (void.ptr)BufEnd) && LineEnd.$at(0) != 10 && LineEnd.$at(0) != 13) {
                LineEnd.$preInc();
            }
            LineStr.$assignMove(new std.string((char.iterator)LineStart, (char.iterator)LineEnd));
            int e = Ranges.size();
            for (int i = 0; i != e; ++i) {
                SMRange R2 = new SMRange(Ranges.$at(i));
                if (!R2.isValid() || R2.Start.getPointer().$greater((Object)LineEnd) || R2.End.getPointer().$less((Object)LineStart)) continue;
                if (R2.Start.getPointer().$less((Object)LineStart)) {
                    R2.Start.$assignMove(SMLoc.getFromPointer(LineStart));
                }
                if (R2.End.getPointer().$greater((Object)LineEnd)) {
                    R2.End.$assignMove(SMLoc.getFromPointer(LineEnd));
                }
                ColRanges.push_back(std.make_pair_int2uint_int2uint((int)R2.Start.getPointer().$sub((abstract_iterator)LineStart), (int)R2.End.getPointer().$sub((abstract_iterator)LineStart)));
            }
            LineAndCol.$assignMove((Object)this.getLineAndColumn(new SMLoc(Loc), CurBuf));
        }
        return new SMDiagnostic(this, new SMLoc(Loc), new StringRef(BufferID), LineAndCol.first, LineAndCol.second - 1, Kind2, new StringRef(Msg.str()), new StringRef(LineStr), new ArrayRef<std_pair.pairUIntUInt>(ColRanges, false), new ArrayRef<SMFixIt>(FixIts));
    }

    public void PrintIncludeStack(SMLoc IncludeLoc, raw_ostream OS) {
        if (IncludeLoc.$eq(new SMLoc())) {
            return;
        }
        int CurBuf = this.FindBufferContainingLoc(new SMLoc(IncludeLoc));
        assert (CurBuf != 0) : "Invalid or unspecified location!";
        this.PrintIncludeStack(new SMLoc(this.getBufferInfo((int)CurBuf).IncludeLoc), OS);
        OS.$out("Included from ").$out(((MemoryBuffer)this.getBufferInfo((int)CurBuf).Buffer.$arrow()).getBufferIdentifier()).$out(NativePointer.$COLON).$out_uint(this.FindLineNumber(new SMLoc(IncludeLoc), CurBuf)).$out(NativePointer.$COLON_LF);
    }

    public String toString() {
        return "Buffers=" + this.Buffers + ", IncludeDirectories=" + this.IncludeDirectories + ", LineNoCache=" + NativeTrace.getIdentityStr((Object)this.LineNoCache) + ", DiagHandler=" + this.DiagHandler + ", DiagContext=" + NativeTrace.getIdentityStr((Object)this.DiagContext);
    }

    private static class SrcBuffer
    implements Destructors.ClassWithDestructor,
    Native.NativePOD<SrcBuffer> {
        public std_ptr.unique_ptr<MemoryBuffer> Buffer;
        public SMLoc IncludeLoc;

        public SrcBuffer() {
            this.Buffer = new std_ptr.unique_ptr();
            this.IncludeLoc = new SMLoc();
        }

        public SrcBuffer(JavaDifferentiators.JD.Move _dparam, SrcBuffer O) {
            this.Buffer = new std_ptr.unique_ptr(JavaDifferentiators.JD.Move.INSTANCE, (std_ptr.unique_ptr)std.move(O.Buffer));
            this.IncludeLoc = new SMLoc(O.IncludeLoc);
        }

        public void $destroy() {
            this.Buffer.$destroy();
        }

        public SrcBuffer $assign(SrcBuffer value) {
            this.Buffer = new std_ptr.unique_ptr(value.Buffer);
            this.IncludeLoc = new SMLoc(value.IncludeLoc);
            return this;
        }

        public SrcBuffer clone() {
            SrcBuffer res = new SrcBuffer();
            res.$assign(this);
            return res;
        }

        public String toString() {
            return "Buffer=" + this.Buffer + ", IncludeLoc=" + this.IncludeLoc;
        }
    }

    public static final class DiagKind
    extends Enum<DiagKind>
    implements Native.NativeUIntEnum {
        public static final /* enum */ DiagKind DK_Error = new DiagKind(0);
        public static final /* enum */ DiagKind DK_Warning = new DiagKind(DK_Error.getValue() + 1);
        public static final /* enum */ DiagKind DK_Note = new DiagKind(DK_Warning.getValue() + 1);
        private final int value;
        private static final /* synthetic */ DiagKind[] $VALUES;

        public static DiagKind[] values() {
            return (DiagKind[])$VALUES.clone();
        }

        public static DiagKind valueOf(String name) {
            return Enum.valueOf(DiagKind.class, name);
        }

        public static DiagKind valueOf(int val) {
            DiagKind out;
            DiagKind diagKind = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private DiagKind(int val) {
            this.value = val;
        }

        public final int getValue() {
            return this.value;
        }

        static {
            $VALUES = new DiagKind[]{DK_Error, DK_Warning, DK_Note};
        }

        private static final class Values {
            private static final DiagKind[] VALUES;
            private static final DiagKind[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (DiagKind kind : DiagKind.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new DiagKind[min < 0 ? 1 - min : 0];
                VALUES = new DiagKind[max >= 0 ? 1 + max : 0];
                for (DiagKind kind : DiagKind.values()) {
                    if (kind.value < 0) {
                        if (_VALUES[-kind.value] != null) continue;
                        Values._VALUES[-((DiagKind)kind).value] = kind;
                        continue;
                    }
                    if (VALUES[kind.value] != null) continue;
                    Values.VALUES[((DiagKind)kind).value] = kind;
                }
            }
        }
    }
}

