/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.char;
import org.clank.support.aliases.int;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.support.impl.RegexStatics;
import org.llvm.support.impl.regcompStatics;
import org.llvm.support.impl.regerrorStatics;
import org.llvm.support.impl.regexJava;
import org.llvm.support.impl.regexecStatics;
import org.llvm.support.impl.regfreeStatics;
import org.llvm.support.llvm;

public class Regex
implements Destructors.ClassWithDestructor,
Native.NativePOD<Regex> {
    public static final int NoFlags = 0;
    public static final int IgnoreCase = 1;
    public static final int Newline = 2;
    public static final int BasicRegex = 4;
    private regexJava.llvm_regex preg;
    private Pattern RegExpString;
    private int error;

    public Regex(StringRef regex) {
        this(regex, 0);
    }

    public Regex(StringRef regex, int Flags) {
        int flags = 0;
        this.preg = new regexJava.llvm_regex();
        this.preg.re_endp = Native.$tryClone((char.ptr)regex.end());
        if ((Flags & 1) != 0) {
            flags |= 2;
        }
        if ((Flags & 2) != 0) {
            flags |= 8;
        }
        if ((Flags & 4) == 0) {
            flags |= 1;
        }
        try {
            String s = regex.toJavaString();
            if (!(s.startsWith("(^)") || s.startsWith("^") || s.startsWith(".*") || s.isEmpty())) {
                s = ".*" + s;
            }
            if (!(s.endsWith("($)") || s.endsWith("$") || s.endsWith(".*") || s.isEmpty())) {
                s = s + ".*";
            }
            this.RegExpString = Pattern.compile(s);
            this.error = 0;
        }
        catch (Throwable e) {
            this.error = regcompStatics.llvm_regcomp(this.preg, regex.data(), flags | 0x20);
        }
    }

    public Regex(Regex $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    public Regex $assign(Regex regex) {
        regexJava.swap_llvm_regex(this.preg, regex.preg);
        std.swap((long)this.error, (long)regex.error);
        Pattern tmp = this.RegExpString;
        this.RegExpString = regex.RegExpString;
        regex.RegExpString = tmp;
        return this;
    }

    public Regex(JavaDifferentiators.JD.Move _dparam, Regex regex) {
        this.preg = regex.preg;
        this.error = regex.error;
        regex.preg = null;
        this.RegExpString = regex.RegExpString;
        regex.RegExpString = null;
    }

    public void $destroy() {
        if (this.preg != null) {
            regfreeStatics.llvm_regfree(this.preg);
            Destructors.$destroy((Object)this.preg);
        }
    }

    public boolean isValid(std.string Error2) {
        if (this.error == 0) {
            return true;
        }
        int len = regerrorStatics.llvm_regerror(this.error, this.preg, null, 0);
        Error2.resize(len - 1);
        regerrorStatics.llvm_regerror(this.error, this.preg, (char.ptr)Native.$AddrOf((Object)Error2.data()), len);
        return false;
    }

    public int getNumMatches() {
        return this.preg.re_nsub;
    }

    public boolean match(char.ptr str) {
        return this.match(new StringRef(str));
    }

    public boolean match(StringRef String2) {
        return this.match(String2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean match(StringRef String2, SmallVectorImpl<StringRef> Matches) {
        if (this.RegExpString != null) {
            Matcher matcher = this.RegExpString.matcher(String2.toJavaString());
            boolean res = matcher.matches();
            if (res && Matches != null) {
                Matches.clear();
                for (int i = 0; i <= matcher.groupCount(); ++i) {
                    Matches.push_back(new StringRef(matcher.group(i)));
                }
            }
            return res;
        }
        SmallVector<regexJava.llvm_regmatch_t> pm = null;
        try {
            int nmatch = Matches != null ? this.preg.re_nsub + 1 : 0;
            pm = new SmallVector<regexJava.llvm_regmatch_t>(8, new regexJava.llvm_regmatch_t());
            pm.resize(nmatch > 0 ? nmatch : 1);
            ((regexJava.llvm_regmatch_t)pm.$at((int)0)).rm_so = 0L;
            ((regexJava.llvm_regmatch_t)pm.$at((int)0)).rm_eo = String2.size();
            int rc = regexecStatics.llvm_regexec(this.preg, String2.data(), nmatch, pm.data(), 4);
            if (rc == 1) {
                boolean bl = false;
                return bl;
            }
            if (rc != 0) {
                this.error = rc;
                boolean bl = false;
                return bl;
            }
            if (Matches != null) {
                Matches.clear();
                for (int i = 0; i != nmatch; ++i) {
                    if (((regexJava.llvm_regmatch_t)pm.$at((int)i)).rm_so == -1L) {
                        Matches.push_back(new StringRef());
                        continue;
                    }
                    assert (((regexJava.llvm_regmatch_t)pm.$at((int)i)).rm_eo >= ((regexJava.llvm_regmatch_t)pm.$at((int)i)).rm_so);
                    Matches.push_back(new StringRef((char.ptr)String2.data().$add(Unsigned.$long2uint((long)((regexJava.llvm_regmatch_t)pm.$at((int)i)).rm_so)), Unsigned.$long2uint((long)(((regexJava.llvm_regmatch_t)pm.$at((int)i)).rm_eo - ((regexJava.llvm_regmatch_t)pm.$at((int)i)).rm_so))));
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (pm != null) {
                pm.$destroy();
            }
        }
    }

    public boolean find(char.ptr str) {
        return this.find(new StringRef(str));
    }

    public boolean find(StringRef String2) {
        Matcher matcher = this.RegExpString.matcher(String2.toJavaString());
        if (this.RegExpString.pattern().isEmpty()) {
            return false;
        }
        return matcher.find();
    }

    public std.string sub(StringRef Repl, StringRef String2) {
        return this.sub(Repl, String2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public std.string sub(StringRef Repl, StringRef String2, std.string Error2) {
        SmallVector<StringRef> Matches = null;
        std.string Res = null;
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            Matches = new SmallVector<StringRef>(8, new StringRef());
            if (Error2 != null && !Error2.empty()) {
                Error2.$assign(NativePointer.$((String)""));
            }
            if (!this.match(new StringRef(String2), (SmallVectorImpl)Native.$AddrOf(Matches))) {
                std.string string2 = String2.$string();
                return string2;
            }
            Res = new std.string((char.iterator)String2.begin(), (char.iterator)((StringRef)Matches.$at(0)).begin());
            block9: while (!Repl.empty()) {
                std_pair.pairTypeType<StringRef, StringRef> Split = Repl.split(NativePointer.$((char)'\\'));
                llvm.$addassign_str_StringRef(Res, new StringRef((StringRef)Split.first));
                if (((StringRef)Split.second).empty()) {
                    if (Repl.size() == ((StringRef)Split.first).size() || Error2 == null || !Error2.empty()) break;
                    Error2.$assign(NativePointer.$((String)"replacement string contained trailing backslash"));
                    break;
                }
                Repl.$assign((StringRef)Split.second);
                switch (Repl.$at(0)) {
                    default: {
                        Res.$addassign(Repl.$at(0));
                        Repl.$assignMove(Repl.substr(1));
                        continue block9;
                    }
                    case 116: {
                        Res.$addassign(NativePointer.$((char)'\t'));
                        Repl.$assignMove(Repl.substr(1));
                        continue block9;
                    }
                    case 110: {
                        Res.$addassign(NativePointer.$((char)'\n'));
                        Repl.$assignMove(Repl.substr(1));
                        continue block9;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                }
                StringRef Ref = Repl.slice(0, Repl.find_first_not_of(new StringRef(NativePointer.$((String)"0123456789"))));
                Repl.$assignMove(Repl.substr(Ref.size()));
                int.ref RefValue = NativePointer.create_int$ref();
                if (!Ref.getAsInteger(10, RefValue) && RefValue.$deref() < Matches.size()) {
                    llvm.$addassign_str_StringRef(Res, new StringRef((StringRef)Matches.$at(RefValue.$deref())));
                    continue;
                }
                if (Error2 == null || !Error2.empty()) continue;
                $c$.clean((Object)Error2.$assignMove((std.string)$c$.track((Object)std.$add_str_T((std.string)((std.string)$c$.track((Object)std.$add_T_str((Object)NativePointer.$((String)"invalid backreference string '"), (std.string)((std.string)$c$.track((Object)Ref.str()))))), (char.ptr)NativePointer.$((String)"'")))));
            }
            llvm.$addassign_str_StringRef(Res, new StringRef(((StringRef)Matches.$at(0)).end(), String2.end().$sub((abstract_iterator)((StringRef)Matches.$at(0)).end())));
            std.string string3 = new std.string(JavaDifferentiators.JD.Move.INSTANCE, Res);
            return string3;
        }
        finally {
            if (Res != null) {
                Res.$destroy();
            }
            if (Matches != null) {
                Matches.$destroy();
            }
            $c$.$destroy();
        }
    }

    public static boolean isLiteralERE(StringRef Str) {
        return Str.find_first_of(new StringRef(RegexStatics.RegexMetachars)) == StringRef.npos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static std.string escape(StringRef String2) {
        std.string RegexStr = null;
        try {
            RegexStr = new std.string();
            int e = String2.size();
            for (int i = 0; i != e; ++i) {
                if (std.strchr((char.ptr)RegexStatics.RegexMetachars, (byte)String2.$at(i)) != null) {
                    RegexStr.$addassign(NativePointer.$((char)'\\'));
                }
                RegexStr.$addassign(String2.$at(i));
            }
            std.string string2 = new std.string(JavaDifferentiators.JD.Move.INSTANCE, RegexStr);
            return string2;
        }
        finally {
            if (RegexStr != null) {
                RegexStr.$destroy();
            }
        }
    }

    public Regex() {
        this.RegExpString = null;
    }

    public Regex clone() {
        return new Regex(this);
    }

    public boolean $eq(Regex other) {
        return other != null && other.RegExpString.equals(this.RegExpString);
    }

    public String toString() {
        return "preg=" + this.preg + ", error=" + this.error;
    }
}

