/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support;

import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.llvm.support.OnDiskChainedHashTable;
import org.llvm.support.SpecificBumpPtrAllocator;
import org.llvm.support.endian.Writer;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;

public class OnDiskChainedHashTableGenerator<external_key_type, internal_key_type, data_type>
implements Destructors.ClassWithDestructor {
    private int NumBuckets = 64;
    private int NumEntries = 0;
    private SpecificBumpPtrAllocator<Item> BA;
    private final EmitInfoInterface<internal_key_type, data_type, ?> InfoObj;
    private Bucket<internal_key_type, data_type>[] Buckets = (Bucket[])NativePointer.new$T((Object[])new Bucket[this.NumBuckets], () -> new Bucket());

    private void insert(Bucket<internal_key_type, data_type>[] Buckets, int Size, Item<internal_key_type, data_type> E) {
        Bucket<internal_key_type, data_type> B = Buckets[E.Hash & Size - 1];
        E.Next = B.Head;
        ++B.Length;
        B.Head = E;
    }

    private void resize(int NewSize) {
        Bucket[] NewBuckets = (Bucket[])NativePointer.new$T((Object[])new Bucket[NewSize], () -> new Bucket());
        for (int I = 0; I < this.NumBuckets; ++I) {
            Item E = this.Buckets[I].Head;
            while (E != null) {
                Item N = E.Next;
                E.Next = null;
                this.insert(NewBuckets, NewSize, E);
                E = N;
            }
        }
        std.free(this.Buckets);
        this.NumBuckets = NewSize;
        this.Buckets = NewBuckets;
    }

    public void insert(internal_key_type Key, data_type Data) {
        this.insert(Key, Data, this.InfoObj);
    }

    public void insert(internal_key_type Key, data_type Data, OnDiskChainedHashTable.InfoInterface<?, internal_key_type, data_type> InfoObj) {
        assert (InfoObj != null);
        assert (InfoObj == this.InfoObj);
        ++this.NumEntries;
        if (4 * this.NumEntries >= 3 * this.NumBuckets) {
            this.resize(this.NumBuckets * 2);
        }
        this.insert(this.Buckets, this.NumBuckets, new Item<internal_key_type, data_type>(Key, Data, InfoObj));
    }

    public boolean contains(internal_key_type Key, OnDiskChainedHashTable.InfoInterface<?, internal_key_type, data_type> InfoObj) {
        int Hash = InfoObj.ComputeHash(Key);
        Item I = this.Buckets[Hash & this.NumBuckets - 1].Head;
        while (I != null) {
            if (I.Hash == Hash && InfoObj.EqualKey(I.Key, Key)) {
                return true;
            }
            I = I.Next;
        }
        return false;
    }

    public int Emit(raw_ostream Out) {
        return this.Emit(Out, this.InfoObj);
    }

    public int Emit(raw_ostream Out, EmitInfoInterface<internal_key_type, data_type, ?> InfoObj) {
        int TargetNumBuckets;
        Writer LE = new Writer(llvm.support.endianness.little, Out);
        int n = TargetNumBuckets = this.NumEntries <= 2 ? 1 : llvm.NextPowerOf2(this.NumEntries * 4 / 3);
        if (Native.$noteq((int)TargetNumBuckets, (int)this.NumBuckets)) {
            this.resize(TargetNumBuckets);
        }
        for (int I = 0; I < this.NumBuckets; ++I) {
            Bucket<internal_key_type, data_type> B = this.Buckets[I];
            if (B.Head == null) continue;
            B.Off = Unsigned.$long2uint((long)Out.tell());
            assert (Native.$bool((int)B.Off)) : "Cannot write a bucket at offset 0. Please add padding.";
            LE.write_uint16(B.Length);
            assert (Native.$bool((boolean)Native.$noteq((int)B.Length, (int)0))) : "Bucket has a head but zero length?";
            Item I$1 = B.Head;
            while (I$1 != null) {
                LE.write_uint32(I$1.Hash);
                long Len = InfoObj.EmitKeyDataLength$WrapPair(Out, I$1.Key, I$1.Data);
                if (NativeTrace.NDEBUG()) {
                    InfoObj.EmitKey(Out, I$1.Key, std_pair.$first_uint((long)Len));
                    InfoObj.EmitData(Out, I$1.Key, I$1.Data, std_pair.$second_uint((long)Len));
                } else {
                    long KeyStart = Out.tell();
                    InfoObj.EmitKey(Out, I$1.Key, std_pair.$first_uint((long)Len));
                    long DataStart = Out.tell();
                    InfoObj.EmitData(Out, I$1.Key, I$1.Data, std_pair.$second_uint((long)Len));
                    long End = Out.tell();
                    assert (Native.$bool((boolean)Native.$eq((long)(DataStart - KeyStart), (long)std_pair.$first_uint((long)Len)))) : "key length does not match bytes written";
                    assert (Native.$bool((boolean)Native.$eq((long)(End - DataStart), (long)std_pair.$second_uint((long)Len)))) : "data length does not match bytes written";
                }
                I$1 = I$1.Next;
            }
        }
        int TableOff = Unsigned.$long2uint((long)Out.tell());
        long N = llvm.OffsetToAlignment(TableOff, llvm.alignOf(Integer.TYPE));
        TableOff = (int)((long)TableOff + N);
        while (N-- != 0L) {
            LE.write_uint8(0);
        }
        LE.write_uint32(this.NumBuckets);
        LE.write_uint32(this.NumEntries);
        for (int I = 0; I < this.NumBuckets; ++I) {
            LE.write_uint32(this.Buckets[I].Off);
        }
        return TableOff;
    }

    public OnDiskChainedHashTableGenerator(EmitInfoInterface<internal_key_type, data_type, ?> InfoObj) {
        this.InfoObj = InfoObj;
    }

    public void $destroy() {
        std.free(this.Buckets);
    }

    public String toString() {
        return "NumBuckets=" + this.NumBuckets + ", NumEntries=" + this.NumEntries + ", BA=" + this.BA + ", Buckets=" + this.Buckets;
    }

    public static interface EmitInfoInterface<internal_key_type, data_type, file_type>
    extends OnDiskChainedHashTable.InfoInterface<Void, internal_key_type, data_type> {
        default public long EmitKeyDataLength$WrapPair(raw_ostream out, internal_key_type key, data_type data) {
            NativeTrace.assertTrueInConsole((boolean)false, (String)("Must be implemented in " + this.getClass() + " for faster writes and less memory allocations. Usually it's enough to change return type and wrap pair into long as here."));
            std_pair.pairUIntUInt ret = this.EmitKeyDataLength(out, key, data);
            return std_pair.wrap_uint_uint_pair((int)ret.first, (int)ret.second);
        }

        default public std_pair.pairUIntUInt EmitKeyDataLength(raw_ostream out, internal_key_type key, data_type data) {
            throw new UnsupportedOperationException("EmitKeyDataLength must be implemented:" + this.getClass() + ". Forgot to remove static?");
        }

        default public void EmitKey(raw_ostream out, internal_key_type key, int sizeof) {
            throw new UnsupportedOperationException("EmitKey must be implemented:" + this.getClass() + ". Forgot to remove static?");
        }

        default public void EmitData(raw_ostream out, internal_key_type key, data_type data, int sizeof) {
            throw new UnsupportedOperationException("EmitData must be implemented:" + this.getClass() + ". Forgot to remove static?");
        }

        default public void EmitFileRef(raw_ostream OutStream, file_type FileRef) {
            throw new UnsupportedOperationException("EmitFileRef must be implemented:" + this.getClass() + ". Forgot to remove static?");
        }

        @Override
        default public boolean EqualKey(internal_key_type a, internal_key_type b) {
            throw new UnsupportedOperationException("Should be implemented for EmitInfoInterface if 'contains' need to be supported " + this.getClass());
        }

        default public char.ptr strings_begin() {
            throw new UnsupportedOperationException("Should be implemented for EmitInfoInterface in " + this.getClass());
        }

        default public char.ptr strings_end() {
            throw new UnsupportedOperationException("Should be implemented for EmitInfoInterface in " + this.getClass());
        }

        default public void $destroy() {
            throw new UnsupportedOperationException("Should be implemented for EmitInfoInterface in " + this.getClass());
        }

        @Override
        default public data_type ReadData(internal_key_type key, char.ptr data, int OffsetInBuf, int len) {
            throw new UnsupportedOperationException("Not supported for EmitInfoInterface");
        }

        @Override
        default public data_type ReadData(internal_key_type key, char.ptr Buf, int DataLength) {
            throw new UnsupportedOperationException("Not supported for EmitInfoInterface");
        }

        @Override
        default public internal_key_type GetInternalKey(Void eKey) {
            throw new UnsupportedOperationException("Not supported for EmitInfoInterface");
        }

        @Override
        default public Void GetExternalKey(internal_key_type x) {
            throw new UnsupportedOperationException("Not supported for EmitInfoInterface");
        }

        @Override
        default public long ReadKeyDataLength(char.ptr d, int OffsetInBuf) {
            throw new UnsupportedOperationException("Not supported for EmitInfoInterface");
        }

        @Override
        default public int getReadKeyDataLengthBytes() {
            throw new UnsupportedOperationException("Not supported for EmitInfoInterface");
        }

        @Override
        default public std_pair.pairUIntUInt ReadKeyDataLength(char.ptr Buf) {
            throw new UnsupportedOperationException("Not supported for EmitInfoInterface");
        }

        @Override
        default public internal_key_type ReadKey(char.ptr d, int OffsetInBuf, int var) {
            throw new UnsupportedOperationException("Not supported for EmitInfoInterface");
        }

        @Override
        default public internal_key_type ReadKey(char.ptr Buf, int KeyLength) {
            throw new UnsupportedOperationException("Not supported for EmitInfoInterface");
        }

        @Override
        default public <file_type> file_type ReadFileRef(char.ptr Buf) {
            throw new UnsupportedOperationException("Not supported for EmitInfoInterface");
        }
    }

    private static final class Bucket<internal_key_type, data_type> {
        public int Off;
        public int Length;
        public Item<internal_key_type, data_type> Head;

        private Bucket() {
        }

        public String toString() {
            return "Off=" + this.Off + ", Length=" + this.Length + ", Head=" + this.Head;
        }
    }

    private static final class Item<internal_key_type, data_type> {
        public internal_key_type Key;
        public data_type Data;
        public Item<internal_key_type, data_type> Next;
        public int Hash;

        public Item(internal_key_type Key, data_type Data, OnDiskChainedHashTable.InfoInterface<?, internal_key_type, data_type> InfoObj) {
            this.Key = Key;
            this.Data = Data;
            this.Next = null;
            this.Hash = InfoObj.ComputeHash(Key);
        }

        public String toString() {
            return "Key=" + this.Key + ", Data=" + this.Data + ", Next=" + this.Next + ", Hash=" + this.Hash;
        }
    }
}

