/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support;

import org.clank.java.io;
import org.clank.java.std;
import org.clank.java.std_errors;
import org.clank.java.std_pair;
import org.clank.java.std_ptr;
import org.clank.java.std_time;
import org.clank.java.unistd;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeMoveable;
import org.clank.support.NativePointer;
import org.clank.support.aliases.int;
import org.llvm.adt.Optional;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.support.AdtsupportLlvmGlobals;
import org.llvm.support.ErrorOr;
import org.llvm.support.MemoryBuffer;
import org.llvm.support.impl.LockFileManagerStatics;
import org.llvm.support.impl.RemoveUniqueLockFileOnSignal;
import org.llvm.support.llvm;
import org.llvm.support.raw_fd_ostream;
import org.llvm.support.raw_string_ostream;
import org.llvm.support.sys.fs;
import org.llvm.support.sys.sys;

public class LockFileManager
implements Destructors.ClassWithDestructor {
    private SmallString FileName;
    private SmallString LockFileName;
    private SmallString UniqueLockFileName;
    private Optional<std_pair.pairTypeInt<std.string>> Owner;
    private Optional<std_errors.error_code> Error;
    private std.string ErrorDiagMsg;

    protected LockFileManager(LockFileManager $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    protected LockFileManager $assign(LockFileManager $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Optional<std_pair.pairTypeInt<std.string>> readLockFile(StringRef LockFileName) {
        ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> MBOrErr = null;
        try {
            MBOrErr = MemoryBuffer.getFile(new Twine(LockFileName));
            if (!MBOrErr.$bool()) {
                fs.remove(new Twine(LockFileName));
                Optional<std_pair.pairTypeInt<std.string>> optional = new Optional<std_pair.pairTypeInt<std.string>>(llvm.None);
                return optional;
            }
            MemoryBuffer MB = (MemoryBuffer)MBOrErr.get().$star();
            StringRef Hostname = new StringRef();
            StringRef PIDStr = new StringRef();
            std.tie((Object)Hostname, (Object)PIDStr).$assign(llvm.getToken(MB.getBuffer(), new StringRef(NativePointer.$SPACE)));
            PIDStr.$assignMove(PIDStr.substr(PIDStr.find_first_not_of(" ")));
            int.ref PID = NativePointer.create_int$ref();
            if (!PIDStr.getAsInteger$Signed(10, PID)) {
                std_pair.pairTypeInt Owner = std.make_pair_T_int((Object)((std.string)Native.$Move((NativeMoveable)Hostname.$string())), (int.ref)PID);
                if (LockFileManager.processStillExecuting(new StringRef((std.string)Owner.first), Owner.second)) {
                    Optional<std_pair.pairTypeInt<std.string>> optional = new Optional<std_pair.pairTypeInt<std.string>>(JavaDifferentiators.JD.T.RR.INSTANCE, Owner);
                    return optional;
                }
            }
            fs.remove(new Twine(LockFileName));
            Optional<std_pair.pairTypeInt<std.string>> optional = new Optional<std_pair.pairTypeInt<std.string>>(llvm.None);
            return optional;
        }
        finally {
            if (MBOrErr != null) {
                MBOrErr.$destroy();
            }
        }
    }

    private static boolean processStillExecuting(StringRef HostID, int PID) {
        SmallString StoredHostID = new SmallString(256);
        if (LockFileManagerStatics.getHostID(StoredHostID).$bool()) {
            return true;
        }
        return !llvm.$eq_StringRef(StoredHostID.$StringRef(), HostID) || unistd.getsid((int)PID) != -1 || io.errno() != 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LockFileManager(StringRef FileName) {
        this.FileName = new SmallString(128);
        this.LockFileName = new SmallString(128);
        this.UniqueLockFileName = new SmallString(128);
        this.Owner = new Optional();
        this.Error = new Optional();
        this.ErrorDiagMsg = new std.string();
        RemoveUniqueLockFileOnSignal RemoveUniqueFile = null;
        try {
            this.FileName.$assign(FileName);
            std_errors.error_code EC = fs.make_absolute(this.FileName);
            if (EC.$bool()) {
                std.string S2 = new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"failed to obtain absolute path for ");
                S2.append(this.FileName.str().$string());
                this.setError(EC, new StringRef(S2));
                return;
            }
            this.LockFileName.$assign(this.FileName);
            this.LockFileName.$addassign(".lock");
            if (this.Owner.$assignMove(LockFileManager.readLockFile(this.LockFileName.$StringRef())).$bool()) {
                return;
            }
            this.UniqueLockFileName.$assign(this.LockFileName);
            this.UniqueLockFileName.$addassign("-%%%%%%%%");
            int.ref UniqueLockFileID = NativePointer.create_int$ref();
            std_errors.error_code EC2 = fs.createUniqueFile(new Twine(this.UniqueLockFileName), UniqueLockFileID, this.UniqueLockFileName);
            if (EC2.$bool()) {
                std.string S3 = new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"failed to create unique file ");
                S3.append(this.UniqueLockFileName.str().$string());
                this.setError(EC2, new StringRef(S3));
                return;
            }
            raw_fd_ostream Out = null;
            try {
                SmallString HostID = new SmallString(256);
                std_errors.error_code EC3 = LockFileManagerStatics.getHostID(HostID);
                if (EC3.$bool()) {
                    this.setError(EC3, new StringRef("failed to get host id"));
                    return;
                }
                Out = new raw_fd_ostream(UniqueLockFileID.$deref(), true);
                Out.$out(HostID).$out_char((byte)32);
                Out.$out_int(unistd.getpid());
                Out.close();
                if (Out.has_error()) {
                    EC3 = AdtsupportLlvmGlobals.make_error_code(std_errors.errc.no_space_on_device);
                    std.string S4 = new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"failed to write to ");
                    S4.append(this.UniqueLockFileName.str().$string());
                    this.setError(EC3, new StringRef(S4));
                    fs.remove(new Twine(this.UniqueLockFileName));
                    return;
                }
            }
            finally {
                if (Out != null) {
                    Out.$destroy();
                }
            }
            RemoveUniqueFile = new RemoveUniqueLockFileOnSignal(this.UniqueLockFileName.$StringRef());
            do {
                if (!(EC2 = fs.create_link(new Twine(this.UniqueLockFileName), new Twine(this.LockFileName))).$bool()) {
                    RemoveUniqueFile.lockAcquired();
                    return;
                }
                if (io.$noteq_error_code$C((std_errors.error_code)EC2, (std_errors.error_code)new std_errors.error_code(std_errors.errc.file_exists))) {
                    raw_string_ostream OSS = null;
                    try {
                        std.string S5 = new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"failed to create link ");
                        OSS = new raw_string_ostream(S5);
                        OSS.$out(this.LockFileName.str()).$out(" to ").$out(this.UniqueLockFileName.str());
                        this.setError(EC2, new StringRef(OSS.str()));
                        return;
                    }
                    finally {
                        if (OSS != null) {
                            OSS.$destroy();
                        }
                    }
                }
                if (!this.Owner.$assignMove(LockFileManager.readLockFile(this.LockFileName.$StringRef())).$bool()) continue;
                fs.remove(new Twine(this.UniqueLockFileName));
                return;
            } while (!fs.exists(new Twine(this.LockFileName)) || !EC2.$assignMove(fs.remove(new Twine(this.LockFileName))).$bool());
            std.string S6 = new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"failed to remove lockfile ");
            S6.append(this.UniqueLockFileName.str().$string());
            this.setError(EC2, new StringRef(S6));
            return;
        }
        finally {
            if (RemoveUniqueFile != null) {
                RemoveUniqueFile.$destroy();
            }
        }
    }

    public void $destroy() {
        if (this.getState() != LockFileState.LFS_Owned) {
            return;
        }
        fs.remove(new Twine(this.LockFileName));
        fs.remove(new Twine(this.UniqueLockFileName));
        sys.DontRemoveFileOnSignal(this.UniqueLockFileName.$StringRef());
        this.ErrorDiagMsg.$destroy();
        this.Error.$destroy();
        this.Owner.$destroy();
        this.UniqueLockFileName.$destroy();
        this.LockFileName.$destroy();
        this.FileName.$destroy();
    }

    public LockFileState getState() {
        if (this.Owner.$bool()) {
            return LockFileState.LFS_Shared;
        }
        if (this.Error.$bool()) {
            return LockFileState.LFS_Error;
        }
        return LockFileState.LFS_Owned;
    }

    public LockFileState $LockFileState() {
        return this.getState();
    }

    public WaitForUnlockResult waitForUnlock() {
        if (this.getState() != LockFileState.LFS_Shared) {
            return WaitForUnlockResult.Res_Success;
        }
        std_time.timespec Interval = new std_time.timespec();
        Interval.tv_sec = 0L;
        Interval.tv_nsec = 1000000L;
        int MaxSeconds = 300;
        do {
            std_time.nanosleep((std_time.timespec)((std_time.timespec)Native.$AddrOf((Object)Interval)), (std_time.timespec)null);
            if (io.$eq_error_code$C((std_errors.error_code)fs.access(new Twine(this.LockFileName.c_str()), fs.AccessMode.Exist), (std_errors.error_code)new std_errors.error_code(std_errors.errc.no_such_file_or_directory))) {
                if (!fs.exists(new Twine(this.FileName))) {
                    return WaitForUnlockResult.Res_OwnerDied;
                }
                return WaitForUnlockResult.Res_Success;
            }
            if (!LockFileManager.processStillExecuting(new StringRef((std.string)this.Owner.$star().first), this.Owner.$star().second)) {
                return WaitForUnlockResult.Res_OwnerDied;
            }
            Interval.tv_sec *= 2L;
            Interval.tv_nsec *= 2L;
            if (Interval.tv_nsec < 1000000000L) continue;
            ++Interval.tv_sec;
            Interval.tv_nsec -= 1000000000L;
        } while (Interval.tv_sec < (long)MaxSeconds);
        return WaitForUnlockResult.Res_Timeout;
    }

    public std_errors.error_code unsafeRemoveLockFile() {
        return fs.remove(new Twine(this.LockFileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public std.string getErrorMessage() {
        if (this.Error.$bool()) {
            raw_string_ostream OSS = null;
            try {
                std.string Str = new std.string(this.ErrorDiagMsg);
                std.string ErrCodeMsg = this.Error.$arrow$Const().message();
                OSS = new raw_string_ostream(Str);
                if (!ErrCodeMsg.empty()) {
                    OSS.$out(": ").$out(this.Error.$arrow$Const().message());
                }
                OSS.flush();
                std.string string2 = Str;
                return string2;
            }
            finally {
                if (OSS != null) {
                    OSS.$destroy();
                }
            }
        }
        return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, NativePointer.$EMPTY);
    }

    public void setError(std_errors.error_code EC) {
        this.setError(EC, new StringRef(NativePointer.$EMPTY));
    }

    public void setError(std_errors.error_code EC, StringRef ErrorMsg) {
        this.Error.$assign_T$C$R(EC);
        this.ErrorDiagMsg.$assignMove(ErrorMsg.str());
    }

    public String toString() {
        return "FileName=" + this.FileName + ", LockFileName=" + this.LockFileName + ", UniqueLockFileName=" + this.UniqueLockFileName + ", Owner=" + this.Owner + ", Error=" + this.Error + ", ErrorDiagMsg=" + this.ErrorDiagMsg;
    }

    public static final class WaitForUnlockResult
    extends Enum<WaitForUnlockResult>
    implements Native.NativeUIntEnum {
        public static final /* enum */ WaitForUnlockResult Res_Success = new WaitForUnlockResult(0);
        public static final /* enum */ WaitForUnlockResult Res_OwnerDied = new WaitForUnlockResult(Res_Success.getValue() + 1);
        public static final /* enum */ WaitForUnlockResult Res_Timeout = new WaitForUnlockResult(Res_OwnerDied.getValue() + 1);
        private final int value;
        private static final /* synthetic */ WaitForUnlockResult[] $VALUES;

        public static WaitForUnlockResult[] values() {
            return (WaitForUnlockResult[])$VALUES.clone();
        }

        public static WaitForUnlockResult valueOf(String name) {
            return Enum.valueOf(WaitForUnlockResult.class, name);
        }

        public static WaitForUnlockResult valueOf(int val) {
            WaitForUnlockResult out;
            WaitForUnlockResult waitForUnlockResult = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private WaitForUnlockResult(int val) {
            this.value = val;
        }

        public final int getValue() {
            return this.value;
        }

        static {
            $VALUES = new WaitForUnlockResult[]{Res_Success, Res_OwnerDied, Res_Timeout};
        }

        private static final class Values {
            private static final WaitForUnlockResult[] VALUES;
            private static final WaitForUnlockResult[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (WaitForUnlockResult kind : WaitForUnlockResult.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new WaitForUnlockResult[min < 0 ? 1 - min : 0];
                VALUES = new WaitForUnlockResult[max >= 0 ? 1 + max : 0];
                for (WaitForUnlockResult kind : WaitForUnlockResult.values()) {
                    if (kind.value < 0) {
                        if (_VALUES[-kind.value] != null) continue;
                        Values._VALUES[-((WaitForUnlockResult)kind).value] = kind;
                        continue;
                    }
                    if (VALUES[kind.value] != null) continue;
                    Values.VALUES[((WaitForUnlockResult)kind).value] = kind;
                }
            }
        }
    }

    public static final class LockFileState
    extends Enum<LockFileState>
    implements Native.NativeUIntEnum {
        public static final /* enum */ LockFileState LFS_Owned = new LockFileState(0);
        public static final /* enum */ LockFileState LFS_Shared = new LockFileState(LFS_Owned.getValue() + 1);
        public static final /* enum */ LockFileState LFS_Error = new LockFileState(LFS_Shared.getValue() + 1);
        private final int value;
        private static final /* synthetic */ LockFileState[] $VALUES;

        public static LockFileState[] values() {
            return (LockFileState[])$VALUES.clone();
        }

        public static LockFileState valueOf(String name) {
            return Enum.valueOf(LockFileState.class, name);
        }

        public static LockFileState valueOf(int val) {
            LockFileState out;
            LockFileState lockFileState = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private LockFileState(int val) {
            this.value = val;
        }

        public final int getValue() {
            return this.value;
        }

        static {
            $VALUES = new LockFileState[]{LFS_Owned, LFS_Shared, LFS_Error};
        }

        private static final class Values {
            private static final LockFileState[] VALUES;
            private static final LockFileState[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (LockFileState kind : LockFileState.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new LockFileState[min < 0 ? 1 - min : 0];
                VALUES = new LockFileState[max >= 0 ? 1 + max : 0];
                for (LockFileState kind : LockFileState.values()) {
                    if (kind.value < 0) {
                        if (_VALUES[-kind.value] != null) continue;
                        Values._VALUES[-((LockFileState)kind).value] = kind;
                        continue;
                    }
                    if (VALUES[kind.value] != null) continue;
                    Values.VALUES[((LockFileState)kind).value] = kind;
                }
            }
        }
    }
}

