/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.java.std_ptr;
import org.clank.java.stdimpl.aliases.StdVector;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.JavaIterator;
import org.clank.support.aliases.type;
import org.llvm.adt.SmallPtrSet;
import org.llvm.adt.aliases.DenseMapInfo$LikePtr;

public class DomTreeNodeBase<NodeT>
implements Iterable<DomTreeNodeBase<NodeT>>,
Destructors.ClassWithDestructor {
    protected NodeT TheBB;
    protected DomTreeNodeBase<NodeT> IDom;
    public std.vector<DomTreeNodeBase<NodeT>> Children;
    public int DFSNumIn;
    public int DFSNumOut;

    public StdVector.iterator<DomTreeNodeBase<NodeT>> begin() {
        return this.Children.begin();
    }

    public StdVector.iterator<DomTreeNodeBase<NodeT>> end() {
        return this.Children.end();
    }

    public StdVector.iterator<DomTreeNodeBase<NodeT>> begin$Const() {
        return this.Children.begin$Const();
    }

    public StdVector.iterator<DomTreeNodeBase<NodeT>> end$Const() {
        return this.Children.end$Const();
    }

    public NodeT getBlock() {
        return this.TheBB;
    }

    public DomTreeNodeBase<NodeT> getIDom() {
        return this.IDom;
    }

    public std.vector<DomTreeNodeBase<NodeT>> getChildren() {
        return this.Children;
    }

    public DomTreeNodeBase(NodeT BB, DomTreeNodeBase<NodeT> iDom) {
        this.TheBB = BB;
        this.IDom = iDom;
        this.Children = new std.vector((Object)null);
        this.DFSNumIn = -1;
        this.DFSNumOut = -1;
    }

    public <T extends DomTreeNodeBase<NodeT>> std_ptr.unique_ptr<T> addChild(std_ptr.unique_ptr<T> C2) {
        this.Children.push_back_T$RR((Object)((DomTreeNodeBase)C2.get()));
        return new std_ptr.unique_ptr(JavaDifferentiators.JD.Move.INSTANCE, C2);
    }

    public int getNumChildren() {
        return this.Children.size();
    }

    public void clearAllChildren() {
        this.Children.clear();
    }

    public boolean compare(DomTreeNodeBase<NodeT> Other) {
        if (this.getNumChildren() != Other.getNumChildren()) {
            return true;
        }
        SmallPtrSet OtherChildren = new SmallPtrSet(DenseMapInfo$LikePtr.$Info(), 4);
        for (DomTreeNodeBase<NodeT> I : (DomTreeNodeBase)Native.$Deref(Other)) {
            NodeT Nd = I.getBlock();
            OtherChildren.insert(Nd);
        }
        for (DomTreeNodeBase<NodeT> I : this) {
            NodeT N = I.getBlock();
            if (OtherChildren.count(N) != 0) continue;
            return true;
        }
        return false;
    }

    public void setIDom(DomTreeNodeBase<NodeT> NewIDom) {
        assert (this.IDom != null) : "No immediate dominator?";
        if (this.IDom != NewIDom) {
            StdVector.iterator I = (StdVector.iterator)std.find((type.iterator)this.IDom.Children.begin(), (type.iterator)this.IDom.Children.end(), (Object)this, (boolean)true);
            assert (std.$noteq___normal_iterator$C((abstract_iterator)I, (abstract_iterator)this.IDom.Children.end())) : "Not in immediate dominator children set!";
            this.IDom.Children.erase(new StdVector.iterator(I));
            this.IDom = NewIDom;
            this.IDom.Children.push_back_T$RR((Object)this);
        }
    }

    public int getDFSNumIn() {
        return this.DFSNumIn;
    }

    public int getDFSNumOut() {
        return this.DFSNumOut;
    }

    public boolean DominatedBy(DomTreeNodeBase<NodeT> other) {
        return this.DFSNumIn >= other.DFSNumIn && this.DFSNumOut <= other.DFSNumOut;
    }

    public void $destroy() {
        this.Children.$destroy();
    }

    @Override
    public Iterator<DomTreeNodeBase<NodeT>> iterator() {
        return new JavaIterator(this.begin(), this.end());
    }

    public String toString() {
        return "TheBB=" + this.TheBB + ", IDom=" + this.IDom + ", Children=" + this.Children + ", DFSNumIn=" + this.DFSNumIn + ", DFSNumOut=" + this.DFSNumOut;
    }
}

