/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support;

import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.llvm.support.AdtsupportLlvmGlobals;
import org.llvm.support.raw_ostream;

public class BranchProbability
implements Native.NativeComparable<BranchProbability> {
    private int N;
    private static int D = Integer.MIN_VALUE;
    private static int UnknownN = -1;

    private BranchProbability(int n) {
        this.N = n;
    }

    public BranchProbability() {
        this.N = UnknownN;
    }

    public BranchProbability(int Numerator, int Denominator) {
        assert (Unsigned.$greater_uint((int)Denominator, (int)0)) : "Denominator cannot be 0!";
        assert (Unsigned.$lesseq_uint((int)Numerator, (int)Denominator)) : "Probability cannot be bigger than 1!";
        if (Denominator == D) {
            this.N = Numerator;
        } else {
            long Prob64 = Unsigned.$div_ullong_uint((long)(Unsigned.$uint2ullong((int)Numerator) * Unsigned.$uint2ulong((int)D) + Unsigned.$uint2ullong((int)Unsigned.$div_uint((int)Denominator, (int)2))), (int)Denominator);
            this.N = Unsigned.$ulong2uint((long)Prob64);
        }
    }

    public boolean isZero() {
        return this.N == 0;
    }

    public boolean isUnknown() {
        return this.N == UnknownN;
    }

    public static BranchProbability getZero() {
        return new BranchProbability(0);
    }

    public static BranchProbability getOne() {
        return new BranchProbability(D);
    }

    public static BranchProbability getUnknown() {
        return new BranchProbability(UnknownN);
    }

    public static BranchProbability getRaw(int N) {
        return new BranchProbability(N);
    }

    public static BranchProbability getBranchProbability(long Numerator, long Denominator) {
        assert (Unsigned.$lesseq_ulong((long)Numerator, (long)Denominator)) : "Probability cannot be bigger than 1!";
        int Scale = 0;
        while (Unsigned.$greater_ulong_uint((long)Denominator, (int)-1)) {
            Denominator >>>= 1;
            ++Scale;
        }
        return new BranchProbability(Unsigned.$ulong2uint((long)(Numerator >>> Scale)), Unsigned.$ulong2uint((long)Denominator));
    }

    public static <ProbabilityIter> void normalizeProbabilities(ProbabilityIter Begin, ProbabilityIter End) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public int getNumerator() {
        return this.N;
    }

    public static int getDenominator() {
        return D;
    }

    public BranchProbability getCompl() {
        return new BranchProbability(D - this.N);
    }

    public raw_ostream print(raw_ostream OS) {
        if (this.isUnknown()) {
            return OS.$out("?%");
        }
        double Percent = Math.rint((double)this.N / (double)D * 100.0 * 100.0) / 100.0;
        return OS.$out(AdtsupportLlvmGlobals.format(NativePointer.$((String)"0x%08x / 0x%08x = %.2f%%"), this.N, D, Percent));
    }

    public void dump() {
        this.print(AdtsupportLlvmGlobals.dbgs()).$out_char((byte)10);
    }

    public long scale(long Num) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public long scaleByInverse(long Num) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public BranchProbability $addassign(BranchProbability RHS) {
        assert (this.N != UnknownN && RHS.N != UnknownN) : "Unknown probability cannot participate in arithmetics.";
        this.N = Unsigned.$greater_ulong_int$C((long)(Unsigned.$uint2ulong((int)this.N) + Unsigned.$uint2ullong((int)RHS.N)), (int)D) ? D : this.N + RHS.N;
        return this;
    }

    public BranchProbability $minusassign(BranchProbability RHS) {
        assert (this.N != UnknownN && RHS.N != UnknownN) : "Unknown probability cannot participate in arithmetics.";
        this.N = Unsigned.$less_uint((int)this.N, (int)RHS.N) ? 0 : this.N - RHS.N;
        return this;
    }

    public BranchProbability $starassign(BranchProbability RHS) {
        assert (this.N != UnknownN && RHS.N != UnknownN) : "Unknown probability cannot participate in arithmetics.";
        this.N = Unsigned.$ullong2uint((long)Unsigned.$div_ullong_int((long)(Unsigned.$uint2ulong((int)this.N) * Unsigned.$uint2ullong((int)RHS.N) + Unsigned.$uint2ullong((int)Unsigned.$div_uint((int)D, (int)2))), (int)D));
        return this;
    }

    public BranchProbability $slashassign(int RHS) {
        assert (this.N != UnknownN) : "Unknown probability cannot participate in arithmetics.";
        assert (Unsigned.$greater_uint((int)RHS, (int)0)) : "The divider cannot be zero.";
        this.N = Unsigned.$div_uint((int)this.N, (int)RHS);
        return this;
    }

    public BranchProbability $add(BranchProbability RHS) {
        BranchProbability Prob = new BranchProbability(this);
        return new BranchProbability(Prob.$addassign(RHS));
    }

    public BranchProbability $sub(BranchProbability RHS) {
        BranchProbability Prob = new BranchProbability(this);
        return new BranchProbability(Prob.$minusassign(RHS));
    }

    public BranchProbability $star(BranchProbability RHS) {
        BranchProbability Prob = new BranchProbability(this);
        return new BranchProbability(Prob.$starassign(RHS));
    }

    public BranchProbability $slash(int RHS) {
        BranchProbability Prob = new BranchProbability(this);
        return new BranchProbability(Prob.$slashassign(RHS));
    }

    public boolean $eq(BranchProbability RHS) {
        return this.N == RHS.N;
    }

    public boolean $noteq(BranchProbability RHS) {
        return !this.$eq(RHS);
    }

    public boolean $less(BranchProbability RHS) {
        assert (this.N != UnknownN && RHS.N != UnknownN) : "Unknown probability cannot participate in comparisons.";
        return Unsigned.$less_uint((int)this.N, (int)RHS.N);
    }

    public boolean $greater(BranchProbability RHS) {
        assert (this.N != UnknownN && RHS.N != UnknownN) : "Unknown probability cannot participate in comparisons.";
        return RHS.$less(this);
    }

    public boolean $lesseq(BranchProbability RHS) {
        assert (this.N != UnknownN && RHS.N != UnknownN) : "Unknown probability cannot participate in comparisons.";
        return !RHS.$less(this);
    }

    public boolean $greatereq(BranchProbability RHS) {
        assert (this.N != UnknownN && RHS.N != UnknownN) : "Unknown probability cannot participate in comparisons.";
        return !this.$less(RHS);
    }

    public BranchProbability(BranchProbability $Prm0) {
        this.N = $Prm0.N;
    }

    public BranchProbability(JavaDifferentiators.JD.Move _dparam, BranchProbability $Prm0) {
        this.N = $Prm0.N;
    }

    public BranchProbability $assign(BranchProbability $Prm0) {
        this.N = $Prm0.N;
        return this;
    }

    public BranchProbability $assignMove(BranchProbability $Prm0) {
        this.N = $Prm0.N;
        return this;
    }

    public String toString() {
        return "N=" + this.N;
    }
}

