/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.mc;

import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.uint;
import org.llvm.adt.StringRef;
import org.llvm.mc.MCAsmInfo;
import org.llvm.mc.MCExpr;
import org.llvm.mc.MCSection;
import org.llvm.mc.MCSymbol;
import org.llvm.mc.SectionKind;
import org.llvm.support.COFF;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;

public final class MCSectionCOFF
extends MCSection
implements Destructors.ClassWithDestructor {
    private StringRef SectionName;
    private int Characteristics;
    private int WinCFISectionID;
    private MCSymbol COMDATSymbol;
    private int Selection;

    public MCSectionCOFF(StringRef Section, int Characteristics2, MCSymbol COMDATSymbol, int Selection, SectionKind K, MCSymbol Begin) {
        super(MCSection.SectionVariant.SV_COFF, new SectionKind(K), Begin);
        this.SectionName = new StringRef(Section);
        this.Characteristics = Characteristics2;
        this.WinCFISectionID = -1;
        this.COMDATSymbol = COMDATSymbol;
        this.Selection = Selection;
        assert ((Characteristics2 & 0xF00000) == 0) : "alignment must not be set upon section creation";
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    public boolean ShouldOmitSectionDirective(StringRef Name2, MCAsmInfo MAI) {
        if (this.COMDATSymbol != null) {
            return false;
        }
        return llvm.$eq_StringRef(Name2, ".text") || llvm.$eq_StringRef(Name2, ".data") || llvm.$eq_StringRef(Name2, ".bss");
    }

    public StringRef getSectionName() {
        return new StringRef(this.SectionName);
    }

    public int getCharacteristics() {
        return this.Characteristics;
    }

    public MCSymbol getCOMDATSymbol() {
        return this.COMDATSymbol;
    }

    public int getSelection() {
        return this.Selection;
    }

    public void setSelection(int Selection) {
        assert (Selection != 0) : "invalid COMDAT selection type";
        this.Selection = Selection;
        this.Characteristics |= 0x1000;
    }

    @Override
    public void PrintSwitchToSection(MCAsmInfo MAI, raw_ostream OS, MCExpr Subsection) {
        if (this.ShouldOmitSectionDirective(new StringRef(this.SectionName), MAI)) {
            OS.$out_char((byte)9).$out(this.getSectionName()).$out_char((byte)10);
            return;
        }
        OS.$out("\t.section\t").$out(this.getSectionName()).$out(",\"");
        if ((this.getCharacteristics() & 0x40) != 0) {
            OS.$out_char((byte)100);
        }
        if ((this.getCharacteristics() & 0x80) != 0) {
            OS.$out_char((byte)98);
        }
        if ((this.getCharacteristics() & 0x20000000) != 0) {
            OS.$out_char((byte)120);
        }
        if ((this.getCharacteristics() & Integer.MIN_VALUE) != 0) {
            OS.$out_char((byte)119);
        } else if ((this.getCharacteristics() & 0x40000000) != 0) {
            OS.$out_char((byte)114);
        } else {
            OS.$out_char((byte)121);
        }
        if ((this.getCharacteristics() & 0x800) != 0) {
            OS.$out_char((byte)110);
        }
        if ((this.getCharacteristics() & 0x10000000) != 0) {
            OS.$out_char((byte)115);
        }
        OS.$out_char((byte)34);
        if ((this.getCharacteristics() & 0x1000) != 0) {
            OS.$out(NativePointer.$COMMA);
            switch (COFF.COMDATType.valueOf(this.Selection)) {
                case IMAGE_COMDAT_SELECT_NODUPLICATES: {
                    OS.$out("one_only,");
                    break;
                }
                case IMAGE_COMDAT_SELECT_ANY: {
                    OS.$out("discard,");
                    break;
                }
                case IMAGE_COMDAT_SELECT_SAME_SIZE: {
                    OS.$out("same_size,");
                    break;
                }
                case IMAGE_COMDAT_SELECT_EXACT_MATCH: {
                    OS.$out("same_contents,");
                    break;
                }
                case IMAGE_COMDAT_SELECT_ASSOCIATIVE: {
                    OS.$out("associative,");
                    break;
                }
                case IMAGE_COMDAT_SELECT_LARGEST: {
                    OS.$out("largest,");
                    break;
                }
                case IMAGE_COMDAT_SELECT_NEWEST: {
                    OS.$out("newest,");
                    break;
                }
                default: {
                    assert (false) : "unsupported COFF selection type";
                    break;
                }
            }
            assert (Native.$bool((Object)this.COMDATSymbol));
            this.COMDATSymbol.print(OS, (MCAsmInfo)Native.$AddrOf((Object)MAI));
        }
        OS.$out_char((byte)10);
    }

    @Override
    public boolean UseCodeAlign() {
        return this.getKind().isText();
    }

    @Override
    public boolean isVirtualSection() {
        return (this.getCharacteristics() & 0x80) != 0;
    }

    public int getOrAssignWinCFISectionID(uint.ptr NextID) {
        if (this.WinCFISectionID == -1) {
            this.WinCFISectionID = NextID.$set$postInc(0);
        }
        return this.WinCFISectionID;
    }

    public static boolean classof(MCSection S2) {
        return S2.getVariant() == MCSection.SectionVariant.SV_COFF;
    }

    @Override
    public String toString() {
        return "SectionName=" + this.SectionName + ", Characteristics=" + this.Characteristics + ", WinCFISectionID=" + this.WinCFISectionID + ", COMDATSymbol=" + this.COMDATSymbol + ", Selection=" + this.Selection + super.toString();
    }
}

