/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.mc;

import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.clank.support.aliases.long;
import org.llvm.adt.ADTAliases;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.ArrayRefUInt;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.ilist_iterator;
import org.llvm.adt.java.ADTRTTI;
import org.llvm.mc.MCAlignFragment;
import org.llvm.mc.MCAsmBackend;
import org.llvm.mc.MCAssembler;
import org.llvm.mc.MCCVLineEntry;
import org.llvm.mc.MCCodeEmitter;
import org.llvm.mc.MCContext;
import org.llvm.mc.MCDataFragment;
import org.llvm.mc.MCDwarfCallFrameFragment;
import org.llvm.mc.MCDwarfFrameEmitter;
import org.llvm.mc.MCDwarfFrameInfo;
import org.llvm.mc.MCDwarfLineAddr;
import org.llvm.mc.MCDwarfLineAddrFragment;
import org.llvm.mc.MCDwarfLineEntry;
import org.llvm.mc.MCDwarfLineTable;
import org.llvm.mc.MCExpr;
import org.llvm.mc.MCFillFragment;
import org.llvm.mc.MCFixup;
import org.llvm.mc.MCFragment;
import org.llvm.mc.MCGenDwarfInfo;
import org.llvm.mc.MCInst;
import org.llvm.mc.MCLEBFragment;
import org.llvm.mc.MCObjectWriter;
import org.llvm.mc.MCOrgFragment;
import org.llvm.mc.MCRelaxableFragment;
import org.llvm.mc.MCSection;
import org.llvm.mc.MCStreamer;
import org.llvm.mc.MCSubtargetInfo;
import org.llvm.mc.MCSymbol;
import org.llvm.mc.MCSymbolRefExpr;
import org.llvm.mc.ilist_traitsMCFragment;
import org.llvm.mc.impl.MCObjectStreamerStatics;
import org.llvm.support.SMLoc;
import org.llvm.support.SourceMgr;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.raw_pwrite_stream;
import org.llvm.support.raw_svector_ostream;

public abstract class MCObjectStreamer
extends MCStreamer
implements Destructors.ClassWithDestructor {
    private MCAssembler Assembler;
    private ilist_iterator<MCFragment> CurInsertionPoint;
    private boolean EmitEHFrame;
    private boolean EmitDebugFrame;
    private SmallVector<MCSymbol> PendingLabels;

    protected abstract void EmitInstToData(MCInst var1, MCSubtargetInfo var2);

    @Override
    protected void EmitCFIStartProcImpl(MCDwarfFrameInfo Frame) {
        Frame.Begin = this.getContext().createTempSymbol();
        this.EmitLabel(Frame.Begin);
    }

    @Override
    protected void EmitCFIEndProcImpl(MCDwarfFrameInfo Frame) {
        Frame.End = this.getContext().createTempSymbol();
        this.EmitLabel(Frame.End);
    }

    protected MCObjectStreamer(MCContext Context, MCAsmBackend TAB, raw_pwrite_stream OS, MCCodeEmitter Emitter_) {
        super(Context);
        this.Assembler = new MCAssembler(Context, TAB, (MCCodeEmitter)Native.$Deref((Object)Emitter_), (MCObjectWriter)Native.$Deref((Object)TAB.createObjectWriter(OS)));
        this.CurInsertionPoint = new ilist_iterator<MCFragment>(ilist_traitsMCFragment.$instance());
        this.EmitEHFrame = true;
        this.EmitDebugFrame = false;
        this.PendingLabels = new SmallVector<MCSymbol>(2, (MCSymbol)null);
    }

    @Override
    public void $destroy() {
        if (Native.$AddrOf((Object)this.Assembler.getBackend()) != null) {
            ((MCAsmBackend)Native.$AddrOf((Object)this.Assembler.getBackend())).$destroy();
        }
        if (Native.$AddrOf((Object)this.Assembler.getEmitter()) != null) {
            ((MCCodeEmitter)Native.$AddrOf((Object)this.Assembler.getEmitter())).$destroy();
        }
        if (Native.$AddrOf((Object)this.Assembler.getWriter()) != null) {
            ((MCObjectWriter)Native.$AddrOf((Object)this.Assembler.getWriter())).$destroy();
        }
        if (this.Assembler != null) {
            this.Assembler.$destroy();
        }
        this.PendingLabels.$destroy();
        super.$destroy();
    }

    @Override
    public void reset() {
        if (this.Assembler != null) {
            this.Assembler.reset();
        }
        this.CurInsertionPoint.$assignMove(new ilist_iterator<MCFragment>(ilist_traitsMCFragment.$instance()));
        this.EmitEHFrame = true;
        this.EmitDebugFrame = false;
        this.PendingLabels.clear();
        super.reset();
    }

    @Override
    public boolean isIntegratedAssemblerRequired() {
        return true;
    }

    public void EmitFrames(MCAsmBackend MAB) {
        if (this.getNumFrameInfos() == 0) {
            return;
        }
        if (this.EmitEHFrame) {
            MCDwarfFrameEmitter.Emit(this, MAB, true);
        }
        if (this.EmitDebugFrame) {
            MCDwarfFrameEmitter.Emit(this, MAB, false);
        }
    }

    @Override
    public void EmitCFISections(boolean EH, boolean Debug) {
        super.EmitCFISections(EH, Debug);
        this.EmitEHFrame = EH;
        this.EmitDebugFrame = Debug;
    }

    public MCFragment getCurrentFragment() {
        assert (this.getCurrentSectionOnly() != null) : "No current section!";
        if (this.CurInsertionPoint.$noteq(this.getCurrentSectionOnly().getFragmentList().begin())) {
            return (MCFragment)Native.$AddrOf((Object)((MCFragment)((ilist_iterator)std.prev(new ilist_iterator<MCFragment>(this.CurInsertionPoint))).$star()));
        }
        return null;
    }

    public void insert(MCFragment F) {
        this.flushPendingLabels(F);
        MCSection CurSection = this.getCurrentSectionOnly();
        CurSection.getFragmentList().insert_ilist_iterator$NodeTy_T$P(new ilist_iterator<MCFragment>(this.CurInsertionPoint), F);
        F.setParent(CurSection);
    }

    public MCDataFragment getOrCreateDataFragment() {
        MCDataFragment F = ADTRTTI.dyn_cast_or_null_MCDataFragment(this.getCurrentFragment());
        if (F == null || this.Assembler.isBundlingEnabled() && !this.Assembler.getRelaxAll() && F.hasInstructions()) {
            F = new MCDataFragment();
            this.insert(F);
        }
        return F;
    }

    protected boolean changeSectionImpl(MCSection Section, MCExpr Subsection) {
        assert (Section != null) : "Cannot switch to a null section!";
        this.flushPendingLabels(null);
        boolean Created = this.getAssembler().registerSection((MCSection)Native.$Deref((Object)Section));
        long.ref IntSubsection = NativePointer.create_long$ref((long)0L);
        if (Subsection != null && !Subsection.evaluateAsAbsolute(IntSubsection, this.getAssembler())) {
            llvm.report_fatal_error(NativePointer.$((String)"Cannot evaluate subsection number"));
        }
        if (IntSubsection.$deref() < 0L || IntSubsection.$deref() > 8192L) {
            llvm.report_fatal_error(NativePointer.$((String)"Subsection number out of range"));
        }
        this.CurInsertionPoint.$assignMove(Section.getSubsectionInsertionPoint(Unsigned.$long2uint((long)IntSubsection.$deref())));
        return Created;
    }

    protected void flushPendingLabels(MCFragment F) {
        this.flushPendingLabels(F, Unsigned.$int2ulong((int)0));
    }

    protected void flushPendingLabels(MCFragment F, long FOffset) {
        if (this.PendingLabels.empty()) {
            return;
        }
        if (F == null) {
            F = new MCDataFragment();
            MCSection CurSection = this.getCurrentSectionOnly();
            CurSection.getFragmentList().insert_ilist_iterator$NodeTy_T$P(new ilist_iterator<MCFragment>(this.CurInsertionPoint), F);
            F.setParent(CurSection);
        }
        for (MCSymbol Sym : this.PendingLabels) {
            Sym.setFragment(F);
            Sym.setOffset(FOffset);
        }
        this.PendingLabels.clear();
    }

    @Override
    public void visitUsedSymbol(MCSymbol Sym) {
        this.Assembler.registerSymbol(Sym);
    }

    public MCAssembler getAssembler() {
        return (MCAssembler)Native.$Deref((Object)this.Assembler);
    }

    @Override
    public void EmitLabel(MCSymbol Symbol) {
        super.EmitLabel(Symbol);
        this.getAssembler().registerSymbol((MCSymbol)Native.$Deref((Object)Symbol));
        MCDataFragment F = ADTRTTI.dyn_cast_or_null_MCDataFragment(this.getCurrentFragment());
        if (!(F == null || this.getAssembler().isBundlingEnabled() && this.getAssembler().getRelaxAll())) {
            Symbol.setFragment(F);
            Symbol.setOffset(Unsigned.$uint2ulong((int)F.getContents().size()));
        } else {
            this.PendingLabels.push_back(Symbol);
        }
    }

    @Override
    public void EmitAssignment(MCSymbol Symbol, MCExpr Value) {
        this.getAssembler().registerSymbol((MCSymbol)Native.$Deref((Object)Symbol));
        super.EmitAssignment(Symbol, Value);
    }

    @Override
    public void EmitValueImpl(MCExpr Value, int Size) {
        this.EmitValueImpl(Value, Size, new SMLoc());
    }

    @Override
    public void EmitValueImpl(MCExpr Value, int Size, SMLoc Loc) {
        super.EmitValueImpl(Value, Size, new SMLoc(Loc));
        MCDataFragment DF = this.getOrCreateDataFragment();
        this.flushPendingLabels(DF, Unsigned.$uint2ulong((int)DF.getContents().size()));
        MCCVLineEntry.Make(this);
        MCDwarfLineEntry.Make(this, (MCSection)this.getCurrentSection().first);
        long.ref AbsValue = NativePointer.create_long$ref();
        if (Value.evaluateAsAbsolute(AbsValue, this.getAssembler())) {
            this.EmitIntValue(AbsValue.$deref(), Size);
            return;
        }
        DF.getFixups().push_back(MCFixup.create(DF.getContents().size(), Value, MCFixup.getKindForSize(Size, false), new SMLoc(Loc)));
        DF.getContents().resize(DF.getContents().size() + Size, (byte)0);
    }

    @Override
    public void EmitULEB128Value(MCExpr Value) {
        long.ref IntValue = NativePointer.create_long$ref();
        if (Value.evaluateAsAbsolute(IntValue, this.getAssembler())) {
            this.EmitULEB128IntValue(IntValue.$deref());
            return;
        }
        this.insert(new MCLEBFragment((MCExpr)Native.$Deref((Object)Value), false));
    }

    @Override
    public void EmitSLEB128Value(MCExpr Value) {
        long.ref IntValue = NativePointer.create_long$ref();
        if (Value.evaluateAsAbsolute(IntValue, this.getAssembler())) {
            this.EmitSLEB128IntValue(IntValue.$deref());
            return;
        }
        this.insert(new MCLEBFragment((MCExpr)Native.$Deref((Object)Value), true));
    }

    @Override
    public void EmitWeakReference(MCSymbol Alias, MCSymbol Symbol) {
        llvm.report_fatal_error(NativePointer.$((String)"This file format doesn't support weak aliases."));
    }

    @Override
    public void ChangeSection(MCSection Section, MCExpr Subsection) {
        this.changeSectionImpl(Section, Subsection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void EmitInstruction(MCInst Inst, MCSubtargetInfo STI) {
        super.EmitInstruction(Inst, STI);
        MCSection Sec = this.getCurrentSectionOnly();
        Sec.setHasInstructions(true);
        MCCVLineEntry.Make(this);
        MCDwarfLineEntry.Make(this, (MCSection)this.getCurrentSection().first);
        MCAssembler Assembler = this.getAssembler();
        if (!Assembler.getBackend().mayNeedRelaxation(Inst)) {
            this.EmitInstToData(Inst, STI);
            return;
        }
        if (Assembler.getRelaxAll() || Assembler.isBundlingEnabled() && Sec.isBundleLocked()) {
            MCInst Relaxed = null;
            try {
                Relaxed = new MCInst();
                this.getAssembler().getBackend().relaxInstruction(Inst, STI, Relaxed);
                while (this.getAssembler().getBackend().mayNeedRelaxation(Relaxed)) {
                    this.getAssembler().getBackend().relaxInstruction(Relaxed, STI, Relaxed);
                }
                this.EmitInstToData(Relaxed, STI);
                return;
            }
            finally {
                if (Relaxed != null) {
                    Relaxed.$destroy();
                }
            }
        }
        this.EmitInstToFragment(Inst, STI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void EmitInstToFragment(MCInst Inst, MCSubtargetInfo STI) {
        raw_svector_ostream VecOS = null;
        try {
            if (this.getAssembler().getRelaxAll() && this.getAssembler().isBundlingEnabled()) {
                throw new llvm_unreachable("All instructions should have already been relaxed");
            }
            MCRelaxableFragment IF = new MCRelaxableFragment(Inst, STI);
            this.insert(IF);
            SmallString Code = new SmallString(128);
            VecOS = new raw_svector_ostream(Code);
            this.getAssembler().getEmitter().encodeInstruction(Inst, VecOS, IF.getFixups(), STI);
            IF.getContents().append_T((char.iterator<?>)Code.begin(), (char.iterator<?>)Code.end());
        }
        finally {
            if (VecOS != null) {
                VecOS.$destroy();
            }
        }
    }

    @Override
    public void EmitBundleAlignMode(int AlignPow2) {
        throw new llvm_unreachable(Native.$toString((char.ptr)MCObjectStreamerStatics.BundlingNotImplementedMsg));
    }

    @Override
    public void EmitBundleLock(boolean AlignToEnd) {
        throw new llvm_unreachable(Native.$toString((char.ptr)MCObjectStreamerStatics.BundlingNotImplementedMsg));
    }

    @Override
    public void EmitBundleUnlock() {
        throw new llvm_unreachable(Native.$toString((char.ptr)MCObjectStreamerStatics.BundlingNotImplementedMsg));
    }

    @Override
    public void EmitBytes(StringRef Data) {
        MCCVLineEntry.Make(this);
        MCDwarfLineEntry.Make(this, (MCSection)this.getCurrentSection().first);
        MCDataFragment DF = this.getOrCreateDataFragment();
        this.flushPendingLabels(DF, Unsigned.$uint2ulong((int)DF.getContents().size()));
        DF.getContents().append_T((char.iterator<?>)Data.begin(), (char.iterator<?>)Data.end());
    }

    @Override
    public void EmitValueToAlignment(int ByteAlignment) {
        this.EmitValueToAlignment(ByteAlignment, 0L, 1, 0);
    }

    @Override
    public void EmitValueToAlignment(int ByteAlignment, long Value) {
        this.EmitValueToAlignment(ByteAlignment, Value, 1, 0);
    }

    @Override
    public void EmitValueToAlignment(int ByteAlignment, long Value, int ValueSize) {
        this.EmitValueToAlignment(ByteAlignment, Value, ValueSize, 0);
    }

    @Override
    public void EmitValueToAlignment(int ByteAlignment, long Value, int ValueSize, int MaxBytesToEmit) {
        if (MaxBytesToEmit == 0) {
            MaxBytesToEmit = ByteAlignment;
        }
        this.insert(new MCAlignFragment(ByteAlignment, Value, ValueSize, MaxBytesToEmit));
        MCSection CurSec = (MCSection)this.getCurrentSection().first;
        if (Unsigned.$greater_uint((int)ByteAlignment, (int)CurSec.getAlignment())) {
            CurSec.setAlignment(ByteAlignment);
        }
    }

    @Override
    public void EmitCodeAlignment(int ByteAlignment) {
        this.EmitCodeAlignment(ByteAlignment, 0);
    }

    @Override
    public void EmitCodeAlignment(int ByteAlignment, int MaxBytesToEmit) {
        this.EmitValueToAlignment(ByteAlignment, 0L, 1, MaxBytesToEmit);
        ADTRTTI.cast_MCAlignFragment(this.getCurrentFragment()).setEmitNops(true);
    }

    @Override
    public void emitValueToOffset(MCExpr Offset, byte Value) {
        this.insert(new MCOrgFragment((MCExpr)Native.$Deref((Object)Offset), Value));
    }

    @Override
    public void EmitDwarfLocDirective(int FileNo, int Line, int Column, int Flags, int Isa, int Discriminator, StringRef FileName) {
        MCDwarfLineEntry.Make(this, (MCSection)this.getCurrentSection().first);
        super.EmitDwarfLocDirective(FileNo, Line, Column, Flags, Isa, Discriminator, new StringRef(FileName));
    }

    public void EmitDwarfAdvanceLineAddr(long LineDelta, MCSymbol LastLabel, MCSymbol Label, int PointerSize) {
        long.ref Res;
        if (LastLabel == null) {
            MCObjectStreamerStatics.emitDwarfSetLineAddr(this, this.Assembler.getDWARFLinetableParams(), LineDelta, Label, PointerSize);
            return;
        }
        MCExpr AddrDelta = MCObjectStreamerStatics.buildSymbolDiff(this, Label, LastLabel);
        if (AddrDelta.evaluateAsAbsolute(Res = NativePointer.create_long$ref(), this.getAssembler())) {
            MCDwarfLineAddr.Emit(this, this.Assembler.getDWARFLinetableParams(), LineDelta, Res.$deref());
            return;
        }
        this.insert(new MCDwarfLineAddrFragment(LineDelta, (MCExpr)Native.$Deref((Object)AddrDelta)));
    }

    public void EmitDwarfAdvanceFrameAddr(MCSymbol LastLabel, MCSymbol Label) {
        long.ref Res;
        MCExpr AddrDelta = MCObjectStreamerStatics.buildSymbolDiff(this, Label, LastLabel);
        if (AddrDelta.evaluateAsAbsolute(Res = NativePointer.create_long$ref(), this.getAssembler())) {
            MCDwarfFrameEmitter.EmitAdvanceLoc(this, Res.$deref());
            return;
        }
        this.insert(new MCDwarfCallFrameFragment((MCExpr)Native.$Deref((Object)AddrDelta)));
    }

    @Override
    public void EmitCVLocDirective(int FunctionId, int FileNo, int Line, int Column, boolean PrologueEnd, boolean IsStmt, StringRef FileName) {
        MCCVLineEntry.Make(this);
        super.EmitCVLocDirective(FunctionId, FileNo, Line, Column, PrologueEnd, IsStmt, new StringRef(FileName));
    }

    @Override
    public void EmitCVLinetableDirective(int FunctionId, MCSymbol Begin, MCSymbol End) {
        this.getContext().getCVContext().emitLineTableForFunction(this, FunctionId, Begin, End);
        super.EmitCVLinetableDirective(FunctionId, Begin, End);
    }

    @Override
    public void EmitCVInlineLinetableDirective(int PrimaryFunctionId, int SourceFileId, int SourceLineNum, MCSymbol FnStartSym, MCSymbol FnEndSym, ArrayRefUInt SecondaryFunctionIds) {
        this.getContext().getCVContext().emitInlineLineTableForFunction(this, PrimaryFunctionId, SourceFileId, SourceLineNum, FnStartSym, FnEndSym, new ArrayRefUInt(SecondaryFunctionIds));
        super.EmitCVInlineLinetableDirective(PrimaryFunctionId, SourceFileId, SourceLineNum, FnStartSym, FnEndSym, new ArrayRefUInt(SecondaryFunctionIds));
    }

    @Override
    public void EmitCVDefRangeDirective(ArrayRef<std_pair.pairPtrPtr<MCSymbol, MCSymbol>> Ranges, StringRef FixedSizePortion) {
        this.getContext().getCVContext().emitDefRange(this, new ArrayRef<std_pair.pairPtrPtr<MCSymbol, MCSymbol>>(Ranges), new StringRef(FixedSizePortion));
        super.EmitCVDefRangeDirective(new ArrayRef<std_pair.pairPtrPtr<MCSymbol, MCSymbol>>(Ranges), new StringRef(FixedSizePortion));
    }

    @Override
    public void EmitCVStringTableDirective() {
        this.getContext().getCVContext().emitStringTable(this);
    }

    @Override
    public void EmitCVFileChecksumsDirective() {
        this.getContext().getCVContext().emitFileChecksums(this);
    }

    @Override
    public void EmitGPRel32Value(MCExpr Value) {
        MCDataFragment DF = this.getOrCreateDataFragment();
        this.flushPendingLabels(DF, Unsigned.$uint2ulong((int)DF.getContents().size()));
        DF.getFixups().push_back(MCFixup.create(DF.getContents().size(), Value, 10));
        DF.getContents().resize(DF.getContents().size() + 4, (byte)0);
    }

    @Override
    public void EmitGPRel64Value(MCExpr Value) {
        MCDataFragment DF = this.getOrCreateDataFragment();
        this.flushPendingLabels(DF, Unsigned.$uint2ulong((int)DF.getContents().size()));
        DF.getFixups().push_back(MCFixup.create(DF.getContents().size(), Value, 10));
        DF.getContents().resize(DF.getContents().size() + 8, (byte)0);
    }

    @Override
    public boolean EmitRelocDirective(MCExpr Offset, StringRef Name2, MCExpr Expr, SMLoc Loc) {
        long.ref OffsetValue = NativePointer.create_long$ref();
        if (!Offset.evaluateAsAbsolute(OffsetValue)) {
            throw new llvm_unreachable("Offset is not absolute");
        }
        if (OffsetValue.$deref() < 0L) {
            throw new llvm_unreachable("Offset is negative");
        }
        MCDataFragment DF = this.getOrCreateDataFragment();
        this.flushPendingLabels(DF, Unsigned.$uint2ulong((int)DF.getContents().size()));
        ADTAliases.OptionalUInt MaybeKind = this.Assembler.getBackend().getFixupKind(new StringRef(Name2));
        if (!MaybeKind.hasValue()) {
            return true;
        }
        int Kind2 = MaybeKind.$star();
        if (Expr == null) {
            Expr = MCSymbolRefExpr.create(this.getContext().createTempSymbol(), this.getContext());
        }
        DF.getFixups().push_back(MCFixup.create(Unsigned.$long2uint((long)OffsetValue.$deref()), Expr, Kind2, new SMLoc(Loc)));
        return false;
    }

    @Override
    public void emitFill(long NumBytes, byte FillValue) {
        MCSection Sec = (MCSection)this.getCurrentSection().first;
        assert (Sec != null) : "need a section";
        this.insert(new MCFillFragment(FillValue, NumBytes));
    }

    @Override
    public void emitFill(MCExpr NumBytes, long FillValue) {
        this.emitFill(NumBytes, FillValue, new SMLoc());
    }

    @Override
    public void emitFill(MCExpr NumBytes, long FillValue, SMLoc Loc) {
        MCDataFragment DF = this.getOrCreateDataFragment();
        this.flushPendingLabels(DF, Unsigned.$uint2ulong((int)DF.getContents().size()));
        long.ref IntNumBytes = NativePointer.create_long$ref();
        if (!NumBytes.evaluateAsAbsolute(IntNumBytes, this.getAssembler())) {
            this.getContext().reportError(new SMLoc(Loc), new Twine("expected absolute expression"));
            return;
        }
        if (IntNumBytes.$deref() <= 0L) {
            this.getContext().reportError(new SMLoc(Loc), new Twine("invalid number of bytes"));
            return;
        }
        this.emitFill(IntNumBytes.$deref(), Unsigned.$ulong2uchar((long)FillValue));
    }

    @Override
    public void emitFill(MCExpr NumValues, long Size, long Expr) {
        this.emitFill(NumValues, Size, Expr, new SMLoc());
    }

    @Override
    public void emitFill(MCExpr NumValues, long Size, long Expr, SMLoc Loc) {
        long.ref IntNumValues = NativePointer.create_long$ref();
        if (!NumValues.evaluateAsAbsolute(IntNumValues, this.getAssembler())) {
            this.getContext().reportError(new SMLoc(Loc), new Twine("expected absolute expression"));
            return;
        }
        if (IntNumValues.$deref() < 0L) {
            this.getContext().getSourceManager().PrintMessage(new SMLoc(Loc), SourceMgr.DiagKind.DK_Warning, new Twine("'.fill' directive with negative repeat count has no effect"));
            return;
        }
        super.emitFill(IntNumValues.$deref(), Size, Expr);
    }

    @Override
    public void FinishImpl() {
        if (this.getContext().getGenDwarfForAssembly()) {
            MCGenDwarfInfo.Emit(this);
        }
        MCDwarfLineTable.Emit(this, this.getAssembler().getDWARFLinetableParams());
        this.flushPendingLabels(null);
        this.getAssembler().Finish();
    }

    @Override
    public void emitAbsoluteSymbolDiff(MCSymbol Hi, MCSymbol Lo, int Size) {
        if (Hi.getFragment() == null || Hi.getFragment() != Lo.getFragment() || Hi.isVariable() || Lo.isVariable()) {
            super.emitAbsoluteSymbolDiff(Hi, Lo, Size);
            return;
        }
        this.EmitIntValue(Hi.getOffset() - Lo.getOffset(), Size);
    }

    @Override
    public boolean mayHaveInstructions(MCSection Sec) {
        return Sec.hasInstructions();
    }

    @Override
    public String toString() {
        return "Assembler=" + this.Assembler + ", CurInsertionPoint=" + this.CurInsertionPoint + ", EmitEHFrame=" + this.EmitEHFrame + ", EmitDebugFrame=" + this.EmitDebugFrame + ", PendingLabels=" + this.PendingLabels + super.toString();
    }
}

