/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.mc;

import org.clank.support.JavaDifferentiators;
import org.clank.support.Unsigned;
import org.llvm.mc.MCExpr;
import org.llvm.support.SMLoc;
import org.llvm.support.llvm_unreachable;

public class MCFixup {
    private MCExpr Value;
    private int Offset;
    private int Kind;
    private SMLoc Loc;

    public static MCFixup create(int Offset, MCExpr Value, int Kind2) {
        return MCFixup.create(Offset, Value, Kind2, new SMLoc());
    }

    public static MCFixup create(int Offset, MCExpr Value, int Kind2, SMLoc Loc) {
        assert (Unsigned.$less_uint((int)Kind2, (int)256)) : "Kind out of range!";
        MCFixup FI = new MCFixup();
        FI.Value = Value;
        FI.Offset = Offset;
        FI.Kind = Kind2;
        FI.Loc.$assign(Loc);
        return FI;
    }

    public int getKind() {
        return this.Kind;
    }

    public int getOffset() {
        return this.Offset;
    }

    public void setOffset(int Value) {
        this.Offset = Value;
    }

    public MCExpr getValue() {
        return this.Value;
    }

    public static int getKindForSize(int Size, boolean isPCRel) {
        switch (Size) {
            default: {
                throw new llvm_unreachable("Invalid generic fixup size!");
            }
            case 1: {
                return isPCRel ? 4 : 0;
            }
            case 2: {
                return isPCRel ? 5 : 1;
            }
            case 4: {
                return isPCRel ? 6 : 2;
            }
            case 8: 
        }
        return isPCRel ? 7 : 3;
    }

    public SMLoc getLoc() {
        return new SMLoc(this.Loc);
    }

    public MCFixup() {
        this.Loc = new SMLoc();
    }

    public MCFixup(JavaDifferentiators.JD.Move _dparam, MCFixup $Prm0) {
        this.Value = $Prm0.Value;
        this.Offset = $Prm0.Offset;
        this.Kind = $Prm0.Kind;
        this.Loc = new SMLoc(JavaDifferentiators.JD.Move.INSTANCE, $Prm0.Loc);
    }

    public MCFixup $assign(MCFixup $Prm0) {
        this.Value = $Prm0.Value;
        this.Offset = $Prm0.Offset;
        this.Kind = $Prm0.Kind;
        this.Loc.$assign($Prm0.Loc);
        return this;
    }

    public String toString() {
        return "Value=[MCExpr], Offset=" + this.Offset + ", Kind=" + this.Kind + ", Loc=" + this.Loc;
    }
}

