/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.mc;

import org.clank.support.Unsigned;
import org.llvm.adt.SmallString;
import org.llvm.mc.MCContext;
import org.llvm.mc.MCDwarfLineTableParams;
import org.llvm.mc.MCStreamer;
import org.llvm.mc.impl.MCDwarfStatics;
import org.llvm.support.AdtsupportLlvmGlobals;
import org.llvm.support.raw_ostream;
import org.llvm.support.raw_svector_ostream;

public class MCDwarfLineAddr {
    public static void Encode(MCContext Context, MCDwarfLineTableParams Params, long LineDelta, long AddrDelta, raw_ostream OS) {
        boolean NeedCopy = false;
        long MaxSpecialAddrDelta = MCDwarfStatics.SpecialAddr(new MCDwarfLineTableParams(Params), Unsigned.$int2ulong((int)255));
        AddrDelta = MCDwarfStatics.ScaleAddrDelta(Context, AddrDelta);
        if (LineDelta == Long.MAX_VALUE) {
            if (AddrDelta == MaxSpecialAddrDelta) {
                OS.$out_char(Unsigned.$uint2char((int)8));
            } else if (AddrDelta != 0L) {
                OS.$out_char(Unsigned.$uint2char((int)2));
                AdtsupportLlvmGlobals.encodeULEB128(AddrDelta, OS);
            }
            OS.$out_char(Unsigned.$uint2char((int)0));
            OS.$out_char((byte)1);
            OS.$out_char(Unsigned.$uint2char((int)1));
            return;
        }
        long Temp = LineDelta - (long)Params.DWARF2LineBase;
        if (Unsigned.$greatereq_ulong_uchar((long)Temp, (byte)Params.DWARF2LineRange) || Unsigned.$greater_ullong((long)(Temp + Unsigned.$uchar2ullong((byte)Params.DWARF2LineOpcodeBase)), (long)Unsigned.$int2ullong((int)255))) {
            OS.$out_char(Unsigned.$uint2char((int)3));
            AdtsupportLlvmGlobals.encodeSLEB128(LineDelta, OS);
            LineDelta = 0L;
            Temp = Unsigned.$int2ulong((int)(0 - Params.DWARF2LineBase));
            NeedCopy = true;
        }
        if (LineDelta == 0L && AddrDelta == Unsigned.$int2ullong((int)0)) {
            OS.$out_char(Unsigned.$uint2char((int)1));
            return;
        }
        Temp += Unsigned.$uchar2ullong((byte)Params.DWARF2LineOpcodeBase);
        if (Unsigned.$less_ulong_ullong((long)AddrDelta, (long)(Unsigned.$int2ullong((int)256) + MaxSpecialAddrDelta))) {
            long Opcode2 = Temp + AddrDelta * Unsigned.$uchar2ullong((byte)Params.DWARF2LineRange);
            if (Unsigned.$lesseq_ulong_ullong((long)Opcode2, (long)Unsigned.$int2ullong((int)255))) {
                OS.$out_char(Unsigned.$ulong2char((long)Opcode2));
                return;
            }
            Opcode2 = Temp + (AddrDelta - MaxSpecialAddrDelta) * Unsigned.$uchar2ullong((byte)Params.DWARF2LineRange);
            if (Unsigned.$lesseq_ulong_ullong((long)Opcode2, (long)Unsigned.$int2ullong((int)255))) {
                OS.$out_char(Unsigned.$uint2char((int)8));
                OS.$out_char(Unsigned.$ulong2char((long)Opcode2));
                return;
            }
        }
        OS.$out_char(Unsigned.$uint2char((int)2));
        AdtsupportLlvmGlobals.encodeULEB128(AddrDelta, OS);
        if (NeedCopy) {
            OS.$out_char(Unsigned.$uint2char((int)1));
        } else {
            assert (Unsigned.$lesseq_ulong_ullong((long)Temp, (long)Unsigned.$int2ullong((int)255))) : "Buggy special opcode encoding.";
            OS.$out_char(Unsigned.$ulong2char((long)Temp));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void Emit(MCStreamer MCOS, MCDwarfLineTableParams Params, long LineDelta, long AddrDelta) {
        raw_svector_ostream OS = null;
        try {
            MCContext Context = MCOS.getContext();
            SmallString Tmp = new SmallString(256);
            OS = new raw_svector_ostream(Tmp);
            MCDwarfLineAddr.Encode(Context, new MCDwarfLineTableParams(Params), LineDelta, AddrDelta, OS);
            MCOS.EmitBytes(OS.str());
        }
        finally {
            if (OS != null) {
                OS.$destroy();
            }
        }
    }

    public String toString() {
        return "";
    }
}

