/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.mc;

import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.type;
import org.clank.support.void;
import org.llvm.adt.SmallString;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.DenseMap;
import org.llvm.mc.MCAsmBackend;
import org.llvm.mc.MCContext;
import org.llvm.mc.MCDwarfFrameInfo;
import org.llvm.mc.MCObjectFileInfo;
import org.llvm.mc.MCObjectStreamer;
import org.llvm.mc.MCSection;
import org.llvm.mc.MCSymbol;
import org.llvm.mc.impl.CIEKey;
import org.llvm.mc.impl.DenseMapInfoCIEKey;
import org.llvm.mc.impl.FrameEmitterImpl;
import org.llvm.mc.impl.MCDwarfStatics;
import org.llvm.support.endian.Writer;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;
import org.llvm.support.raw_svector_ostream;

public class MCDwarfFrameEmitter {
    public static void Emit(MCObjectStreamer Streamer, MCAsmBackend MAB, boolean IsEH) {
        boolean NeedsEHFrameSection;
        Streamer.generateCompactUnwindEncodings(MAB);
        MCContext Context = Streamer.getContext();
        MCObjectFileInfo MOFI = Context.getObjectFileInfo();
        FrameEmitterImpl Emitter = new FrameEmitterImpl(IsEH, Streamer);
        ArrayRef<MCDwarfFrameInfo> FrameArray = Streamer.getDwarfFrameInfos();
        boolean bl = NeedsEHFrameSection = !MOFI.getSupportsCompactUnwindWithoutEHFrame();
        if (IsEH && MOFI.getCompactUnwindSection() != null) {
            boolean SectionEmitted = false;
            for (MCDwarfFrameInfo Frame : FrameArray) {
                if (Frame.CompactUnwindEncoding == 0) continue;
                if (!SectionEmitted) {
                    Streamer.SwitchSection(MOFI.getCompactUnwindSection());
                    Streamer.EmitValueToAlignment(Context.getAsmInfo().getPointerSize());
                    SectionEmitted = true;
                }
                NeedsEHFrameSection |= Frame.CompactUnwindEncoding == MOFI.getCompactUnwindDwarfEHFrameOnly();
                Emitter.EmitCompactUnwind(Frame);
            }
        }
        if (!NeedsEHFrameSection) {
            return;
        }
        MCSection Section = IsEH ? (MCSection)Native.$Deref((Object)MOFI.getEHFrameSection()) : (MCSection)Native.$Deref((Object)MOFI.getDwarfFrameSection());
        Streamer.SwitchSection((MCSection)Native.$AddrOf((Object)Section));
        MCSymbol SectionStart = Context.createTempSymbol();
        Streamer.EmitLabel(SectionStart);
        DenseMap<CIEKey, MCSymbol> CIEStarts = new DenseMap<CIEKey, MCSymbol>(DenseMapInfoCIEKey.$Info(), (MCSymbol)null);
        Object DummyDebugKey = null;
        boolean CanOmitDwarf = MOFI.getOmitDwarfIfHaveCompactUnwind();
        type.ptr I = (type.ptr)Native.$tryClone(FrameArray.begin());
        type.ptr E = (type.ptr)Native.$tryClone(FrameArray.end());
        while (Native.$noteq_ptr((void.ptr)I, (void.ptr)E)) {
            type.ref CIEStart;
            MCDwarfFrameInfo Frame = (MCDwarfFrameInfo)I.$star();
            I.$preInc();
            if (CanOmitDwarf && Frame.CompactUnwindEncoding != MOFI.getCompactUnwindDwarfEHFrameOnly()) continue;
            CIEKey Key = new CIEKey(Frame.Personality, Frame.PersonalityEncoding, Frame.LsdaEncoding, Frame.IsSignalFrame, Frame.IsSimple);
            type.ref ref2 = CIEStart = IsEH ? CIEStarts.ref$at_T1$C$R(Key) : NativePointer.create_type$ref(DummyDebugKey);
            if (CIEStart.$deref() == null) {
                CIEStart.$set((Object)((MCSymbol)Native.$AddrOf((Object)Emitter.EmitCIE(Frame.Personality, Frame.PersonalityEncoding, Frame.Lsda, Frame.IsSignalFrame, Frame.LsdaEncoding, Frame.IsSimple))));
            }
            Emitter.EmitFDE((MCSymbol)Native.$Deref((Object)((MCSymbol)CIEStart.$deref())), Frame, Native.$eq_ptr((void.ptr)I, (void.ptr)E), (MCSymbol)Native.$Deref((Object)SectionStart));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void EmitAdvanceLoc(MCObjectStreamer Streamer, long AddrDelta) {
        raw_svector_ostream OS = null;
        try {
            MCContext Context = Streamer.getContext();
            SmallString Tmp = new SmallString(256);
            OS = new raw_svector_ostream(Tmp);
            MCDwarfFrameEmitter.EncodeAdvanceLoc(Context, AddrDelta, OS);
            Streamer.EmitBytes(OS.str());
        }
        finally {
            if (OS != null) {
                OS.$destroy();
            }
        }
    }

    public static void EncodeAdvanceLoc(MCContext Context, long AddrDelta, raw_ostream OS) {
        if ((AddrDelta = MCDwarfStatics.ScaleAddrDelta(Context, AddrDelta)) != Unsigned.$int2ullong((int)0)) {
            if (llvm.isUIntN(6, AddrDelta)) {
                byte Opcode2 = Unsigned.$ullong2uchar((long)(Unsigned.$uint2ullong((int)64) | AddrDelta));
                OS.$out_uchar(Opcode2);
            } else if (llvm.isUInt8(AddrDelta)) {
                OS.$out_uchar(Unsigned.$uint2uchar((int)2));
                OS.$out_uchar(Unsigned.$ulong2uchar((long)AddrDelta));
            } else if (llvm.isUInt16(AddrDelta)) {
                OS.$out_uchar(Unsigned.$uint2uchar((int)3));
                if (Context.getAsmInfo().isLittleEndian()) {
                    new Writer(llvm.support.endianness.little, OS).write_uint16(Unsigned.$ulong2ushort((long)AddrDelta));
                } else {
                    new Writer(llvm.support.endianness.big, OS).write(Character.valueOf(Unsigned.$ulong2ushort((long)AddrDelta)));
                }
            } else {
                assert (llvm.isUInt32(AddrDelta));
                OS.$out_uchar(Unsigned.$uint2uchar((int)4));
                if (Context.getAsmInfo().isLittleEndian()) {
                    new Writer(llvm.support.endianness.little, OS).write_uint32(Unsigned.$ulong2uint((long)AddrDelta));
                } else {
                    new Writer(llvm.support.endianness.big, OS).write(Unsigned.$ulong2uint((long)AddrDelta));
                }
            }
        }
    }

    public String toString() {
        return "";
    }
}

